/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import java.util.Optional;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class SubstringExpression<T, R>
extends AbstractFunctionExpression<T, String> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowNulls().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public SubstringExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireMinParameters(2, args, this);
        FunctionParametersValidator.requireMaxParameters(3, args, this);
    }

    @Override
    public String apply(T value) {
        Optional<Integer> optEndIndex;
        R source = this.evaluateChild(0, value, this._typeValidator);
        if (source == null) {
            return null;
        }
        String arg = DateTimeConverter.isDateTime(source) ? DateTimeConverter.toStringMapper().apply(source) : String.valueOf(source);
        int startIndex = this.getRequiredParameter(1, value, Integer.class, "Function '%s' requires argument %d to be an integer");
        if (startIndex == 0) {
            startIndex = 1;
        }
        if (!(optEndIndex = this.getOptionalParameter(2, value, Integer.class, "Function '%s' requires argument %d to be an integer")).isPresent()) {
            return arg.substring(startIndex - 1);
        }
        if (startIndex < 0) {
            startIndex = arg.length() + startIndex + 1;
        }
        if (optEndIndex.get() <= 0) {
            return "";
        }
        int endIndex = Math.min(arg.length(), startIndex + (optEndIndex.get() - 1));
        return arg.substring(startIndex - 1, endIndex);
    }
}

