/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.coldctr;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.coldctr.ColdCtrStrategy;
import org.apache.rocketmq.broker.coldctr.PIDAdaptiveColdCtrStrategy;
import org.apache.rocketmq.broker.coldctr.SimpleColdCtrStrategy;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.SystemClock;
import org.apache.rocketmq.common.coldctr.AccAndTimeStamp;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class ColdDataCgCtrService
extends ServiceThread {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqColdCtr");
    private final SystemClock systemClock = new SystemClock();
    private final long cgColdAccResideTimeoutMills = 60000L;
    private static final AtomicLong GLOBAL_ACC = new AtomicLong(0L);
    private static final String ADAPTIVE = "||adaptive";
    private final ConcurrentHashMap<String, AccAndTimeStamp> cgColdThresholdMapRuntime = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> cgColdThresholdMapConfig = new ConcurrentHashMap();
    private final BrokerConfig brokerConfig;
    private final MessageStoreConfig messageStoreConfig;
    private final ColdCtrStrategy coldCtrStrategy;

    public ColdDataCgCtrService(BrokerController brokerController) {
        this.brokerConfig = brokerController.getBrokerConfig();
        this.messageStoreConfig = brokerController.getMessageStoreConfig();
        this.coldCtrStrategy = this.brokerConfig.isUsePIDColdCtrStrategy() ? new PIDAdaptiveColdCtrStrategy(this, (long)((double)this.brokerConfig.getGlobalColdReadThreshold() * 0.8)) : new SimpleColdCtrStrategy(this);
    }

    public String getServiceName() {
        return ColdDataCgCtrService.class.getSimpleName();
    }

    public void run() {
        log.info("{} service started", (Object)this.getServiceName());
        while (!this.isStopped()) {
            try {
                long costTime;
                if (this.messageStoreConfig.isColdDataFlowControlEnable()) {
                    this.waitForRunning(5000L);
                } else {
                    this.waitForRunning(180000L);
                }
                long beginLockTimestamp = this.systemClock.now();
                this.clearDataAcc();
                if (!this.brokerConfig.isColdCtrStrategyEnable()) {
                    this.clearAdaptiveConfig();
                }
                log.info("[{}] clearTheDataAcc-cost {} ms.", (Object)((costTime = this.systemClock.now() - beginLockTimestamp) > 3000L ? "NOTIFYME" : "OK"), (Object)costTime);
            }
            catch (Throwable e) {
                log.warn(this.getServiceName() + " service has exception", e);
            }
        }
        log.info("{} service end", (Object)this.getServiceName());
    }

    public String getColdDataFlowCtrInfo() {
        JSONObject result = new JSONObject();
        result.put((Object)"runtimeTable", this.cgColdThresholdMapRuntime);
        result.put((Object)"configTable", this.cgColdThresholdMapConfig);
        result.put((Object)"cgColdReadThreshold", (Object)this.brokerConfig.getCgColdReadThreshold());
        result.put((Object)"globalColdReadThreshold", (Object)this.brokerConfig.getGlobalColdReadThreshold());
        result.put((Object)"globalAcc", (Object)GLOBAL_ACC.get());
        return result.toJSONString(new JSONWriter.Feature[0]);
    }

    private void clearDataAcc() {
        log.info("clearDataAcc cgColdThresholdMapRuntime key size: {}", (Object)this.cgColdThresholdMapRuntime.size());
        if (this.brokerConfig.isColdCtrStrategyEnable()) {
            this.coldCtrStrategy.collect(GLOBAL_ACC.get());
        }
        Iterator<Map.Entry<String, AccAndTimeStamp>> iterator = this.cgColdThresholdMapRuntime.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, AccAndTimeStamp> next = iterator.next();
            if (System.currentTimeMillis() >= 60000L + next.getValue().getLastColdReadTimeMills()) {
                if (this.brokerConfig.isColdCtrStrategyEnable()) {
                    this.cgColdThresholdMapConfig.remove(this.buildAdaptiveKey(next.getKey()));
                }
                iterator.remove();
            } else if (next.getValue().getColdAcc().get() >= this.getThresholdByConsumerGroup(next.getKey())) {
                log.info("Coldctr consumerGroup: {}, acc: {}, threshold: {}", new Object[]{next.getKey(), next.getValue().getColdAcc().get(), this.getThresholdByConsumerGroup(next.getKey())});
                if (this.brokerConfig.isColdCtrStrategyEnable() && !this.isGlobalColdCtr() && !this.isAdminConfig(next.getKey())) {
                    this.coldCtrStrategy.promote(this.buildAdaptiveKey(next.getKey()), this.getThresholdByConsumerGroup(next.getKey()));
                }
            }
            next.getValue().getColdAcc().set(0L);
        }
        if (this.isGlobalColdCtr()) {
            log.info("Coldctr global acc: {}, threshold: {}", (Object)GLOBAL_ACC.get(), (Object)this.brokerConfig.getGlobalColdReadThreshold());
        }
        if (this.brokerConfig.isColdCtrStrategyEnable()) {
            this.sortAndDecelerate();
        }
        GLOBAL_ACC.set(0L);
    }

    private void sortAndDecelerate() {
        ArrayList<Map.Entry<String, Long>> configMapList = new ArrayList<Map.Entry<String, Long>>(this.cgColdThresholdMapConfig.entrySet());
        configMapList.sort(new Comparator<Map.Entry<String, Long>>(){

            @Override
            public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                return (int)(o2.getValue() - o1.getValue());
            }
        });
        Iterator iterator = configMapList.iterator();
        int maxDecelerate = 3;
        while (iterator.hasNext() && maxDecelerate > 0) {
            Map.Entry next = (Map.Entry)iterator.next();
            if (this.isAdminConfig((String)next.getKey())) continue;
            this.coldCtrStrategy.decelerate((String)next.getKey(), this.getThresholdByConsumerGroup((String)next.getKey()));
            --maxDecelerate;
        }
    }

    public void coldAcc(String consumerGroup, long coldDataToAcc) {
        if (coldDataToAcc <= 0L) {
            return;
        }
        GLOBAL_ACC.addAndGet(coldDataToAcc);
        AccAndTimeStamp atomicAcc = this.cgColdThresholdMapRuntime.get(consumerGroup);
        if (null == atomicAcc) {
            atomicAcc = new AccAndTimeStamp(new AtomicLong(coldDataToAcc));
            atomicAcc = this.cgColdThresholdMapRuntime.putIfAbsent(consumerGroup, atomicAcc);
        }
        if (null != atomicAcc) {
            atomicAcc.getColdAcc().addAndGet(coldDataToAcc);
            atomicAcc.setLastColdReadTimeMills(Long.valueOf(System.currentTimeMillis()));
        }
    }

    public void addOrUpdateGroupConfig(String consumerGroup, Long threshold) {
        this.cgColdThresholdMapConfig.put(consumerGroup, threshold);
    }

    public void removeGroupConfig(String consumerGroup) {
        this.cgColdThresholdMapConfig.remove(consumerGroup);
    }

    public boolean isCgNeedColdDataFlowCtr(String consumerGroup) {
        if (!this.messageStoreConfig.isColdDataFlowControlEnable()) {
            return false;
        }
        if (MixAll.isSysConsumerGroupForNoColdReadLimit((String)consumerGroup)) {
            return false;
        }
        AccAndTimeStamp accAndTimeStamp = this.cgColdThresholdMapRuntime.get(consumerGroup);
        if (null == accAndTimeStamp) {
            return false;
        }
        Long threshold = this.getThresholdByConsumerGroup(consumerGroup);
        if (accAndTimeStamp.getColdAcc().get() >= threshold) {
            return true;
        }
        return GLOBAL_ACC.get() >= this.brokerConfig.getGlobalColdReadThreshold();
    }

    public boolean isGlobalColdCtr() {
        return GLOBAL_ACC.get() > this.brokerConfig.getGlobalColdReadThreshold();
    }

    public BrokerConfig getBrokerConfig() {
        return this.brokerConfig;
    }

    private Long getThresholdByConsumerGroup(String consumerGroup) {
        if (this.isAdminConfig(consumerGroup)) {
            if (consumerGroup.endsWith(ADAPTIVE)) {
                return this.cgColdThresholdMapConfig.get(consumerGroup.split(ADAPTIVE)[0]);
            }
            return this.cgColdThresholdMapConfig.get(consumerGroup);
        }
        Long threshold = null;
        if (this.brokerConfig.isColdCtrStrategyEnable()) {
            threshold = consumerGroup.endsWith(ADAPTIVE) ? this.cgColdThresholdMapConfig.get(consumerGroup) : this.cgColdThresholdMapConfig.get(this.buildAdaptiveKey(consumerGroup));
        }
        if (null == threshold) {
            threshold = this.brokerConfig.getCgColdReadThreshold();
        }
        return threshold;
    }

    private String buildAdaptiveKey(String consumerGroup) {
        return consumerGroup + ADAPTIVE;
    }

    private boolean isAdminConfig(String consumerGroup) {
        if (consumerGroup.endsWith(ADAPTIVE)) {
            consumerGroup = consumerGroup.split(ADAPTIVE)[0];
        }
        return this.cgColdThresholdMapConfig.containsKey(consumerGroup);
    }

    private void clearAdaptiveConfig() {
        this.cgColdThresholdMapConfig.entrySet().removeIf(next -> ((String)next.getKey()).endsWith(ADAPTIVE));
    }
}

