/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.hook;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.java.hook.MessageHookPoints;
import org.apache.rocketmq.client.java.hook.MessageInterceptor;
import org.apache.rocketmq.client.java.hook.MessageInterceptorContext;
import org.apache.rocketmq.client.java.message.GeneralMessage;

public class InflightRequestCountInterceptor
implements MessageInterceptor {
    private final AtomicLong inflightReceiveRequestCount = new AtomicLong(0L);

    @Override
    public void doBefore(MessageInterceptorContext context, List<GeneralMessage> messages) {
        if (context.getMessageHookPoints() == MessageHookPoints.RECEIVE) {
            this.inflightReceiveRequestCount.incrementAndGet();
        }
    }

    @Override
    public void doAfter(MessageInterceptorContext context, List<GeneralMessage> messages) {
        if (context.getMessageHookPoints() == MessageHookPoints.RECEIVE) {
            this.inflightReceiveRequestCount.decrementAndGet();
        }
    }

    public long getInflightReceiveRequestCount() {
        return this.inflightReceiveRequestCount.get();
    }
}

