/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.message;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.java.message.MessageImpl;

public class MessageBuilderImpl
implements MessageBuilder {
    public static final Pattern TOPIC_PATTERN = Pattern.compile("^[%a-zA-Z0-9_-]+$");
    protected String topic = null;
    protected byte[] body = null;
    protected String tag = null;
    protected String messageGroup = null;
    protected String liteTopic = null;
    protected Long deliveryTimestamp = null;
    protected Integer priority = null;
    protected Collection<String> keys = new HashSet<String>();
    protected final Map<String, String> properties = new HashMap<String, String>();

    public MessageBuilder setTopic(String topic) {
        Preconditions.checkNotNull((Object)topic, (Object)"topic should not be null");
        Preconditions.checkArgument((boolean)TOPIC_PATTERN.matcher(topic).matches(), (String)"topic does not match the regex [regex=%s]", (Object)TOPIC_PATTERN.pattern());
        this.topic = topic;
        return this;
    }

    public MessageBuilder setBody(byte[] body) {
        Preconditions.checkArgument((boolean)ArrayUtils.isNotEmpty((byte[])body), (Object)"body should not be empty");
        this.body = (byte[])body.clone();
        return this;
    }

    public MessageBuilder setTag(String tag) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)tag), (Object)"tag should not be blank");
        Preconditions.checkArgument((!tag.contains("|") ? 1 : 0) != 0, (Object)"tag should not contain \"|\"");
        this.tag = tag;
        return this;
    }

    public MessageBuilder setKeys(String ... keys) {
        for (String key : keys) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key should not be blank");
        }
        this.keys = new ArrayList<String>();
        this.keys.addAll(Arrays.asList(keys));
        return this;
    }

    public MessageBuilder setMessageGroup(String messageGroup) {
        Preconditions.checkArgument((null == this.deliveryTimestamp ? 1 : 0) != 0, (Object)"messageGroup and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument((null == this.liteTopic ? 1 : 0) != 0, (Object)"messageGroup and liteTopic should not be set at same time");
        Preconditions.checkArgument((null == this.priority ? 1 : 0) != 0, (Object)"messageGroup and priority should not be set at same time");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)messageGroup), (Object)"messageGroup should not be blank");
        this.messageGroup = messageGroup;
        return this;
    }

    public MessageBuilder setLiteTopic(String liteTopic) {
        Preconditions.checkArgument((null == this.deliveryTimestamp ? 1 : 0) != 0, (Object)"liteTopic and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument((null == this.messageGroup ? 1 : 0) != 0, (Object)"liteTopic and messageGroup should not be set at same time");
        Preconditions.checkArgument((null == this.priority ? 1 : 0) != 0, (Object)"liteTopic and priority should not be set at same time");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)liteTopic), (Object)"liteTopic should not be blank");
        this.liteTopic = liteTopic;
        return this;
    }

    public MessageBuilder setDeliveryTimestamp(long deliveryTimestamp) {
        Preconditions.checkArgument((null == this.messageGroup ? 1 : 0) != 0, (Object)"deliveryTimestamp and messageGroup should not be set at same time");
        Preconditions.checkArgument((null == this.liteTopic ? 1 : 0) != 0, (Object)"deliveryTimestamp and liteTopic should not be set at same time");
        Preconditions.checkArgument((null == this.priority ? 1 : 0) != 0, (Object)"deliveryTimestamp and priority should not be set at same time");
        this.deliveryTimestamp = deliveryTimestamp;
        return this;
    }

    public MessageBuilder setPriority(int priority) {
        Preconditions.checkArgument((null == this.deliveryTimestamp ? 1 : 0) != 0, (Object)"priority and deliveryTimestamp should not be set at same time");
        Preconditions.checkArgument((null == this.messageGroup ? 1 : 0) != 0, (Object)"priority and messageGroup should not be set at same time");
        Preconditions.checkArgument((null == this.liteTopic ? 1 : 0) != 0, (Object)"priority and liteTopic should not be set at same time");
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"priority must be greater than or equal to 0");
        this.priority = priority;
        return this;
    }

    public MessageBuilder addProperty(String key, String value) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)key), (Object)"key should not be blank");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)value), (Object)"value should not be blank");
        this.properties.put(key, value);
        return this;
    }

    public Message build() {
        Preconditions.checkNotNull((Object)this.topic, (Object)"topic has not been set yet");
        Preconditions.checkNotNull((Object)this.body, (Object)"body has not been set yet");
        return new MessageImpl(this);
    }
}

