/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.grpc;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.rocketmq.shaded.grpc.netty.NettyChannelBuilder;
import org.apache.rocketmq.shaded.io.grpc.ManagedChannel;
import org.apache.rocketmq.shaded.io.grpc.ManagedChannelBuilder;
import org.apache.rocketmq.shaded.io.grpc.netty.GrpcSslContexts;
import org.apache.rocketmq.shaded.io.grpc.okhttp.OkHttpChannelBuilder;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.TlsUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.retry.RetryPolicy;
import org.apache.rocketmq.shaded.io.opentelemetry.exporter.internal.retry.RetryUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;

public final class ManagedChannelUtil {
    private static final Logger logger = Logger.getLogger(ManagedChannelUtil.class.getName());

    public static void setClientKeysAndTrustedCertificatesPem(ManagedChannelBuilder<?> managedChannelBuilder, @Nullable byte[] privateKeyPem, @Nullable byte[] certificatePem, byte[] trustedCertificatesPem) throws SSLException {
        Objects.requireNonNull(managedChannelBuilder, "managedChannelBuilder");
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        X509TrustManager tmf = TlsUtil.trustManager(trustedCertificatesPem);
        X509KeyManager kmf = null;
        if (privateKeyPem != null && certificatePem != null) {
            kmf = TlsUtil.keyManager(privateKeyPem, certificatePem);
        }
        if (managedChannelBuilder.getClass().getName().equals("org.apache.rocketmq.shaded.io.grpc.netty.NettyChannelBuilder")) {
            org.apache.rocketmq.shaded.io.grpc.netty.NettyChannelBuilder nettyBuilder = (org.apache.rocketmq.shaded.io.grpc.netty.NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(GrpcSslContexts.forClient().keyManager((KeyManager)kmf).trustManager((TrustManager)tmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("org.apache.rocketmq.shaded.grpc.netty.NettyChannelBuilder")) {
            NettyChannelBuilder nettyBuilder = (NettyChannelBuilder)managedChannelBuilder;
            nettyBuilder.sslContext(org.apache.rocketmq.shaded.grpc.netty.GrpcSslContexts.forClient().trustManager(tmf).keyManager(kmf).build());
        } else if (managedChannelBuilder.getClass().getName().equals("org.apache.rocketmq.shaded.io.grpc.okhttp.OkHttpChannelBuilder")) {
            OkHttpChannelBuilder okHttpBuilder = (OkHttpChannelBuilder)managedChannelBuilder;
            okHttpBuilder.sslSocketFactory(TlsUtil.sslSocketFactory(kmf, tmf));
        } else {
            throw new SSLException("TLS certificate configuration not supported for unrecognized ManagedChannelBuilder " + managedChannelBuilder.getClass().getName());
        }
    }

    public static Map<String, ?> toServiceConfig(String serviceName, RetryPolicy retryPolicy) {
        List retryableStatusCodes = RetryUtil.retryableGrpcStatusCodes().stream().map(Double::parseDouble).collect(Collectors.toList());
        HashMap<String, Object> retryConfig = new HashMap<String, Object>();
        retryConfig.put("retryableStatusCodes", retryableStatusCodes);
        retryConfig.put("maxAttempts", Double.valueOf(retryPolicy.getMaxAttempts()));
        retryConfig.put("initialBackoff", (double)retryPolicy.getInitialBackoff().toMillis() / 1000.0 + "s");
        retryConfig.put("maxBackoff", (double)retryPolicy.getMaxBackoff().toMillis() / 1000.0 + "s");
        retryConfig.put("backoffMultiplier", retryPolicy.getBackoffMultiplier());
        HashMap<String, Object> methodConfig = new HashMap<String, Object>();
        methodConfig.put("name", Collections.singletonList(Collections.singletonMap("service", serviceName)));
        methodConfig.put("retryPolicy", retryConfig);
        return Collections.singletonMap("methodConfig", Collections.singletonList(methodConfig));
    }

    public static CompletableResultCode shutdownChannel(ManagedChannel managedChannel) {
        CompletableResultCode result = new CompletableResultCode();
        managedChannel.shutdown();
        Thread thread = new Thread(() -> {
            try {
                managedChannel.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.log(Level.WARNING, "Failed to shutdown the gRPC channel", e);
                result.fail();
            }
            result.succeed();
        });
        thread.setDaemon(true);
        thread.setName("grpc-cleanup");
        thread.start();
        return result;
    }

    private ManagedChannelUtil() {
    }
}

