/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.rocketmq.shaded.io.opentelemetry.api.common.Attributes;
import org.apache.rocketmq.shaded.io.opentelemetry.context.Context;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.DoubleAccumulation;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.concurrent.DoubleAdder;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.resources.Resource;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoubleAccumulation, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier) {
        super(instrumentDescriptor);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<DoubleAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get());
    }

    @Override
    public DoubleAccumulation accumulateDoubleMeasurement(double value, Attributes attributes, Context context) {
        return DoubleAccumulation.create(value);
    }

    @Override
    public DoubleAccumulation merge(DoubleAccumulation previousAccumulation, DoubleAccumulation accumulation) {
        return DoubleAccumulation.create(previousAccumulation.getValue() + accumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    public DoubleAccumulation diff(DoubleAccumulation previousAccumulation, DoubleAccumulation accumulation) {
        return DoubleAccumulation.create(accumulation.getValue() - previousAccumulation.getValue(), accumulation.getExemplars());
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Map<Attributes, DoubleAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, MetricDataUtils.toDoublePointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<DoubleAccumulation, DoubleExemplarData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();

        Handle(ExemplarReservoir<DoubleExemplarData> exemplarReservoir) {
            super(exemplarReservoir);
        }

        @Override
        protected DoubleAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            return DoubleAccumulation.create(this.current.sumThenReset(), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

