/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.service.center.client;

import com.google.common.eventbus.EventBus;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.servicecomb.http.client.auth.RequestAuthHeaderProvider;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.apache.servicecomb.http.client.common.WebSocketListener;
import org.apache.servicecomb.http.client.common.WebSocketTransport;
import org.apache.servicecomb.service.center.client.DiscoveryEvents;
import org.apache.servicecomb.service.center.client.ServiceCenterAddressManager;
import org.java_websocket.handshake.ServerHandshake;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceCenterWatch
implements WebSocketListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceCenterWatch.class);
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String WS = "ws://";
    private static final String WSS = "wss://";
    private static final String WATCH = "/v4/%s/registry/microservices/%s/watcher";
    private static final long SLEEP_BASE = 3000L;
    private static final long SLEEP_MAX = 6000000L;
    private final ServiceCenterAddressManager addressManager;
    private final HttpConfiguration.SSLProperties sslProperties;
    private final RequestAuthHeaderProvider requestAuthHeaderProvider;
    private final String tenantName;
    private final Map<String, String> extraGlobalHeaders;
    private WebSocketTransport webSocketTransport;
    private String project;
    private String serviceId;
    private int continuousError = 0;
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private final EventBus eventBus;
    private String currentServerUri;
    private final ExecutorService connector = Executors.newFixedThreadPool(1, r -> new Thread(r, "web-socket-connector"));

    public ServiceCenterWatch(ServiceCenterAddressManager addressManager, HttpConfiguration.SSLProperties sslProperties, RequestAuthHeaderProvider requestAuthHeaderProvider, String tenantName, Map<String, String> extraGlobalHeaders, EventBus eventBus) {
        this.addressManager = addressManager;
        this.sslProperties = sslProperties;
        this.requestAuthHeaderProvider = requestAuthHeaderProvider;
        this.tenantName = tenantName;
        this.extraGlobalHeaders = extraGlobalHeaders;
        this.eventBus = eventBus;
    }

    public void startWatch(String project, String serviceId) {
        this.project = project;
        this.serviceId = serviceId;
        this.startWatch();
    }

    private void startWatch() {
        this.connector.submit(() -> {
            this.backOff();
            String address = this.addressManager.address();
            try {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("x-domain-name", this.tenantName);
                headers.putAll(this.extraGlobalHeaders);
                headers.putAll(this.requestAuthHeaderProvider.loadAuthHeader(null));
                this.currentServerUri = this.convertAddress(address);
                LOGGER.info("start watch to address {}", (Object)this.currentServerUri);
                this.webSocketTransport = new WebSocketTransport(this.currentServerUri, this.sslProperties, headers, (WebSocketListener)this);
                this.webSocketTransport.connectBlocking();
                this.addressManager.recordSuccessState(address);
            }
            catch (Exception e) {
                this.addressManager.recordFailState(address);
                LOGGER.error("start watch failed. ", (Throwable)e);
            }
        });
    }

    private String convertAddress(String address) {
        String url = String.format(WATCH, this.project, this.serviceId);
        if (address.startsWith(HTTP)) {
            return WS + address.substring(HTTP.length()) + url;
        }
        if (address.startsWith(HTTPS)) {
            return WSS + address.substring(HTTPS.length()) + url;
        }
        return address + url;
    }

    public void stop() {
        if (this.webSocketTransport != null) {
            this.webSocketTransport.close();
        }
    }

    private void reconnect() {
        if (this.reconnecting.getAndSet(true)) {
            return;
        }
        ++this.continuousError;
        if (this.webSocketTransport != null) {
            this.webSocketTransport.close();
        }
        this.startWatch();
    }

    private void backOff() {
        if (this.continuousError <= 0) {
            return;
        }
        try {
            Thread.sleep(Math.min(6000000L, (long)(this.continuousError * this.continuousError) * 3000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void onMessage(String s) {
        LOGGER.info("web socket receive message [{}], start query instance", (Object)s);
        this.eventBus.post((Object)new DiscoveryEvents.PullInstanceEvent(s));
    }

    public void onError(Exception e) {
        LOGGER.warn("web socket receive error [{}], will restart.", (Object)e.getMessage());
        this.reconnect();
    }

    public void onClose(int code, String reason, boolean remote) {
        LOGGER.warn("web socket closed, code={}, reason={}.", (Object)code, (Object)reason);
    }

    public void onOpen(ServerHandshake serverHandshake) {
        LOGGER.info("web socket connected to server {}, status={}, message={}", new Object[]{this.currentServerUri, serverHandshake.getHttpStatus(), serverHandshake.getHttpStatusMessage()});
        this.continuousError = 0;
        this.reconnecting.set(false);
    }
}

