/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.huaweicloud.dashboard.monitor;

import org.apache.servicecomb.foundation.ssl.SSLCustom;
import org.apache.servicecomb.foundation.ssl.SSLOption;
import org.apache.servicecomb.http.client.common.HttpConfiguration;
import org.springframework.core.env.Environment;

public class TransportUtils {
    public static HttpConfiguration.SSLProperties createSSLProperties(boolean sslEnabled, Environment environment, String tag) {
        HttpConfiguration.SSLProperties sslProperties = new HttpConfiguration.SSLProperties();
        sslProperties.setEnabled(sslEnabled);
        if (!sslEnabled) {
            return sslProperties;
        }
        SSLOption option = new SSLOption();
        option.setEngine(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getEngine(), "ssl." + tag + ".engine", "ssl.engine"));
        option.setProtocols(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getProtocols(), "ssl." + tag + ".protocols", "ssl.protocols"));
        option.setCiphers(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".ciphers", "ssl.ciphers"));
        option.setAuthPeer(TransportUtils.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAuthPeer(), "ssl." + tag + ".authPeer", "ssl.authPeer"));
        option.setCheckCNHost(TransportUtils.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNHost(), "ssl." + tag + ".checkCN.host", "ssl.checkCN.host"));
        option.setCheckCNWhite(TransportUtils.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isCheckCNWhite(), "ssl." + tag + ".checkCN.white", "ssl.checkCN.white"));
        option.setCheckCNWhiteFile(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCiphers(), "ssl." + tag + ".checkCN.white.file", "ssl.checkCN.white.file"));
        option.setAllowRenegotiate(TransportUtils.getBooleanProperty(environment, SSLOption.DEFAULT_OPTION.isAllowRenegotiate(), "ssl." + tag + ".allowRenegotiate", "ssl.allowRenegotiate"));
        option.setStorePath(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getStorePath(), "ssl." + tag + ".storePath", "ssl.storePath"));
        option.setClientAuth(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getClientAuth(), "ssl." + tag + ".clientAuth", "ssl.clientAuth"));
        option.setTrustStore(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStore(), "ssl." + tag + ".trustStore", "ssl.trustStore"));
        option.setTrustStoreType(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreType(), "ssl." + tag + ".trustStoreType", "ssl.trustStoreType"));
        option.setTrustStoreValue(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getTrustStoreValue(), "ssl." + tag + ".trustStoreValue", "ssl.trustStoreValue"));
        option.setKeyStore(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStore(), "ssl." + tag + ".keyStore", "ssl.keyStore"));
        option.setKeyStoreType(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreType(), "ssl." + tag + ".keyStoreType", "ssl.keyStoreType"));
        option.setKeyStoreValue(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getKeyStoreValue(), "ssl." + tag + ".keyStoreValue", "ssl.keyStoreValue"));
        option.setCrl(TransportUtils.getStringProperty(environment, SSLOption.DEFAULT_OPTION.getCrl(), "ssl." + tag + ".crl", "ssl.crl"));
        option.setSslCustomClass(TransportUtils.getStringProperty(environment, null, "ssl." + tag + ".sslCustomClass", "ssl.sslCustomClass"));
        sslProperties.setSslOption(option);
        sslProperties.setSslCustom(SSLCustom.createSSLCustom((String)option.getSslCustomClass()));
        return sslProperties;
    }

    private static String getStringProperty(Environment environment, String defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return environment.getProperty(key);
        }
        return defaultValue;
    }

    private static boolean getBooleanProperty(Environment environment, boolean defaultValue, String ... keys) {
        for (String key : keys) {
            if (environment.getProperty(key) == null) continue;
            return (Boolean)environment.getProperty(key, Boolean.TYPE, (Object)false);
        }
        return defaultValue;
    }
}

