/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import org.apache.sis.coordinate.DefaultCoordinateMetadata;
import org.apache.sis.coverage.grid.CoordinateOperationFinder;
import org.apache.sis.coverage.grid.GridClippingMode;
import org.apache.sis.coverage.grid.GridDerivation;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridExtentCRS;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.IllegalGridGeometryException;
import org.apache.sis.coverage.grid.IncompleteGridGeometryException;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.coverage.grid.PixelTranslation;
import org.apache.sis.coverage.grid.SliceGeometry;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.ImmutableDirectPosition;
import org.apache.sis.geometry.ImmutableEnvelope;
import org.apache.sis.io.TableAppender;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.internal.shared.ReferencingServices;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.crs.AbstractCRS;
import org.apache.sis.referencing.internal.shared.AxisDirections;
import org.apache.sis.referencing.internal.shared.DirectPositionView;
import org.apache.sis.referencing.internal.shared.ExtendedPrecisionMatrix;
import org.apache.sis.referencing.internal.shared.TemporalAccessor;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.matrix.MatrixSIS;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PassThroughTransform;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Classes;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.DefaultTreeTable;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.shared.DoubleDouble;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.util.resources.Vocabulary;
import org.apache.sis.xml.NilObject;
import org.apache.sis.xml.NilReason;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GridGeometry
implements LenientComparable,
Serializable {
    private static final long serialVersionUID = -954786616001606624L;
    public static final int CRS = 1;
    public static final int ENVELOPE = 2;
    public static final int EXTENT = 4;
    public static final int GRID_TO_CRS = 8;
    public static final int ORIGIN = 128;
    public static final int RESOLUTION = 16;
    public static final int GEOGRAPHIC_EXTENT = 32;
    public static final int TEMPORAL_EXTENT = 64;
    protected final GridExtent extent;
    protected final ImmutableEnvelope envelope;
    protected final MathTransform gridToCRS;
    protected final MathTransform cornerToCRS;
    protected final double[] resolution;
    final long nonLinears;
    private volatile transient GeographicBoundingBox geographicBBox;
    private volatile transient Instant[] timeRange;
    private volatile transient DirectPosition constantCoordinates;
    public static final GridGeometry UNDEFINED = new GridGeometry();

    private GridGeometry() {
        this.extent = null;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.envelope = null;
        this.resolution = null;
        this.nonLinears = 0L;
    }

    protected GridGeometry(GridGeometry other) {
        this.extent = other.extent;
        this.gridToCRS = other.gridToCRS;
        this.cornerToCRS = other.cornerToCRS;
        this.envelope = other.envelope;
        this.resolution = other.resolution;
        this.nonLinears = other.nonLinears;
    }

    public GridGeometry(GridGeometry other, GridExtent extent, MathTransform toOther) throws TransformException {
        int dimension = other.getDimension();
        this.extent = extent;
        GridGeometry.ensureDimensionMatches(dimension, extent);
        if (toOther == null || toOther.isIdentity()) {
            this.gridToCRS = other.gridToCRS;
            this.cornerToCRS = other.cornerToCRS;
            this.resolution = other.resolution;
            this.nonLinears = other.nonLinears;
        } else if (other.gridToCRS != null) {
            MathTransform centerShift = MathTransforms.concatenate((MathTransform)MathTransforms.uniformTranslation((int)dimension, (double)0.5), (MathTransform)toOther, (MathTransform)MathTransforms.uniformTranslation((int)dimension, (double)-0.5));
            this.cornerToCRS = MathTransforms.concatenate((MathTransform)toOther, (MathTransform)other.cornerToCRS);
            this.gridToCRS = MathTransforms.concatenate((MathTransform)centerShift, (MathTransform)other.gridToCRS);
            this.resolution = GridGeometry.resolution(this.gridToCRS, extent, PixelInCell.CELL_CENTER);
            this.nonLinears = GridGeometry.findNonLinearTargets(this.gridToCRS);
        } else {
            this.cornerToCRS = null;
            this.gridToCRS = null;
            this.resolution = GridGeometry.resolution(toOther, extent, PixelInCell.CELL_CENTER);
            this.nonLinears = GridGeometry.findNonLinearTargets(toOther);
        }
        ImmutableEnvelope envelope = other.envelope;
        ImmutableEnvelope computed = this.computeEnvelope(this.gridToCRS, GridGeometry.getCoordinateReferenceSystem((Envelope)envelope), (Envelope)(toOther == null ? null : envelope));
        if (computed == null || !computed.equals((Object)envelope)) {
            envelope = computed;
        }
        this.envelope = envelope;
        if (envelope == null && this.gridToCRS == null) {
            ArgumentChecks.ensureNonNull((String)"extent", (Object)extent);
        }
    }

    public GridGeometry(GridExtent extent, PixelInCell anchor, MathTransform gridToCRS, CoordinateReferenceSystem crs) {
        if (gridToCRS != null) {
            GridGeometry.ensureDimensionMatches(gridToCRS.getSourceDimensions(), extent);
            ArgumentChecks.ensureDimensionMatches((String)"crs", (int)gridToCRS.getTargetDimensions(), (CoordinateReferenceSystem)crs);
        } else if (crs == null) {
            ArgumentChecks.ensureNonNull((String)"extent", (Object)extent);
        }
        try {
            this.extent = extent;
            this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
            this.cornerToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CORNER);
            this.envelope = this.computeEnvelope(gridToCRS, crs, null);
            this.resolution = GridGeometry.resolution(gridToCRS, extent, anchor);
            this.nonLinears = GridGeometry.findNonLinearTargets(gridToCRS);
        }
        catch (TransformException e) {
            throw new IllegalGridGeometryException(e, "gridToCRS");
        }
    }

    private ImmutableEnvelope computeEnvelope(MathTransform specified, CoordinateReferenceSystem crs, Envelope limits) throws TransformException {
        GeneralEnvelope env;
        if (this.extent != null && this.cornerToCRS != null) {
            env = this.extent.toEnvelope(this.cornerToCRS, false, specified, limits);
            env.setCoordinateReferenceSystem(crs);
            if (limits != null) {
                env.intersect(limits);
            }
        } else if (crs != null) {
            env = new GeneralEnvelope(crs);
            env.setToNaN();
        } else {
            return null;
        }
        return new ImmutableEnvelope((Envelope)env);
    }

    public GridGeometry(PixelInCell anchor, MathTransform gridToCRS, Envelope envelope, GridRoundingMode rounding) {
        if (gridToCRS == null) {
            ArgumentChecks.ensureNonNull((String)"envelope", (Object)envelope);
        } else {
            ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)gridToCRS.getTargetDimensions(), (Envelope)envelope);
        }
        ArgumentChecks.ensureNonNull((String)"rounding", (Object)((Object)rounding));
        this.gridToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CENTER);
        this.cornerToCRS = PixelTranslation.translate(gridToCRS, anchor, PixelInCell.CELL_CORNER);
        Matrix scales = MathTransforms.getMatrix((MathTransform)gridToCRS);
        int numToIgnore = 1;
        if (envelope != null && this.cornerToCRS != null) {
            GeneralEnvelope env;
            try {
                env = Envelopes.transform((MathTransform)this.cornerToCRS.inverse(), (Envelope)envelope);
                this.extent = new GridExtent((AbstractEnvelope)env, false, rounding, GridClippingMode.STRICT, null, null, null, null);
                env = this.extent.toEnvelope(this.cornerToCRS, false, gridToCRS, envelope);
            }
            catch (TransformException e) {
                throw new IllegalGridGeometryException(e, "gridToCRS");
            }
            env.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
            this.envelope = new ImmutableEnvelope((Envelope)env);
            if (scales == null) {
                try {
                    scales = gridToCRS.derivative((DirectPosition)new DirectPositionView.Double(this.extent.getPointOfInterest(anchor)));
                    numToIgnore = 0;
                }
                catch (TransformException e) {
                    GridGeometry.recoverableException("<init>", (Exception)((Object)e));
                }
            }
        } else {
            this.extent = null;
            this.envelope = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        }
        this.resolution = scales != null ? GridGeometry.resolution(scales, numToIgnore) : null;
        this.nonLinears = GridGeometry.findNonLinearTargets(gridToCRS);
    }

    private static void ensureDimensionMatches(int expected, GridExtent extent) throws MismatchedDimensionException {
        int dimension;
        if (extent != null && (dimension = extent.getDimension()) != expected) {
            throw new MismatchedDimensionException(Errors.format((short)101, (Object)"extent", (Object)expected, (Object)dimension));
        }
    }

    static void recoverableException(String caller, Exception exception) {
        Logging.recoverableException((Logger)GridExtent.LOGGER, GridGeometry.class, (String)caller, (Throwable)exception);
    }

    public GridGeometry(GridExtent extent, Envelope envelope, GridOrientation orientation) {
        this.nonLinears = 0L;
        long flip = 0L;
        ImmutableEnvelope target = null;
        int[] sourceDimensions = null;
        if (envelope != null) {
            CoordinateSystem targetCS;
            CoordinateSystem sourceCS;
            AbstractCRS targetCRS;
            AbstractCRS sourceCRS;
            if (extent != null) {
                ArgumentChecks.ensureDimensionMatches((String)"envelope", (int)extent.getDimension(), (Envelope)envelope);
            }
            ArgumentChecks.ensureNonNull((String)"orientation", (Object)orientation);
            if (orientation.crsVariant != null && (sourceCRS = AbstractCRS.castOrCopy((CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem())) != null && (targetCRS = sourceCRS.forConvention(orientation.crsVariant)) != sourceCRS && (sourceDimensions = AxisDirections.indicesOfLenientMapping((CoordinateSystem)(sourceCS = sourceCRS.getCoordinateSystem()), (CoordinateSystem)(targetCS = targetCRS.getCoordinateSystem()))) != null) {
                double[] lowerCorner = new double[sourceDimensions.length];
                double[] upperCorner = new double[sourceDimensions.length];
                for (int i = 0; i < sourceDimensions.length; ++i) {
                    int s = sourceDimensions[i];
                    lowerCorner[i] = envelope.getMinimum(s);
                    upperCorner[i] = envelope.getMaximum(s);
                    if (sourceCS.getAxis(s).getDirection() == targetCS.getAxis(i).getDirection()) continue;
                    flip |= Numerics.bitmask((int)i);
                }
                target = new ImmutableEnvelope(lowerCorner, upperCorner, (CoordinateReferenceSystem)targetCRS);
            }
        }
        if (target == null) {
            target = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        }
        boolean nilEnvelope = true;
        if (target == null || (nilEnvelope = target.isAllNaN()) && target.getCoordinateReferenceSystem() == null) {
            if (target != null && nilEnvelope) {
                throw new NullPointerException(Errors.format((short)189));
            }
            ArgumentChecks.ensureNonNull((String)"extent", (Object)extent);
            this.envelope = null;
        } else {
            this.envelope = target;
            if (extent != null && orientation != GridOrientation.UNKNOWN) {
                if (sourceDimensions != null && orientation.canReorderGridAxis) {
                    if (!ArraysExt.isRange((int)0, sourceDimensions)) {
                        extent = extent.reorder(sourceDimensions);
                    }
                    sourceDimensions = null;
                }
                if (!nilEnvelope) {
                    MatrixSIS affine = extent.cornerToCRS((Envelope)target, orientation.flippedAxes ^ flip, sourceDimensions);
                    this.cornerToCRS = MathTransforms.linear((Matrix)affine);
                    int srcDim = this.cornerToCRS.getSourceDimensions();
                    int tgtDim = this.cornerToCRS.getTargetDimensions();
                    this.resolution = new double[tgtDim];
                    for (int j = 0; j < tgtDim; ++j) {
                        int i = sourceDimensions != null ? sourceDimensions[j] : j;
                        DoubleDouble scale = DoubleDouble.of((Number)affine.getNumber(j, i), (boolean)true);
                        DoubleDouble offset = DoubleDouble.of((Number)affine.getNumber(j, srcDim), (boolean)true);
                        this.resolution[j] = Math.abs(scale.doubleValue());
                        offset = offset.add(scale.scalb(-1));
                        affine.setNumber(j, srcDim, (Number)offset);
                    }
                    this.gridToCRS = MathTransforms.linear((Matrix)affine);
                    this.extent = extent;
                    return;
                }
            }
        }
        this.extent = extent;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.resolution = null;
    }

    public GridGeometry(Envelope envelope) {
        this.envelope = ImmutableEnvelope.castOrCopy((Envelope)envelope);
        if (this.envelope.isAllNaN() && this.envelope.getCoordinateReferenceSystem() == null) {
            throw new IllegalArgumentException(Errors.format((short)44, (Object)"envelope"));
        }
        this.extent = null;
        this.gridToCRS = null;
        this.cornerToCRS = null;
        this.resolution = null;
        this.nonLinears = 0L;
    }

    GridGeometry(GridExtent extent, MathTransform gridToCRS, MathTransform cornerToCRS, ImmutableEnvelope envelope, double[] resolution, long nonLinears) {
        this.extent = extent;
        this.gridToCRS = gridToCRS;
        this.cornerToCRS = cornerToCRS;
        this.envelope = envelope;
        this.resolution = resolution;
        this.nonLinears = nonLinears;
        if (gridToCRS != null) {
            assert (extent == null || gridToCRS.getSourceDimensions() == extent.getDimension());
            assert (envelope == null || gridToCRS.getTargetDimensions() == envelope.getDimension());
            assert (resolution == null || gridToCRS.getTargetDimensions() == resolution.length);
        }
    }

    public GridGeometry(GridGeometry lower, GridGeometry upper) throws FactoryException {
        GridExtent gridExtent = this.extent = lower.extent == null && upper.extent == null ? null : new GridExtent(lower.getExtent(), upper.getExtent());
        if (lower.gridToCRS == null && upper.gridToCRS == null) {
            this.gridToCRS = null;
            this.cornerToCRS = null;
        } else {
            this.gridToCRS = GridGeometry.compound(lower, upper, PixelInCell.CELL_CENTER);
            this.cornerToCRS = GridGeometry.compound(lower, upper, PixelInCell.CELL_CORNER);
        }
        this.nonLinears = lower.nonLinears | upper.nonLinears << lower.getDimension();
        double[] dArray = this.resolution = lower.resolution == null && upper.resolution == null ? null : ArraysExt.concatenate((double[])lower.getResolution(true), (double[])upper.getResolution(true));
        if (lower.envelope == null && upper.envelope == null) {
            this.envelope = null;
        } else {
            ImmutableEnvelope e2;
            ImmutableEnvelope e1 = lower.envelope;
            if (e1 == null) {
                e1 = lower.getEnvelope();
            }
            if ((e2 = upper.envelope) == null) {
                e2 = upper.getEnvelope();
            }
            this.envelope = ImmutableEnvelope.castOrCopy((Envelope)Envelopes.compound((Envelope[])new Envelope[]{e1, e2}));
        }
    }

    private static MathTransform compound(GridGeometry lower, GridGeometry upper, PixelInCell anchor) {
        return MathTransforms.compound((MathTransform[])new MathTransform[]{lower.getGridToCRS(anchor), upper.getGridToCRS(anchor)});
    }

    private static MathTransform cornerToCenter(MathTransform gridToCRS) {
        return PixelTranslation.translate(gridToCRS, PixelInCell.CELL_CORNER, PixelInCell.CELL_CENTER);
    }

    public final int getDimension() {
        if (this.extent != null) {
            return this.extent.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getSourceDimensions();
        }
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        throw this.incomplete(4, (short)73);
    }

    final int getTargetDimension() {
        if (this.envelope != null) {
            return this.envelope.getDimension();
        }
        if (this.gridToCRS != null) {
            return this.gridToCRS.getTargetDimensions();
        }
        return this.extent.getDimension();
    }

    public GridExtent getExtent() {
        if (this.extent != null) {
            return this.extent;
        }
        throw this.incomplete(4, (short)73);
    }

    public MathTransform getGridToCRS(PixelInCell anchor) {
        MathTransform mt;
        switch (anchor) {
            case CELL_CENTER: {
                mt = this.gridToCRS;
                break;
            }
            case CELL_CORNER: {
                mt = this.cornerToCRS;
                break;
            }
            default: {
                mt = PixelTranslation.translate(this.gridToCRS, PixelInCell.CELL_CENTER, anchor);
            }
        }
        if (mt != null) {
            return mt;
        }
        throw this.incomplete(8, (short)75);
    }

    public LinearTransform getLinearGridToCRS(PixelInCell anchor) throws TransformException {
        MathTransform tr = this.getGridToCRS(anchor);
        if (tr instanceof LinearTransform) {
            return (LinearTransform)tr;
        }
        return MathTransforms.linear((Matrix)MathTransforms.getMatrix((MathTransform)tr, (DirectPosition)new DirectPositionView.Double(this.getExtent().getPointOfInterest(anchor))));
    }

    public DefaultCoordinateMetadata getCoordinateMetadata() {
        return new DefaultCoordinateMetadata(this.getCoordinateReferenceSystem(), null);
    }

    private static CoordinateReferenceSystem getCoordinateReferenceSystem(Envelope envelope) {
        return envelope != null ? envelope.getCoordinateReferenceSystem() : null;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        CoordinateReferenceSystem crs = GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope);
        if (crs != null) {
            return crs;
        }
        throw this.incomplete(1, (short)72);
    }

    public Envelope getEnvelope() {
        if (!this.isEnvelopeUndefined()) {
            return this.envelope;
        }
        throw this.incomplete(2, this.extent == null ? (short)73 : 75);
    }

    private boolean isEnvelopeUndefined() {
        return this.envelope == null || this.envelope.isAllNaN();
    }

    public Envelope getEnvelope(CoordinateReferenceSystem crs) throws TransformException {
        int errorKey;
        int bitmask;
        ArgumentChecks.ensureNonNull((String)"crs", (Object)crs);
        CoordinateReferenceSystem sourceCRS = GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope);
        if (org.apache.sis.referencing.CRS.equivalent((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)crs)) {
            return this.envelope;
        }
        if (sourceCRS == null) {
            bitmask = 1;
            errorKey = 72;
        } else if (this.extent == null && this.envelope == null) {
            bitmask = 4;
            errorKey = 73;
        } else if (this.cornerToCRS == null && this.envelope == null) {
            bitmask = 8;
            errorKey = 75;
        } else {
            try {
                GeneralEnvelope clip;
                boolean onlyEnvelope = this.extent == null || this.cornerToCRS == null;
                CoordinateOperation op = org.apache.sis.referencing.CRS.findOperation((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)crs, (GeographicBoundingBox)this.geographicBBox());
                try {
                    clip = Envelopes.transform((CoordinateOperation)op, (Envelope)this.envelope);
                    if (onlyEnvelope) {
                        return clip;
                    }
                }
                catch (TransformException e) {
                    if (onlyEnvelope) {
                        throw e;
                    }
                    GridGeometry.recoverableException("getEnvelope", (Exception)((Object)e));
                    clip = null;
                }
                MathTransform tr = MathTransforms.concatenate((MathTransform)this.cornerToCRS, (MathTransform)op.getMathTransform());
                GeneralEnvelope env = this.extent.toEnvelope(tr, false, tr, (Envelope)clip);
                env.setCoordinateReferenceSystem(op.getTargetCRS());
                env.normalize();
                if (clip != null) {
                    env.intersect((Envelope)clip);
                }
                return env;
            }
            catch (FactoryException e) {
                throw new TransformException(null, (Throwable)e);
            }
        }
        throw this.incomplete(bitmask, (short)errorKey);
    }

    public Optional<GeographicBoundingBox> getGeographicExtent() {
        return Optional.ofNullable(this.geographicBBox());
    }

    private final GeographicBoundingBox geographicBBox() {
        GeographicBoundingBox bbox = this.geographicBBox;
        if (bbox == null && GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope) != null && !this.envelope.isAllNaN()) {
            DefaultGeographicBoundingBox db;
            NilReason reason = null;
            try {
                db = ReferencingServices.getInstance().setBounds((Envelope)this.envelope, null, null);
            }
            catch (TransformException e) {
                db = null;
                reason = NilReason.INAPPLICABLE;
            }
            if (db != null) {
                db.transitionTo(ModifiableMetadata.State.FINAL);
                bbox = db;
            } else {
                if (reason == null) {
                    reason = NilReason.MISSING;
                }
                bbox = (GeographicBoundingBox)reason.createNilObject(GeographicBoundingBox.class);
            }
            this.geographicBBox = bbox;
        }
        return bbox instanceof NilObject ? null : bbox;
    }

    public Instant[] getTemporalExtent() {
        Instant[] times = this.timeRange();
        if (times.length != 0) {
            times = (Instant[])times.clone();
        }
        return times;
    }

    private Instant[] timeRange() {
        Instant[] times = this.timeRange;
        if (times == null) {
            TemporalAccessor t = TemporalAccessor.of((CoordinateReferenceSystem)GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope), (int)0);
            times = t != null ? t.getTimeBounds((AbstractEnvelope)this.envelope) : TemporalAccessor.EMPTY;
            this.timeRange = times;
        }
        return times;
    }

    public Optional<DirectPosition> getConstantCoordinates() {
        DirectPosition constants = this.constantCoordinates;
        if (constants == null && this.envelope != null) {
            CoordinateReferenceSystem crs;
            double[] coordinates = new double[this.envelope.getDimension()];
            Arrays.fill(coordinates, Double.NaN);
            BitSet selected = new BitSet();
            for (int i = 0; i < coordinates.length; ++i) {
                double lower = this.envelope.getLower(i);
                double upper = this.envelope.getUpper(i);
                if (Double.isNaN(lower)) {
                    lower = upper;
                }
                if (Double.isNaN(upper)) {
                    upper = lower;
                }
                if (lower != upper) continue;
                coordinates[i] = lower;
                selected.set(i);
            }
            if (selected.isEmpty()) {
                crs = null;
                coordinates = ArraysExt.EMPTY_DOUBLE;
            } else {
                crs = this.envelope.getCoordinateReferenceSystem();
                try {
                    crs = org.apache.sis.referencing.CRS.selectDimensions((CoordinateReferenceSystem)crs, (BitSet)selected, (CRS.SeparationMode)CRS.SeparationMode.WHOLE_UNSEPARABLE);
                    int count = 0;
                    for (int i : selected.stream().toArray()) {
                        coordinates[count++] = coordinates[i];
                    }
                    coordinates = ArraysExt.resize((double[])coordinates, (int)count);
                }
                catch (FactoryException e) {
                    GridGeometry.recoverableException("getConstantCoordinates", (Exception)((Object)e));
                }
            }
            this.constantCoordinates = constants = new ImmutableDirectPosition(crs, coordinates);
        }
        if (constants != null && constants.getDimension() == 0) {
            constants = null;
        }
        return Optional.ofNullable(constants);
    }

    public double[] getOrigin() {
        if (this.cornerToCRS == null) {
            if (this.isEnvelopeUndefined()) {
                throw this.incomplete(128, (short)75);
            }
            return this.getEnvelope().getLowerCorner().getCoordinate();
        }
        double[] origin = new double[this.cornerToCRS.getTargetDimensions()];
        Matrix matrix = MathTransforms.getMatrix((MathTransform)this.cornerToCRS);
        if (matrix != null) {
            int lastColumn = matrix.getNumCol() - 1;
            for (int j = 0; j < origin.length; ++j) {
                Matrix other;
                origin[j] = matrix.getElement(j, lastColumn);
                if (!Double.isNaN(origin[j]) || (other = MathTransforms.getMatrix((MathTransform)this.gridToCRS)) == null) continue;
                origin[j] = other.getElement(j, lastColumn);
            }
        } else {
            try {
                this.cornerToCRS.transform(new double[this.cornerToCRS.getSourceDimensions()], 0, origin, 0, 1);
            }
            catch (TransformException e) {
                throw new IllegalGridGeometryException(e, "origin");
            }
        }
        return origin;
    }

    public double[] getResolution(boolean allowEstimates) {
        if (this.resolution != null) {
            double[] res = (double[])this.resolution.clone();
            if (!allowEstimates) {
                int i;
                for (long nonLinearDimensions = this.nonLinears; nonLinearDimensions != 0L; nonLinearDimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) {
                    i = Long.numberOfTrailingZeros(nonLinearDimensions);
                    res[i] = Double.NaN;
                }
            }
            return res;
        }
        throw this.incomplete(16, this.gridToCRS == null ? (short)75 : 73);
    }

    static double[] resolution(MathTransform gridToCRS, GridExtent domain, PixelInCell anchor) {
        Matrix matrix = MathTransforms.getMatrix((MathTransform)gridToCRS);
        if (matrix != null) {
            return GridGeometry.resolution(matrix, 1);
        }
        if (domain != null && gridToCRS != null) {
            try {
                return GridGeometry.resolution(gridToCRS.derivative((DirectPosition)new DirectPositionView.Double(domain.getPointOfInterest(anchor))), 0);
            }
            catch (TransformException e) {
                GridGeometry.recoverableException("resolution", (Exception)((Object)e));
            }
        }
        return null;
    }

    private static double[] resolution(Matrix gridToCRS, int numToIgnore) {
        double[] resolution = new double[gridToCRS.getNumRow() - numToIgnore];
        double[] buffer = new double[gridToCRS.getNumCol() - numToIgnore];
        for (int j = 0; j < resolution.length; ++j) {
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = gridToCRS.getElement(j, i);
            }
            resolution[j] = MathFunctions.magnitude((double[])buffer);
        }
        return resolution;
    }

    public boolean isConversionLinear(int ... targets) {
        int dimension = this.getTargetDimension();
        long mask = 0L;
        for (int d : targets) {
            mask |= Numerics.bitmask((int)Objects.checkIndex(d, dimension));
        }
        return (this.nonLinears & mask) == 0L;
    }

    private static long findNonLinearTargets(MathTransform gridToCRS) {
        long nonLinearDimensions = 0L;
        for (MathTransform step : MathTransforms.getSteps((MathTransform)gridToCRS)) {
            long mask;
            Matrix matrix = MathTransforms.getMatrix((MathTransform)step);
            if (matrix != null) {
                mask = nonLinearDimensions;
                nonLinearDimensions = 0L;
                while (mask != 0L) {
                    int i = Long.numberOfTrailingZeros(mask);
                    int j = matrix.getNumRow() - 1;
                    while (--j >= 0) {
                        if (matrix.getElement(j, i) == 0.0) continue;
                        if (j >= 64) {
                            throw GridGeometry.excessiveDimension(gridToCRS);
                        }
                        nonLinearDimensions |= 1L << j;
                    }
                    mask &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL;
                }
                continue;
            }
            if (step instanceof PassThroughTransform) {
                mask = 0L;
                int dimIncrease = step.getTargetDimensions() - step.getSourceDimensions();
                int maxBits = 64 - Math.max(dimIncrease, 0);
                for (int i : ((PassThroughTransform)step).getModifiedCoordinates()) {
                    if (i >= maxBits) {
                        throw GridGeometry.excessiveDimension(gridToCRS);
                    }
                    mask |= 1L << i;
                }
                if (dimIncrease != 0) {
                    mask = (Long.highestOneBit(mask) << dimIncrease + 1) - Long.lowestOneBit(mask);
                }
                nonLinearDimensions |= mask;
                continue;
            }
            int dimension = gridToCRS.getTargetDimensions();
            if (dimension > 64) {
                throw GridGeometry.excessiveDimension(gridToCRS);
            }
            return Numerics.bitmask((int)dimension) - 1L;
        }
        return nonLinearDimensions;
    }

    static ArithmeticException excessiveDimension(MathTransform gridToCRS) {
        return new ArithmeticException(Errors.format((short)50, (Object)gridToCRS.getTargetDimensions()));
    }

    private IncompleteGridGeometryException incomplete(int bitmask, short errorKey) {
        assert (this.getClass() != GridGeometry.class || !this.isDefined(bitmask));
        return new IncompleteGridGeometryException(Resources.format(errorKey));
    }

    final MathTransform requireGridToCRS(boolean center) throws IncompleteGridGeometryException {
        MathTransform mt;
        if (this.extent == null) {
            throw this.incomplete(4, (short)73);
        }
        MathTransform mathTransform = mt = center ? this.gridToCRS : this.cornerToCRS;
        if (mt == null) {
            throw this.incomplete(8, (short)75);
        }
        return mt;
    }

    public boolean isDefined(int bitmask) {
        if ((bitmask & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"bitmask", (Object)bitmask));
        }
        return !((bitmask & 1) != 0 && null == GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope) || (bitmask & 2) != 0 && this.isEnvelopeUndefined() || (bitmask & 4) != 0 && null == this.extent || (bitmask & 8) != 0 && null == this.gridToCRS || (bitmask & 0x80) != 0 && null == this.gridToCRS && this.isEnvelopeUndefined() || (bitmask & 0x10) != 0 && null == this.resolution || (bitmask & 0x20) != 0 && null == this.geographicBBox() || (bitmask & 0x40) != 0 && this.timeRange().length == 0);
    }

    final boolean isExtentOnly() {
        return this.gridToCRS == null && this.envelope == null && this.extent != null;
    }

    final boolean isEnvelopeOnly() {
        return this.gridToCRS == null && this.extent == null && this.envelope != null;
    }

    public GridDerivation derive() {
        return new GridDerivation(this);
    }

    public GridGeometry upsample(long ... periods) {
        GridExtent newExtent = this.extent;
        if (newExtent != null && (newExtent = newExtent.upsample(periods)) == this.extent) {
            return this;
        }
        boolean changed = false;
        LinearTransform newGridToCRS = null;
        double[] newResolution = null;
        if (this.cornerToCRS != null) {
            boolean isNonLinear;
            int tgtDim = this.cornerToCRS.getTargetDimensions();
            int srcDim = this.cornerToCRS.getSourceDimensions();
            MatrixSIS matrix = Matrices.copy((Matrix)MathTransforms.getMatrix((MathTransform)this.cornerToCRS));
            boolean bl = isNonLinear = matrix == null;
            if (isNonLinear) {
                matrix = Matrices.create((int)(tgtDim + 1), (int)(srcDim + 1), (Number[])ExtendedPrecisionMatrix.CREATE_IDENTITY);
            }
            newResolution = (double[])this.resolution.clone();
            int i = Math.min(srcDim, periods.length);
            while (--i >= 0) {
                double p = periods[i];
                if (p == 1.0) continue;
                int n = i;
                newResolution[n] = newResolution[n] / p;
                DoubleDouble pd = DoubleDouble.of((double)p, (boolean)true);
                for (int j = 0; j < tgtDim; ++j) {
                    DoubleDouble e = DoubleDouble.of((Number)matrix.getNumber(j, i), (boolean)true);
                    matrix.setNumber(j, i, (Number)e.divide(pd));
                    changed = true;
                }
            }
            newGridToCRS = MathTransforms.linear((Matrix)matrix);
            if (isNonLinear) {
                newGridToCRS = MathTransforms.concatenate((MathTransform)newGridToCRS, (MathTransform)this.cornerToCRS);
            }
        }
        if (!changed) {
            return this;
        }
        return new GridGeometry(newExtent, GridGeometry.cornerToCenter(newGridToCRS), (MathTransform)newGridToCRS, this.envelope, newResolution, this.nonLinears);
    }

    public final GridGeometry shiftGrid(long ... translation) {
        return this.shiftGrid(translation, false);
    }

    public GridGeometry shiftGrid(long[] translation, boolean negate) {
        ArgumentChecks.ensureNonNull((String)"translation", (Object)translation);
        GridExtent newExtent = this.extent;
        if (newExtent != null && (newExtent = newExtent.translate(translation, negate)) == this.extent) {
            return this;
        }
        MathTransform t1 = this.gridToCRS;
        MathTransform t2 = this.cornerToCRS;
        if (t1 != null || t2 != null) {
            boolean isZero = true;
            double[] vector = new double[this.getDimension()];
            int i = Math.min(vector.length, translation.length);
            while (--i >= 0) {
                isZero &= translation[i] == 0L;
                double v = translation[i];
                vector[i] = negate ? v : -v;
            }
            if (isZero) {
                return this;
            }
            LinearTransform t = MathTransforms.translation((double[])vector);
            t1 = MathTransforms.concatenate((MathTransform)t, (MathTransform)t1);
            t2 = MathTransforms.concatenate((MathTransform)t, (MathTransform)t2);
        }
        return new GridGeometry(newExtent, t1, t2, this.envelope, this.resolution, this.nonLinears);
    }

    public GridGeometry shiftGridToZeros() {
        if (this.extent == null || this.extent.startsAtZero()) {
            return this;
        }
        return this.shiftGrid(this.extent.getLow().getCoordinateValues(), true);
    }

    public GridGeometry relocate(GridExtent newExtent) throws TransformException {
        ImmutableEnvelope relocated;
        if (newExtent.equals(this.extent)) {
            return this;
        }
        GridGeometry.ensureDimensionMatches(this.getDimension(), newExtent);
        if (this.cornerToCRS != null) {
            GeneralEnvelope env = newExtent.toEnvelope(this.cornerToCRS, false, this.gridToCRS, null);
            env.setCoordinateReferenceSystem(GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope));
            relocated = new ImmutableEnvelope((Envelope)env);
        } else {
            relocated = this.envelope;
        }
        return new GridGeometry(newExtent, this.gridToCRS, this.cornerToCRS, relocated, this.resolution, this.nonLinears);
    }

    public GridGeometry selectDimensions(int ... indices) {
        if ((indices = GridExtent.verifyDimensions(indices, this.getDimension())) != null) {
            try {
                return new SliceGeometry(this, null, indices, null).reduce(null, -1);
            }
            catch (FactoryException e) {
                throw new BackingStoreException((Throwable)e);
            }
        }
        return this;
    }

    public DerivedCRS createImageCRS(String name, PixelInCell anchor) {
        ArgumentChecks.ensureNonEmpty((String)"name", (CharSequence)name);
        try {
            return GridExtentCRS.forCoverage(name, this, anchor, null);
        }
        catch (FactoryException e) {
            throw new BackingStoreException((Throwable)e);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalStateException(e);
        }
    }

    public MathTransform createTransformTo(GridGeometry target, PixelInCell anchor) throws TransformException {
        MathTransform tr;
        ArgumentChecks.ensureNonNull((String)"target", (Object)target);
        ArgumentChecks.ensureNonNull((String)"anchor", (Object)((Object)anchor));
        CoordinateOperationFinder finder = new CoordinateOperationFinder(target, this);
        finder.verifyPresenceOfCRS(false);
        finder.setAnchor(anchor);
        try {
            tr = finder.inverse();
        }
        catch (FactoryException e) {
            throw new TransformException(e.getMessage(), (Throwable)e);
        }
        return MathTransforms.concatenate((MathTransform)this.getGridToCRS(anchor), (MathTransform)tr);
    }

    public GridExtent extentOf(GridGeometry other, PixelInCell include, GridRoundingMode rounding) throws TransformException {
        MathTransform tr;
        GridExtent result = other.getExtent();
        if (!(this.cornerToCRS == other.cornerToCRS && this.gridToCRS == other.gridToCRS || (tr = other.createTransformTo(this, include)).isIdentity())) {
            boolean isCenter = include == PixelInCell.CELL_CENTER;
            GeneralEnvelope bounds = result.toEnvelope(tr, isCenter, tr, null);
            result = new GridExtent((AbstractEnvelope)bounds, isCenter, rounding, GridClippingMode.NONE, null, null, this.extent, null);
        }
        return result;
    }

    public boolean intersects(GridGeometry other) {
        return this.interacts(other, true);
    }

    public boolean contains(GridGeometry other) {
        return this.interacts(other, false);
    }

    private boolean interacts(GridGeometry other, boolean intersects) {
        try {
            if (this.extent != null && other.extent != null) {
                GridExtent source = this.getExtent();
                GridExtent target = this.extentOf(other, intersects ? PixelInCell.CELL_CORNER : PixelInCell.CELL_CENTER, intersects ? GridRoundingMode.ENCLOSING : GridRoundingMode.NEAREST);
                return intersects ? source.intersects(target) : source.contains(target);
            }
            AbstractEnvelope source = AbstractEnvelope.castOrCopy((Envelope)this.getEnvelope());
            Envelope target = other.getEnvelope(this.getCoordinateReferenceSystem());
            return intersects ? source.intersects(target) : source.contains(target);
        }
        catch (TransformException e) {
            GridGeometry.recoverableException(intersects ? "intersects" : "contains", (Exception)((Object)e));
            return intersects;
        }
    }

    public boolean equals(Object object) {
        return this.equals(object, ComparisonMode.STRICT);
    }

    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object instanceof GridGeometry) {
            GridGeometry that = (GridGeometry)object;
            if ((mode != ComparisonMode.STRICT || this.getClass().equals(object.getClass())) && Utilities.deepEquals((Object)this.extent, (Object)that.extent, (ComparisonMode)mode) && Utilities.deepEquals((Object)this.gridToCRS, (Object)that.gridToCRS, (ComparisonMode)mode)) {
                ImmutableEnvelope othenv = that.envelope;
                if (!mode.isApproximate()) {
                    return Utilities.deepEquals((Object)this.envelope, (Object)othenv, (ComparisonMode)mode);
                }
                if (this.envelope == null == (othenv == null) && Utilities.deepEquals((Object)GridGeometry.getCoordinateReferenceSystem((Envelope)this.envelope), (Object)GridGeometry.getCoordinateReferenceSystem((Envelope)othenv), (ComparisonMode)mode)) {
                    return this.equalsApproximately(othenv);
                }
            }
        }
        return false;
    }

    final boolean equalsApproximately(ImmutableEnvelope othenv) {
        if (this.envelope != null) {
            int i = this.envelope.getDimension();
            while (--i >= 0) {
                double \u03b5;
                double d = \u03b5 = this.resolution != null ? this.resolution[i] * 0.5 : 0.0;
                if (MathFunctions.epsilonEqual((double)this.envelope.getLower(i), (double)othenv.getLower(i), (double)\u03b5) && MathFunctions.epsilonEqual((double)this.envelope.getUpper(i), (double)othenv.getUpper(i), (double)\u03b5)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int code = -1527952352;
        if (this.gridToCRS != null) {
            code += this.gridToCRS.hashCode();
        }
        if (this.extent != null) {
            code += this.extent.hashCode();
        }
        return code;
    }

    final int defaultFlags() {
        Matrix matrix;
        int flags = 13;
        if (this.envelope != null) {
            flags |= 2;
        }
        if ((matrix = MathTransforms.getMatrix((MathTransform)this.gridToCRS)) != null) {
            int lastColumn = matrix.getNumCol() - 1;
            int j = matrix.getNumRow() - 1;
            while (--j >= 0) {
                Matrix other;
                if (!Double.isNaN(matrix.getElement(j, lastColumn)) || (other = MathTransforms.getMatrix((MathTransform)this.cornerToCRS)) == null || Double.isNaN(other.getElement(j, lastColumn))) continue;
                flags |= 0x80;
                break;
            }
        } else if (this.gridToCRS != null) {
            flags |= 0x80;
        }
        if (this.resolution != null && this.isEnvelopeUndefined()) {
            flags |= 0x10;
        }
        if (this.geographicBBox() != null) {
            flags |= 0x20;
        }
        if (this.timeRange().length != 0) {
            flags |= 0x40;
        }
        return flags;
    }

    public String toString() {
        return this.toTree(Locale.getDefault(), this.defaultFlags()).toString();
    }

    public TreeTable toTree(Locale locale, int bitmask) {
        ArgumentChecks.ensureNonNull((String)"locale", (Object)locale);
        DefaultTreeTable tree = new DefaultTreeTable(new TableColumn[]{TableColumn.VALUE_AS_TEXT});
        TreeTable.Node root = tree.getRoot();
        root.setValue(TableColumn.VALUE_AS_TEXT, (Object)Classes.getShortClassName((Object)this));
        this.formatTo(locale, Vocabulary.forLocale((Locale)locale), bitmask, root);
        return tree;
    }

    final void formatTo(Locale locale, Vocabulary vocabulary, int bitmask, TreeTable.Node root) {
        if ((bitmask & 0xFFFFFF00) != 0) {
            throw new IllegalArgumentException(Errors.format((short)59, (Object)"bitmask", (Object)bitmask));
        }
        try {
            new Formatter(locale, vocabulary, bitmask, root).format();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private final class Formatter {
        private final int bitmask;
        private final StringBuilder buffer;
        private final TreeTable.Node root;
        private TreeTable.Node section;
        private final Vocabulary vocabulary;
        private final Locale locale;
        private final CoordinateReferenceSystem crs;
        private final CoordinateSystem cs;
        private NumberFormat numberFormat;

        Formatter(Locale locale, Vocabulary vocabulary, int bitmask, TreeTable.Node out) {
            this.root = out;
            this.bitmask = bitmask;
            this.buffer = new StringBuilder(256);
            this.locale = locale;
            this.vocabulary = vocabulary;
            this.crs = GridGeometry.getCoordinateReferenceSystem((Envelope)GridGeometry.this.envelope);
            this.cs = this.crs != null ? this.crs.getCoordinateSystem() : null;
        }

        private NumberFormat numberFormat() {
            if (this.numberFormat == null) {
                this.numberFormat = NumberFormat.getNumberInstance(this.locale);
            }
            return this.numberFormat;
        }

        final void format() throws IOException {
            Matrix matrix;
            int i;
            if (this.section(4, (short)97, true, false)) {
                GridGeometry.this.extent.appendTo(this.buffer, this.vocabulary);
                this.writeNodes();
            }
            if (this.section(32, (short)93, false, false) || this.section(64, (short)192, false, false)) {
                TableAppender table = new TableAppender((Appendable)this.buffer, "  ");
                AngleFormat nf = new AngleFormat("DD\u00b0MM\u2032SS\u2033", this.locale);
                GeographicBoundingBox bbox = (this.bitmask & 0x20) != 0 ? GridGeometry.this.geographicBBox() : null;
                double westBoundLongitude = Double.NaN;
                double eastBoundLongitude = Double.NaN;
                Instant[] times = (this.bitmask & 0x40) != 0 ? GridGeometry.this.timeRange() : TemporalAccessor.EMPTY;
                this.vocabulary.appendLabel((short)123, (Appendable)table);
                table.setCellAlignment((byte)1);
                if (bbox != null) {
                    nf.setRoundingMode(RoundingMode.FLOOR);
                    westBoundLongitude = bbox.getWestBoundLongitude();
                    table.nextColumn();
                    table.append((CharSequence)nf.format((Object)new Latitude(bbox.getSouthBoundLatitude())));
                    table.nextColumn();
                    table.append((CharSequence)nf.format((Object)new Longitude(westBoundLongitude)));
                }
                if (times.length >= 1) {
                    table.nextColumn();
                    table.append((CharSequence)times[0].toString());
                }
                table.nextLine();
                table.setCellAlignment((byte)-1);
                this.vocabulary.appendLabel((short)211, (Appendable)table);
                table.setCellAlignment((byte)1);
                if (bbox != null) {
                    nf.setRoundingMode(RoundingMode.CEILING);
                    eastBoundLongitude = bbox.getEastBoundLongitude();
                    table.nextColumn();
                    table.append((CharSequence)nf.format((Object)new Latitude(bbox.getNorthBoundLatitude())));
                    table.nextColumn();
                    table.append((CharSequence)nf.format((Object)new Longitude(eastBoundLongitude)));
                }
                if (times.length >= 2) {
                    table.nextColumn();
                    table.append((CharSequence)times[1].toString());
                }
                table.flush();
                if (Longitude.isWraparound((double)westBoundLongitude, (double)eastBoundLongitude)) {
                    this.vocabulary.appendLabel((short)143, (Appendable)this.buffer);
                    this.buffer.append(' ').append(Messages.forLocale((Locale)this.locale).getString((short)36));
                }
                this.writeNodes();
            }
            if (this.section(2, (short)79, true, false)) {
                boolean appendResolution = (this.bitmask & 0x10) != 0 && GridGeometry.this.resolution != null;
                TableAppender table = new TableAppender((Appendable)this.buffer, "");
                int dimension = GridGeometry.this.envelope.getDimension();
                NumberFormat nf = this.numberFormat();
                for (i = 0; i < dimension; ++i) {
                    double lower = GridGeometry.this.envelope.getLower(i);
                    double upper = GridGeometry.this.envelope.getUpper(i);
                    double delta = GridGeometry.this.resolution != null ? GridGeometry.this.resolution[i] : Double.NaN;
                    nf.setMinimumFractionDigits(Numerics.fractionDigitsForDelta((double)delta));
                    nf.setMaximumFractionDigits(Numerics.suggestFractionDigits((double[])new double[]{lower, upper}) - 1);
                    CoordinateSystemAxis axis = this.cs != null ? this.cs.getAxis(i) : null;
                    String name = axis != null ? axis.getName().getCode() : this.vocabulary.getString((short)64, (Object)i);
                    table.append((CharSequence)name).append((CharSequence)": ").nextColumn();
                    table.setCellAlignment((byte)1);
                    table.append((CharSequence)nf.format(lower)).nextColumn();
                    table.setCellAlignment((byte)-1);
                    table.append((CharSequence)" \u2026 ").append((CharSequence)nf.format(upper));
                    if (appendResolution) {
                        boolean isLinear = i < 64 && (GridGeometry.this.nonLinears & 1L << i) == 0L;
                        table.nextColumn();
                        table.append((CharSequence)"  \u2206");
                        if (axis != null) {
                            table.append((CharSequence)axis.getAbbreviation());
                        }
                        table.nextColumn();
                        table.append(' ').append(isLinear ? (char)'=' : '\u2248').append(' ');
                        this.append((Appendable)table, delta, Double.NaN, i);
                    }
                    table.nextLine();
                }
                table.flush();
                this.writeNodes();
                nf.setMinimumFractionDigits(0);
            }
            if (this.section(128, (short)154, true, false)) {
                this.buffer.append('(');
                this.append(GridGeometry.this.getOrigin(), GridGeometry.this.resolution, "  ");
                this.buffer.append(')');
                this.writeNode();
            }
            if (this.section(16, (short)172, true, false)) {
                this.append(GridGeometry.this.resolution, null, " \u00d7 ");
                this.writeNode();
            }
            if (this.section(1, (short)36, true, false)) {
                Identifier id = IdentifiedObjects.getIdentifier((IdentifiedObject)this.crs, null);
                if (id != null) {
                    this.buffer.append(IdentifiedObjects.toString((Identifier)id)).append(" \u2014 ");
                }
                this.buffer.append(this.crs.getName().getCode());
                this.writeNode();
            }
            if (this.section(8, (short)34, true, (matrix = MathTransforms.getMatrix((MathTransform)GridGeometry.this.gridToCRS)) != null)) {
                if (matrix != null) {
                    this.writeNode(Matrices.toString((Matrix)matrix));
                } else {
                    long nonLinearDimensions;
                    this.buffer.append(GridGeometry.this.gridToCRS.getSourceDimensions()).append("D \u2192 ").append(GridGeometry.this.gridToCRS.getTargetDimensions()).append("D ");
                    String separator = Resources.forLocale(this.locale).getString((short)51, Long.bitCount(nonLinearDimensions));
                    for (nonLinearDimensions = GridGeometry.this.nonLinears; nonLinearDimensions != 0L; nonLinearDimensions &= 1L << i ^ 0xFFFFFFFFFFFFFFFFL) {
                        i = Long.numberOfTrailingZeros(nonLinearDimensions);
                        this.buffer.append(separator).append(' ').append(this.cs != null ? this.cs.getAxis(i).getName().getCode() : String.valueOf(i));
                        separator = ",";
                    }
                    this.writeNode();
                }
            }
        }

        private boolean section(int property, short title, boolean mandatory, boolean cellCenter) {
            if ((this.bitmask & property) != 0) {
                String text = this.vocabulary.getString(title);
                if (cellCenter) {
                    text = this.buffer.append((CharSequence)text).append(" (").append(this.vocabulary.getString((short)155).toLowerCase(this.locale)).append(')').toString();
                    this.buffer.setLength(0);
                }
                this.section = this.root.newChild();
                this.section.setValue(TableColumn.VALUE_AS_TEXT, (Object)text);
                if (GridGeometry.this.isDefined(property)) {
                    return true;
                }
                if (mandatory) {
                    this.writeNode(this.vocabulary.getString((short)209));
                }
            }
            return false;
        }

        private void writeNode(CharSequence line) {
            String text = line.toString().trim();
            if (!text.isEmpty()) {
                this.section.newChild().setValue(TableColumn.VALUE_AS_TEXT, (Object)text);
            }
        }

        private void writeNode() {
            this.writeNode(this.buffer);
            this.buffer.setLength(0);
        }

        private void writeNodes() {
            for (CharSequence line : CharSequences.splitOnEOL((CharSequence)this.buffer)) {
                this.writeNode(line);
            }
            this.buffer.setLength(0);
        }

        private void append(double[] values, double[] resolution, String separator) throws IOException {
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    this.buffer.append(separator);
                }
                double delta = resolution != null ? resolution[i] : Double.NaN;
                this.append(this.buffer, values[i], delta, i);
            }
        }

        private void append(Appendable out, double value, double delta, int dim) throws IOException {
            if (Double.isNaN(value)) {
                out.append('?');
            } else {
                NumberFormat nf = this.numberFormat();
                int n = Double.isNaN(delta) ? Numerics.suggestFractionDigits((double[])new double[]{value}) / 2 : Numerics.fractionDigitsForDelta((double)delta);
                nf.setMaximumFractionDigits(n + 1);
                out.append(nf.format(value));
            }
            if (this.cs != null) {
                String unit = String.valueOf(this.cs.getAxis(dim).getUnit());
                if (unit.isEmpty() || Character.isLetterOrDigit(unit.codePointAt(0))) {
                    out.append(' ');
                }
                out.append(unit);
            }
        }
    }
}

