/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.xml.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stax.StAXResult;
import org.apache.sis.storage.xml.stream.InputType;
import org.apache.sis.storage.xml.stream.StaxDataStore;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

enum OutputType {
    STAX((Class)XMLStreamWriter.class, InputType.STAX){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) {
            return (XMLStreamWriter)s;
        }
    }
    ,
    STREAM((Class)OutputStream.class, InputType.STREAM){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            XMLOutputFactory f = ds.outputFactory();
            Charset encoding = ds.getEncoding();
            return encoding != null ? f.createXMLStreamWriter((OutputStream)s, encoding.name()) : f.createXMLStreamWriter((OutputStream)s);
        }

        @Override
        Closeable snapshot(Object s) {
            if (s instanceof ByteArrayOutputStream) {
                return new ByteArrayInputStream(((ByteArrayOutputStream)s).toByteArray());
            }
            return super.snapshot(s);
        }
    }
    ,
    CHARACTERS((Class)Writer.class, InputType.CHARACTERS){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.outputFactory().createXMLStreamWriter((Writer)s);
        }

        @Override
        Closeable snapshot(Object s) {
            if (s instanceof StringWriter) {
                return new StringReader(s.toString());
            }
            return super.snapshot(s);
        }
    }
    ,
    RESULT((Class)Result.class, InputType.SOURCE){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.outputFactory().createXMLStreamWriter((Result)s);
        }
    }
    ,
    NODE((Class)Node.class, InputType.NODE){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.outputFactory().createXMLStreamWriter(new DOMResult((Node)s));
        }
    }
    ,
    SAX((Class)ContentHandler.class, InputType.SAX){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.outputFactory().createXMLStreamWriter(new SAXResult((ContentHandler)s));
        }
    }
    ,
    EVENT((Class)XMLEventWriter.class, InputType.EVENT){

        @Override
        XMLStreamWriter create(StaxDataStore ds, Object s) throws XMLStreamException {
            return ds.outputFactory().createXMLStreamWriter(new StAXResult((XMLEventWriter)s));
        }
    };

    private final Class<?> outputType;
    final InputType inputType;

    private OutputType(Class<?> outputType, InputType inputType) {
        this.inputType = inputType;
        this.outputType = outputType;
    }

    abstract XMLStreamWriter create(StaxDataStore var1, Object var2) throws XMLStreamException;

    Closeable snapshot(Object s) {
        return null;
    }

    static OutputType forType(Class<?> type) {
        for (OutputType c : OutputType.values()) {
            if (!c.outputType.isAssignableFrom(type)) continue;
            return c;
        }
        return null;
    }
}

