/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.apache.sis.metadata.KeyNamePolicy;
import org.apache.sis.metadata.ModifiableMetadata;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.iso.citation.DefaultResponsibility;
import org.apache.sis.metadata.sql.LookupInfo;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.Classes;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.shared.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.ResponsibleParty;

final class Dispatcher
implements InvocationHandler {
    final String identifier;
    private final MetadataSource source;
    int preferredIndex;
    private volatile transient Object cache;
    private transient long nullValues;

    public Dispatcher(String identifier, MetadataSource source) {
        this.identifier = identifier;
        this.source = source;
        this.preferredIndex = -1;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        int n = args != null ? args.length : 0;
        switch (method.getName()) {
            case "toString": {
                if (n != 0) break;
                return this.toString(method.getDeclaringClass());
            }
            case "hashCode": {
                if (n != 0) break;
                return System.identityHashCode(proxy);
            }
            case "equals": {
                if (n != 1) break;
                return proxy == args[0];
            }
            case "identifier": {
                if (n != 1) break;
                return args[0] == this.source ? this.identifier : null;
            }
            default: {
                Class<?> returnType;
                Object value;
                if (n != 0) break;
                try {
                    long nb = this.nullValues;
                    value = this.fetchValue(this.source.getLookupInfo(method.getDeclaringClass()), method);
                    if (value == null) {
                        this.nullValues = nb;
                        if ((method = Dispatcher.supercede(method)) == null) {
                            return null;
                        }
                        value = this.fetchValue(this.source.getLookupInfo(method.getDeclaringClass()), method);
                    }
                }
                catch (ReflectiveOperationException | SQLException | MetadataStoreException e) {
                    throw new BackingStoreException(this.error(method), (Throwable)e);
                }
                if (value == null && Collection.class.isAssignableFrom(returnType = method.getReturnType())) {
                    value = Dispatcher.empty(returnType);
                }
                return value;
            }
        }
        throw new BackingStoreException(Errors.format((short)199, (Object)(Classes.getShortName(method.getDeclaringClass()) + "." + method.getName())));
    }

    private static <E> Collection<E> empty(Class<?> type) {
        if (type != null) {
            if (type.isAssignableFrom(List.class)) {
                return Collections.emptyList();
            }
            if (type.isAssignableFrom(Set.class)) {
                return Collections.emptySet();
            }
            if (type.isAssignableFrom(SortedSet.class)) {
                return Collections.emptySortedSet();
            }
            if (type.isAssignableFrom(NavigableSet.class)) {
                return Collections.emptyNavigableSet();
            }
            if (type.isAssignableFrom(Queue.class)) {
                return Containers.emptyQueue();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchValue(LookupInfo info, Method method) throws ReflectiveOperationException, SQLException, MetadataStoreException {
        long nullBit;
        Object value;
        block22: {
            value = null;
            nullBit = Numerics.bitmask((int)info.asIndexMap(this.source.standard).get(method.getName()));
            if ((this.nullValues & nullBit) == 0L) {
                Class<?> type = info.getMetadataType();
                boolean needFlagReset = Semaphores.NULL_FOR_EMPTY_COLLECTION.set();
                try {
                    Dependencies dependencies;
                    Class<?> impl;
                    Object cache = this.cache;
                    if (cache != null) {
                        Object object = cache;
                        synchronized (object) {
                            value = method.invoke(cache, new Object[0]);
                        }
                    }
                    if (value != null) break block22;
                    info.setMetadataType(type);
                    value = this.source.readColumn(info, method, this);
                    if (value != null) {
                        if (cache == null) {
                            impl = this.source.standard.getImplementation(type);
                            if (impl == null) {
                                Object object = value;
                                return object;
                            }
                            cache = impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (cache instanceof ModifiableMetadata) {
                                ((ModifiableMetadata)cache).transitionTo(ModifiableMetadata.State.COMPLETABLE);
                            }
                            this.cache = cache;
                        }
                        Map<String, Object> map = this.source.standard.asValueMap(cache, type, KeyNamePolicy.METHOD_NAME, ValueExistencePolicy.ALL);
                        Object object = cache;
                        synchronized (object) {
                            value = map.putIfAbsent(method.getName(), value);
                            if (value == null) {
                                value = method.invoke(cache, new Object[0]);
                            }
                            break block22;
                        }
                    }
                    impl = this.source.standard.getImplementation(type);
                    if (impl == null || (dependencies = impl.getMethod(method.getName(), new Class[0]).getAnnotation(Dependencies.class)) == null) break block22;
                    boolean hasValue = false;
                    for (String dep : dependencies.value()) {
                        info.setMetadataType(type);
                        hasValue |= this.fetchValue(info, impl.getMethod(dep, new Class[0])) != null;
                    }
                    if (!hasValue || (cache = this.cache) == null) break block22;
                    Object object = cache;
                    synchronized (object) {
                        value = method.invoke(cache, new Object[0]);
                    }
                }
                finally {
                    Semaphores.NULL_FOR_EMPTY_COLLECTION.clearIfTrue(needFlagReset);
                }
            }
        }
        if (value == null) {
            this.nullValues |= nullBit;
        }
        return value;
    }

    final String error(Method method) {
        Class elementType;
        Class returnType = method.getReturnType();
        if ((Classes.isParameterizedProperty(returnType) || Collection.class.isAssignableFrom(returnType)) && (elementType = Classes.boundOfParameterizedProperty((Method)method)) != null) {
            returnType = elementType;
        }
        return Errors.format((short)33, (Object)returnType, (Object)this.identifier);
    }

    private String toString(Class<?> type) {
        return Classes.getShortName(type) + "[id=\u201c" + this.identifier + "\u201d]";
    }

    public String toString() {
        return this.toString(this.getClass());
    }

    private static Method supercede(Method method) throws NoSuchMethodException {
        if (method.getDeclaringClass() == ResponsibleParty.class) {
            if ("getRole".equals(method.getName())) {
                method = DefaultResponsibility.class.getMethod("getRole", new Class[0]);
            } else {
                return null;
            }
        }
        return method;
    }
}

