/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.trigger.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.DistributionRequestType;
import org.apache.sling.distribution.SimpleDistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.trigger.DistributionRequestHandler;
import org.apache.sling.distribution.trigger.DistributionTrigger;
import org.apache.sling.distribution.util.impl.DistributionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledDistributionTrigger
implements DistributionTrigger {
    private static final String SCHEDULE_NAME = "scheduledEventTrigger";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DistributionRequestType distributionAction;
    private final String path;
    private final int secondsInterval;
    private final Scheduler scheduler;
    private final String serviceName;
    private final ResourceResolverFactory resourceResolverFactory;
    private final Set<String> registeredJobs = Collections.synchronizedSet(new HashSet());

    public ScheduledDistributionTrigger(String distributionActionName, String path, int secondsInterval, String serviceName, Scheduler scheduler, ResourceResolverFactory resourceResolverFactory) {
        this.serviceName = serviceName;
        this.resourceResolverFactory = resourceResolverFactory;
        this.distributionAction = DistributionRequestType.fromName((String)distributionActionName);
        this.path = path;
        this.secondsInterval = secondsInterval;
        this.scheduler = scheduler;
        if (this.distributionAction == null) {
            throw new IllegalArgumentException("unsupported action " + distributionActionName);
        }
        if (path == null && (DistributionRequestType.ADD.equals((Object)this.distributionAction) || DistributionRequestType.DELETE.equals((Object)this.distributionAction))) {
            throw new IllegalArgumentException("path is required for action " + distributionActionName);
        }
    }

    @Override
    public void register(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        try {
            ScheduleOptions options = this.scheduler.NOW(-1, (long)this.secondsInterval);
            String jobName = this.getJobName(requestHandler);
            options.name(jobName);
            options.canRunConcurrently(false);
            options.onLeaderOnly(true);
            boolean success = this.scheduler.schedule((Object)new ScheduledDistribution(requestHandler), options);
            if (success) {
                this.registeredJobs.add(jobName);
            }
            this.log.info("handler registered {} {}", (Object)jobName, (Object)success);
        }
        catch (Exception e) {
            throw new DistributionException("unable to register handler " + requestHandler, e);
        }
    }

    @Override
    public void unregister(@NotNull DistributionRequestHandler requestHandler) throws DistributionException {
        String jobName = this.getJobName(requestHandler);
        boolean success = this.scheduler.unschedule(jobName);
        if (success) {
            this.registeredJobs.remove(jobName);
        }
        this.log.info("handler unregistered {} {}", (Object)jobName, (Object)success);
    }

    public void disable() {
        for (String jobName : this.registeredJobs) {
            boolean result = this.scheduler.unschedule(jobName);
            this.log.info("handler unregistered {} {}", (Object)jobName, (Object)result);
        }
    }

    private String getJobName(DistributionRequestHandler requestHandler) {
        return SCHEDULE_NAME + requestHandler.toString();
    }

    private class ScheduledDistribution
    implements Runnable {
        private final DistributionRequestHandler requestHandler;

        public ScheduledDistribution(DistributionRequestHandler requestHandler) {
            this.requestHandler = requestHandler;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ScheduledDistributionTrigger.this.log.debug("agent {}: scheduling {} distribution of {}", new Object[]{this.requestHandler, ScheduledDistributionTrigger.this.distributionAction, ScheduledDistributionTrigger.this.path});
            if (ScheduledDistributionTrigger.this.serviceName == null) {
                this.requestHandler.handle(null, (DistributionRequest)new SimpleDistributionRequest(ScheduledDistributionTrigger.this.distributionAction, new String[]{ScheduledDistributionTrigger.this.path}));
                return;
            }
            ResourceResolver resourceResolver = null;
            try {
                resourceResolver = DistributionUtils.loginService(ScheduledDistributionTrigger.this.resourceResolverFactory, ScheduledDistributionTrigger.this.serviceName);
                this.requestHandler.handle(resourceResolver, (DistributionRequest)new SimpleDistributionRequest(ScheduledDistributionTrigger.this.distributionAction, new String[]{ScheduledDistributionTrigger.this.path}));
            }
            catch (LoginException le) {
                try {
                    ScheduledDistributionTrigger.this.log.error("cannot obtain resource resolver for {}", (Object)ScheduledDistributionTrigger.this.serviceName);
                }
                catch (Throwable throwable) {
                    DistributionUtils.safelyLogout(resourceResolver);
                    throw throwable;
                }
                DistributionUtils.safelyLogout(resourceResolver);
                return;
            }
            DistributionUtils.safelyLogout(resourceResolver);
            return;
        }
    }
}

