/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.impl.io;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.vault.fs.api.ImportInfo;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeStash {
    static final Logger log = LoggerFactory.getLogger(NodeStash.class);
    private final Session session;
    private final String path;
    private Node tmpNode;
    private final Set<String> excludedNodeName = new HashSet<String>();
    private static final String[] ROOTS = new String[]{"/", "/tmp", "/var", "/etc", "/content"};
    private static final List<String> PROTECTED_PROPERTIES_TO_STASH = Arrays.asList("jcr:mixinTypes");
    private static final String PROTECTED_PROPERTIES_SUFFIX = "-stashed";

    public NodeStash(Session session, String path) {
        this.session = session;
        this.path = path;
    }

    private Node getOrCreateTemporaryNode() throws RepositoryException {
        if (this.tmpNode != null) {
            return this.tmpNode;
        }
        for (String rootPath : ROOTS) {
            try {
                Node root = this.session.getNode(rootPath);
                this.tmpNode = root.addNode("tmp" + System.currentTimeMillis(), "nt:unstructured");
                return this.tmpNode;
            }
            catch (RepositoryException e) {
                log.debug("unable to create temporary stash location below {}.", (Object)rootPath);
            }
        }
        throw new RepositoryException("Unable to create temporary root below.");
    }

    public NodeStash excludeName(String name) {
        this.excludedNodeName.add(name);
        return this;
    }

    @Nullable
    public String stash() {
        try {
            Node parent = this.session.getNode(this.path);
            Node tmp = this.getOrCreateTemporaryNode();
            NodeIterator nodeIterator = parent.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                String name = child.getName();
                if (this.excludedNodeName.contains(name)) {
                    log.debug("skipping excluded child node from stash: {}", (Object)child.getPath());
                    continue;
                }
                try {
                    this.session.move(child.getPath(), tmp.getPath() + "/" + name);
                }
                catch (RepositoryException e) {
                    log.error("Error while moving child node to temporary location. Child will be removed.", (Throwable)e);
                }
            }
            PropertyIterator propIterator = parent.getProperties();
            while (propIterator.hasNext()) {
                Property property = propIterator.nextProperty();
                String stashPropertyName = !property.getDefinition().isProtected() ? property.getName() : (PROTECTED_PROPERTIES_TO_STASH.contains(property.getName()) ? property.getName() + PROTECTED_PROPERTIES_SUFFIX : null);
                if (stashPropertyName == null) continue;
                if (property.isMultiple()) {
                    tmp.setProperty(stashPropertyName, property.getValues(), property.getType());
                    continue;
                }
                tmp.setProperty(stashPropertyName, property.getValue(), property.getType());
            }
            return parent.getPrimaryNodeType().getName();
        }
        catch (RepositoryException e) {
            log.warn("error while moving child nodes (ignored)", (Throwable)e);
            return null;
        }
    }

    public void recover(@NotNull ImportMode importMode, @Nullable ImportInfo importInfo) throws RepositoryException {
        if (this.tmpNode != null) {
            boolean hasErrors;
            block9: {
                Node parent = this.session.getNode(this.path);
                NodeIterator iter = this.tmpNode.getNodes();
                hasErrors = false;
                while (iter.hasNext()) {
                    Node child = iter.nextNode();
                    String newPath = parent.getPath() + "/" + child.getName();
                    try {
                        if (this.session.nodeExists(newPath)) {
                            log.debug("Skipping restore from temporary location {} as node already exists at {}", (Object)child.getPath(), (Object)newPath);
                            continue;
                        }
                        this.session.move(child.getPath(), newPath);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to move child back to new location at {} due to: {}. Node will remain in temporary location: {}", new Object[]{newPath, e.getMessage(), child.getPath()});
                        if (importInfo == null) continue;
                        importInfo.onError(newPath, (Exception)((Object)e));
                        hasErrors = true;
                    }
                }
                if (importMode != ImportMode.REPLACE) {
                    try {
                        this.recoverProperties(importMode == ImportMode.MERGE || importMode == ImportMode.MERGE_PROPERTIES);
                    }
                    catch (RepositoryException e) {
                        log.warn("Unable to restore properties at {} due to: {}. Properties will remain in temporary location: {}", new Object[]{this.path, e.getMessage(), this.tmpNode.getPath()});
                        if (importInfo == null) break block9;
                        importInfo.onError(this.path, (Exception)((Object)e));
                        hasErrors = true;
                    }
                }
            }
            if (!hasErrors) {
                this.tmpNode.remove();
            }
        }
    }

    private void recoverProperties(boolean overwriteNewOnes) throws RepositoryException {
        Property mixinProperty;
        Node destNode = this.session.getNode(this.path);
        Property property = mixinProperty = this.tmpNode.hasProperty("jcr:mixinTypes-stashed") ? this.tmpNode.getProperty("jcr:mixinTypes-stashed") : null;
        if (mixinProperty != null) {
            for (Value value : mixinProperty.getValues()) {
                this.tmpNode.addMixin(value.getString());
            }
        }
        PropertyIterator propIterator = this.tmpNode.getProperties();
        while (propIterator.hasNext()) {
            Property property2 = propIterator.nextProperty();
            if (property2.getDefinition().isProtected() || property2.getName().endsWith(PROTECTED_PROPERTIES_SUFFIX)) continue;
            if (!overwriteNewOnes && destNode.hasProperty(property2.getName())) {
                log.debug("Skipping restore property {} as it has been updated", (Object)property2.getPath());
                continue;
            }
            if (property2.isMultiple()) {
                destNode.setProperty(property2.getName(), property2.getValues(), property2.getType());
                continue;
            }
            destNode.setProperty(property2.getName(), property2.getValue(), property2.getType());
        }
    }
}

