/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.Dictionary;
import org.apache.sling.installer.api.tasks.InstallTask;
import org.apache.sling.installer.api.tasks.TaskResourceGroup;
import org.apache.sling.installer.factories.configuration.impl.ConfigUtil;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractConfigTask
extends InstallTask {
    protected final String configPid;
    protected final String factoryPid;
    private final ConfigurationAdmin configAdmin;
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    AbstractConfigTask(TaskResourceGroup r, ConfigurationAdmin configAdmin) {
        super(r);
        this.configAdmin = configAdmin;
        this.configPid = (String)this.getResource().getAttribute("service.pid");
        this.factoryPid = (String)this.getResource().getAttribute("service.factoryPid");
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String getRealPID() {
        if (this.factoryPid != null) {
            return ConfigUtil.getPIDOfFactoryPID(this.factoryPid, this.configPid);
        }
        return this.configPid;
    }

    protected ConfigurationAdmin getConfigurationAdmin() {
        return this.configAdmin;
    }

    protected Dictionary<String, Object> getDictionary() {
        return this.getResource().getDictionary();
    }
}

