/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jackrabbit.usermanager.impl.resource;

import java.security.Principal;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.api.security.principal.GroupPrincipal;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adapter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.jackrabbit.usermanager.impl.resource.BaseResource;

@Adaptable(adaptableClass=Resource.class, adapters={@Adapter(value={Map.class, ValueMap.class, Principal.class}), @Adapter(condition="If the resource is an PrincipalResource and represents a JCR principal", value={Principal.class})})
public class PrincipalResource
extends BaseResource {
    protected final Principal principal;
    private final String resourceType;

    public PrincipalResource(Principal principal, ResourceResolver resourceResolver, String path) {
        super(resourceResolver, path);
        this.principal = principal;
        this.resourceType = this.toResourceType(principal);
    }

    protected String toResourceType(Principal principal) {
        if (principal instanceof GroupPrincipal) {
            return "sling/group";
        }
        return "sling/user";
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public <T> T adaptTo(Class<T> type) {
        if (type == Map.class || type == ValueMap.class) {
            ValueMapDecorator valueMap = new ValueMapDecorator(Collections.emptyMap());
            return type.cast(valueMap);
        }
        if (type == Principal.class) {
            return type.cast(this.principal);
        }
        return (T)super.adaptTo(type);
    }

    public String toString() {
        String id = null;
        if (this.principal != null) {
            id = this.principal.getName();
        }
        return ((Object)((Object)this)).getClass().getSimpleName() + ", id=" + id + ", path=" + this.getPath();
    }
}

