/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.fpm;

import java.io.Serializable;
import java.util.List;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.fpm.PrefixSpan$;
import org.apache.spark.mllib.fpm.PrefixSpan$Prefix$;
import org.apache.spark.mllib.fpm.PrefixSpanModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.collection.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}c\u0001B%K\u0001UC\u0001\"\u001a\u0001\u0003\u0002\u0004%IA\u001a\u0005\tU\u0002\u0011\t\u0019!C\u0005W\"A\u0011\u000f\u0001B\u0001B\u0003&q\r\u0003\u0005s\u0001\t\u0005\r\u0011\"\u0003t\u0011!9\bA!a\u0001\n\u0013A\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b\u0015\u0002;\t\u0011m\u0004!\u00111A\u0005\nqD!\"!\u0001\u0001\u0005\u0003\u0007I\u0011BA\u0002\u0011%\t9\u0001\u0001B\u0001B\u0003&Q\u0010C\u0004\u0002\n\u0001!I!a\u0003\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\u0018!1\u00111\u0006\u0001\u0005\u0002\u0019Dq!a\f\u0001\t\u0003\t\t\u0004\u0003\u0004\u0002:\u0001!\ta\u001d\u0005\b\u0003{\u0001A\u0011AA \u0011\u0019\t)\u0005\u0001C\u0001y\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA)\u0001\u0011\u0005\u00111\u000b\u0005\b\u0003#\u0002A\u0011AAP\u000f\u001d\tyN\u0013E\u0001\u0003C4a!\u0013&\t\u0002\u0005\r\bbBA\u0005+\u0011\u0005\u0011Q\u001d\u0005\t\u0003O,B\u0011\u0001&\u0002j\"A!QA\u000b\u0005\u0002)\u00139\u0001\u0003\u0005\u0003>U!\tA\u0013B \r\u001d\u0011\t&\u0006\u0001K\u0005'B!B!\u0016\u001b\u0005\u000b\u0007I\u0011\u0001B,\u0011)\u0011IF\u0007B\u0001B\u0003%!q\u0002\u0005\n\u00057R\"Q1A\u0005\u0002MD\u0011B!\u0018\u001b\u0005\u0003\u0005\u000b\u0011\u0002;\t\u000f\u0005%!\u0004\"\u0003\u0003`!A!\u0011\u000e\u000eC\u0002\u0013\u00051\u000fC\u0004\u0003li\u0001\u000b\u0011\u0002;\t\u000f\t5$\u0004\"\u0001\u0003p\u001dA!QO\u000b\t\u0002)\u00139H\u0002\u0005\u0003RUA\tA\u0013B=\u0011\u001d\tI\u0001\nC\u0001\u0005wB\u0011B! %\u0005\u0004%IAa \t\u0011\tUE\u0005)A\u0005\u0005\u0003CaAa&%\t\u0013\u0019\b\"\u0003BMI\t\u0007I\u0011\u0001BN\u0011!\u0011i\n\nQ\u0001\n\t\u0005\u0004\"\u0003BPI\u0005\u0005I\u0011\u0002BQ\r\u001d\u0011I+\u0006\u0001K\u0005WC!B!\u0016-\u0005\u000b\u0007I\u0011\u0001B,\u0011)\u0011I\u0006\fB\u0001B\u0003%!q\u0002\u0005\n\u0005[c#Q1A\u0005\u0002MD\u0011Ba,-\u0005\u0003\u0005\u000b\u0011\u0002;\t\u0015\tEFF!b\u0001\n\u0003\u00119\u0006\u0003\u0006\u000342\u0012\t\u0011)A\u0005\u0005\u001fAq!!\u0003-\t\u0003\u0011)\fC\u0004\u0003@2\u0002K\u0011B:\t\u000f\t\u0005G\u0006\"\u0001\u0003D\"9!\u0011\u001c\u0017\u0005\u0002\tm\u0007b\u0002BrY\u0011\u0005!Q\u001d\u0005\b\u0005GdC\u0011\u0002Bv\u0011\u001d\u0011\u0019\u000f\fC\u0001\u0005_DqAa=-\t\u0003\u0011)p\u0002\u0006\u0003xV\t\t\u0011#\u0001K\u0005s4!B!+\u0016\u0003\u0003E\tA\u0013B~\u0011\u001d\tI\u0001\u0010C\u0001\u0005{D\u0011Ba@=#\u0003%\ta!\u0001\t\u0013\rUA(%A\u0005\u0002\r]\u0001\"\u0003BPy\u0005\u0005I\u0011\u0002BQ\r\u0019\u0019Y\"\u0006\u0001\u0004\u001e!Q1\u0011E!\u0003\u0006\u0004%\taa\t\t\u0015\r=\u0012I!A!\u0002\u0013\u0019)\u0003C\u0005\u00044\u0005\u0013)\u0019!C\u0001y\"I1qG!\u0003\u0002\u0003\u0006I! \u0005\b\u0003\u0013\tE\u0011AB\u001e\u0011\u001d\u0019I%\u0011C\u0001\u0007\u0017B\u0011Ba(\u0016\u0003\u0003%IA!)\u0003\u0015A\u0013XMZ5y'B\fgN\u0003\u0002L\u0019\u0006\u0019a\r]7\u000b\u00055s\u0015!B7mY&\u0014'BA(Q\u0003\u0015\u0019\b/\u0019:l\u0015\t\t&+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0006\u0019qN]4\u0004\u0001M!\u0001A\u0016/c!\t9&,D\u0001Y\u0015\u0005I\u0016!B:dC2\f\u0017BA.Y\u0005\u0019\te.\u001f*fMB\u0011Q\fY\u0007\u0002=*\u0011qLT\u0001\tS:$XM\u001d8bY&\u0011\u0011M\u0018\u0002\b\u0019><w-\u001b8h!\t96-\u0003\u0002e1\na1+\u001a:jC2L'0\u00192mK\u0006QQ.\u001b8TkB\u0004xN\u001d;\u0016\u0003\u001d\u0004\"a\u00165\n\u0005%D&A\u0002#pk\ndW-\u0001\bnS:\u001cV\u000f\u001d9peR|F%Z9\u0015\u00051|\u0007CA,n\u0013\tq\u0007L\u0001\u0003V]&$\bb\u00029\u0003\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014aC7j]N+\b\u000f]8si\u0002\n\u0001#\\1y!\u0006$H/\u001a:o\u0019\u0016tw\r\u001e5\u0016\u0003Q\u0004\"aV;\n\u0005YD&aA%oi\u0006!R.\u0019=QCR$XM\u001d8MK:<G\u000f[0%KF$\"\u0001\\=\t\u000fA,\u0011\u0011!a\u0001i\u0006\tR.\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u0011\u0002%5\f\u0007\u0010T8dC2\u0004&o\u001c6E\u0005NK'0Z\u000b\u0002{B\u0011qK`\u0005\u0003\u007fb\u0013A\u0001T8oO\u00061R.\u0019=M_\u000e\fG\u000e\u0015:pU\u0012\u00135+\u001b>f?\u0012*\u0017\u000fF\u0002m\u0003\u000bAq\u0001\u001d\u0005\u0002\u0002\u0003\u0007Q0A\nnCbdunY1m!J|'\u000e\u0012\"TSj,\u0007%\u0001\u0004=S:LGO\u0010\u000b\t\u0003\u001b\t\t\"a\u0005\u0002\u0016A\u0019\u0011q\u0002\u0001\u000e\u0003)CQ!\u001a\u0006A\u0002\u001dDQA\u001d\u0006A\u0002QDQa\u001f\u0006A\u0002u$\"!!\u0004)\u000b-\tY\"a\n\u0011\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\tO\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tyBA\u0003TS:\u001cW-\t\u0002\u0002*\u0005)\u0011GL\u001b/a\u0005iq-\u001a;NS:\u001cV\u000f\u001d9peRDS\u0001DA\u000e\u0003O\tQb]3u\u001b&t7+\u001e9q_J$H\u0003BA\u001a\u0003ki\u0011\u0001\u0001\u0005\u0006K6\u0001\ra\u001a\u0015\u0006\u001b\u0005m\u0011qE\u0001\u0014O\u0016$X*\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u0015\u0006\u001d\u0005m\u0011qE\u0001\u0014g\u0016$X*\u0019=QCR$XM\u001d8MK:<G\u000f\u001b\u000b\u0005\u0003g\t\t\u0005C\u0003s\u001f\u0001\u0007A\u000fK\u0003\u0010\u00037\t9#A\u000bhKRl\u0015\r\u001f'pG\u0006d\u0007K]8k\t\n\u001b\u0016N_3)\u000bA\tY\"a\n\u0002+M,G/T1y\u0019>\u001c\u0017\r\u001c)s_*$%iU5{KR!\u00111GA'\u0011\u0015Y\u0018\u00031\u0001~Q\u0015\t\u00121DA\u0014\u0003\r\u0011XO\\\u000b\u0005\u0003+\n\u0019\u0007\u0006\u0003\u0002X\u0005\u0015E\u0003BA-\u0003k\u0002b!a\u0004\u0002\\\u0005}\u0013bAA/\u0015\ny\u0001K]3gSb\u001c\u0006/\u00198N_\u0012,G\u000e\u0005\u0003\u0002b\u0005\rD\u0002\u0001\u0003\b\u0003K\u0012\"\u0019AA4\u0005\u0011IE/Z7\u0012\t\u0005%\u0014q\u000e\t\u0004/\u0006-\u0014bAA71\n9aj\u001c;iS:<\u0007cA,\u0002r%\u0019\u00111\u000f-\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002xI\t\t\u0011q\u0001\u0002z\u0005QQM^5eK:\u001cW\rJ\u0019\u0011\r\u0005m\u0014\u0011QA0\u001b\t\tiHC\u0002\u0002\u0000a\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0002\u0004\u0006u$\u0001C\"mCN\u001cH+Y4\t\u000f\u0005\u001d%\u00031\u0001\u0002\n\u0006!A-\u0019;b!\u0019\tY)!%\u0002\u00166\u0011\u0011Q\u0012\u0006\u0004\u0003\u001fs\u0015a\u0001:eI&!\u00111SAG\u0005\r\u0011F\t\u0012\t\u0006/\u0006]\u00151T\u0005\u0004\u00033C&!B!se\u0006L\b#B,\u0002\u0018\u0006}\u0003&\u0002\n\u0002\u001c\u0005\u001dR\u0003CAQ\u0003O\u000b\u0019.!0\u0015\t\u0005\r\u0016\u0011\u0016\t\u0007\u0003\u001f\tY&!*\u0011\t\u0005\u0005\u0014q\u0015\u0003\b\u0003K\u001a\"\u0019AA4\u0011\u001d\t9i\u0005a\u0001\u0003W\u0003b!!,\u00028\u0006mVBAAX\u0015\u0011\t\t,a-\u0002\t)\fg/\u0019\u0006\u0004\u0003ks\u0015aA1qS&!\u0011\u0011XAX\u0005\u001dQ\u0015M^1S\t\u0012\u0003B!!\u0019\u0002>\u00129\u0011qX\nC\u0002\u0005\u0005'\u0001C*fcV,gnY3\u0012\t\u0005%\u00141\u0019\t\u0007\u0003\u000b\fi-!5\u000e\u0005\u0005\u001d'\u0002BAe\u0003\u0017\fA\u0001\\1oO*\u0011\u0011\u0011W\u0005\u0005\u0003\u001f\f9M\u0001\u0005Ji\u0016\u0014\u0018M\u00197f!\u0011\t\t'a5\u0005\u000f\u0005U7C1\u0001\u0002X\n9\u0011\n^3ng\u0016$\u0018\u0003BA5\u00033\u0004b!!2\u0002N\u0006\u0015\u0006&B\n\u0002\u001c\u0005\u001d\u0002&\u0002\u0001\u0002\u001c\u0005\u001d\u0012A\u0003)sK\u001aL\u0007p\u00159b]B\u0019\u0011qB\u000b\u0014\tU1FL\u0019\u000b\u0003\u0003C\f\u0011CZ5oI\u001a\u0013X-];f]RLE/Z7t+\u0011\tY/a=\u0015\r\u00055\u00181 B\u0001)\u0011\ty/!>\u0011\u000b]\u000b9*!=\u0011\t\u0005\u0005\u00141\u001f\u0003\b\u0003K:\"\u0019AA4\u0011%\t9pFA\u0001\u0002\b\tI0\u0001\u0006fm&$WM\\2fII\u0002b!a\u001f\u0002\u0002\u0006E\bbBAD/\u0001\u0007\u0011Q \t\u0007\u0003\u0017\u000b\t*a@\u0011\u000b]\u000b9*a<\t\r\t\rq\u00031\u0001~\u0003!i\u0017N\\\"pk:$\u0018A\u0006;p\t\u0006$\u0018MY1tK&sG/\u001a:oC2\u0014V\r\u001d:\u0016\t\t%!\u0011\u0004\u000b\u0007\u0005\u0017\u0011YBa\t\u0015\t\t5!\u0011\u0003\t\u0007\u0003\u0017\u000b\tJa\u0004\u0011\t]\u000b9\n\u001e\u0005\n\u0005'A\u0012\u0011!a\u0002\u0005+\t!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\tY(!!\u0003\u0018A!\u0011\u0011\rB\r\t\u001d\t)\u0007\u0007b\u0001\u0003OBq!a\"\u0019\u0001\u0004\u0011i\u0002\u0005\u0004\u0002\f\u0006E%q\u0004\t\u0006/\u0006]%\u0011\u0005\t\u0006/\u0006]%q\u0003\u0005\b\u0005KA\u0002\u0019\u0001B\u0014\u0003%IG/Z7U_&sG\u000fE\u0004\u0003*\t]\"q\u0003;\u000f\t\t-\"1\u0007\t\u0004\u0005[AVB\u0001B\u0018\u0015\r\u0011\t\u0004V\u0001\u0007yI|w\u000e\u001e \n\u0007\tU\u0002,\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005s\u0011YDA\u0002NCBT1A!\u000eY\u0003=9WM\u001c$sKF\u0004\u0016\r\u001e;fe:\u001cHC\u0003B!\u0005\u0013\u0012YE!\u0014\u0003PA1\u00111RAI\u0005\u0007\u0002ba\u0016B#\u0005\u001fi\u0018b\u0001B$1\n1A+\u001e9mKJBq!a\"\u001a\u0001\u0004\u0011i\u0001\u0003\u0004\u0003\u0004e\u0001\r! \u0005\u0006ef\u0001\r\u0001\u001e\u0005\u0006wf\u0001\r! \u0002\u0007!J,g-\u001b=\u0014\u0007i1&-A\u0003ji\u0016l7/\u0006\u0002\u0003\u0010\u00051\u0011\u000e^3ng\u0002\na\u0001\\3oORD\u0017a\u00027f]\u001e$\b\u000e\t\u000b\u0007\u0005C\u0012)Ga\u001a\u0011\u0007\t\r$$D\u0001\u0016\u0011\u001d\u0011)f\ba\u0001\u0005\u001fAaAa\u0017 \u0001\u0004!\u0018AA5e\u0003\rIG\rI\u0001\fI\r|Gn\u001c8%a2,8\u000f\u0006\u0003\u0003b\tE\u0004B\u0002B:E\u0001\u0007A/\u0001\u0003ji\u0016l\u0017A\u0002)sK\u001aL\u0007\u0010E\u0002\u0003d\u0011\u001a2\u0001\n,c)\t\u00119(A\u0004d_VtG/\u001a:\u0016\u0005\t\u0005\u0005\u0003\u0002BB\u0005#k!A!\"\u000b\t\t\u001d%\u0011R\u0001\u0007CR|W.[2\u000b\t\t-%QR\u0001\u000bG>t7-\u001e:sK:$(\u0002\u0002BH\u0003\u0017\fA!\u001e;jY&!!1\u0013BC\u00055\tEo\\7jG&sG/Z4fe\u0006A1m\\;oi\u0016\u0014\b%\u0001\u0004oKb$\u0018\nZ\u0001\u0006K6\u0004H/_\u000b\u0003\u0005C\na!Z7qif\u0004\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa)\u0011\t\u0005\u0015'QU\u0005\u0005\u0005O\u000b9M\u0001\u0004PE*,7\r\u001e\u0002\b!>\u001cHOZ5y'\racKY\u0001\u0006gR\f'\u000f^\u0001\u0007gR\f'\u000f\u001e\u0011\u0002\u001bA\f'\u000f^5bYN#\u0018M\u001d;t\u00039\u0001\u0018M\u001d;jC2\u001cF/\u0019:ug\u0002\"\u0002Ba.\u0003:\nm&Q\u0018\t\u0004\u0005Gb\u0003b\u0002B+g\u0001\u0007!q\u0002\u0005\t\u0005[\u001b\u0004\u0013!a\u0001i\"I!\u0011W\u001a\u0011\u0002\u0003\u0007!qB\u0001\nMVdGn\u0015;beR\fabZ3o!J,g-\u001b=Ji\u0016l7/\u0006\u0002\u0003FB1!q\u0019Bi\u0005/tAA!3\u0003N:!!Q\u0006Bf\u0013\u0005I\u0016b\u0001Bh1\u00069\u0001/Y2lC\u001e,\u0017\u0002\u0002Bj\u0005+\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0005\u001fD\u0006#B,\u0003FQl\u0018\u0001\u00038p]\u0016k\u0007\u000f^=\u0016\u0005\tu\u0007cA,\u0003`&\u0019!\u0011\u001d-\u0003\u000f\t{w\u000e\\3b]\u00069\u0001O]8kK\u000e$H\u0003\u0002B\\\u0005ODaA!;8\u0001\u0004!\u0018A\u00029sK\u001aL\u0007\u0010\u0006\u0003\u00038\n5\bb\u0002Buq\u0001\u0007!q\u0002\u000b\u0005\u0005o\u0013\t\u0010C\u0004\u0003jf\u0002\rA!\u0019\u0002\u0015\r|W\u000e\u001d:fgN,G-\u0006\u0002\u00038\u00069\u0001k\\:uM&D\bc\u0001B2yM\u0019AH\u00162\u0015\u0005\te\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0004\u0004)\u001aAo!\u0002,\u0005\r\u001d\u0001\u0003BB\u0005\u0007#i!aa\u0003\u000b\t\r51qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\tY\u0013\u0011\u0019\u0019ba\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u000b\u0003\u00073QCAa\u0004\u0004\u0006\taaI]3r'\u0016\fX/\u001a8dKV!1qDB\u0016'\r\teKY\u0001\tg\u0016\fX/\u001a8dKV\u00111Q\u0005\t\u0006/\u0006]5q\u0005\t\u0006/\u0006]5\u0011\u0006\t\u0005\u0003C\u001aY\u0003B\u0004\u0002f\u0005\u0013\r!a\u001a)\u000b\t\u000bY\"a\n\u0002\u0013M,\u0017/^3oG\u0016\u0004\u0003&B\"\u0002\u001c\u0005\u001d\u0012\u0001\u00024sKFDS\u0001RA\u000e\u0003O\tQA\u001a:fc\u0002BS!RA\u000e\u0003O!ba!\u0010\u0004@\r\r\u0003#\u0002B2\u0003\u000e%\u0002bBB\u0011\r\u0002\u00071Q\u0005\u0015\u0007\u0007\u007f\tY\"a\n\t\r\rMb\t1\u0001~Q\u0019\u0019\u0019%a\u0007\u0002(!*a)a\u0007\u0002(\u0005a!.\u0019<b'\u0016\fX/\u001a8dKV\u00111Q\n\t\u0007\u0007\u001f\u001a\tf!\u0016\u000e\u0005\t5\u0015\u0002BB*\u0005\u001b\u0013A\u0001T5tiB11qJB)\u0007SASaRA\u000e\u0003OAS!QA\u000e\u0003OAS!FA\u000e\u0003OAS\u0001FA\u000e\u0003O\u0001")
public class PrefixSpan
implements Logging,
scala.Serializable {
    private double minSupport;
    private int maxPatternLength;
    private long maxLocalProjDBSize;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private double minSupport() {
        return this.minSupport;
    }

    private void minSupport_$eq(double x$1) {
        this.minSupport = x$1;
    }

    private int maxPatternLength() {
        return this.maxPatternLength;
    }

    private void maxPatternLength_$eq(int x$1) {
        this.maxPatternLength = x$1;
    }

    private long maxLocalProjDBSize() {
        return this.maxLocalProjDBSize;
    }

    private void maxLocalProjDBSize_$eq(long x$1) {
        this.maxLocalProjDBSize = x$1;
    }

    public double getMinSupport() {
        return this.minSupport();
    }

    public PrefixSpan setMinSupport(double minSupport) {
        Predef$.MODULE$.require(minSupport >= 0.0 && minSupport <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("The minimum support value must be in [0, 1], but got ").append(minSupport).append(".").toString());
        this.minSupport_$eq(minSupport);
        return this;
    }

    public int getMaxPatternLength() {
        return this.maxPatternLength();
    }

    public PrefixSpan setMaxPatternLength(int maxPatternLength) {
        Predef$.MODULE$.require(maxPatternLength >= 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("The maximum pattern length value must be greater than 0, but got ").append(maxPatternLength).append(".").toString());
        this.maxPatternLength_$eq(maxPatternLength);
        return this;
    }

    public long getMaxLocalProjDBSize() {
        return this.maxLocalProjDBSize();
    }

    public PrefixSpan setMaxLocalProjDBSize(long maxLocalProjDBSize) {
        Predef$.MODULE$.require(maxLocalProjDBSize >= 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("The maximum local projected database size must be nonnegative, but got ").append(maxLocalProjDBSize).toString());
        this.maxLocalProjDBSize_$eq(maxLocalProjDBSize);
        return this;
    }

    public <Item> PrefixSpanModel<Item> run(RDD<Object[]> data, ClassTag<Item> evidence$1) {
        Object object;
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Input data is not cached.");
        }
        long totalCount = data.count();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("number of sequences: ").append(totalCount).toString());
        long minCount = (long)package$.MODULE$.ceil(this.minSupport() * (double)totalCount);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("minimum count for a frequent pattern: ").append(minCount).toString());
        Object freqItems = PrefixSpan$.MODULE$.findFrequentItems(data, minCount, evidence$1);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("number of frequent items: ").append(ScalaRunTime$.MODULE$.array_length(freqItems)).toString());
        Map itemToInt = Utils$.MODULE$.toMapWithIndex((Iterable)Predef$.MODULE$.genericWrapArray(freqItems));
        RDD dataInternalRepr = PrefixSpan$.MODULE$.toDatabaseInternalRepr(data, itemToInt, evidence$1).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD<Tuple2<int[], Object>> results = PrefixSpan$.MODULE$.genFreqPatterns((RDD<int[]>)dataInternalRepr, minCount, this.maxPatternLength(), this.maxLocalProjDBSize());
        RDD freqSequences = results.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int[] seq = (int[])tuple2._1();
                long count = tuple2._2$mcJ$sp();
                if (seq != null) {
                    int[] nArray = seq;
                    long l = count;
                    return new FreqSequence(PrefixSpan.toPublicRepr$1(nArray, evidence$1, freqItems), l);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(FreqSequence.class));
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (storageLevel3 == null ? storageLevel4 != null : !storageLevel3.equals(storageLevel4)) {
            freqSequences.persist(data.getStorageLevel());
            object = BoxesRunTime.boxToLong((long)freqSequences.count());
        } else {
            object = BoxedUnit.UNIT;
        }
        dataInternalRepr.unpersist(dataInternalRepr.unpersist$default$1());
        return new PrefixSpanModel(freqSequences);
    }

    public <Item, Itemset extends java.lang.Iterable<Item>, Sequence extends java.lang.Iterable<Itemset>> PrefixSpanModel<Item> run(JavaRDD<Sequence> data) {
        ClassTag tag = JavaSparkContext$.MODULE$.fakeClassTag();
        return this.run((RDD<Object[]>)data.rdd().map((Function1 & Serializable & scala.Serializable)x$1 -> (Object[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$1).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(x$2).asScala()).toArray(tag), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass()))), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(tag.runtimeClass())))), tag);
    }

    private static final Object[] toPublicRepr$1(int[] pattern, ClassTag evidence$1$1, Object freqItems$1) {
        ArrayBuilder sequenceBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$1$1.runtimeClass())));
        ArrayBuilder itemsetBuilder = ArrayBuilder$.MODULE$.make(evidence$1$1);
        int n = pattern.length;
        for (int i = 1; i < n; ++i) {
            BoxedUnit boxedUnit;
            int x = pattern[i];
            if (x == 0) {
                sequenceBuilder.$plus$eq(itemsetBuilder.result());
                itemsetBuilder.clear();
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            boxedUnit = itemsetBuilder.$plus$eq(ScalaRunTime$.MODULE$.array_apply(freqItems$1, x - 1));
        }
        return (Object[])sequenceBuilder.result();
    }

    private PrefixSpan(double minSupport, int maxPatternLength, long maxLocalProjDBSize) {
        this.minSupport = minSupport;
        this.maxPatternLength = maxPatternLength;
        this.maxLocalProjDBSize = maxLocalProjDBSize;
        Logging.$init$((Logging)this);
    }

    public PrefixSpan() {
        this(0.1, 10, 32000000L);
    }

    public static class FreqSequence<Item>
    implements scala.Serializable {
        private final Object[] sequence;
        private final long freq;

        public Object[] sequence() {
            return this.sequence;
        }

        public long freq() {
            return this.freq;
        }

        public List<List<Item>> javaSequence() {
            return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(this.sequence())).map((Function1 & Serializable & scala.Serializable)x$10 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.genericArrayOps(x$10).toList()).asJava(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(List.class))))).toList()).asJava();
        }

        public FreqSequence(Object[] sequence, long freq) {
            this.sequence = sequence;
            this.freq = freq;
        }
    }

    public static class Postfix
    implements scala.Serializable {
        private final int[] items;
        private final int start;
        private final int[] partialStarts;

        public int[] items() {
            return this.items;
        }

        public int start() {
            return this.start;
        }

        public int[] partialStarts() {
            return this.partialStarts;
        }

        private int fullStart() {
            int i = this.start();
            while (this.items()[i] != 0) {
                ++i;
            }
            return i;
        }

        public Iterator<Tuple2<Object, Object>> genPrefixItems() {
            int n1 = this.items().length - 1;
            scala.collection.mutable.Map prefixes = Map$.MODULE$.empty();
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)start -> {
                int i = start;
                int x = -this.items()[i];
                while (x != 0) {
                    if (!prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) {
                        prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
                    }
                    x = -this.items()[++i];
                }
            });
            for (int i = this.fullStart(); i < n1; ++i) {
                int x = this.items()[i];
                if (x == 0 || prefixes.contains((Object)BoxesRunTime.boxToInteger((int)x))) continue;
                prefixes.update((Object)BoxesRunTime.boxToInteger((int)x), (Object)BoxesRunTime.boxToLong((long)(n1 - i)));
            }
            return prefixes.iterator();
        }

        public boolean nonEmpty() {
            return this.items().length > this.start() + 1;
        }

        public Postfix project(int prefix) {
            Predef$.MODULE$.require(prefix != 0);
            int n1 = this.items().length - 1;
            BooleanRef matched = BooleanRef.create((boolean)false);
            IntRef newStart = IntRef.create((int)n1);
            ArrayBuilder newPartialStarts = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            if (prefix < 0) {
                int target = -prefix;
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).foreach((Function1 & Serializable & scala.Serializable)start -> Postfix.$anonfun$project$1(this, target, matched, newStart, newPartialStarts, BoxesRunTime.unboxToInt((Object)start)));
            } else {
                int target = prefix;
                for (int i = this.fullStart(); i < n1; ++i) {
                    BoxedUnit boxedUnit;
                    int x = this.items()[i];
                    if (x == target) {
                        if (!matched.elem) {
                            newStart.elem = i;
                            matched.elem = true;
                        }
                        if (this.items()[i + 1] != 0) {
                            boxedUnit = newPartialStarts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                            continue;
                        }
                        boxedUnit = BoxedUnit.UNIT;
                        continue;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            return new Postfix(this.items(), newStart.elem, (int[])newPartialStarts.result());
        }

        private Postfix project(int[] prefix) {
            boolean partial = true;
            Postfix cur = this;
            int np = prefix.length;
            for (int i = 0; i < np && cur.nonEmpty(); ++i) {
                int x = prefix[i];
                if (x == 0) {
                    partial = false;
                    continue;
                }
                if (partial) {
                    cur = cur.project(-x);
                    continue;
                }
                cur = cur.project(x);
                partial = true;
            }
            return cur;
        }

        public Postfix project(Prefix prefix) {
            return this.project(prefix.items());
        }

        public Postfix compressed() {
            if (this.start() > 0) {
                return new Postfix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).slice(this.start(), this.items().length), 0, (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$9 -> x$9 - this.start(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())));
            }
            return this;
        }

        public static final /* synthetic */ Object $anonfun$project$1(Postfix $this, int target$1, BooleanRef matched$1, IntRef newStart$1, ArrayBuilder newPartialStarts$1, int start) {
            int i = start;
            int x = $this.items()[i];
            while (x != target$1 && x != 0) {
                x = $this.items()[++i];
            }
            if (x == target$1) {
                ++i;
                if (!matched$1.elem) {
                    newStart$1.elem = i;
                    matched$1.elem = true;
                }
                if ($this.items()[i] != 0) {
                    return newPartialStarts$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }

        public Postfix(int[] items, int start, int[] partialStarts) {
            block0: {
                this.items = items;
                this.start = start;
                this.partialStarts = partialStarts;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(items)).last()) == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("The last item in a postfix must be zero, but got ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).last()).append(".").toString());
                if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partialStarts)).nonEmpty()) break block0;
                Predef$.MODULE$.require(BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(partialStarts)).head()) >= start, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append("The first partial start cannot be smaller than the start index,").append("but got partialStarts.head = ").append(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.partialStarts())).head()).append(" < start = ").append(this.start()).append(".").toString());
            }
        }
    }

    public static class Prefix
    implements scala.Serializable {
        private final int[] items;
        private final int length;
        private final int id;

        public int[] items() {
            return this.items;
        }

        public int length() {
            return this.length;
        }

        public int id() {
            return this.id;
        }

        public Prefix $colon$plus(int item) {
            Predef$.MODULE$.require(item != 0);
            if (item < 0) {
                return new Prefix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).$colon$plus((Object)BoxesRunTime.boxToInteger((int)(-item)), ClassTag$.MODULE$.Int()), this.length() + 1);
            }
            return new Prefix((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.items())).$plus$plus((GenTraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{0, item})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())), this.length() + 1);
        }

        public Prefix(int[] items, int length) {
            this.items = items;
            this.length = length;
            this.id = PrefixSpan$Prefix$.MODULE$.org$apache$spark$mllib$fpm$PrefixSpan$Prefix$$nextId();
        }
    }
}

