/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.StreamingConf$;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGenerator$GeneratorState$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.RateLimiter;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}h!\u0002&L\u00015+\u0006\u0002\u00031\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011\u0015\u0004!\u0011!Q\u0001\n\u0019D\u0001\u0002\u001c\u0001\u0003\u0002\u0003\u0006I!\u001c\u0005\tc\u0002\u0011\t\u0011)A\u0005e\")\u0001\u0010\u0001C\u0001s\u001a)q\u0010\u0001#\u0002\u0002!Q\u0011Q\u0003\u0004\u0003\u0016\u0004%\t!a\u0006\t\u0015\u0005\u0015bA!E!\u0002\u0013\tI\u0002\u0003\u0006\u0002(\u0019\u0011)\u001a!C\u0001\u0003SA!\"!\u0011\u0007\u0005#\u0005\u000b\u0011BA\u0016\u0011\u0019Ah\u0001\"\u0001\u0002D!I\u0011Q\n\u0004\u0002\u0002\u0013\u0005\u0011q\n\u0005\n\u0003+2\u0011\u0013!C\u0001\u0003/B\u0011\"!\u001c\u0007#\u0003%\t!a\u001c\t\u0013\u0005Md!!A\u0005B\u0005U\u0004\"CAD\r\u0005\u0005I\u0011AAE\u0011%\tYIBA\u0001\n\u0003\ti\tC\u0005\u0002\u0014\u001a\t\t\u0011\"\u0011\u0002\u0016\"I\u0011q\u0014\u0004\u0002\u0002\u0013\u0005\u0011\u0011\u0015\u0005\n\u0003W3\u0011\u0011!C!\u0003[C\u0011\"a,\u0007\u0003\u0003%\t%!-\t\u0013\u0005Mf!!A\u0005B\u0005Uv!CA]\u0001\u0005\u0005\t\u0012BA^\r!y\b!!A\t\n\u0005u\u0006B\u0002=\u0019\t\u0003\tY\rC\u0005\u00020b\t\t\u0011\"\u0012\u00022\"I\u0011Q\u001a\r\u0002\u0002\u0013\u0005\u0015q\u001a\u0005\n\u0003+D\u0012\u0011!CA\u0003/<q!!;\u0001\u0011\u0013\tYOB\u0004\u0002n\u0002AI!a<\t\ratB\u0011AA|\u000b\u0019\tiO\b\u0001\u0002z\"I!\u0011\u0001\u0010C\u0002\u0013\u0005!1\u0001\u0005\t\u0005\u000bq\u0002\u0015!\u0003\u0002z\"I!q\u0001\u0010C\u0002\u0013\u0005!1\u0001\u0005\t\u0005\u0013q\u0002\u0015!\u0003\u0002z\"I!1\u0002\u0010C\u0002\u0013\u0005!1\u0001\u0005\t\u0005\u001bq\u0002\u0015!\u0003\u0002z\"I!q\u0002\u0010C\u0002\u0013\u0005!1\u0001\u0005\t\u0005#q\u0002\u0015!\u0003\u0002z\"I!1\u0003\u0010C\u0002\u0013\u0005!1\u0001\u0005\t\u0005+q\u0002\u0015!\u0003\u0002z\"I!q\u0003\u0001C\u0002\u0013%!\u0011\u0004\u0005\t\u0005C\u0001\u0001\u0015!\u0003\u0003\u001c!I!1\u0005\u0001C\u0002\u0013%!Q\u0005\u0005\t\u0005c\u0001\u0001\u0015!\u0003\u0003(!I!1\u0007\u0001C\u0002\u0013%\u0011\u0011\u0012\u0005\b\u0005k\u0001\u0001\u0015!\u0003g\u0011%\u00119\u0004\u0001b\u0001\n\u0013\u0011I\u0004\u0003\u0005\u0003J\u0001\u0001\u000b\u0011\u0002B\u001e\u0011%\u0011Y\u0005\u0001b\u0001\n\u0013\u0011i\u0005\u0003\u0005\u0003V\u0001\u0001\u000b\u0011\u0002B(\u0011%\u00119\u0006\u0001a\u0001\n\u0013\tI\u0003C\u0005\u0003Z\u0001\u0001\r\u0011\"\u0003\u0003\\!A!Q\r\u0001!B\u0013\tY\u0003C\u0005\u0003p\u0001\u0001\r\u0011\"\u0003\u0003r!I!q\u000f\u0001A\u0002\u0013%!\u0011\u0010\u0005\t\u0005{\u0002\u0001\u0015)\u0003\u0003t!9!\u0011\u0011\u0001\u0005\u0002\t\r\u0005b\u0002BC\u0001\u0011\u0005!1\u0011\u0005\b\u0005\u000f\u0003A\u0011\u0001BE\u0011\u001d\u0011y\t\u0001C\u0001\u0005#CqA!'\u0001\t\u0003\u0011Y\nC\u0004\u0003:\u0002!\tAa/\t\u000f\tu\u0006\u0001\"\u0001\u0003<\"9!q\u0018\u0001\u0005\n\t\u0005\u0007b\u0002Bd\u0001\u0011%!1\u0011\u0005\b\u0005\u0013\u0004A\u0011\u0002Bf\u0011\u001d\u0011I\u000f\u0001C\u0005\u0005W<!B!=L\u0003\u0003E\t!\u0014Bz\r%Q5*!A\t\u00025\u0013)\u0010\u0003\u0004y\u000f\u0012\u0005!q\u001f\u0005\n\u0005s<\u0015\u0013!C\u0001\u0005w\u0014aB\u00117pG.<UM\\3sCR|'O\u0003\u0002M\u001b\u0006A!/Z2fSZ,'O\u0003\u0002O\u001f\u0006I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003!F\u000bQa\u001d9be.T!AU*\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0016aA8sON\u0019\u0001A\u0016.\u0011\u0005]CV\"A&\n\u0005e[%a\u0003*bi\u0016d\u0015.\\5uKJ\u0004\"a\u00170\u000e\u0003qS!!X(\u0002\u0011%tG/\u001a:oC2L!a\u0018/\u0003\u000f1{wmZ5oO\u0006AA.[:uK:,'o\u0001\u0001\u0011\u0005]\u001b\u0017B\u00013L\u0005Y\u0011En\\2l\u000f\u0016tWM]1u_Jd\u0015n\u001d;f]\u0016\u0014\u0018A\u0003:fG\u0016Lg/\u001a:JIB\u0011qM[\u0007\u0002Q*\t\u0011.A\u0003tG\u0006d\u0017-\u0003\u0002lQ\n\u0019\u0011J\u001c;\u0002\t\r|gN\u001a\t\u0003]>l\u0011aT\u0005\u0003a>\u0013\u0011b\u00159be.\u001cuN\u001c4\u0002\u000b\rdwnY6\u0011\u0005M4X\"\u0001;\u000b\u0005U|\u0015\u0001B;uS2L!a\u001e;\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)\u0015Q8\u0010`?\u007f!\t9\u0006\u0001C\u0003a\u000b\u0001\u0007!\rC\u0003f\u000b\u0001\u0007a\rC\u0003m\u000b\u0001\u0007Q\u000eC\u0004r\u000bA\u0005\t\u0019\u0001:\u0003\u000b\tcwnY6\u0014\u000f\u0019\t\u0019!!\u0003\u0002\u0010A\u0019q-!\u0002\n\u0007\u0005\u001d\u0001N\u0001\u0004B]f\u0014VM\u001a\t\u0004O\u0006-\u0011bAA\u0007Q\n9\u0001K]8ek\u000e$\bcA4\u0002\u0012%\u0019\u00111\u00035\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0005%$WCAA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010\u001f\u000691\u000f^8sC\u001e,\u0017\u0002BA\u0012\u0003;\u0011Qb\u0015;sK\u0006l'\t\\8dW&#\u0017aA5eA\u00051!-\u001e4gKJ,\"!a\u000b\u0011\r\u00055\u0012qGA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003kA\u0017AC2pY2,7\r^5p]&!\u0011\u0011HA\u0018\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\u0007\u001d\fi$C\u0002\u0002@!\u00141!\u00118z\u0003\u001d\u0011WO\u001a4fe\u0002\"b!!\u0012\u0002J\u0005-\u0003cAA$\r5\t\u0001\u0001C\u0004\u0002\u0016-\u0001\r!!\u0007\t\u000f\u0005\u001d2\u00021\u0001\u0002,\u0005!1m\u001c9z)\u0019\t)%!\u0015\u0002T!I\u0011Q\u0003\u0007\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u0005\n\u0003Oa\u0001\u0013!a\u0001\u0003W\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002Z)\"\u0011\u0011DA.W\t\ti\u0006\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0013Ut7\r[3dW\u0016$'bAA4Q\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0014\u0011\r\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003cRC!a\u000b\u0002\\\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005!A.\u00198h\u0015\t\t\t)\u0001\u0003kCZ\f\u0017\u0002BAC\u0003w\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLX#\u00014\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111HAH\u0011!\t\t*EA\u0001\u0002\u00041\u0017a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0018B1\u0011\u0011TAN\u0003wi!!a\r\n\t\u0005u\u00151\u0007\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002$\u0006%\u0006cA4\u0002&&\u0019\u0011q\u00155\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011S\n\u0002\u0002\u0003\u0007\u00111H\u0001\tQ\u0006\u001c\bnQ8eKR\ta-\u0001\u0005u_N#(/\u001b8h)\t\t9(\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003G\u000b9\fC\u0005\u0002\u0012Z\t\t\u00111\u0001\u0002<\u0005)!\t\\8dWB\u0019\u0011q\t\r\u0014\u000ba\ty,a\u0004\u0011\u0015\u0005\u0005\u0017qYA\r\u0003W\t)%\u0004\u0002\u0002D*\u0019\u0011Q\u00195\u0002\u000fI,h\u000e^5nK&!\u0011\u0011ZAb\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0003w\u000bQ!\u00199qYf$b!!\u0012\u0002R\u0006M\u0007bBA\u000b7\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003OY\u0002\u0019AA\u0016\u0003\u001d)h.\u00199qYf$B!!7\u0002fB)q-a7\u0002`&\u0019\u0011Q\u001c5\u0003\r=\u0003H/[8o!\u001d9\u0017\u0011]A\r\u0003WI1!a9i\u0005\u0019!V\u000f\u001d7fe!I\u0011q\u001d\u000f\u0002\u0002\u0003\u0007\u0011QI\u0001\u0004q\u0012\u0002\u0014AD$f]\u0016\u0014\u0018\r^8s'R\fG/\u001a\t\u0004\u0003\u000fr\"AD$f]\u0016\u0014\u0018\r^8s'R\fG/Z\n\u0004=\u0005E\bcA4\u0002t&\u0019\u0011Q\u001f5\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u000b\u0003\u0003W\u0004B!a?\u0002~6\ta$\u0003\u0003\u0002\u0000\u0006M(!\u0002,bYV,\u0017aC%oSRL\u0017\r\\5{K\u0012,\"!!?\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\u0002\r\u0005\u001bG/\u001b<f\u0003\u001d\t5\r^5wK\u0002\n\u0011c\u0015;paB,G-\u00113eS:<G)\u0019;b\u0003I\u0019Fo\u001c9qK\u0012\fE\rZ5oO\u0012\u000bG/\u0019\u0011\u0002/M#x\u000e\u001d9fI\u001e+g.\u001a:bi&twM\u00117pG.\u001c\u0018\u0001G*u_B\u0004X\rZ$f]\u0016\u0014\u0018\r^5oO\ncwnY6tA\u0005Q1\u000b^8qa\u0016$\u0017\t\u001c7\u0002\u0017M#x\u000e\u001d9fI\u0006cG\u000eI\u0001\u0010E2|7m[%oi\u0016\u0014h/\u00197NgV\u0011!1\u0004\t\u0004O\nu\u0011b\u0001B\u0010Q\n!Aj\u001c8h\u0003A\u0011Gn\\2l\u0013:$XM\u001d<bY6\u001b\b%\u0001\ncY>\u001c7.\u00138uKJ4\u0018\r\u001c+j[\u0016\u0014XC\u0001B\u0014!\u0011\u0011IC!\f\u000e\u0005\t-\"BA;N\u0013\u0011\u0011yCa\u000b\u0003\u001dI+7-\u001e:sS:<G+[7fe\u0006\u0019\"\r\\8dW&sG/\u001a:wC2$\u0016.\\3sA\u0005q!\r\\8dWF+X-^3TSj,\u0017a\u00042m_\u000e\\\u0017+^3vKNK'0\u001a\u0011\u0002!\tdwnY6t\r>\u0014\b+^:iS:<WC\u0001B\u001e!\u0019\u0011iD!\u0012\u0002F5\u0011!q\b\u0006\u0005\u0005\u0003\u0012\u0019%\u0001\u0006d_:\u001cWO\u001d:f]RT1!^A@\u0013\u0011\u00119Ea\u0010\u0003%\u0005\u0013(/Y=CY>\u001c7.\u001b8h#V,W/Z\u0001\u0012E2|7m[:G_J\u0004Vo\u001d5j]\u001e\u0004\u0013A\u00052m_\u000e\\\u0007+^:iS:<G\u000b\u001b:fC\u0012,\"Aa\u0014\u0011\t\u0005e$\u0011K\u0005\u0005\u0005'\nYH\u0001\u0004UQJ,\u0017\rZ\u0001\u0014E2|7m\u001b)vg\"Lgn\u001a+ie\u0016\fG\rI\u0001\u000eGV\u0014(/\u001a8u\u0005V4g-\u001a:\u0002#\r,(O]3oi\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0003\u0003^\t\r\u0004cA4\u0003`%\u0019!\u0011\r5\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003#3\u0014\u0011!a\u0001\u0003W\tabY;se\u0016tGOQ;gM\u0016\u0014\b\u0005K\u00028\u0005S\u00022a\u001aB6\u0013\r\u0011i\u0007\u001b\u0002\tm>d\u0017\r^5mK\u0006)1\u000f^1uKV\u0011!1\u000f\t\u0005\u0005k\niPD\u0002\u0002Hu\t\u0011b\u001d;bi\u0016|F%Z9\u0015\t\tu#1\u0010\u0005\n\u0003#K\u0014\u0011!a\u0001\u0005g\naa\u001d;bi\u0016\u0004\u0003f\u0001\u001e\u0003j\u0005)1\u000f^1siR\u0011!QL\u0001\u0005gR|\u0007/A\u0004bI\u0012$\u0015\r^1\u0015\t\tu#1\u0012\u0005\b\u0005\u001bk\u0004\u0019AA\u001e\u0003\u0011!\u0017\r^1\u0002'\u0005$G\rR1uC^KG\u000f[\"bY2\u0014\u0017mY6\u0015\r\tu#1\u0013BK\u0011\u001d\u0011iI\u0010a\u0001\u0003wAqAa&?\u0001\u0004\tY$\u0001\u0005nKR\fG-\u0019;b\u0003m\tG\rZ'vYRL\u0007\u000f\\3ECR\fw+\u001b;i\u0007\u0006dGNY1dWR1!Q\fBO\u0005oCqAa(@\u0001\u0004\u0011\t+\u0001\u0007eCR\f\u0017\n^3sCR|'\u000f\u0005\u0004\u0003$\nM\u00161\b\b\u0005\u0005K\u0013yK\u0004\u0003\u0003(\n5VB\u0001BU\u0015\r\u0011Y+Y\u0001\u0007yI|w\u000e\u001e \n\u0003%L1A!-i\u0003\u001d\u0001\u0018mY6bO\u0016LA!!(\u00036*\u0019!\u0011\u00175\t\u000f\t]u\b1\u0001\u0002<\u0005A\u0011n]!di&4X\r\u0006\u0002\u0002$\u0006I\u0011n]*u_B\u0004X\rZ\u0001\u0014kB$\u0017\r^3DkJ\u0014XM\u001c;Ck\u001a4WM\u001d\u000b\u0005\u0005;\u0012\u0019\rC\u0004\u0003F\n\u0003\rAa\u0007\u0002\tQLW.Z\u0001\u0012W\u0016,\u0007\u000fU;tQ&twM\u00117pG.\u001c\u0018a\u0003:fa>\u0014H/\u0012:s_J$bA!\u0018\u0003N\n}\u0007b\u0002Bh\t\u0002\u0007!\u0011[\u0001\b[\u0016\u001c8/Y4f!\u0011\u0011\u0019Na7\u000f\t\tU'q\u001b\t\u0004\u0005OC\u0017b\u0001BmQ\u00061\u0001K]3eK\u001aLA!!\"\u0003^*\u0019!\u0011\u001c5\t\u000f\t\u0005H\t1\u0001\u0003d\u0006\tA\u000f\u0005\u0003\u0003$\n\u0015\u0018\u0002\u0002Bt\u0005k\u0013\u0011\u0002\u00165s_^\f'\r\\3\u0002\u0013A,8\u000f\u001b\"m_\u000e\\G\u0003\u0002B/\u0005[DqAa<F\u0001\u0004\t)%A\u0003cY>\u001c7.\u0001\bCY>\u001c7nR3oKJ\fGo\u001c:\u0011\u0005];5cA$\u0002\u0004Q\u0011!1_\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tu(f\u0001:\u0002\\\u0001")
public class BlockGenerator
extends RateLimiter {
    private volatile BlockGenerator$Block$ Block$module;
    private volatile BlockGenerator$GeneratorState$ GeneratorState$module;
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final long blockIntervalMs;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile Enumeration.Value state;

    public static Clock $lessinit$greater$default$4() {
        return BlockGenerator$.MODULE$.$lessinit$greater$default$4();
    }

    private BlockGenerator$Block$ Block() {
        if (this.Block$module == null) {
            this.Block$lzycompute$1();
        }
        return this.Block$module;
    }

    private BlockGenerator$GeneratorState$ GeneratorState() {
        if (this.GeneratorState$module == null) {
            this.GeneratorState$lzycompute$1();
        }
        return this.GeneratorState$module;
    }

    private long blockIntervalMs() {
        return this.blockIntervalMs;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    private ArrayBlockingQueue<Block> blocksForPushing() {
        return this.blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    private Enumeration.Value state() {
        return this.state;
    }

    private void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public synchronized void start() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Initialized();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.state_$eq(this.GeneratorState().Active());
            this.blockIntervalTimer().start();
            this.blockPushingThread().start();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started BlockGenerator");
            return;
        }
        throw new SparkException(new StringBuilder(74).append("Cannot start BlockGenerator as its not in the Initialized state [state = ").append(this.state()).append("]").toString());
    }

    public void stop() {
        block11: {
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                block10: {
                    Enumeration.Value value = this.state();
                    Enumeration.Value value2 = this.GeneratorState().Active();
                    if (value != null ? !value.equals(value2) : value2 != null) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Cannot stop BlockGenerator as its not in the Active state [state = ").append(this.state()).append("]").toString());
                        break block10;
                    }
                    this.state_$eq(this.GeneratorState().StoppedAddingData());
                    break block11;
                }
                return;
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping BlockGenerator");
        this.blockIntervalTimer().stop(false);
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            this.state_$eq(this.GeneratorState().StoppedGeneratingBlocks());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for block pushing thread to terminate");
        this.blockPushingThread().join();
        BlockGenerator blockGenerator2 = this;
        synchronized (blockGenerator2) {
            this.state_$eq(this.GeneratorState().StoppedAll());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped BlockGenerator");
    }

    public void addData(Object data) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.waitToPush();
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$eq(data);
            }
            return;
        }
        throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
    }

    public void addDataWithCallback(Object data, Object metadata) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.waitToPush();
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$eq(data);
                this.listener.onAddData(data, metadata);
            }
            return;
        }
        throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
    }

    public void addMultipleDataWithCallback(Iterator<Object> dataIterator, Object metadata) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            ArrayBuffer tempBuffer = new ArrayBuffer();
            dataIterator.foreach((Function1 & Serializable & scala.Serializable)data -> {
                this.waitToPush();
                return tempBuffer.$plus$eq(data);
            });
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$plus$eq((TraversableOnce)tempBuffer);
                this.listener.onAddData(tempBuffer, metadata);
            }
            return;
        }
        throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
    }

    public boolean isActive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isStopped() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().StoppedAll();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private void updateCurrentBuffer(long time) {
        try {
            Block newBlock = null;
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                if (this.currentBuffer().nonEmpty()) {
                    ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
                    this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
                    StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockIntervalMs());
                    this.listener.onGenerateBlock(blockId);
                    newBlock = new Block(this, blockId, newBlockBuffer);
                }
            }
            if (newBlock != null) {
                this.blocksForPushing().put(newBlock);
            }
        }
        catch (InterruptedException ie) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Block updating timer thread was interrupted");
        }
        catch (Exception e) {
            this.reportError("Error in block updating thread", e);
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started block pushing thread");
        try {
            while (this.areBlocksBeingGenerated$1()) {
                Option option = Option$.MODULE$.apply((Object)this.blocksForPushing().poll(10L, TimeUnit.MILLISECONDS));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Block block = (Block)some.value();
                    this.pushBlock(block);
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    continue;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Pushing out the last ").append(this.blocksForPushing().size()).append(" blocks").toString());
            while (!this.blocksForPushing().isEmpty()) {
                Block block = this.blocksForPushing().take();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Pushing block ").append(block).toString());
                this.pushBlock(block);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Blocks left to push ").append(this.blocksForPushing().size()).toString());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped block pushing thread");
        }
        catch (InterruptedException ie) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Block pushing thread was interrupted");
        }
        catch (Exception e) {
            this.reportError("Error in block pushing thread", e);
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Pushed block ").append(block.id()).toString());
    }

    private final void Block$lzycompute$1() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module == null) {
                this.Block$module = new BlockGenerator$Block$(this);
            }
        }
    }

    private final void GeneratorState$lzycompute$1() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.GeneratorState$module == null) {
                this.GeneratorState$module = new BlockGenerator$GeneratorState$(this);
            }
        }
    }

    private final synchronized boolean areBlocksBeingGenerated$1() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().StoppedGeneratingBlocks();
        return value == null ? value2 != null : !value.equals(value2);
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf, Clock clock) {
        this.listener = listener;
        this.receiverId = receiverId;
        super(conf);
        this.blockIntervalMs = BoxesRunTime.unboxToLong((Object)conf.get(StreamingConf$.MODULE$.BLOCK_INTERVAL()));
        Predef$.MODULE$.require(this.blockIntervalMs() > 0L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("'").append(StreamingConf$.MODULE$.BLOCK_INTERVAL().key()).append("' should be a positive value").toString());
        this.blockIntervalTimer = new RecurringTimer(clock, this.blockIntervalMs(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> this.updateCurrentBuffer(time), "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new Thread(this){
            private final /* synthetic */ BlockGenerator $outer;

            public void run() {
                this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.currentBuffer = new ArrayBuffer();
        this.state = this.GeneratorState().Initialized();
    }

    private class Block
    implements Product,
    scala.Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.id();
                }
                case 1: {
                    return this.buffer();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            if (((Block)object).org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() != this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

