/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.math3.special;

import org.apache.hadoop.shaded.org.apache.commons.math3.special.Gamma;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.FastMath;

public class Erf {
    private static final double X_CRIT = 0.4769362762044697;

    private Erf() {
    }

    public static double erf(double x) {
        if (FastMath.abs(x) > 40.0) {
            return x > 0.0 ? 1.0 : -1.0;
        }
        double ret = Gamma.regularizedGammaP(0.5, x * x, 1.0E-15, 10000);
        return x < 0.0 ? -ret : ret;
    }

    public static double erfc(double x) {
        if (FastMath.abs(x) > 40.0) {
            return x > 0.0 ? 0.0 : 2.0;
        }
        double ret = Gamma.regularizedGammaQ(0.5, x * x, 1.0E-15, 10000);
        return x < 0.0 ? 2.0 - ret : ret;
    }

    public static double erf(double x1, double x2) {
        if (x1 > x2) {
            return -Erf.erf(x2, x1);
        }
        return x1 < -0.4769362762044697 ? (x2 < 0.0 ? Erf.erfc(-x2) - Erf.erfc(-x1) : Erf.erf(x2) - Erf.erf(x1)) : (x2 > 0.4769362762044697 && x1 > 0.0 ? Erf.erfc(x1) - Erf.erfc(x2) : Erf.erf(x2) - Erf.erf(x1));
    }
}

