/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BitLength$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the bit length of string data or number of bits of binary data.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       72\n      > SELECT _FUNC_(x'537061726b2053514c');\n       72\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\r\u001b\u0001\u001eB\u0001b\u0010\u0001\u0003\u0016\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0003\")Q\t\u0001C\u0001\r\")\u0011\n\u0001C!\u0015\")\u0011\u000b\u0001C!%\")\u0011\r\u0001C)E\")\u0001\u000e\u0001C!S\")q\u000f\u0001C!q\"9\u00111\u0001\u0001\u0005R\u0005\u0015\u0001\"CA\u0006\u0001\u0005\u0005I\u0011AA\u0007\u0011%\t\t\u0002AI\u0001\n\u0003\t\u0019\u0002C\u0005\u0002*\u0001\t\t\u0011\"\u0011\u0002,!I\u00111\b\u0001\u0002\u0002\u0013\u0005\u0011Q\b\u0005\n\u0003\u000b\u0002\u0011\u0011!C\u0001\u0003\u000fB\u0011\"!\u0014\u0001\u0003\u0003%\t%a\u0014\t\u0013\u0005u\u0003!!A\u0005\u0002\u0005}\u0003\"CA5\u0001\u0005\u0005I\u0011IA6\u000f%\tyIGA\u0001\u0012\u0003\t\tJ\u0002\u0005\u001a5\u0005\u0005\t\u0012AAJ\u0011\u0019)5\u0003\"\u0001\u0002\"\"I\u00111U\n\u0002\u0002\u0013\u0015\u0013Q\u0015\u0005\n\u0003O\u001b\u0012\u0011!CA\u0003SC\u0011\"!,\u0014\u0003\u0003%\t)a,\t\u0013\u0005m6#!A\u0005\n\u0005u&!\u0003\"ji2+gn\u001a;i\u0015\tYB$A\u0006fqB\u0014Xm]:j_:\u001c(BA\u000f\u001f\u0003!\u0019\u0017\r^1msN$(BA\u0010!\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003C\t\nQa\u001d9be.T!a\t\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0013aA8sO\u000e\u00011C\u0002\u0001)Y=2D\b\u0005\u0002*U5\t!$\u0003\u0002,5\tyQK\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002*[%\u0011aF\u0007\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011\u0001g\r\b\u0003SEJ!A\r\u000e\u0002\u000fA\f7m[1hK&\u0011A'\u000e\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\t\u0011$\u0004\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004HA\u0004Qe>$Wo\u0019;\u0011\u0005]j\u0014B\u0001 9\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005\t\u0005CA\u0015C\u0013\t\u0019%D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002H\u0011B\u0011\u0011\u0006\u0001\u0005\u0006\u007f\r\u0001\r!Q\u0001\tI\u0006$\u0018\rV=qKV\t1\n\u0005\u0002M\u001f6\tQJ\u0003\u0002O=\u0005)A/\u001f9fg&\u0011\u0001+\u0014\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0003M\u00032\u0001V._\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002YM\u00051AH]8pizJ\u0011!O\u0005\u0003eaJ!\u0001X/\u0003\u0007M+\u0017O\u0003\u00023qA\u0011AjX\u0005\u0003A6\u0013\u0001#\u00112tiJ\f7\r\u001e#bi\u0006$\u0016\u0010]3\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0005\r4\u0007CA\u001ce\u0013\t)\u0007HA\u0002B]fDQa\u001a\u0004A\u0002\r\fQA^1mk\u0016\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007)\u0004X\u000f\u0005\u0002l]6\tAN\u0003\u0002n5\u000591m\u001c3fO\u0016t\u0017BA8m\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"B9\b\u0001\u0004\u0011\u0018aA2uqB\u00111n]\u0005\u0003i2\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003w\u000f\u0001\u0007!.\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003e\u0004\"A\u001f@\u000f\u0005md\bC\u0001,9\u0013\ti\b(\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!AB*ue&twM\u0003\u0002~q\u0005!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2aRA\u0004\u0011\u0019\tI!\u0003a\u0001\u0003\u0006Aa.Z<DQ&dG-\u0001\u0003d_BLHcA$\u0002\u0010!9qH\u0003I\u0001\u0002\u0004\t\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003+Q3!QA\fW\t\tI\u0002\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0012q\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0012Q\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002.A!\u0011qFA\u001d\u001b\t\t\tD\u0003\u0003\u00024\u0005U\u0012\u0001\u00027b]\u001eT!!a\u000e\u0002\t)\fg/Y\u0005\u0004\u007f\u0006E\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA !\r9\u0014\u0011I\u0005\u0004\u0003\u0007B$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA2\u0002J!I\u00111\n\b\u0002\u0002\u0003\u0007\u0011qH\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0003#BA*\u00033\u001aWBAA+\u0015\r\t9\u0006O\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA.\u0003+\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011MA4!\r9\u00141M\u0005\u0004\u0003KB$a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0017\u0002\u0012\u0011!a\u0001G\u00061Q-];bYN$B!!\u0019\u0002n!A\u00111J\t\u0002\u0002\u0003\u00071\rK\n\u0001\u0003c\n9(!\u001f\u0002~\u0005}\u00141QAC\u0003\u0013\u000bY\tE\u0002*\u0003gJ1!!\u001e\u001b\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001f\u0002-~3UKT\"`Q\u0015D\bO]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!E&$\b\u0005\\3oORD\u0007e\u001c4!gR\u0014\u0018N\\4!I\u0006$\u0018\rI8sA9,XNY3sA=4\u0007EY5ug\u0002zg\r\t2j]\u0006\u0014\u0018\u0010\t3bi\u0006t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0015a\u001e\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oIR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006_\u00146g]\u0002d'M\u001c3m\t\u0014\u0004'N\u001a6cQ\u001aw%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!oIR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003\u000f\u000bQA\r\u00184]A\nQa\u001a:pkB\f#!!$\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0013\tKG\u000fT3oORD\u0007CA\u0015\u0014'\u0011\u0019\u0012Q\u0013\u001f\u0011\r\u0005]\u0015QT!H\u001b\t\tIJC\u0002\u0002\u001cb\nqA];oi&lW-\u0003\u0003\u0002 \u0006e%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011\u0011\u0011S\u0001\ti>\u001cFO]5oOR\u0011\u0011QF\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u000f\u0006-\u0006\"B \u0017\u0001\u0004\t\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003c\u000b9\f\u0005\u00038\u0003g\u000b\u0015bAA[q\t1q\n\u001d;j_:D\u0001\"!/\u0018\u0003\u0003\u0005\raR\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a0\u0011\t\u0005=\u0012\u0011Y\u0005\u0005\u0003\u0007\f\tD\u0001\u0004PE*,7\r\u001e")
public class BitLength
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(BitLength bitLength) {
        return BitLength$.MODULE$.unapply(bitLength);
    }

    public static <A> Function1<Expression, A> andThen(Function1<BitLength, A> function1) {
        return BitLength$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, BitLength> compose(Function1<A, Expression> function1) {
        return BitLength$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public DataType dataType() {
        return IntegerType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, BinaryType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object value) {
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)(((UTF8String)value).numBytes() * 8));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return BoxesRunTime.boxToInteger((int)(((byte[])value).length * 8));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        DataType dataType = this.child().dataType();
        if (StringType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(17).append("(").append((String)c).append(").numBytes() * 8").toString());
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return this.defineCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> new StringBuilder(13).append("(").append((String)c).append(").length * 8").toString());
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public String prettyName() {
        return "bit_length";
    }

    @Override
    public BitLength withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public BitLength copy(Expression child) {
        return new BitLength(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "BitLength";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitLength;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitLength)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitLength bitLength = (BitLength)x$1;
        Expression expression = this.child();
        Expression expression2 = bitLength.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitLength.canEqual(this)) return false;
        return true;
    }

    public BitLength(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

