/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master;

import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.DriverInfo;
import org.apache.spark.deploy.master.ExecutorDesc;
import org.apache.spark.deploy.master.WorkerResourceInfo;
import org.apache.spark.deploy.master.WorkerState$;
import org.apache.spark.resource.ResourceAllocator;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t%c!B\u001c9\u0001q\u0012\u0005\u0002\u0003'\u0001\u0005\u000b\u0007I\u0011\u0001(\t\u0011i\u0003!\u0011!Q\u0001\n=C\u0001b\u0017\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t9\u0002\u0011\t\u0011)A\u0005\u001f\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!b\u0001\n\u0003q\u0006\u0002\u00033\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u0011\u0015\u0004!Q1A\u0005\u0002yC\u0001B\u001a\u0001\u0003\u0002\u0003\u0006Ia\u0018\u0005\tO\u0002\u0011)\u0019!C\u0001Q\"Aq\u000e\u0001B\u0001B\u0003%\u0011\u000e\u0003\u0005q\u0001\t\u0015\r\u0011\"\u0001O\u0011!\t\bA!A!\u0002\u0013y\u0005\u0002\u0003:\u0001\u0005\u000b\u0007I\u0011A:\t\u0011m\u0004!\u0011!Q\u0001\nQDQ\u0001 \u0001\u0005\u0002uD1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0012!Y\u0011\u0011\u0006\u0001A\u0002\u0003\u0007I\u0011AA\u0016\u0011-\t9\u0004\u0001a\u0001\u0002\u0003\u0006K!a\u0005\t\u0017\u0005\u0005\u0003\u00011AA\u0002\u0013\u0005\u00111\t\u0005\f\u0003\u001b\u0002\u0001\u0019!a\u0001\n\u0003\ty\u0005C\u0006\u0002T\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0003bCA,\u0001\u0001\u0007\t\u0019!C\u0001\u00033B1\"a\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002n!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0005\u000b\u0015BA.\u0011)\t)\b\u0001a\u0001\u0002\u0004%\tA\u0018\u0005\f\u0003o\u0002\u0001\u0019!a\u0001\n\u0003\tI\b\u0003\u0006\u0002~\u0001\u0001\r\u0011!Q!\n}C!\"!!\u0001\u0001\u0004\u0005\r\u0011\"\u0001_\u0011-\t\u0019\t\u0001a\u0001\u0002\u0004%\t!!\"\t\u0015\u0005%\u0005\u00011A\u0001B\u0003&q\fC\u0006\u0002\u000e\u0002\u0001\r\u00111A\u0005\u0002\u0005=\u0005bCAL\u0001\u0001\u0007\t\u0019!C\u0001\u00033C1\"!(\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0012\"1\u0011\u0011\u0015\u0001\u0005\u0002yCa!a)\u0001\t\u0003q\u0006bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003W\u0003A\u0011AAW\u0011\u001d\ti\f\u0001C\u0001\u0003[Cq!a0\u0001\t\u0003\ti\u000bC\u0004\u0002B\u0002!I!a1\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\"1\u0011Q\u001c\u0001\u0005\u00029Cq!a8\u0001\t\u0003\t\t\u000fC\u0004\u0002h\u0002!\t!!;\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9!\u0011\u0001\u0001\u0005\u0002\t\r\u0001b\u0002B\u0005\u0001\u0011\u0005!1\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0001B\t\u0011\u001d\u0011)\u0002\u0001C\u0001\u0005/AqA!\u0007\u0001\t\u0003\u0011Y\u0002C\u0004\u0003:\u0001!\tAa\u000f\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D\tQqk\u001c:lKJLeNZ8\u000b\u0005eR\u0014AB7bgR,'O\u0003\u0002<y\u00051A-\u001a9m_fT!!\u0010 \u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0002\u0015AB1qC\u000eDWMC\u0001B\u0003\ry'oZ\n\u0004\u0001\rK\u0005C\u0001#H\u001b\u0005)%\"\u0001$\u0002\u000bM\u001c\u0017\r\\1\n\u0005!+%AB!osJ+g\r\u0005\u0002E\u0015&\u00111*\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0003S\u0012\u001c\u0001!F\u0001P!\t\u0001vK\u0004\u0002R+B\u0011!+R\u0007\u0002'*\u0011A+T\u0001\u0007yI|w\u000e\u001e \n\u0005Y+\u0015A\u0002)sK\u0012,g-\u0003\u0002Y3\n11\u000b\u001e:j]\u001eT!AV#\u0002\u0007%$\u0007%\u0001\u0003i_N$\u0018!\u00025pgR\u0004\u0013\u0001\u00029peR,\u0012a\u0018\t\u0003\t\u0002L!!Y#\u0003\u0007%sG/A\u0003q_J$\b%A\u0003d_J,7/\u0001\u0004d_J,7\u000fI\u0001\u0007[\u0016lwN]=\u0002\u000f5,Wn\u001c:zA\u0005AQM\u001c3q_&tG/F\u0001j!\tQW.D\u0001l\u0015\taG(A\u0002sa\u000eL!A\\6\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006IQM\u001c3q_&tG\u000fI\u0001\ro\u0016\u0014W+[!eIJ,7o]\u0001\u000eo\u0016\u0014W+[!eIJ,7o\u001d\u0011\u0002\u0013I,7o\\;sG\u0016\u001cX#\u0001;\u0011\tA+xj^\u0005\u0003mf\u00131!T1q!\tA\u00180D\u00019\u0013\tQ\bH\u0001\nX_J\\WM\u001d*fg>,(oY3J]\u001a|\u0017A\u0003:fg>,(oY3tA\u00051A(\u001b8jiz\"\u0002C`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0011\u0005a\u0004\u0001\"\u0002'\u0012\u0001\u0004y\u0005\"B.\u0012\u0001\u0004y\u0005\"B/\u0012\u0001\u0004y\u0006\"B2\u0012\u0001\u0004y\u0006\"B3\u0012\u0001\u0004y\u0006\"B4\u0012\u0001\u0004I\u0007\"\u00029\u0012\u0001\u0004y\u0005\"\u0002:\u0012\u0001\u0004!\u0018!C3yK\u000e,Ho\u001c:t+\t\t\u0019\u0002E\u0004\u0002\u0016\u0005}q*a\t\u000e\u0005\u0005]!\u0002BA\r\u00037\tq!\\;uC\ndWMC\u0002\u0002\u001e\u0015\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t#a\u0006\u0003\u000f!\u000b7\u000f['baB\u0019\u00010!\n\n\u0007\u0005\u001d\u0002H\u0001\u0007Fq\u0016\u001cW\u000f^8s\t\u0016\u001c8-A\u0007fq\u0016\u001cW\u000f^8sg~#S-\u001d\u000b\u0005\u0003[\t\u0019\u0004E\u0002E\u0003_I1!!\rF\u0005\u0011)f.\u001b;\t\u0013\u0005U2#!AA\u0002\u0005M\u0011a\u0001=%c\u0005QQ\r_3dkR|'o\u001d\u0011)\u0007Q\tY\u0004E\u0002E\u0003{I1!a\u0010F\u0005%!(/\u00198tS\u0016tG/A\u0004ee&4XM]:\u0016\u0005\u0005\u0015\u0003cBA\u000b\u0003?y\u0015q\t\t\u0004q\u0006%\u0013bAA&q\tQAI]5wKJLeNZ8\u0002\u0017\u0011\u0014\u0018N^3sg~#S-\u001d\u000b\u0005\u0003[\t\t\u0006C\u0005\u00026Y\t\t\u00111\u0001\u0002F\u0005AAM]5wKJ\u001c\b\u0005K\u0002\u0018\u0003w\tQa\u001d;bi\u0016,\"!a\u0017\u0011\t\u0005u\u00131\r\b\u0004q\u0006}\u0013bAA1q\u0005Yqk\u001c:lKJ\u001cF/\u0019;f\u0013\u0011\t)'a\u001a\u0003\u000bY\u000bG.^3\n\u0007\u0005%TIA\u0006F]VlWM]1uS>t\u0017!C:uCR,w\fJ3r)\u0011\ti#a\u001c\t\u0013\u0005U\u0012$!AA\u0002\u0005m\u0013AB:uCR,\u0007\u0005K\u0002\u001b\u0003w\t\u0011bY8sKN,6/\u001a3\u0002\u001b\r|'/Z:Vg\u0016$w\fJ3r)\u0011\ti#a\u001f\t\u0011\u0005UB$!AA\u0002}\u000b!bY8sKN,6/\u001a3!Q\ri\u00121H\u0001\u000b[\u0016lwN]=Vg\u0016$\u0017AD7f[>\u0014\u00180V:fI~#S-\u001d\u000b\u0005\u0003[\t9\t\u0003\u0005\u00026}\t\t\u00111\u0001`\u0003-iW-\\8ssV\u001bX\r\u001a\u0011)\u0007\u0001\nY$A\u0007mCN$\b*Z1si\n,\u0017\r^\u000b\u0003\u0003#\u00032\u0001RAJ\u0013\r\t)*\u0012\u0002\u0005\u0019>tw-A\tmCN$\b*Z1si\n,\u0017\r^0%KF$B!!\f\u0002\u001c\"I\u0011Q\u0007\u0012\u0002\u0002\u0003\u0007\u0011\u0011S\u0001\u000fY\u0006\u001cH\u000fS3beR\u0014W-\u0019;!Q\r\u0019\u00131H\u0001\nG>\u0014Xm\u001d$sK\u0016\f!\"\\3n_JLhI]3f\u0003M\u0011Xm]8ve\u000e,7/Q7pk:$hI]3f+\t\tI\u000b\u0005\u0003Qk>{\u0016!\u0004:fg>,(oY3t\u0013:4w.\u0006\u0002\u00020B)\u0001+^(\u00022B!\u00111WA]\u001b\t\t)LC\u0002\u00028r\n\u0001B]3t_V\u00148-Z\u0005\u0005\u0003w\u000b)LA\nSKN|WO]2f\u0013:4wN]7bi&|g.A\tsKN|WO]2fg&sgm\u001c$sK\u0016\f\u0011C]3t_V\u00148-Z:J]\u001a|Wk]3e\u0003)\u0011X-\u00193PE*,7\r\u001e\u000b\u0005\u0003[\t)\rC\u0004\u0002H*\u0002\r!!3\u0002\u0005%t\u0007\u0003BAf\u0003+l!!!4\u000b\t\u0005=\u0017\u0011[\u0001\u0003S>T!!a5\u0002\t)\fg/Y\u0005\u0005\u0003/\fiMA\tPE*,7\r^%oaV$8\u000b\u001e:fC6\fA!\u001b8jiR\u0011\u0011QF\u0001\tQ>\u001cH\u000fU8si\u0006Y\u0011\r\u001a3Fq\u0016\u001cW\u000f^8s)\u0011\ti#a9\t\u000f\u0005\u0015X\u00061\u0001\u0002$\u0005!Q\r_3d\u00039\u0011X-\\8wK\u0016CXmY;u_J$B!!\f\u0002l\"9\u0011Q\u001d\u0018A\u0002\u0005\r\u0012a\u00035bg\u0016CXmY;u_J$B!!=\u0002xB\u0019A)a=\n\u0007\u0005UXIA\u0004C_>dW-\u00198\t\u000f\u0005ex\u00061\u0001\u0002|\u0006\u0019\u0011\r\u001d9\u0011\u0007a\fi0C\u0002\u0002\u0000b\u0012q\"\u00119qY&\u001c\u0017\r^5p]&sgm\\\u0001\nC\u0012$GI]5wKJ$B!!\f\u0003\u0006!9!q\u0001\u0019A\u0002\u0005\u001d\u0013A\u00023sSZ,'/\u0001\u0007sK6|g/\u001a#sSZ,'\u000f\u0006\u0003\u0002.\t5\u0001b\u0002B\u0004c\u0001\u0007\u0011qI\u0001\tg\u0016$8\u000b^1uKR!\u0011Q\u0006B\n\u0011\u001d\t9F\ra\u0001\u00037\nq![:BY&4X\r\u0006\u0002\u0002r\u0006\u0001\u0012mY9vSJ,'+Z:pkJ\u001cWm\u001d\u000b\u0005\u0003_\u0013i\u0002C\u0004\u0003 Q\u0002\rA!\t\u0002\u0019I,7o\\;sG\u0016\u0014V-]:\u0011\r\t\r\"Q\u0006B\u001a\u001d\u0011\u0011)C!\u000b\u000f\u0007I\u00139#C\u0001G\u0013\r\u0011Y#R\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011yC!\r\u0003\u0007M+\u0017OC\u0002\u0003,\u0015\u0003B!a-\u00036%!!qGA[\u0005M\u0011Vm]8ve\u000e,'+Z9vSJ,W.\u001a8u\u0003A\u0011XmY8wKJ\u0014Vm]8ve\u000e,7\u000f\u0006\u0003\u0002.\tu\u0002b\u0002B k\u0001\u0007\u0011qV\u0001\tKb\u0004Xm\u0019;fI\u0006\u0001\"/\u001a7fCN,'+Z:pkJ\u001cWm\u001d\u000b\u0005\u0003[\u0011)\u0005C\u0004\u0003HY\u0002\r!a,\u0002\u0013\u0005dGn\\2bi\u0016$\u0007")
public class WorkerInfo
implements scala.Serializable {
    private final String id;
    private final String host;
    private final int port;
    private final int cores;
    private final int memory;
    private final RpcEndpointRef endpoint;
    private final String webUiAddress;
    private final Map<String, WorkerResourceInfo> resources;
    private transient HashMap<String, ExecutorDesc> executors;
    private transient HashMap<String, DriverInfo> drivers;
    private transient Enumeration.Value state;
    private transient int coresUsed;
    private transient int memoryUsed;
    private transient long lastHeartbeat;

    public String id() {
        return this.id;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int cores() {
        return this.cores;
    }

    public int memory() {
        return this.memory;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public String webUiAddress() {
        return this.webUiAddress;
    }

    public Map<String, WorkerResourceInfo> resources() {
        return this.resources;
    }

    public HashMap<String, ExecutorDesc> executors() {
        return this.executors;
    }

    public void executors_$eq(HashMap<String, ExecutorDesc> x$1) {
        this.executors = x$1;
    }

    public HashMap<String, DriverInfo> drivers() {
        return this.drivers;
    }

    public void drivers_$eq(HashMap<String, DriverInfo> x$1) {
        this.drivers = x$1;
    }

    public Enumeration.Value state() {
        return this.state;
    }

    public void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public int coresUsed() {
        return this.coresUsed;
    }

    public void coresUsed_$eq(int x$1) {
        this.coresUsed = x$1;
    }

    public int memoryUsed() {
        return this.memoryUsed;
    }

    public void memoryUsed_$eq(int x$1) {
        this.memoryUsed = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public int coresFree() {
        return this.cores() - this.coresUsed();
    }

    public int memoryFree() {
        return this.memory() - this.memoryUsed();
    }

    public Map<String, Object> resourcesAmountFree() {
        return (Map)this.resources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                WorkerResourceInfo rInfo = (WorkerResourceInfo)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)BoxesRunTime.boxToInteger((int)rInfo.availableAddrs().length()));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, ResourceInformation> resourcesInfo() {
        return (Map)this.resources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                WorkerResourceInfo rInfo = (WorkerResourceInfo)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)new ResourceInformation(rName, (String[])rInfo.addresses().toArray(ClassTag$.MODULE$.apply(String.class))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, ResourceInformation> resourcesInfoFree() {
        return (Map)this.resources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                WorkerResourceInfo rInfo = (WorkerResourceInfo)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)new ResourceInformation(rName, (String[])rInfo.availableAddrs().toArray(ClassTag$.MODULE$.apply(String.class))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, ResourceInformation> resourcesInfoUsed() {
        return (Map)this.resources().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String rName = (String)tuple2._1();
                WorkerResourceInfo rInfo = (WorkerResourceInfo)tuple2._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)new ResourceInformation(rName, (String[])rInfo.assignedAddrs().toArray(ClassTag$.MODULE$.apply(String.class))));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    private void readObject(ObjectInputStream in) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            in.defaultReadObject();
            this.init();
        });
    }

    private void init() {
        this.executors_$eq((HashMap<String, ExecutorDesc>)new HashMap());
        this.drivers_$eq((HashMap<String, DriverInfo>)new HashMap());
        this.state_$eq(WorkerState$.MODULE$.ALIVE());
        this.coresUsed_$eq(0);
        this.memoryUsed_$eq(0);
        this.lastHeartbeat_$eq(System.currentTimeMillis());
    }

    public String hostPort() {
        Predef$.MODULE$.assert(this.port() > 0);
        return new StringBuilder(1).append(this.host()).append(":").append(this.port()).toString();
    }

    public void addExecutor(ExecutorDesc exec) {
        this.executors().update((Object)exec.fullId(), (Object)exec);
        this.coresUsed_$eq(this.coresUsed() + exec.cores());
        this.memoryUsed_$eq(this.memoryUsed() + exec.memory());
    }

    public void removeExecutor(ExecutorDesc exec) {
        if (this.executors().contains((Object)exec.fullId())) {
            this.executors().$minus$eq((Object)exec.fullId());
            this.coresUsed_$eq(this.coresUsed() - exec.cores());
            this.memoryUsed_$eq(this.memoryUsed() - exec.memory());
            this.releaseResources(exec.resources());
            return;
        }
    }

    public boolean hasExecutor(ApplicationInfo app) {
        return this.executors().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$hasExecutor$1(app, x$1)));
    }

    public void addDriver(DriverInfo driver) {
        this.drivers().update((Object)driver.id(), (Object)driver);
        this.memoryUsed_$eq(this.memoryUsed() + driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() + driver.desc().cores());
    }

    public void removeDriver(DriverInfo driver) {
        this.drivers().$minus$eq((Object)driver.id());
        this.memoryUsed_$eq(this.memoryUsed() - driver.desc().mem());
        this.coresUsed_$eq(this.coresUsed() - driver.desc().cores());
        this.releaseResources(driver.resources());
    }

    public void setState(Enumeration.Value state) {
        this.state_$eq(state);
    }

    public boolean isAlive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = WorkerState$.MODULE$.ALIVE();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public Map<String, ResourceInformation> acquireResources(Seq<ResourceRequirement> resourceReqs) {
        return ((TraversableOnce)resourceReqs.map((Function1 & Serializable & scala.Serializable)req -> {
            String rName = req.resourceName();
            int amount = req.amount();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)rName), (Object)((WorkerResourceInfo)this.resources().apply((Object)rName)).acquire(amount));
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public void recoverResources(Map<String, ResourceInformation> expected) {
        expected.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$recoverResources$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void releaseResources(Map<String, ResourceInformation> allocated) {
        allocated.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            WorkerInfo.$anonfun$releaseResources$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$hasExecutor$1(ApplicationInfo app$1, ExecutorDesc x$1) {
        ApplicationInfo applicationInfo = x$1.application();
        ApplicationInfo applicationInfo2 = app$1;
        return !(applicationInfo != null ? !applicationInfo.equals(applicationInfo2) : applicationInfo2 != null);
    }

    public static final /* synthetic */ void $anonfun$recoverResources$1(WorkerInfo $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            ResourceInformation rInfo = (ResourceInformation)tuple2._2();
            ((ResourceAllocator)$this.resources().apply((Object)rName)).acquire((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])rInfo.addresses()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseResources$1(WorkerInfo $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String rName = (String)tuple2._1();
            ResourceInformation rInfo = (ResourceInformation)tuple2._2();
            ((ResourceAllocator)$this.resources().apply((Object)rName)).release((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])rInfo.addresses()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public WorkerInfo(String id, String host, int port, int cores, int memory, RpcEndpointRef endpoint, String webUiAddress, Map<String, WorkerResourceInfo> resources) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.cores = cores;
        this.memory = memory;
        this.endpoint = endpoint;
        this.webUiAddress = webUiAddress;
        this.resources = resources;
        Utils$.MODULE$.checkHost(host);
        Predef$.MODULE$.assert(port > 0);
        this.init();
    }
}

