/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BitwiseAnd;
import org.apache.spark.sql.catalyst.expressions.Empty2Null;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.HiveHash;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Pmod;
import org.apache.spark.sql.catalyst.expressions.Pmod$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.optimizer.EliminateSorts$;
import org.apache.spark.sql.catalyst.optimizer.FoldablePropagation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.physical.HashPartitioning;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.WriteFilesExec;
import org.apache.spark.sql.execution.datasources.WriterBucketSpec;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;

public final class V1WritesUtils$ {
    public static V1WritesUtils$ MODULE$;

    static {
        new V1WritesUtils$();
    }

    public Option<WriterBucketSpec> getWriterBucketSpec(Option<BucketSpec> bucketSpec, Seq<Attribute> dataColumns, Map<String, String> options) {
        return bucketSpec.map((Function1 & Serializable & scala.Serializable)spec -> {
            Seq bucketColumns = (Seq)spec.bucketColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$getWriterBucketSpec$3(c, x$4))).get(), Seq$.MODULE$.canBuildFrom());
            Object object = options.getOrElse((Object)BucketingUtils$.MODULE$.optionForHiveCompatibleBucketWrite(), (Function0 & Serializable & scala.Serializable)() -> "false");
            String string = "true";
            if (!(object != null ? !object.equals(string) : string != null)) {
                BitwiseAnd hashId = new BitwiseAnd((Expression)new HiveHash(bucketColumns), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
                Pmod bucketIdExpression = new Pmod((Expression)hashId, (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)spec.numBuckets())), Pmod$.MODULE$.apply$default$3());
                Function1 & Serializable & scala.Serializable fileNamePrefix = (Function1 & Serializable & scala.Serializable)bucketId -> V1WritesUtils$.$anonfun$getWriterBucketSpec$5(BoxesRunTime.unboxToInt((Object)bucketId));
                return new WriterBucketSpec((Expression)bucketIdExpression, (Function1<Object, String>)fileNamePrefix);
            }
            Expression bucketIdExpression = new HashPartitioning(bucketColumns, spec.numBuckets()).partitionIdExpression();
            return new WriterBucketSpec(bucketIdExpression, (Function1<Object, String>)(Function1 & Serializable & scala.Serializable)x$5 -> V1WritesUtils$.$anonfun$getWriterBucketSpec$6(BoxesRunTime.unboxToInt((Object)x$5)));
        });
    }

    public Seq<Attribute> getBucketSortColumns(Option<BucketSpec> bucketSpec, Seq<Attribute> dataColumns) {
        return (Seq)Option$.MODULE$.option2Iterable(bucketSpec).toSeq().flatMap((Function1 & Serializable & scala.Serializable)spec -> (Seq)spec.sortColumnNames().map((Function1 & Serializable & scala.Serializable)c -> (Attribute)dataColumns.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$getBucketSortColumns$3(c, x$6))).get(), Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<SortOrder> getSortOrder(Seq<Attribute> outputColumns, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, int numStaticPartitionCols) {
        Predef$.MODULE$.require(partitionColumns.size() >= numStaticPartitionCols);
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq dataColumns = (Seq)outputColumns.filterNot((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
        Option<WriterBucketSpec> writerBucketSpec = this.getWriterBucketSpec(bucketSpec, (Seq<Attribute>)dataColumns, options);
        Seq<Attribute> sortColumns = this.getBucketSortColumns(bucketSpec, (Seq<Attribute>)dataColumns);
        Seq dynamicPartitionColumns = (Seq)partitionColumns.drop(numStaticPartitionCols);
        if (SQLConf$.MODULE$.get().maxConcurrentOutputFileWriters() > 0 && sortColumns.isEmpty()) {
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)((TraversableLike)((TraversableLike)dynamicPartitionColumns.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(writerBucketSpec.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.bucketIdExpression())), Seq$.MODULE$.canBuildFrom())).$plus$plus(sortColumns, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> SortOrder$.MODULE$.apply(x$8, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom());
    }

    public int getSortOrder$default$5() {
        return 0;
    }

    public Seq<NamedExpression> convertEmptyToNull(Seq<Attribute> output, Seq<Attribute> partitionColumns) {
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        BooleanRef needConvert = BooleanRef.create((boolean)false);
        Seq projectList = (Seq)output.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Attribute attribute = x0$1;
            if (partitionSet.contains((NamedExpression)attribute)) {
                DataType dataType = attribute.dataType();
                StringType$ stringType$ = StringType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null) && attribute.nullable()) {
                    needConvert$1.elem = true;
                    Empty2Null x$1 = new Empty2Null((Expression)attribute);
                    String x$2 = attribute.name();
                    ExprId x$3 = Alias$.MODULE$.apply$default$3((Expression)x$1, x$2);
                    Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                    Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                    Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                    return new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
                }
            }
            return attribute;
        }, Seq$.MODULE$.canBuildFrom());
        if (needConvert.elem) {
            return projectList;
        }
        return Nil$.MODULE$;
    }

    public boolean hasEmptyToNull(Seq<Expression> expressions) {
        return expressions.exists((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.exists((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$hasEmptyToNull$2(x$10)))));
    }

    public LogicalPlan eliminateFoldableOrdering(Seq<SortOrder> ordering2, LogicalPlan query) {
        return EliminateSorts$.MODULE$.apply(FoldablePropagation$.MODULE$.apply((LogicalPlan)new Sort(ordering2, false, query)));
    }

    public boolean isOrderingMatched(Seq<Expression> requiredOrdering, Seq<SortOrder> outputOrdering) {
        if (requiredOrdering.length() > outputOrdering.length()) {
            return false;
        }
        return ((IterableLike)requiredOrdering.zip(outputOrdering, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)V1WritesUtils$.$anonfun$isOrderingMatched$1(x0$1)));
    }

    public Option<WriteFilesExec> getWriteFilesOpt(SparkPlan child) {
        return child.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof WriteFilesExec) {
                    WriteFilesExec writeFilesExec = (WriteFilesExec)A1;
                    return (B1)writeFilesExec;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                return sparkPlan instanceof WriteFilesExec;
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$getWriterBucketSpec$3(String c$1, Attribute x$4) {
        String string = x$4.name();
        String string2 = c$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$getWriterBucketSpec$5(int bucketId) {
        int arg$macro$1 = bucketId;
        return new StringOps("%05d_0_").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)arg$macro$1)}));
    }

    public static final /* synthetic */ String $anonfun$getWriterBucketSpec$6(int x$5) {
        return "";
    }

    public static final /* synthetic */ boolean $anonfun$getBucketSortColumns$3(String c$2, Attribute x$6) {
        String string = x$6.name();
        String string2 = c$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$hasEmptyToNull$2(Expression x$10) {
        return x$10 instanceof Empty2Null;
    }

    public static final /* synthetic */ boolean $anonfun$isOrderingMatched$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression requiredOrder = (Expression)tuple2._1();
            SortOrder outputOrder = (SortOrder)tuple2._2();
            return outputOrder.satisfies(outputOrder.copy(requiredOrder, outputOrder.copy$default$2(), outputOrder.copy$default$3(), outputOrder.copy$default$4()));
        }
        throw new MatchError((Object)tuple2);
    }

    private V1WritesUtils$() {
        MODULE$ = this;
    }
}

