/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.csv.CSVExprUtils$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CSVUtils$ {
    public static CSVUtils$ MODULE$;

    static {
        new CSVUtils$();
    }

    public Dataset<String> filterCommentAndEmpty(Dataset<String> lines, CSVOptions options) {
        Dataset<Row> aliased = lines.toDF((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}));
        Dataset<Row> nonEmptyLines = aliased.filter(functions$.MODULE$.length(functions$.MODULE$.trim(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$))).$greater(BoxesRunTime.boxToInteger((int)0)));
        if (options.isCommentSet()) {
            return nonEmptyLines.filter(lines.sqlContext().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value"}))).$((Seq<Object>)Nil$.MODULE$).startsWith(Character.toString(options.comment())).unary_$bang()).as(lines.sqlContext().implicits().newStringEncoder());
        }
        return nonEmptyLines.as(lines.sqlContext().implicits().newStringEncoder());
    }

    public Iterator<String> filterHeaderLine(Iterator<String> iter, String firstLine, CSVOptions options) {
        if (options.headerFlag()) {
            return iter.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$filterHeaderLine$1(firstLine, x$1)));
        }
        return iter;
    }

    public String[] makeSafeHeader(String[] row, boolean caseSensitive, CSVOptions options) {
        if (options.headerFlag()) {
            String[] headerNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CSVUtils$.$anonfun$makeSafeHeader$1(x$2))))).map((Function1 & Serializable & scala.Serializable)name -> {
                if (caseSensitive) {
                    return name;
                }
                return name.toLowerCase();
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            String[] duplicates = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headerNames)).diff((GenSeq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])headerNames)).distinct())))).distinct();
            return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2;
                block5: {
                    int index;
                    String value;
                    block7: {
                        block6: {
                            tuple2 = x0$1;
                            if (tuple2 == null) break block5;
                            value = (String)tuple2._1();
                            index = tuple2._2$mcI$sp();
                            if (value == null || value.isEmpty()) break block6;
                            String string = value;
                            String string2 = options.nullValue();
                            if (string != null ? !string.equals(string2) : string2 != null) break block7;
                        }
                        return new StringBuilder(2).append("_c").append(index).toString();
                    }
                    if (!caseSensitive && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])duplicates)).contains((Object)value.toLowerCase())) {
                        return new StringBuilder(0).append(value).append(index).toString();
                    }
                    if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])duplicates)).contains((Object)value)) {
                        return new StringBuilder(0).append(value).append(index).toString();
                    }
                    return value;
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        }
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])row)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                int index = tuple2._2$mcI$sp();
                return new StringBuilder(2).append("_c").append(index).toString();
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public Dataset<String> sample(Dataset<String> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("samplingRatio (").append(options.samplingRatio()).append(") should be greater than 0").toString());
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public RDD<String[]> sample(RDD<String[]> csv, CSVOptions options) {
        Predef$.MODULE$.require(options.samplingRatio() > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("samplingRatio (").append(options.samplingRatio()).append(") should be greater than 0").toString());
        if (options.samplingRatio() > 0.99) {
            return csv;
        }
        return csv.sample(false, options.samplingRatio(), 1L);
    }

    public Iterator<String> filterCommentAndEmpty(Iterator<String> iter, CSVOptions options) {
        return CSVExprUtils$.MODULE$.filterCommentAndEmpty(iter, options);
    }

    public static final /* synthetic */ boolean $anonfun$filterHeaderLine$1(String firstLine$1, String x$1) {
        String string = x$1;
        String string2 = firstLine$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$makeSafeHeader$1(String x$2) {
        return x$2 != null;
    }

    private CSVUtils$() {
        MODULE$ = this;
    }
}

