/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.r;

import java.io.Serializable;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.ml.feature.RFormulaModel;
import org.apache.spark.ml.r.IsotonicRegressionWrapper;
import org.apache.spark.ml.r.RWrapperUtils$;
import org.apache.spark.ml.regression.IsotonicRegression;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class IsotonicRegressionWrapper$
implements MLReadable<IsotonicRegressionWrapper> {
    public static IsotonicRegressionWrapper$ MODULE$;

    static {
        new IsotonicRegressionWrapper$();
    }

    public IsotonicRegressionWrapper fit(Dataset<Row> data, String formula, boolean isotonic, int featureIndex, String weightCol) {
        RFormula rFormula = new RFormula().setFormula(formula).setFeaturesCol("features");
        RWrapperUtils$.MODULE$.checkDataColumns(rFormula, data);
        Model rFormulaModel = rFormula.fit((Dataset)data);
        StructType schema = ((RFormulaModel)rFormulaModel).transform(data).schema();
        Attribute[] featureAttrs = (Attribute[])AttributeGroup$.MODULE$.fromStructField(schema.apply(((RFormulaModel)rFormulaModel).getFeaturesCol())).attributes().get();
        String[] features = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])featureAttrs)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1.name().get(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])features)).size() == 1);
        IsotonicRegression isotonicRegression = new IsotonicRegression().setIsotonic(isotonic).setFeatureIndex(featureIndex).setFeaturesCol(rFormula.getFeaturesCol());
        Object object = weightCol != null ? isotonicRegression.setWeightCol(weightCol) : BoxedUnit.UNIT;
        Model pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{rFormulaModel, isotonicRegression})).fit((Dataset)data);
        return new IsotonicRegressionWrapper((PipelineModel)pipeline, features);
    }

    @Override
    public MLReader<IsotonicRegressionWrapper> read() {
        return new IsotonicRegressionWrapper.IsotonicRegressionWrapperReader();
    }

    @Override
    public IsotonicRegressionWrapper load(String path) {
        return (IsotonicRegressionWrapper)MLReadable.load$(this, path);
    }

    private IsotonicRegressionWrapper$() {
        MODULE$ = this;
        MLReadable.$init$(this);
    }
}

