/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;

public class FixedConflictManager
extends AbstractConflictManager {
    private Collection<String> revisions;

    public FixedConflictManager(String[] revs) {
        this.revisions = Arrays.asList(revs);
        this.setName("fixed" + this.revisions);
    }

    @Override
    public Collection<IvyNode> resolveConflicts(IvyNode parent, Collection<IvyNode> conflicts) {
        ArrayList<IvyNode> resolved = new ArrayList<IvyNode>(conflicts.size());
        for (IvyNode node : conflicts) {
            String revision = node.getResolvedId().getRevision();
            if (!this.revisions.contains(revision)) continue;
            resolved.add(node);
        }
        return resolved;
    }

    public Collection<String> getRevs() {
        return this.revisions;
    }
}

