/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud!B\u0011#\u0001!r\u0003\u0002C \u0001\u0005\u0003\u0005\u000b\u0011B!\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019CQ\u0001\u0014\u0001\u0005\u00025Cq!\u0015\u0001C\u0002\u0013%!\u000b\u0003\u0004_\u0001\u0001\u0006Ia\u0015\u0005\b?\u0002\u0011\r\u0011\"\u0003S\u0011\u0019\u0001\u0007\u0001)A\u0005'\"9\u0011\r\u0001b\u0001\n\u0013\u0011\u0006B\u00022\u0001A\u0003%1\u000bC\u0004d\u0001\t\u0007I\u0011\u00023\t\rE\u0004\u0001\u0015!\u0003f\u0011\u001d\u0011\bA1A\u0005\nMDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%Ia\u001d\u0005\u0007s\u0002\u0001\u000b\u0011\u0002;\t\u000fi\u0004!\u0019!C\u0005g\"11\u0010\u0001Q\u0001\nQDQ\u0001 \u0001\u0005BuDq!a\u0002\u0001\t\u0003\nI\u0001C\u0004\u0002\u0012\u0001!\t%a\u0005\b\u0011\u0005\r#\u0005#\u0001)\u0003\u000b2q!\t\u0012\t\u0002!\n9\u0005\u0003\u0004M-\u0011\u0005\u0011\u0011\n\u0005\t\u0003\u00172\"\u0019!C\u0001%\"9\u0011Q\n\f!\u0002\u0013\u0019\u0006\u0002CA(-\t\u0007I\u0011\u0001*\t\u000f\u0005Ec\u0003)A\u0005'\"I\u00111\u000b\fC\u0002\u0013\u0005\u0011Q\u000b\u0005\b\u0003/2\u0002\u0015!\u0003m\u0011!\tIF\u0006b\u0001\n\u0003\u0019\bbBA.-\u0001\u0006I\u0001\u001e\u0005\n\u0003;2\u0012\u0013!C\u0001\u0003?\u0012\u0001\u0004\u0012:jm\u0016\u00148+\u001a:wS\u000e,g)Z1ukJ,7\u000b^3q\u0015\t\u0019C%\u0001\u0005gK\u0006$XO]3t\u0015\t)c%A\u0002lqMT!a\n\u0015\u0002\r\u0011,\u0007\u000f\\8z\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0003\u0002\u00010ke\u0002\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012a!\u00118z%\u00164\u0007C\u0001\u001c8\u001b\u0005\u0011\u0013B\u0001\u001d#\u0005mYUOY3s]\u0016$Xm\u001d$fCR,(/Z\"p]\u001aLwm\u0015;faB\u0011!(P\u0007\u0002w)\u0011A\bK\u0001\tS:$XM\u001d8bY&\u0011ah\u000f\u0002\b\u0019><w-\u001b8h\u00039YWOY3s]\u0016$Xm]\"p]\u001a\u001c\u0001\u0001\u0005\u0002C\u00076\tA%\u0003\u0002EI\t!2*\u001e2fe:,G/Z:Ee&4XM]\"p]\u001a\fQa\u00197pG.\u0004\"a\u0012&\u000e\u0003!S!!\u0013\u0015\u0002\tU$\u0018\u000e\\\u0005\u0003\u0017\"\u0013Qa\u00117pG.\fa\u0001P5oSRtDc\u0001(P!B\u0011a\u0007\u0001\u0005\u0006\u007f\r\u0001\r!\u0011\u0005\b\u000b\u000e\u0001\n\u00111\u0001G\u0003Q\u0001(/\u001a4feJ,GmU3sm&\u001cWMT1nKV\t1\u000b\u0005\u0002U7:\u0011Q+\u0017\t\u0003-Fj\u0011a\u0016\u0006\u00031\u0002\u000ba\u0001\u0010:p_Rt\u0014B\u0001.2\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i\u000b\u0014!\u00069sK\u001a,'O]3e'\u0016\u0014h/[2f\u001d\u0006lW\rI\u0001\u0014e\u0016\u001cx\u000e\u001c<fIN+'O^5dK:\u000bW.Z\u0001\u0015e\u0016\u001cx\u000e\u001c<fIN+'O^5dK:\u000bW.\u001a\u0011\u0002\u001d%\u0004h)Y7jYf\u0004v\u000e\\5ds\u0006y\u0011\u000e\u001d$b[&d\u0017\u0010U8mS\u000eL\b%\u0001\u0006ja\u001a\u000bW.\u001b7jKN,\u0012!\u001a\t\u0004M*dW\"A4\u000b\u0005%C'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001e\u0014A\u0001T5tiB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000e[\u0001\u0005Y\u0006tw-\u0003\u0002]]\u0006Y\u0011\u000e\u001d$b[&d\u0017.Z:!\u0003)!'/\u001b<feB{'\u000f^\u000b\u0002iB\u0011\u0001'^\u0005\u0003mF\u00121!\u00138u\u0003-!'/\u001b<feB{'\u000f\u001e\u0011\u0002-\u0011\u0014\u0018N^3s\u00052|7m['b]\u0006<WM\u001d)peR\fq\u0003\u001a:jm\u0016\u0014(\t\\8dW6\u000bg.Y4feB{'\u000f\u001e\u0011\u0002\u0019\u0011\u0014\u0018N^3s+&\u0003vN\u001d;\u0002\u001b\u0011\u0014\u0018N^3s+&\u0003vN\u001d;!\u00031\u0019wN\u001c4jOV\u0014X\rU8e)\rq\u00181\u0001\t\u0003\u0005~L1!!\u0001%\u0005!\u0019\u0006/\u0019:l!>$\u0007BBA\u0003%\u0001\u0007a0A\u0002q_\u0012\f\u0001eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d\u0007k\u001c3TsN$X-\u001c)s_B,'\u000f^5fgR\u0011\u00111\u0002\t\u0006)\u000651kU\u0005\u0004\u0003\u001fi&aA'ba\u0006\u0001s-\u001a;BI\u0012LG/[8oC2\\UOY3s]\u0016$Xm\u001d*fg>,(oY3t)\t\t)\u0002\u0005\u0004\u0002\u0018\u0005\u0005\u0012q\u0005\b\u0005\u00033\tiBD\u0002W\u00037I\u0011AM\u0005\u0004\u0003?\t\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003G\t)CA\u0002TKFT1!a\b2!\u0011\tI#a\u0010\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tQ!\\8eK2TA!!\r\u00024\u0005\u0019\u0011\r]5\u000b\t\u0005U\u0012qG\u0001\u000bWV\u0014WM\u001d8fi\u0016\u001c(\u0002BA\u001d\u0003w\tqAZ1ce&\u001c\u0007H\u0003\u0002\u0002>\u0005\u0011\u0011n\\\u0005\u0005\u0003\u0003\nYCA\u0006ICNlU\r^1eCR\f\u0017\u0001\u0007#sSZ,'oU3sm&\u001cWMR3biV\u0014Xm\u0015;faB\u0011aGF\n\u0003-=\"\"!!\u0012\u0002/\u0011\u0013\u0016JV#S?\nKe\nR0B\t\u0012\u0013ViU*`\u0017\u0016K\u0016\u0001\u0007#S\u0013Z+%k\u0018\"J\u001d\u0012{\u0016\t\u0012#S\u000bN\u001bvlS#ZA\u0005yAIU%W\u000bJ{\u0006jT*U?.+\u0015,\u0001\tE%&3VIU0I\u001fN#vlS#ZA\u0005\u0011BIU%W\u000bJ{6KV\"`!>\u001bFKR%Y+\u0005a\u0017a\u0005#S\u0013Z+%kX*W\u0007~\u0003vj\u0015+G\u0013b\u0003\u0013aF'B1~\u001bVI\u0015,J\u0007\u0016{f*Q'F?2+ej\u0012+I\u0003ai\u0015\tW0T\u000bJ3\u0016jQ#`\u001d\u0006kUi\u0018'F\u001d\u001e#\u0006\nI\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0005$f\u0001$\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GMC\u0002\u0002pE\n!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class DriverServiceFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesDriverConf kubernetesConf;
    private final String preferredServiceName;
    private final String resolvedServiceName;
    private final String ipFamilyPolicy;
    private final java.util.List<String> ipFamilies;
    private final int driverPort;
    private final int driverBlockManagerPort;
    private final int driverUIPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2();
    }

    public static int MAX_SERVICE_NAME_LENGTH() {
        return DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH();
    }

    public static String DRIVER_SVC_POSTFIX() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
    }

    public static String DRIVER_HOST_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY();
    }

    public static String DRIVER_BIND_ADDRESS_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalPreKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String preferredServiceName() {
        return this.preferredServiceName;
    }

    private String resolvedServiceName() {
        return this.resolvedServiceName;
    }

    private String ipFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    private java.util.List<String> ipFamilies() {
        return this.ipFamilies;
    }

    private int driverPort() {
        return this.driverPort;
    }

    private int driverBlockManagerPort() {
        return this.driverBlockManagerPort;
    }

    private int driverUIPort() {
        return this.driverUIPort;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        return pod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String driverHostname = new StringBuilder(5).append(this.resolvedServiceName()).append(".").append(this.kubernetesConf.namespace()).append(".svc").toString();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()), (Object)driverHostname), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_PORT().key()), (Object)Integer.toString(this.driverPort())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()), (Object)Integer.toString(this.driverBlockManagerPort()))}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        Service driverService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceFluentImpl)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.resolvedServiceName()).addToAnnotations((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.serviceAnnotations()).asJava()).addToLabels(Constants$.MODULE$.SPARK_APP_ID_LABEL(), this.kubernetesConf.appId()).addToLabels((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.serviceLabels()).asJava())).endMetadata()).withNewSpec().withClusterIP("None").withIpFamilyPolicy(this.ipFamilyPolicy()).withIpFamilies(this.ipFamilies()).withSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.labels()).asJava()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverPort())).withNewTargetPort((Object)BoxesRunTime.boxToInteger((int)this.driverPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort())).withNewTargetPort((Object)BoxesRunTime.boxToInteger((int)this.driverBlockManagerPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.UI_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverUIPort())).withNewTargetPort((Object)BoxesRunTime.boxToInteger((int)this.driverUIPort()))).endPort()).endSpec()).build();
        return (Seq)new .colon.colon((Object)driverService, (List)Nil$.MODULE$);
    }

    public DriverServiceFeatureStep(KubernetesDriverConf kubernetesConf, Clock clock) {
        String string;
        this.kubernetesConf = kubernetesConf;
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is not supported in Kubernetes mode, as the driver's bind ").append("address is managed and set to the driver pod's IP address.").toString());
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is not supported in Kubernetes mode, as the driver's hostname will be ").append("managed via a Kubernetes service.").toString());
        this.preferredServiceName = new StringBuilder(0).append(kubernetesConf.resourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
        if (this.preferredServiceName().length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
            string = this.preferredServiceName();
        } else {
            String randomServiceId = KubernetesUtils$.MODULE$.uniqueID(clock);
            String shorterServiceName = new StringBuilder(6).append("spark-").append(randomServiceId).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(137).append("Driver's hostname would preferably be ").append(this.preferredServiceName()).append(", but this is ").append("too long (must be <= ").append(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()).append(" characters). Falling back to use ").append(shorterServiceName).append(" as the driver service's name.").toString());
            string = shorterServiceName;
        }
        this.resolvedServiceName = string;
        this.ipFamilyPolicy = (String)kubernetesConf.sparkConf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_IP_FAMILY_POLICY());
        this.ipFamilies = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)kubernetesConf.sparkConf().get(Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_IP_FAMILIES())).split(","))).toList()).asJava();
        this.driverPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_PORT().key(), Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        this.driverBlockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
        this.driverUIPort = BoxesRunTime.unboxToInt(kubernetesConf.get(UI$.MODULE$.UI_PORT()));
    }
}

