/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import java.io.Serializable;
import org.apache.spark.mllib.evaluation.RankingMetrics;
import org.apache.spark.mllib.evaluation.RegressionMetrics;
import org.apache.spark.mllib.recommendation.ALS$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class RankingMetricsExample$ {
    public static final RankingMetricsExample$ MODULE$ = new RankingMetricsExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("RankingMetricsExample").getOrCreate();
        RDD ratings = spark.read().textFile("data/mllib/sample_movielens_data.txt").rdd().map((Function1 & Serializable)line -> {
            String[] fields = line.split("::");
            return new Rating(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fields[0])), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(fields[1])), StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(fields[2])) - 2.5);
        }, ClassTag$.MODULE$.apply(Rating.class)).cache();
        RDD binarizedRatings = ratings.map((Function1 & Serializable)r -> new Rating(r.user(), r.product(), r.rating() > 0.0 ? 1.0 : 0.0), ClassTag$.MODULE$.apply(Rating.class)).cache();
        long numRatings = ratings.count();
        long numUsers = ratings.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.user()), (ClassTag)ClassTag$.MODULE$.Int()).distinct().count();
        long numMovies = ratings.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.product()), (ClassTag)ClassTag$.MODULE$.Int()).distinct().count();
        Predef$.MODULE$.println((Object)("Got " + numRatings + " ratings from " + numUsers + " users on " + numMovies + " movies."));
        int numIterations = 10;
        int rank = 10;
        double lambda = 0.01;
        MatrixFactorizationModel model = ALS$.MODULE$.train(ratings, rank, numIterations, lambda);
        RDD userRecommended = model.recommendProductsForUsers(10).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int user = tuple2._1$mcI$sp();
                Rating[] recs = (Rating[])tuple2._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])recs), (Function1 & Serializable)r -> RankingMetricsExample$.scaledRating$1(r), ClassTag$.MODULE$.apply(Rating.class)));
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD userMovies = binarizedRatings.groupBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.user()), (ClassTag)ClassTag$.MODULE$.Int());
        RDD relevantDocuments = RDD$.MODULE$.rddToPairRDDFunctions(userMovies, (ClassTag)ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.Int$.MODULE$).join(userRecommended).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                Iterable actual = (Iterable)tuple2._1();
                Rating[] predictions = (Rating[])tuple2._2();
                return new Tuple2(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])predictions), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.product()), (ClassTag)ClassTag$.MODULE$.Int()), ((IterableOnceOps)((IterableOps)actual.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)RankingMetricsExample$.$anonfun$main$10(x$5)))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.product()))).toArray((ClassTag)ClassTag$.MODULE$.Int()));
            }
            throw new MatchError((Object)tuple22);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RankingMetrics metrics = new RankingMetrics(relevantDocuments, ClassTag$.MODULE$.Nothing());
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5}), (Function1)(JFunction1.mcVI.sp & Serializable)k -> Predef$.MODULE$.println((Object)("Precision at " + k + " = " + metrics.precisionAt(k))));
        Predef$.MODULE$.println((Object)("Mean average precision = " + metrics.meanAveragePrecision()));
        Predef$.MODULE$.println((Object)("Mean average precision at 2 = " + metrics.meanAveragePrecisionAt(2)));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5}), (Function1)(JFunction1.mcVI.sp & Serializable)k -> Predef$.MODULE$.println((Object)("NDCG at " + k + " = " + metrics.ndcgAt(k))));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.intArrayOps(new int[]{1, 3, 5}), (Function1)(JFunction1.mcVI.sp & Serializable)k -> Predef$.MODULE$.println((Object)("Recall at " + k + " = " + metrics.recallAt(k))));
        RDD allPredictions = model.predict(ratings.map((Function1 & Serializable)r -> new Tuple2.mcII.sp(r.user(), r.product()), ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1 & Serializable)r -> new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating())), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD allRatings = ratings.map((Function1 & Serializable)r -> new Tuple2((Object)new Tuple2.mcII.sp(r.user(), r.product()), (Object)BoxesRunTime.boxToDouble((double)r.rating())), ClassTag$.MODULE$.apply(Tuple2.class));
        RDD predictionsAndLabels = RDD$.MODULE$.rddToPairRDDFunctions(allPredictions, ClassTag$.MODULE$.apply(Tuple2.class), (ClassTag)ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).join(allRatings).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Tuple2 tuple22 = (Tuple2)tuple2._1();
                Tuple2 tuple23 = (Tuple2)tuple2._2();
                if (tuple22 != null && tuple23 != null) {
                    double predicted = tuple23._1$mcD$sp();
                    double actual = tuple23._2$mcD$sp();
                    return new Tuple2.mcDD.sp(predicted, actual);
                }
            }
            throw new MatchError((Object)tuple2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RegressionMetrics regressionMetrics = new RegressionMetrics(predictionsAndLabels);
        Predef$.MODULE$.println((Object)("RMSE = " + regressionMetrics.rootMeanSquaredError()));
        Predef$.MODULE$.println((Object)("R-squared = " + regressionMetrics.r2()));
    }

    private static final Rating scaledRating$1(Rating r) {
        double scaledRating = package$.MODULE$.max(package$.MODULE$.min(r.rating(), 1.0), 0.0);
        return new Rating(r.user(), r.product(), scaledRating);
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Rating x$5) {
        return x$5.rating() > 0.0;
    }

    private RankingMetricsExample$() {
    }
}

