/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed$;
import org.apache.spark.sql.catalyst.expressions.LeafExpression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.Uuid$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.RandomUUIDGenerator;
import org.apache.spark.sql.types.DataType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_() - Returns an universally unique identifier (UUID) string. The value is returned as a canonical UUID 36-character string.", examples="\n    Examples:\n      > SELECT _FUNC_();\n       46707d92-02f4-4817-8116-a4c3b23e6266\n  ", note="\n    The function is non-deterministic.\n  ", since="2.3.0", group="misc_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001B\u0011#\u0001>B\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t/\u0002\u0011\t\u0012)A\u0005#\")\u0001\f\u0001C\u00013\")\u0001\f\u0001C\u00019\")\u0001\f\u0001C\u0001;\")1\r\u0001C!I\")Q\r\u0001C!M\"A\u0001\u000e\u0001EC\u0002\u0013\u0005\u0013\u000eC\u0003n\u0001\u0011\u0005\u0013\u000eC\u0003o\u0001\u0011\u0005\u0013\u000eC\u0005p\u0001\u0001\u0007\t\u0011)Q\u0005a\")!\u0010\u0001C)w\"9\u0011\u0011\u0002\u0001\u0005R\u0005-\u0001bBA\u0010\u0001\u0011\u0005\u0013\u0011\u0005\u0005\n\u0003{\u0001\u0011\u0011!C\u0001\u0003\u007fA\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\t\u0013\u0005m\u0003!!A\u0005B\u0005u\u0003\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\t\u0019\bAA\u0001\n\u0003\t)\bC\u0005\u0002|\u0001\t\t\u0011\"\u0011\u0002~!I\u00111\u0012\u0001\u0002\u0002\u0013\u0005\u0011Q\u0012\u0005\n\u0003#\u0003\u0011\u0011!C!\u0003'C\u0011\"a&\u0001\u0003\u0003%\t%!'\b\u0013\u0005\r'%!A\t\u0002\u0005\u0015g\u0001C\u0011#\u0003\u0003E\t!a2\t\raKB\u0011AAp\u0011%\t\t/GA\u0001\n\u000b\n\u0019\u000fC\u0005\u0002ff\t\t\u0011\"!\u0002h\"I\u00111^\r\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003[L\u0012\u0011!CA\u0003_D\u0011\"a>\u001a#\u0003%\t!!\u0012\t\u0013\u0005e\u0018$!A\u0005\n\u0005m(\u0001B+vS\u0012T!a\t\u0013\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003K\u0019\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003O!\n1a]9m\u0015\tI#&A\u0003ta\u0006\u00148N\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<7\u0001A\n\b\u0001A\"tGO\u001fD!\t\t$'D\u0001#\u0013\t\u0019$E\u0001\bMK\u00064W\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005E*\u0014B\u0001\u001c#\u0005AquN\u001c3fi\u0016\u0014X.\u001b8jgRL7\r\u0005\u00022q%\u0011\u0011H\t\u0002!\t\u00164\u0017-\u001e7u'R\u0014\u0018N\\4Qe>$WoY5oO\u0016C\bO]3tg&|g\u000e\u0005\u00022w%\u0011AH\t\u0002\u0019\u000bb\u0004(/Z:tS>tw+\u001b;i%\u0006tGm\\7TK\u0016$\u0007C\u0001 B\u001b\u0005y$\"\u0001!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t{$a\u0002)s_\u0012,8\r\u001e\t\u0003\t2s!!\u0012&\u000f\u0005\u0019KU\"A$\u000b\u0005!s\u0013A\u0002\u001fs_>$h(C\u0001A\u0013\tYu(A\u0004qC\u000e\\\u0017mZ3\n\u00055s%\u0001D*fe&\fG.\u001b>bE2,'BA&@\u0003)\u0011\u0018M\u001c3p[N+W\rZ\u000b\u0002#B\u0019aH\u0015+\n\u0005M{$AB(qi&|g\u000e\u0005\u0002?+&\u0011ak\u0010\u0002\u0005\u0019>tw-A\u0006sC:$w.\\*fK\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002[7B\u0011\u0011\u0007\u0001\u0005\b\u001f\u000e\u0001\n\u00111\u0001R)\u0005QFC\u0001._\u0011\u0015yV\u00011\u0001a\u0003\u0011\u0019X-\u001a3\u0011\u0005E\n\u0017B\u00012#\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u000fg\u0016,G-\u0012=qe\u0016\u001c8/[8o+\u0005\u0001\u0017aC<ji\"tUm^*fK\u0012$\"AW4\t\u000b};\u0001\u0019\u0001+\u0002\u0011I,7o\u001c7wK\u0012,\u0012A\u001b\t\u0003}-L!\u0001\\ \u0003\u000f\t{w\u000e\\3b]\u0006Aa.\u001e7mC\ndW-\u0001\u0005ti\u0006$XMZ;m\u0003=\u0011\u0018M\u001c3p[\u001e+g.\u001a:bi>\u0014\bCA9u\u001b\u0005\u0011(BA:%\u0003\u0011)H/\u001b7\n\u0005U\u0014(a\u0005*b]\u0012|W.V+J\t\u001e+g.\u001a:bi>\u0014\bFA\u0006x!\tq\u00040\u0003\u0002z\u007f\tIAO]1og&,g\u000e^\u0001\u0013S:LG/[1mSj,\u0017J\u001c;fe:\fG\u000e\u0006\u0002}\u007fB\u0011a(`\u0005\u0003}~\u0012A!\u00168ji\"9\u0011\u0011\u0001\u0007A\u0002\u0005\r\u0011A\u00049beRLG/[8o\u0013:$W\r\u001f\t\u0004}\u0005\u0015\u0011bAA\u0004\u007f\t\u0019\u0011J\u001c;\u0002\u0019\u00154\u0018\r\\%oi\u0016\u0014h.\u00197\u0015\t\u00055\u00111\u0003\t\u0004}\u0005=\u0011bAA\t\u007f\t\u0019\u0011I\\=\t\u000f\u0005UQ\u00021\u0001\u0002\u0018\u0005)\u0011N\u001c9viB!\u0011\u0011DA\u000e\u001b\u0005!\u0013bAA\u000fI\tY\u0011J\u001c;fe:\fGNU8x\u0003%!wnR3o\u0007>$W\r\u0006\u0004\u0002$\u0005=\u0012\u0011\b\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006\u0012\u0002\u000f\r|G-Z4f]&!\u0011QFA\u0014\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007bBA\u0019\u001d\u0001\u0007\u00111G\u0001\u0004GRD\b\u0003BA\u0013\u0003kIA!a\u000e\u0002(\tq1i\u001c3fO\u0016t7i\u001c8uKb$\bbBA\u001e\u001d\u0001\u0007\u00111E\u0001\u0003KZ\fAaY8qsR\u0019!,!\u0011\t\u000f={\u0001\u0013!a\u0001#\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA$U\r\t\u0016\u0011J\u0016\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0005v]\u000eDWmY6fI*\u0019\u0011QK \u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002Z\u0005=#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!A.\u00198h\u0015\t\tI'\u0001\u0003kCZ\f\u0017\u0002BA7\u0003G\u0012aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0002\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0004\u0002x!I\u0011\u0011P\n\u0002\u0002\u0003\u0007\u00111A\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0004CBAA\u0003\u000f\u000bi!\u0004\u0002\u0002\u0004*\u0019\u0011QQ \u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\n\u0006\r%\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2A[AH\u0011%\tI(FA\u0001\u0002\u0004\ti!\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA0\u0003+C\u0011\"!\u001f\u0017\u0003\u0003\u0005\r!a\u0001\u0002\r\u0015\fX/\u00197t)\rQ\u00171\u0014\u0005\n\u0003s:\u0012\u0011!a\u0001\u0003\u001bAs\u0003AAP\u0003K\u000b9+a+\u0002.\u0006E\u00161WA\\\u0003s\u000bi,a0\u0011\u0007E\n\t+C\u0002\u0002$\n\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002*\u0006\t\u0019a\u0018$V\u001d\u000e{\u0006&\u000b\u0011.AI+G/\u001e:og\u0002\ng\u000eI;oSZ,'o]1mYf\u0004SO\\5rk\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:!QU+\u0016\nR\u0015!gR\u0014\u0018N\\4/AQCW\r\t<bYV,\u0007%[:!e\u0016$XO\u001d8fI\u0002\n7\u000fI1!G\u0006twN\\5dC2\u0004S+V%EAM2Tf\u00195be\u0006\u001cG/\u001a:!gR\u0014\u0018N\\4/\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAX\u0003YS\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!iY:\u0004g\u000e3:e5\u0002$G\u001a\u001b.ia\nt'\f\u001d2cYj\u0013\rN24EJ\u001aTM\u000e\u001a7m)\u0001\u0003%\u0001\u0003o_R,\u0017EAA[\u0003)R\u0001\u0005\t\u0011!)\",\u0007EZ;oGRLwN\u001c\u0011jg\u0002rwN\\\u0017eKR,'/\\5oSN$\u0018n\u0019\u0018\u000bA\u0001\nQa]5oG\u0016\f#!a/\u0002\u000bIr3G\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005\u0005\u0017AC7jg\u000e|f-\u001e8dg\u0006!Q+^5e!\t\t\u0014dE\u0003\u001a\u0003\u0013\f)\u000e\u0005\u0004\u0002L\u0006E\u0017KW\u0007\u0003\u0003\u001bT1!a4@\u0003\u001d\u0011XO\u001c;j[\u0016LA!a5\u0002N\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005]\u0017Q\\\u0007\u0003\u00033TA!a7\u0002h\u0005\u0011\u0011n\\\u0005\u0004\u001b\u0006eGCAAc\u0003!!xn\u0015;sS:<GCAA0\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0016\u0011\u001e\u0005\b\u001fr\u0001\n\u00111\u0001R\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\n\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003c\f\u0019\u0010E\u0002?%FC\u0001\"!>\u001f\u0003\u0003\u0005\rAW\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002~B!\u0011\u0011MA\u0000\u0013\u0011\u0011\t!a\u0019\u0003\r=\u0013'.Z2u\u0001")
public class Uuid
extends LeafExpression
implements Nondeterministic,
DefaultStringProducingExpression,
ExpressionWithRandomSeed,
Serializable {
    private boolean resolved;
    private final Option<Object> randomSeed;
    private transient RandomUUIDGenerator randomGenerator;
    private Seq<Enumeration.Value> nodePatterns;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private volatile byte bitmap$0;

    public static Option<Object> $lessinit$greater$default$1() {
        return Uuid$.MODULE$.$lessinit$greater$default$1();
    }

    public static Option<Option<Object>> unapply(Uuid x$0) {
        return Uuid$.MODULE$.unapply(x$0);
    }

    public static Option<Object> apply$default$1() {
        return Uuid$.MODULE$.apply$default$1();
    }

    public static <A> Function1<Option<Object>, A> andThen(Function1<Uuid, A> g) {
        return Uuid$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Uuid> compose(Function1<A$, Option<Object>> g) {
        return Uuid$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private boolean deterministic$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    public Option<Object> randomSeed() {
        return this.randomSeed;
    }

    @Override
    public Expression seedExpression() {
        return (Expression)this.randomSeed().map((Function1 & Serializable)v -> Literal$.MODULE$.apply(v)).getOrElse((Function0 & Serializable)() -> UnresolvedSeed$.MODULE$);
    }

    @Override
    public Uuid withNewSeed(long seed) {
        return new Uuid((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)seed)));
    }

    private boolean resolved$lzycompute() {
        Uuid uuid = this;
        synchronized (uuid) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.resolved = this.randomSeed().isDefined();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.randomGenerator = new RandomUUIDGenerator(BoxesRunTime.unboxToLong((Object)this.randomSeed().get()) + (long)partitionIndex);
    }

    @Override
    public Object evalInternal(InternalRow input) {
        return this.randomGenerator.getNextUUIDUTF8String();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String randomGen = ctx.freshName("randomGen");
        String x$1 = "org.apache.spark.sql.catalyst.util.RandomUUIDGenerator";
        String x$2 = randomGen;
        boolean x$3 = true;
        boolean x$4 = false;
        Function1<String, String> x$5 = ctx.addMutableState$default$3();
        ctx.addMutableState("org.apache.spark.sql.catalyst.util.RandomUUIDGenerator", x$2, x$5, true, false);
        ctx.addPartitionInitializationStatement(randomGen + " = new org.apache.spark.sql.catalyst.util.RandomUUIDGenerator(" + this.randomSeed().get() + "L + partitionIndex);");
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"final UTF8String ", " = ", ".getNextUUIDUTF8String();"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), randomGen})), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public Uuid copy(Option<Object> randomSeed) {
        return new Uuid(randomSeed);
    }

    public Option<Object> copy$default$1() {
        return this.randomSeed();
    }

    @Override
    public String productPrefix() {
        return "Uuid";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.randomSeed();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Uuid;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "randomSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Uuid)) return false;
        boolean bl = true;
        if (!bl) return false;
        Uuid uuid = (Uuid)x$1;
        Option<Object> option = this.randomSeed();
        Option<Object> option2 = uuid.randomSeed();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!uuid.canEqual(this)) return false;
        return true;
    }

    public Uuid(Option<Object> randomSeed) {
        this.randomSeed = randomSeed;
        Nondeterministic.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        ExpressionWithRandomSeed.$init$(this);
        Statics.releaseFence();
    }

    public Uuid() {
        this((Option<Object>)None$.MODULE$);
    }

    public Uuid(Expression seed) {
        this(ExpressionWithRandomSeed$.MODULE$.expressionToSeed(seed, "UUID"));
    }
}

