/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.sql.connector.catalog.Identifier;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QuotingUtils$ {
    public static final QuotingUtils$ MODULE$ = new QuotingUtils$();
    private static final Pattern validIdentPattern = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*");

    private String quoteByDefault(String elem) {
        return "\"" + elem + "\"";
    }

    public String toSQLConf(String conf) {
        return this.quoteByDefault(conf);
    }

    public String toSQLSchema(String schema) {
        return this.quoteByDefault(schema);
    }

    public String quoteIdentifier(String name) {
        return "`" + name.replace("`", "``") + "`";
    }

    public String quoteNameParts(Seq<String> name) {
        return ((IterableOnceOps)name.map((Function1 & Serializable)part -> MODULE$.quoteIdentifier((String)part))).mkString(".");
    }

    private Pattern validIdentPattern() {
        return validIdentPattern;
    }

    public boolean needQuote(String part) {
        return !this.validIdentPattern().matcher(part).matches();
    }

    public String quoteIfNeeded(String part) {
        if (this.needQuote(part)) {
            return this.quoteIdentifier(part);
        }
        return part;
    }

    public String quoted(String[] namespace) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])namespace), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".");
    }

    public String quoted(Identifier ident) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))) {
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Function1 & Serializable)part -> MODULE$.quoteIfNeeded((String)part), ClassTag$.MODULE$.apply(String.class))).mkString(".") + "." + this.quoteIfNeeded(ident.name());
        }
        return this.quoteIfNeeded(ident.name());
    }

    public String fullyQuoted(Identifier ident) {
        if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()))) {
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ident.namespace()), (Function1 & Serializable)name -> MODULE$.quoteIdentifier((String)name), ClassTag$.MODULE$.apply(String.class))).mkString(".") + "." + this.quoteIdentifier(ident.name());
        }
        return this.quoteIdentifier(ident.name());
    }

    public String escapeSingleQuotedString(String str) {
        StringBuilder builder = new StringBuilder();
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(str), (Function1 & Serializable)x0$1 -> QuotingUtils$.$anonfun$escapeSingleQuotedString$1(builder, BoxesRunTime.unboxToChar((Object)x0$1)));
        return builder.toString();
    }

    public static final /* synthetic */ StringBuilder $anonfun$escapeSingleQuotedString$1(StringBuilder builder$1, char x0$1) {
        char c = x0$1;
        switch (c) {
            case '\'': {
                return builder$1.$plus$plus$eq("\\'");
            }
        }
        return (StringBuilder)builder$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)c));
    }

    private QuotingUtils$() {
    }
}

