/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.valuegenerator;

import java.util.Properties;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.valuegenerator.ValueGenerationBlock;
import org.datanucleus.store.valuegenerator.ValueGenerationException;
import org.datanucleus.store.valuegenerator.ValueGenerator;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public abstract class AbstractGenerator<T>
implements ValueGenerator<T> {
    protected String name;
    protected Properties properties;
    protected int allocationSize = 5;
    protected int initialValue = 0;
    protected ValueGenerationBlock<T> block;
    protected boolean repositoryExists = false;

    public AbstractGenerator(String name, Properties props) {
        this.name = name;
        this.properties = props;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized T next() {
        if (this.block == null || !this.block.hasNext()) {
            this.block = this.obtainGenerationBlock();
        }
        return this.block.next();
    }

    @Override
    public synchronized T current() {
        if (this.block == null) {
            return null;
        }
        return this.block.current();
    }

    @Override
    public long nextValue() {
        return this.getLongValueForObject(this.next());
    }

    @Override
    public long currentValue() {
        return this.getLongValueForObject(this.current());
    }

    private long getLongValueForObject(Object oid) {
        if (oid instanceof Long) {
            return (Long)oid;
        }
        if (oid instanceof Integer) {
            return ((Integer)oid).longValue();
        }
        if (oid instanceof Short) {
            return ((Short)oid).longValue();
        }
        throw new NucleusDataStoreException(Localiser.msg("040009", this.name));
    }

    @Override
    public synchronized void allocate(int additional) {
        if (this.block == null) {
            this.block = this.obtainGenerationBlock(additional);
        } else {
            this.block.addBlock(this.obtainGenerationBlock(additional));
        }
    }

    protected ValueGenerationBlock<T> obtainGenerationBlock() {
        return this.obtainGenerationBlock(-1);
    }

    protected ValueGenerationBlock<T> obtainGenerationBlock(int number) {
        ValueGenerationBlock<T> block = null;
        boolean repository_exists = true;
        if (this.requiresRepository() && !this.repositoryExists) {
            this.repositoryExists = this.repositoryExists();
            if (!this.repositoryExists) {
                this.createRepository();
                this.repositoryExists = true;
            }
        }
        try {
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        catch (ValueGenerationException vex) {
            NucleusLogger.VALUEGENERATION.info(Localiser.msg("040003", vex.getMessage()));
            if (this.requiresRepository()) {
                repository_exists = false;
            }
            throw vex;
        }
        catch (RuntimeException ex) {
            NucleusLogger.VALUEGENERATION.info(Localiser.msg("040003", ex.getMessage()));
            if (this.requiresRepository()) {
                repository_exists = false;
            }
            throw ex;
        }
        if (!repository_exists) {
            NucleusLogger.VALUEGENERATION.info(Localiser.msg("040005"));
            if (!this.createRepository()) {
                throw new ValueGenerationException(Localiser.msg("040002"));
            }
            block = number < 0 ? this.reserveBlock() : this.reserveBlock(number);
        }
        return block;
    }

    protected ValueGenerationBlock<T> reserveBlock() {
        return this.reserveBlock(this.allocationSize);
    }

    protected abstract ValueGenerationBlock<T> reserveBlock(long var1);

    protected boolean requiresRepository() {
        return false;
    }

    protected boolean repositoryExists() {
        return true;
    }

    protected boolean createRepository() {
        return true;
    }
}

