/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import org.apache.spark.sql.errors.QueryExecutionErrors$;
import scala.Predef$;
import scala.collection.StringOps$;

public final class MetadataVersionUtil$ {
    public static final MetadataVersionUtil$ MODULE$ = new MetadataVersionUtil$();

    public int validateVersion(String text, int maxSupportedVersion) {
        int version = this.extractVersion(text);
        if (version > maxSupportedVersion) {
            throw QueryExecutionErrors$.MODULE$.logVersionGreaterThanSupported(version, maxSupportedVersion);
        }
        return version;
    }

    public int validateVersionExactMatch(String text, int matchVersion) {
        int version = this.extractVersion(text);
        if (version != matchVersion) {
            throw QueryExecutionErrors$.MODULE$.logVersionNotMatch(version, matchVersion);
        }
        return version;
    }

    private int extractVersion(String text) {
        int n;
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(text)) && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) == 'v') {
            try {
                n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(text.substring(1, text.length())));
            }
            catch (NumberFormatException numberFormatException) {
                throw QueryExecutionErrors$.MODULE$.malformedLogFile(text);
            }
        } else {
            throw QueryExecutionErrors$.MODULE$.malformedLogFile(text);
        }
        int version = n;
        if (version <= 0) {
            throw QueryExecutionErrors$.MODULE$.malformedLogFile(text);
        }
        return version;
    }

    private MetadataVersionUtil$() {
    }
}

