/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GetTimestamp;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.ParseToDate$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.CurrentOrigin$;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(date_str[, fmt]) - Parses the `date_str` expression with the `fmt` expression to\n      a date. Returns null with invalid input. By default, it follows casting rules to a date if\n      the `fmt` is omitted.\n  ", arguments="\n    Arguments:\n      * date_str - A string to be parsed to date.\n      * fmt - Date format pattern to follow. See <a href=\"https://spark.apache.org/docs/latest/sql-ref-datetime-pattern.html\">Datetime Patterns</a> for valid\n              date and time format patterns.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('2009-07-30 04:17:52');\n       2009-07-30\n      > SELECT _FUNC_('2016-12-31', 'yyyy-MM-dd');\n       2016-12-31\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0005\tuc\u0001\u0002\u0016,\u0001bB\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\t5\u0002\u0011\t\u0012)A\u0005s!A1\f\u0001BK\u0002\u0013\u0005A\f\u0003\u0005a\u0001\tE\t\u0015!\u0003^\u0011!\t\u0007A!f\u0001\n\u0003\u0011\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B2\t\u00115\u0004!Q3A\u0005\u00029D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\tu\u0002A)\u0019!C!3\")1\u000f\u0001C\u0001w\")1\u000f\u0001C\u0001}\"9\u0011\u0011\u0001\u0001\u0005B\u0005\r\u0001bBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u0017\u0001A\u0011IA\u0007\u0011\u001d\ty\u0004\u0001C!\u0003\u0003Bq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002X\u0001!\t&!\u0017\t\u0013\u0005\u0015\u0004!!A\u0005\u0002\u0005\u001d\u0004\"CA9\u0001E\u0005I\u0011AA:\u0011%\tI\tAI\u0001\n\u0003\tY\tC\u0005\u0002\u0010\u0002\t\n\u0011\"\u0001\u0002\u0012\"I\u0011Q\u0013\u0001\u0012\u0002\u0013\u0005\u0011q\u0013\u0005\n\u00037\u0003\u0011\u0011!C!\u0003;C\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!!A\u0005\u0002\u0005e\u0006\"CAc\u0001\u0005\u0005I\u0011IAd\u0011%\t)\u000eAA\u0001\n\u0003\t9\u000eC\u0005\u0002\\\u0002\t\t\u0011\"\u0011\u0002^\"I\u0011\u0011\u001d\u0001\u0002\u0002\u0013\u0005\u00131]\u0004\n\u0005\u001bY\u0013\u0011!E\u0001\u0005\u001f1\u0001BK\u0016\u0002\u0002#\u0005!\u0011\u0003\u0005\u0007g\u0002\"\tA!\u000b\t\u0013\t-\u0002%!A\u0005F\t5\u0002\"\u0003B\u0018A\u0005\u0005I\u0011\u0011B\u0019\u0011%\u0011Y\u0004II\u0001\n\u0003\t\t\nC\u0005\u0003>\u0001\n\n\u0011\"\u0001\u0002\u0018\"I!q\b\u0011\u0002\u0002\u0013\u0005%\u0011\t\u0005\n\u0005\u001f\u0002\u0013\u0013!C\u0001\u0003#C\u0011B!\u0015!#\u0003%\t!a&\t\u0013\tM\u0003%!A\u0005\n\tU#a\u0003)beN,Gk\u001c#bi\u0016T!\u0001L\u0017\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003]=\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003aE\n1a]9m\u0015\t\u00114'A\u0003ta\u0006\u00148N\u0003\u00025k\u00051\u0011\r]1dQ\u0016T\u0011AN\u0001\u0004_J<7\u0001A\n\b\u0001ej\u0004i\u0011$M!\tQ4(D\u0001,\u0013\ta4F\u0001\u0006FqB\u0014Xm]:j_:\u0004\"A\u000f \n\u0005}Z#A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"AO!\n\u0005\t[#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005i\"\u0015BA#,\u0005]!\u0016.\\3[_:,\u0017i^1sK\u0016C\bO]3tg&|g\u000e\u0005\u0002H\u00156\t\u0001JC\u0001J\u0003\u0015\u00198-\u00197b\u0013\tY\u0005JA\u0004Qe>$Wo\u0019;\u0011\u00055+fB\u0001(T\u001d\ty%+D\u0001Q\u0015\t\tv'\u0001\u0004=e>|GOP\u0005\u0002\u0013&\u0011A\u000bS\u0001\ba\u0006\u001c7.Y4f\u0013\t1vK\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002U\u0011\u0006!A.\u001a4u+\u0005I\u0014!\u00027fMR\u0004\u0013A\u00024pe6\fG/F\u0001^!\r9e,O\u0005\u0003?\"\u0013aa\u00149uS>t\u0017a\u00024pe6\fG\u000fI\u0001\u000bi&lWMW8oK&#W#A2\u0011\u0007\u001dsF\r\u0005\u0002fS:\u0011am\u001a\t\u0003\u001f\"K!\u0001\u001b%\u0002\rA\u0013X\rZ3g\u0013\tQ7N\u0001\u0004TiJLgn\u001a\u0006\u0003Q\"\u000b1\u0002^5nKj{g.Z%eA\u0005Y\u0011M\\:j\u000b:\f'\r\\3e+\u0005y\u0007CA$q\u0013\t\t\bJA\u0004C_>dW-\u00198\u0002\u0019\u0005t7/[#oC\ndW\r\u001a\u0011\u0002\rqJg.\u001b;?)\u0015)ho\u001e=z!\tQ\u0004\u0001C\u0003Y\u0013\u0001\u0007\u0011\bC\u0003\\\u0013\u0001\u0007Q\fC\u0004b\u0013A\u0005\t\u0019A2\t\u000f5L\u0001\u0013!a\u0001_\u0006Y!/\u001a9mC\u000e,W.\u001a8u)\r)H0 \u0005\u00061.\u0001\r!\u000f\u0005\u00067.\u0001\r!\u000f\u000b\u0003k~DQ\u0001\u0017\u0007A\u0002e\n!\u0002\u001d:fiRLh*Y7f+\u0005!\u0017\u0001D<ji\"$\u0016.\\3[_:,GcA\"\u0002\n!)\u0011M\u0004a\u0001I\u0006!bn\u001c3f!\u0006$H/\u001a:og&sG/\u001a:oC2$\"!a\u0004\u0011\u000b5\u000b\t\"!\u0006\n\u0007\u0005MqKA\u0002TKF\u0004B!a\u0006\u0002:9!\u0011\u0011DA\u001a\u001d\u0011\tY\"a\f\u000f\t\u0005u\u0011Q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1aTA\u0013\u0013\u00051\u0014B\u0001\u001b6\u0013\t\u00114'\u0003\u00021c%\u0011afL\u0005\u0004\u0003ci\u0013!\u0002;sK\u0016\u001c\u0018\u0002BA\u001b\u0003o\t1\u0002\u0016:fKB\u000bG\u000f^3s]*\u0019\u0011\u0011G\u0017\n\t\u0005m\u0012Q\b\u0002\f)J,W\rU1ui\u0016\u0014hN\u0003\u0003\u00026\u0005]\u0012\u0001C2iS2$'/\u001a8\u0016\u0005\u0005\r\u0003\u0003B'\u0002\u0012e\n!\"\u001b8qkR$\u0016\u0010]3t+\t\tI\u0005E\u0003N\u0003#\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tfL\u0001\u0006if\u0004Xm]\u0005\u0005\u0003+\nyE\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0004s\u0005m\u0003bBA/%\u0001\u0007\u0011qL\u0001\f]\u0016<8\t[5mIJ,g\u000e\u0005\u0003N\u0003CJ\u0014bAA2/\nQ\u0011J\u001c3fq\u0016$7+Z9\u0002\t\r|\u0007/\u001f\u000b\nk\u0006%\u00141NA7\u0003_Bq\u0001W\n\u0011\u0002\u0003\u0007\u0011\bC\u0004\\'A\u0005\t\u0019A/\t\u000f\u0005\u001c\u0002\u0013!a\u0001G\"9Qn\u0005I\u0001\u0002\u0004y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003kR3!OA<W\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u0013Ut7\r[3dW\u0016$'bAAB\u0011\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u001bS3!XA<\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a%+\u0007\r\f9(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e%fA8\u0002x\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a(\u0011\t\u0005\u0005\u00161V\u0007\u0003\u0003GSA!!*\u0002(\u0006!A.\u00198h\u0015\t\tI+\u0001\u0003kCZ\f\u0017b\u00016\u0002$\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0017\t\u0004\u000f\u0006M\u0016bAA[\u0011\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111XAa!\r9\u0015QX\u0005\u0004\u0003\u007fC%aA!os\"I\u00111\u0019\u000e\u0002\u0002\u0003\u0007\u0011\u0011W\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0007CBAf\u0003#\fY,\u0004\u0002\u0002N*\u0019\u0011q\u001a%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00065'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a\\Am\u0011%\t\u0019\rHA\u0001\u0002\u0004\tY,\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BAP\u0003?D\u0011\"a1\u001e\u0003\u0003\u0005\r!!-\u0002\r\u0015\fX/\u00197t)\ry\u0017Q\u001d\u0005\n\u0003\u0007t\u0012\u0011!a\u0001\u0003wCs\u0003AAu\u0003_\f\t0!>\u0002x\u0006m\u0018Q B\u0001\u0005\u0007\u00119A!\u0003\u0011\u0007i\nY/C\u0002\u0002n.\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002t\u0006\tIL\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0017\r^3`gR\u00148\f\f\u0011g[Rl\u0016\u0006I\u0017!!\u0006\u00148/Z:!i\",\u0007\u0005\u00193bi\u0016|6\u000f\u001e:aA\u0015D\bO]3tg&|g\u000eI<ji\"\u0004C\u000f[3!A\u001alG\u000f\u0019\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005I1!I\u0006$XM\f\u0011SKR,(O\\:!]VdG\u000eI<ji\"\u0004\u0013N\u001c<bY&$\u0007%\u001b8qkRt\u0003EQ=!I\u00164\u0017-\u001e7uY\u0001JG\u000f\t4pY2|wo\u001d\u0011dCN$\u0018N\\4!eVdWm\u001d\u0011u_\u0002\n\u0007\u0005Z1uK\u0002JgM\u0003\u0011!A\u0001\u0002\u0003\u0005\u001e5fA\u00014W\u000e\u001e1!SN\u0004s.\\5ui\u0016$gF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002z\u0006\u0011yB\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u0006$XmX:ue\u0002j\u0003%\u0011\u0011tiJLgn\u001a\u0011u_\u0002\u0012W\r\t9beN,G\r\t;pA\u0011\fG/\u001a\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+A\u0019lG\u000fI\u0017!\t\u0006$X\r\t4pe6\fG\u000f\t9biR,'O\u001c\u0011u_\u00022w\u000e\u001c7po:\u00023+Z3!y\u0005\u0004\u0003N]3g{\tBG\u000f\u001e9tu=z3\u000f]1sW:\n\u0007/Y2iK:z'oZ\u0018e_\u000e\u001cx\u0006\\1uKN$xf]9m[I,g-\f3bi\u0016$\u0018.\\3.a\u0006$H/\u001a:o]!$X\u000e\u001c\u0012?\t\u0006$X\r^5nK\u0002\u0002\u0016\r\u001e;fe:\u001cHhL1?A\u0019|'\u000f\t<bY&$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005Z1uK\u0002\ng\u000e\u001a\u0011uS6,\u0007EZ8s[\u0006$\b\u0005]1ui\u0016\u0014hn\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u007f\f\u0011Q\u0006\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0004'O\u00171o5\u001a\u0004\u0007\t\u00195uE:$(\u000e\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002#\u0007\r\u0019:[A:Tf\r\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u0012\u0004'\r\u001c.cIj3'M\u0014-A\u001dJ\u00180_=.\u001b6kC\rZ\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'\r\u001c.cIj3'\r\u0006!A\u0005)qM]8va\u0006\u0012!QA\u0001\u000fI\u0006$X\r^5nK~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011Y!A\u00032]Ur\u0003'A\u0006QCJ\u001cX\rV8ECR,\u0007C\u0001\u001e!'\u0015\u0001#1\u0003B\u0010!%\u0011)Ba\u0007:;\u000e|W/\u0004\u0002\u0003\u0018)\u0019!\u0011\u0004%\u0002\u000fI,h\u000e^5nK&!!Q\u0004B\f\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|g\u000e\u000e\t\u0005\u0005C\u00119#\u0004\u0002\u0003$)!!QEAT\u0003\tIw.C\u0002W\u0005G!\"Aa\u0004\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a(\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013U\u0014\u0019D!\u000e\u00038\te\u0002\"\u0002-$\u0001\u0004I\u0004\"B.$\u0001\u0004i\u0006bB1$!\u0003\u0005\ra\u0019\u0005\b[\u000e\u0002\n\u00111\u0001p\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0002\u000fUt\u0017\r\u001d9msR!!1\tB&!\u00119eL!\u0012\u0011\u000f\u001d\u00139%O/d_&\u0019!\u0011\n%\u0003\rQ+\b\u000f\\35\u0011!\u0011iEJA\u0001\u0002\u0004)\u0018a\u0001=%a\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B,!\u0011\t\tK!\u0017\n\t\tm\u00131\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class ParseToDate
extends Expression
implements RuntimeReplaceable,
ImplicitCastInputTypes,
TimeZoneAwareExpression,
Serializable {
    private Expression replacement;
    private final Expression left;
    private final Option<Expression> format;
    private final Option<String> timeZoneId;
    private final boolean ansiEnabled;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private Expression canonicalized;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$4() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$4();
    }

    public static Option<String> $lessinit$greater$default$3() {
        return ParseToDate$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple4<Expression, Option<Expression>, Option<String>, Object>> unapply(ParseToDate x$0) {
        return ParseToDate$.MODULE$.unapply(x$0);
    }

    public static boolean apply$default$4() {
        return ParseToDate$.MODULE$.apply$default$4();
    }

    public static Option<String> apply$default$3() {
        return ParseToDate$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple4<Expression, Option<Expression>, Option<String>, Object>, ParseToDate> tupled() {
        return ParseToDate$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Option<Expression>, Function1<Option<String>, Function1<Object, ParseToDate>>>> curried() {
        return ParseToDate$.MODULE$.curried();
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.resolved$lzycompute();
        }
        return this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if (!this.bitmap$trans$0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        if (!this.bitmap$trans$0) {
            return this.zoneId$lzycompute();
        }
        return this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    private Expression canonicalized$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
    }

    public Expression left() {
        return this.left;
    }

    public Option<Expression> format() {
        return this.format;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    public boolean ansiEnabled() {
        return this.ansiEnabled;
    }

    private Expression replacement$lzycompute() {
        ParseToDate parseToDate = this;
        synchronized (parseToDate) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.replacement = (Expression)CurrentOrigin$.MODULE$.withOrigin(this.origin(), (Function0 & Serializable)() -> (Cast)this.format().map((Function1 & Serializable)f -> new Cast(new GetTimestamp(this.left(), (Expression)f, (DataType)TimestampType$.MODULE$, "try_to_timestamp", this.timeZoneId(), this.ansiEnabled()), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled()))).getOrElse((Function0 & Serializable)() -> new Cast(this.left(), (DataType)DateType$.MODULE$, this.timeZoneId(), EvalMode$.MODULE$.fromBoolean(this.ansiEnabled()))));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return "to_date";
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Some x$1 = new Some((Object)timeZoneId);
        Expression x$2 = this.copy$default$1();
        Option<Expression> x$3 = this.copy$default$2();
        boolean x$4 = this.copy$default$4();
        return this.copy(x$2, x$3, (Option<String>)x$1, x$4);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return new .colon.colon((Object)TreePattern$.MODULE$.RUNTIME_REPLACEABLE(), (List)Nil$.MODULE$);
    }

    @Override
    public Seq<Expression> children() {
        Expression expression = this.left();
        return (Seq)Option$.MODULE$.option2Iterable(this.format()).toSeq().$plus$colon((Object)expression);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        TypeCollection typeCollection = TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), DateType$.MODULE$, TimestampType$.MODULE$, TimestampNTZType$.MODULE$}));
        return (Seq)Option$.MODULE$.option2Iterable(this.format().map((Function1 & Serializable)x$6 -> StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()))).toSeq().$plus$colon((Object)typeCollection);
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        if (this.format().isDefined()) {
            return this.copy((Expression)newChildren.head(), (Option<Expression>)new Some(newChildren.last()), this.copy$default$3(), this.copy$default$4());
        }
        return this.copy((Expression)newChildren.head(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4());
    }

    public ParseToDate copy(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        return new ParseToDate(left, format, timeZoneId, ansiEnabled);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Option<Expression> copy$default$2() {
        return this.format();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    public boolean copy$default$4() {
        return this.ansiEnabled();
    }

    @Override
    public String productPrefix() {
        return "ParseToDate";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.format();
            }
            case 2: {
                return this.timeZoneId();
            }
            case 3: {
                return BoxesRunTime.boxToBoolean((boolean)this.ansiEnabled());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ParseToDate;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "format";
            }
            case 2: {
                return "timeZoneId";
            }
            case 3: {
                return "ansiEnabled";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ParseToDate)) return false;
        boolean bl = true;
        if (!bl) return false;
        ParseToDate parseToDate = (ParseToDate)x$1;
        if (this.ansiEnabled() != parseToDate.ansiEnabled()) return false;
        Expression expression = this.left();
        Expression expression2 = parseToDate.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.format();
        Option<Expression> option2 = parseToDate.format();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<String> option3 = this.timeZoneId();
        Option<String> option4 = parseToDate.timeZoneId();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        if (!parseToDate.canEqual(this)) return false;
        return true;
    }

    public ParseToDate(Expression left, Option<Expression> format, Option<String> timeZoneId, boolean ansiEnabled) {
        this.left = left;
        this.format = format;
        this.timeZoneId = timeZoneId;
        this.ansiEnabled = ansiEnabled;
        RuntimeReplaceable.$init$(this);
        ExpectsInputTypes.$init$(this);
        TimeZoneAwareExpression.$init$(this);
        Statics.releaseFence();
    }

    public ParseToDate(Expression left, Expression format) {
        this(left, (Option<Expression>)Option$.MODULE$.apply((Object)format), ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }

    public ParseToDate(Expression left) {
        this(left, (Option<Expression>)None$.MODULE$, ParseToDate$.MODULE$.$lessinit$greater$default$3(), ParseToDate$.MODULE$.$lessinit$greater$default$4());
    }
}

