/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedSeed$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ExpressionImplUtils;
import org.apache.spark.sql.catalyst.expressions.ExpressionWithRandomSeed;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Nondeterministic;
import org.apache.spark.sql.catalyst.expressions.RandStr$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.util.random.XORShiftRandom;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(length[, seed]) - Returns a string of the specified length whose characters are chosen\n      uniformly at random from the following pool of characters: 0-9, a-z, A-Z. The random seed is\n      optional. The string length must be a constant two-byte or four-byte integer (SMALLINT or INT,\n      respectively).\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(3, 0) AS result;\n       ceV\n  ", since="4.0.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\tme\u0001\u0002\u00180\u0001rB\u0001\"\u001a\u0001\u0003\u0016\u0004%\tA\u001a\u0005\tO\u0002\u0011\t\u0012)A\u0005{!A\u0001\u000e\u0001BK\u0002\u0013\u0005c\r\u0003\u0005j\u0001\tE\t\u0015!\u0003>\u0011!Q\u0007A!f\u0001\n\u0003Y\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011\u00027\t\u000bA\u0004A\u0011A9\t\u000bA\u0004A\u0011\u0001<\t\u000bA\u0004A\u0011\u0001=\t\u000bm\u0004A\u0011I6\t\u000bq\u0004A\u0011I6\t\u000bu\u0004A\u0011\t4\t\u000by\u0004A\u0011\t4\t\r}\u0004A\u0011IA\u0001\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%\t\"a\u0006\t\u0017\u0005%\u0002\u00011AA\u0002\u0013E\u00111\u0006\u0005\f\u0003o\u0001\u0001\u0019!A!B\u0013\tI\u0002\u0003\u0006\u0002B\u0001A)\u0019!C\t\u0003\u0007Bq!!\u0014\u0001\t#\ny\u0005C\u0004\u0002\\\u0001!\t%!\u0018\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!1A\u0007\u0001C!\u0003_Bq!!!\u0001\t\u0003\n\u0019\tC\u0004\u0002\u0012\u0002!\t%a%\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u00111\u0016\u0001\u0005B\u00055\u0006\"CAe\u0001\u0005\u0005I\u0011AAf\u0011%\t\u0019\u000eAI\u0001\n\u0003\t)\u000eC\u0005\u0002l\u0002\t\n\u0011\"\u0001\u0002V\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\n\u0003g\u0004\u0011\u0011!C!\u0003kD\u0011B!\u0002\u0001\u0003\u0003%\tAa\u0002\t\u0013\t%\u0001!!A\u0005\u0002\t-\u0001\"\u0003B\b\u0001\u0005\u0005I\u0011\tB\t\u0011%\u0011y\u0002AA\u0001\n\u0003\u0011\t\u0003C\u0005\u0003&\u0001\t\t\u0011\"\u0011\u0003(!I!1\u0006\u0001\u0002\u0002\u0013\u0005#QF\u0004\b\u0005#z\u0003\u0012\u0001B*\r\u0019qs\u0006#\u0001\u0003V!1\u0001o\nC\u0001\u0005OBqA!\u001b(\t\u0003\u0011Y\u0007C\u0004\u0003j\u001d\"\tAa\u001c\t\u0013\t%t%!A\u0005\u0002\nU\u0004\"\u0003B?O\u0005\u0005I\u0011\u0011B@\u0011%\u0011\tjJA\u0001\n\u0013\u0011\u0019JA\u0004SC:$7\u000b\u001e:\u000b\u0005A\n\u0014aC3yaJ,7o]5p]NT!AM\u001a\u0002\u0011\r\fG/\u00197zgRT!\u0001N\u001b\u0002\u0007M\fHN\u0003\u00027o\u0005)1\u000f]1sW*\u0011\u0001(O\u0001\u0007CB\f7\r[3\u000b\u0003i\n1a\u001c:h\u0007\u0001\u0019\u0012\u0002A\u001fB\t*k\u0005kU-\u0011\u0005yzT\"A\u0018\n\u0005\u0001{#AC#yaJ,7o]5p]B\u0011aHQ\u0005\u0003\u0007>\u0012\u0001$\u0012=qe\u0016\u001c8/[8o/&$\bNU1oI>l7+Z3e!\r)\u0005*P\u0007\u0002\r*\u0011q)M\u0001\u0006iJ,Wm]\u0005\u0003\u0013\u001a\u0013!BQ5oCJLH*[6f!\tq4*\u0003\u0002M_\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\tqd*\u0003\u0002P_\t\u0001bj\u001c8eKR,'/\\5oSN$\u0018n\u0019\t\u0003}EK!AU\u0018\u0003#\u0015C\b/Z2ug&s\u0007/\u001e;UsB,7\u000f\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVKA\u0004Qe>$Wo\u0019;\u0011\u0005i\u0013gBA.a\u001d\tav,D\u0001^\u0015\tq6(\u0001\u0004=e>|GOP\u0005\u0002-&\u0011\u0011-V\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019GM\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002b+\u00061A.\u001a8hi\",\u0012!P\u0001\bY\u0016tw\r\u001e5!\u00039\u0019X-\u001a3FqB\u0014Xm]:j_:\fqb]3fI\u0016C\bO]3tg&|g\u000eI\u0001\tQ&$WmU3fIV\tA\u000e\u0005\u0002U[&\u0011a.\u0016\u0002\b\u0005>|G.Z1o\u0003%A\u0017\u000eZ3TK\u0016$\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0005eN$X\u000f\u0005\u0002?\u0001!)Qm\u0002a\u0001{!)\u0001n\u0002a\u0001{!)!n\u0002a\u0001YR\u0011!o\u001e\u0005\u0006K\"\u0001\r!\u0010\u000b\u0004efT\b\"B3\n\u0001\u0004i\u0004\"\u00025\n\u0001\u0004i\u0014\u0001\u00038vY2\f'\r\\3\u0002\u0011M$\u0018\r^3gk2\fA\u0001\\3gi\u0006)!/[4ii\u0006Q\u0011N\u001c9viRK\b/Z:\u0016\u0005\u0005\r\u0001#\u0002.\u0002\u0006\u0005%\u0011bAA\u0004I\n\u00191+Z9\u0011\t\u0005-\u0011\u0011C\u0007\u0003\u0003\u001bQ1!a\u00044\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019\"!\u0004\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017a\u0001:oOV\u0011\u0011\u0011\u0004\t\u0005\u00037\t)#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0019\u0011\u0018M\u001c3p[*\u0019\u00111E\u001b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003O\tiB\u0001\bY\u001fJ\u001b\u0006.\u001b4u%\u0006tGm\\7\u0002\u000fItwm\u0018\u0013fcR!\u0011QFA\u001a!\r!\u0016qF\u0005\u0004\u0003c)&\u0001B+oSRD\u0011\"!\u000e\u0011\u0003\u0003\u0005\r!!\u0007\u0002\u0007a$\u0013'\u0001\u0003s]\u001e\u0004\u0003fA\t\u0002<A\u0019A+!\u0010\n\u0007\u0005}RKA\u0005ue\u0006t7/[3oi\u0006!1/Z3e+\t\t)\u0005E\u0002U\u0003\u000fJ1!!\u0013V\u0005\u0011auN\\4)\u0007I\tY$\u0001\nj]&$\u0018.\u00197ju\u0016Le\u000e^3s]\u0006dG\u0003BA\u0017\u0003#Bq!a\u0015\u0014\u0001\u0004\t)&\u0001\bqCJ$\u0018\u000e^5p]&sG-\u001a=\u0011\u0007Q\u000b9&C\u0002\u0002ZU\u00131!\u00138u\u0003-9\u0018\u000e\u001e5OK^\u001cV-\u001a3\u0015\u0007u\ny\u0006C\u0004\u0002bQ\u0001\r!!\u0012\u0002\u000f9,woU3fI\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006{\u0005\u001d\u00141\u000e\u0005\u0007\u0003S*\u0002\u0019A\u001f\u0002\u00119,wOR5sgRDa!!\u001c\u0016\u0001\u0004i\u0014!\u00038foN+7m\u001c8e+\t\t\t\b\u0005\u0003\u0002t\u0005md\u0002BA;\u0003o\u0002\"\u0001X+\n\u0007\u0005eT+\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\nyH\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003s*\u0016aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAAC!\u0011\t9)!$\u000e\u0005\u0005%%bAAFc\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u0010\u0006%%a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u0019\u00154\u0018\r\\%oi\u0016\u0014h.\u00197\u0015\t\u0005U\u00151\u0014\t\u0004)\u0006]\u0015bAAM+\n\u0019\u0011I\\=\t\u000f\u0005u\u0005\u00041\u0001\u0002 \u0006)\u0011N\u001c9viB!\u0011\u0011UAR\u001b\u0005\t\u0014bAASc\tY\u0011J\u001c;fe:\fGNU8x\u00035aWM\\4uQ&sG/Z4feR\u0011\u0011QK\u0001\nI><UM\\\"pI\u0016$b!a,\u0002<\u0006\u0015\u0007\u0003BAY\u0003ok!!a-\u000b\u0007\u0005Uv&A\u0004d_\u0012,w-\u001a8\n\t\u0005e\u00161\u0017\u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0018\u000eA\u0002\u0005}\u0016aA2uqB!\u0011\u0011WAa\u0013\u0011\t\u0019-a-\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011q\u0019\u000eA\u0002\u0005=\u0016AA3w\u0003\u0011\u0019w\u000e]=\u0015\u000fI\fi-a4\u0002R\"9Qm\u0007I\u0001\u0002\u0004i\u0004b\u00025\u001c!\u0003\u0005\r!\u0010\u0005\bUn\u0001\n\u00111\u0001m\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a6+\u0007u\nIn\u000b\u0002\u0002\\B!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018!C;oG\",7m[3e\u0015\r\t)/V\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003?\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002r*\u001aA.!7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0010\u0005\u0003\u0002z\n\rQBAA~\u0015\u0011\ti0a@\u0002\t1\fgn\u001a\u0006\u0003\u0005\u0003\tAA[1wC&!\u0011QPA~\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U%Q\u0002\u0005\n\u0003k\t\u0013\u0011!a\u0001\u0003+\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005'\u0001bA!\u0006\u0003\u001c\u0005UUB\u0001B\f\u0015\r\u0011I\"V\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u000f\u0005/\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019ANa\t\t\u0013\u0005U2%!AA\u0002\u0005U\u0015A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a>\u0003*!I\u0011Q\u0007\u0013\u0002\u0002\u0003\u0007\u0011QK\u0001\u0007KF,\u0018\r\\:\u0015\u00071\u0014y\u0003C\u0005\u00026\u0015\n\t\u00111\u0001\u0002\u0016\"\u001a\u0002Aa\r\u0003:\tm\"q\bB!\u0005\u000b\u00129Ea\u0013\u0003NA\u0019aH!\u000e\n\u0007\t]rFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\tu\u0012A!\"\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006\u0006\\3oORD7\f\f\u0011tK\u0016$W,\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007e\u001d;sS:<\u0007e\u001c4!i\",\u0007e\u001d9fG&4\u0017.\u001a3!Y\u0016tw\r\u001e5!o\"|7/\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004\u0013M]3!G\"|7/\u001a8\u000bA\u0001\u0002\u0003\u0005\t\u0011v]&4wN]7ms\u0002\nG\u000f\t:b]\u0012|W\u000e\t4s_6\u0004C\u000f[3!M>dGn\\<j]\u001e\u0004\u0003o\\8mA=4\u0007e\u00195be\u0006\u001cG/\u001a:tu\u0001\u0002T&\u000f\u0017!C6RH\u0006I!.5:\u0002C\u000b[3!e\u0006tGm\\7!g\u0016,G\rI5t\u0015\u0001\u0002\u0003\u0005\t\u0011!_B$\u0018n\u001c8bY:\u0002C\u000b[3!gR\u0014\u0018N\\4!Y\u0016tw\r\u001e5![V\u001cH\u000f\t2fA\u0005\u00043m\u001c8ti\u0006tG\u000f\t;x_6\u0012\u0017\u0010^3!_J\u0004cm\\;s[\tLH/\u001a\u0011j]R,w-\u001a:!QMk\u0015\t\u0014'J\u001dR\u0003sN\u001d\u0011J\u001dRc#\u0002\t\u0011!A\u0001\u0002#/Z:qK\u000e$\u0018N^3ms&r#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#Aa\u0011\u0002\u0007*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3\u0007\f\u00111S\u0001\n5\u000b\t:fgVdGo\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011dKZS\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0005\u0013\nQ\u0001\u000e\u00181]A\nQa\u001a:pkB\f#Aa\u0014\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u000fI\u000bg\u000eZ*ueB\u0011ahJ\n\u0006O\t]#Q\f\t\u0004)\ne\u0013b\u0001B.+\n1\u0011I\\=SK\u001a\u0004BAa\u0018\u0003f5\u0011!\u0011\r\u0006\u0005\u0005G\ny0\u0001\u0002j_&\u00191M!\u0019\u0015\u0005\tM\u0013!B1qa2LHc\u0001:\u0003n!)Q-\u000ba\u0001{Q)!O!\u001d\u0003t!)QM\u000ba\u0001{!)\u0001N\u000ba\u0001{Q9!Oa\u001e\u0003z\tm\u0004\"B3,\u0001\u0004i\u0004\"\u00025,\u0001\u0004i\u0004\"\u00026,\u0001\u0004a\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0013i\tE\u0003U\u0005\u0007\u00139)C\u0002\u0003\u0006V\u0013aa\u00149uS>t\u0007C\u0002+\u0003\nvjD.C\u0002\u0003\fV\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003BHY\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0003'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0003\u0016B!\u0011\u0011 BL\u0013\u0011\u0011I*a?\u0003\r=\u0013'.Z2u\u0001")
public class RandStr
extends Expression
implements ExpressionWithRandomSeed,
BinaryLike<Expression>,
DefaultStringProducingExpression,
Nondeterministic,
ExpectsInputTypes,
Serializable {
    private transient long seed;
    private final Expression length;
    private final Expression seedExpression;
    private final boolean hideSeed;
    private transient XORShiftRandom rng;
    private boolean deterministic;
    private transient boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    private transient Seq<Expression> children;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;
    private volatile transient byte bitmap$trans$0;

    public static Option<Tuple3<Expression, Expression, Object>> unapply(RandStr x$0) {
        return RandStr$.MODULE$.unapply(x$0);
    }

    @Override
    public final boolean foldable() {
        return Nondeterministic.foldable$(this);
    }

    @Override
    public final void initialize(int partitionIndex) {
        Nondeterministic.initialize$(this, partitionIndex);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Nondeterministic.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Nondeterministic.eval$default$1$(this);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private boolean deterministic$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if (!this.bitmap$0) {
                this.deterministic = Nondeterministic.deterministic$(this);
                this.bitmap$0 = true;
            }
        }
        return this.deterministic;
    }

    @Override
    public final boolean deterministic() {
        if (!this.bitmap$0) {
            return this.deterministic$lzycompute();
        }
        return this.deterministic;
    }

    @Override
    public boolean org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized() {
        return this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized_$eq(boolean x$1) {
        this.org$apache$spark$sql$catalyst$expressions$Nondeterministic$$initialized = x$1;
    }

    private Seq<Expression> children$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if ((byte)(this.bitmap$trans$0 & 2) == 0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$ExpressionWithRandomSeed$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression length() {
        return this.length;
    }

    @Override
    public Expression seedExpression() {
        return this.seedExpression;
    }

    public boolean hideSeed() {
        return this.hideSeed;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public boolean stateful() {
        return true;
    }

    @Override
    public Expression left() {
        return this.length();
    }

    @Override
    public Expression right() {
        return this.seedExpression();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{IntegerType$.MODULE$, LongType$.MODULE$})), (List)Nil$.MODULE$));
    }

    public XORShiftRandom rng() {
        return this.rng;
    }

    public void rng_$eq(XORShiftRandom x$1) {
        this.rng = x$1;
    }

    private long seed$lzycompute() {
        RandStr randStr = this;
        synchronized (randStr) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                long l;
                Expression expression = this.seedExpression();
                DataType dataType = expression.dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                if (!(dataType != null ? !dataType.equals(integerType$) : integerType$ != null)) {
                    l = BoxesRunTime.unboxToInt((Object)expression.eval(expression.eval$default$1()));
                } else {
                    DataType dataType2 = expression.dataType();
                    LongType$ longType$ = LongType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(longType$) : longType$ != null)) {
                        l = BoxesRunTime.unboxToLong((Object)expression.eval(expression.eval$default$1()));
                    } else {
                        throw new MatchError((Object)expression);
                    }
                }
                this.seed = l;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.seed;
    }

    public long seed() {
        if ((byte)(this.bitmap$trans$0 & 1) == 0) {
            return this.seed$lzycompute();
        }
        return this.seed;
    }

    @Override
    public void initializeInternal(int partitionIndex) {
        this.rng_$eq(new XORShiftRandom(this.seed() + (long)partitionIndex));
    }

    @Override
    public Expression withNewSeed(long newSeed) {
        return new RandStr(this.length(), new Literal(BoxesRunTime.boxToLong((long)newSeed), (DataType)LongType$.MODULE$), this.hideSeed());
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond) {
        return new RandStr(newFirst, newSecond, this.hideSeed());
    }

    @Override
    public String sql() {
        return "randstr(" + this.length().sql() + (this.hideSeed() ? "" : ", " + this.seedExpression().sql()) + ")";
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        ObjectRef result = ObjectRef.create((Object)ExpectsInputTypes.checkInputDataTypes$(this));
        new .colon.colon((Object)new Tuple2((Object)this.length(), (Object)"length"), (List)new .colon.colon((Object)new Tuple2((Object)this.seedExpression(), (Object)"seed"), (List)Nil$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
            RandStr.$anonfun$checkInputDataTypes$2(result, x0$1);
            return BoxedUnit.UNIT;
        });
        return (TypeCheckResult)result.elem;
    }

    @Override
    public Object evalInternal(InternalRow input) {
        int numChars = this.lengthInteger();
        return ExpressionImplUtils.randStr(this.rng(), numChars);
    }

    private int lengthInteger() {
        DataType dataType = this.length().dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), (Function0 & Serializable)() -> "Expected IntegerType, got " + this.length().dataType());
        int result = BoxesRunTime.unboxToInt((Object)this.length().eval(this.length().eval$default$1()));
        if (result < 0) {
            throw QueryExecutionErrors$.MODULE$.unexpectedValueForLengthInFunctionError(this.prettyName(), result);
        }
        return result;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String className = XORShiftRandom.class.getName();
        String rngTerm = ctx.addMutableState(className, "rng", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        ctx.addPartitionInitializationStatement(rngTerm + " = new " + className + "(" + this.seed() + "L + partitionIndex);");
        int numChars = this.lengthInteger();
        return ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\n        |UTF8String ", " =\n        |  ", ".randStr(", ", ", ");\n        |boolean ", " = false;\n        |"}))), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), ExpressionImplUtils.class.getName(), rngTerm, BoxesRunTime.boxToInteger((int)numChars), ev.isNull()})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    public RandStr copy(Expression length, Expression seedExpression, boolean hideSeed) {
        return new RandStr(length, seedExpression, hideSeed);
    }

    public Expression copy$default$1() {
        return this.length();
    }

    public Expression copy$default$2() {
        return this.seedExpression();
    }

    public boolean copy$default$3() {
        return this.hideSeed();
    }

    @Override
    public String productPrefix() {
        return "RandStr";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.length();
            }
            case 1: {
                return this.seedExpression();
            }
            case 2: {
                return BoxesRunTime.boxToBoolean((boolean)this.hideSeed());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RandStr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "length";
            }
            case 1: {
                return "seedExpression";
            }
            case 2: {
                return "hideSeed";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RandStr)) return false;
        boolean bl = true;
        if (!bl) return false;
        RandStr randStr = (RandStr)x$1;
        if (this.hideSeed() != randStr.hideSeed()) return false;
        Expression expression = this.length();
        Expression expression2 = randStr.length();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.seedExpression();
        Expression expression4 = randStr.seedExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!randStr.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$checkInputDataTypes$2(ObjectRef result$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Expression expr = (Expression)tuple2._1();
            String name = (String)tuple2._2();
            if (expr != null) {
                Expression expression = expr;
                if (name != null) {
                    String string = name;
                    TypeCheckResult typeCheckResult = (TypeCheckResult)result$2.elem;
                    TypeCheckResult$TypeCheckSuccess$ typeCheckResult$TypeCheckSuccess$ = TypeCheckResult$TypeCheckSuccess$.MODULE$;
                    if (!(typeCheckResult != null ? !typeCheckResult.equals(typeCheckResult$TypeCheckSuccess$) : typeCheckResult$TypeCheckSuccess$ != null) && !expression.foldable()) {
                        result$2.elem = new TypeCheckResult.DataTypeMismatch("NON_FOLDABLE_INPUT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputName"), (Object)ExpectsInputTypes$.MODULE$.toSQLId(string)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)"integer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputExpr"), (Object)ExpectsInputTypes$.MODULE$.toSQLExpr(expression))}))));
                        return;
                    }
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public RandStr(Expression length, Expression seedExpression, boolean hideSeed) {
        this.length = length;
        this.seedExpression = seedExpression;
        this.hideSeed = hideSeed;
        ExpressionWithRandomSeed.$init$(this);
        BinaryLike.$init$(this);
        DefaultStringProducingExpression.$init$(this);
        Nondeterministic.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public RandStr(Expression length) {
        this(length, UnresolvedSeed$.MODULE$, true);
    }

    public RandStr(Expression length, Expression seedExpression) {
        this(length, seedExpression, false);
    }
}

