/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.ServiceUtils;
import org.apache.hive.service.auth.PasswdAuthenticationProvider;

public class LdapAuthenticationProviderImpl
implements PasswdAuthenticationProvider {
    private final String ldapURL;
    private final String baseDN;
    private final String ldapDomain;
    private final String userDNPattern;

    LdapAuthenticationProviderImpl() {
        HiveConf conf = new HiveConf();
        this.ldapURL = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_URL);
        this.baseDN = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_BASEDN);
        this.ldapDomain = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_DOMAIN);
        this.userDNPattern = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERDNPATTERN);
    }

    @Override
    public void Authenticate(String user, String password) throws AuthenticationException {
        if (!this.hasDomain((String)user) && this.ldapDomain != null) {
            user = (String)user + "@" + this.ldapDomain;
        }
        if (password == null || password.isEmpty() || password.getBytes()[0] == 0) {
            throw new AuthenticationException("Error validating LDAP user: a null or blank password has been provided");
        }
        List<Object> candidatePrincipals = new ArrayList<CallSite>();
        if (StringUtils.isBlank((CharSequence)this.userDNPattern)) {
            if (StringUtils.isNotBlank((CharSequence)this.baseDN)) {
                String pattern = "uid=" + (String)user + "," + this.baseDN;
                candidatePrincipals.add(pattern);
            }
        } else {
            String[] patterns;
            for (String pattern : patterns = this.userDNPattern.split(":")) {
                if (!StringUtils.contains((CharSequence)pattern, (CharSequence)",") || !StringUtils.contains((CharSequence)pattern, (CharSequence)"=")) continue;
                candidatePrincipals.add(pattern.replaceAll("%s", (String)user));
            }
        }
        if (candidatePrincipals.isEmpty()) {
            candidatePrincipals = Collections.singletonList(user);
        }
        Iterator iterator = candidatePrincipals.iterator();
        while (iterator.hasNext()) {
            String principal = (String)iterator.next();
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", this.ldapURL);
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", principal);
            env.put("java.naming.security.credentials", password);
            try {
                InitialDirContext ctx = new InitialDirContext(env);
                ctx.close();
                break;
            }
            catch (NamingException e) {
                if (iterator.hasNext()) continue;
                throw new AuthenticationException("Error validating LDAP user", e);
            }
        }
    }

    private boolean hasDomain(String userName) {
        return ServiceUtils.indexOfDomainMatch(userName) > 0;
    }
}

