/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.MinMaxScaler;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class FMRegressorExample$ {
    public static final FMRegressorExample$ MODULE$ = new FMRegressorExample$();

    public void main(String[] args) {
        Object object;
        SparkSession spark = SparkSession$.MODULE$.builder().appName("FMRegressorExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        MinMaxScalerModel featureScaler = new MinMaxScaler().setInputCol("features").setOutputCol("scaledFeatures").fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.7, 0.3});
        if (datasetArray == null || Array.UnapplySeqWrapper$.MODULE$.isEmpty$extension(object = Array$.MODULE$.unapplySeq((Object)datasetArray)) || new Array.UnapplySeqWrapper(Array.UnapplySeqWrapper$.MODULE$.get$extension(object)) == null || Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset trainingData = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 0);
        Dataset testData = (Dataset)Array.UnapplySeqWrapper$.MODULE$.apply$extension(Array.UnapplySeqWrapper$.MODULE$.get$extension(object), 1);
        Tuple2 tuple2 = new Tuple2((Object)trainingData, (Object)testData);
        Dataset trainingData2 = (Dataset)tuple2._1();
        Dataset testData2 = (Dataset)tuple2._2();
        FMRegressor fm = ((FMRegressor)new FMRegressor().setLabelCol("label").setFeaturesCol("scaledFeatures")).setStepSize(0.001);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{featureScaler, fm}));
        PipelineModel model = pipeline.fit(trainingData2);
        Dataset predictions = model.transform(testData2);
        predictions.select("prediction", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"})).show(5);
        RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
        double rmse = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)("Root Mean Squared Error (RMSE) on test data = " + rmse));
        FMRegressionModel fmModel = (FMRegressionModel)model.stages()[1];
        Predef$.MODULE$.println((Object)("Factors: " + fmModel.factors() + " Linear: " + fmModel.linear() + " Intercept: " + fmModel.intercept()));
        spark.stop();
    }

    private FMRegressorExample$() {
    }
}

