/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.plugin;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.api.plugin.SparkPlugin;
import org.apache.spark.internal.config.package$;
import org.apache.spark.internal.plugin.DriverPluginContainer;
import org.apache.spark.internal.plugin.ExecutorPluginContainer;
import org.apache.spark.internal.plugin.PluginContainer;
import org.apache.spark.resource.ResourceInformation;
import org.apache.spark.util.Utils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class PluginContainer$ {
    public static final PluginContainer$ MODULE$ = new PluginContainer$();
    private static final String EXTRA_CONF_PREFIX = "spark.plugins.internal.conf.";

    public String EXTRA_CONF_PREFIX() {
        return EXTRA_CONF_PREFIX;
    }

    public Option<PluginContainer> apply(SparkContext sc, Map<String, ResourceInformation> resources) {
        return this.apply((Either<SparkContext, SparkEnv>)new Left((Object)sc), resources);
    }

    public Option<PluginContainer> apply(SparkEnv env, Map<String, ResourceInformation> resources) {
        return this.apply((Either<SparkContext, SparkEnv>)new Right((Object)env), resources);
    }

    private Option<PluginContainer> apply(Either<SparkContext, SparkEnv> ctx, Map<String, ResourceInformation> resources) {
        SparkConf conf = (SparkConf)ctx.fold((Function1 & Serializable)x$1 -> x$1.conf(), (Function1 & Serializable)x$2 -> x$2.conf());
        Seq<SparkPlugin> plugins = Utils$.MODULE$.loadExtensions(SparkPlugin.class, (Seq<String>)((Seq)((SeqOps)conf.get(package$.MODULE$.PLUGINS())).distinct()), conf);
        if (plugins.nonEmpty()) {
            Either<SparkContext, SparkEnv> either = ctx;
            if (either instanceof Left) {
                Left left = (Left)either;
                SparkContext sc = (SparkContext)left.value();
                return new Some((Object)new DriverPluginContainer(sc, resources, plugins));
            }
            if (either instanceof Right) {
                Right right = (Right)either;
                SparkEnv env = (SparkEnv)right.value();
                return new Some((Object)new ExecutorPluginContainer(env, resources, plugins));
            }
            throw new MatchError(either);
        }
        return None$.MODULE$;
    }

    private PluginContainer$() {
    }
}

