/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.RFormula;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaRFormulaExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaRFormulaExample").getOrCreate();
        StructType schema = DataTypes.createStructType((StructField[])new StructField[]{DataTypes.createStructField((String)"id", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"country", (DataType)DataTypes.StringType, (boolean)false), DataTypes.createStructField((String)"hour", (DataType)DataTypes.IntegerType, (boolean)false), DataTypes.createStructField((String)"clicked", (DataType)DataTypes.DoubleType, (boolean)false)});
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{7, "US", 18, 1.0}), RowFactory.create((Object[])new Object[]{8, "CA", 12, 0.0}), RowFactory.create((Object[])new Object[]{9, "NZ", 15, 0.0}));
        Dataset dataset = spark.createDataFrame(data, schema);
        RFormula formula = new RFormula().setFormula("clicked ~ country + hour").setFeaturesCol("features").setLabelCol("label");
        Dataset output = formula.fit(dataset).transform(dataset);
        output.select("features", new String[]{"label"}).show();
        spark.stop();
    }
}

