/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.api.java;

import java.io.Serializable;
import java.util.Objects;

public final class Optional<T>
implements Serializable {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    private Optional() {
        this.value = null;
    }

    private Optional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public T get() {
        return Objects.requireNonNull(this.value);
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public static <T> Optional<T> absent() {
        return Optional.empty();
    }

    public static <T> Optional<T> fromNullable(T value) {
        return Optional.ofNullable(value);
    }

    public T or(T other) {
        return this.value != null ? this.value : other;
    }

    public T orNull() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public String toString() {
        return this.value == null ? "Optional.empty" : String.format("Optional[%s]", this.value);
    }
}

