/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.util.SparkShutdownHookManager;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.StringContext;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashSet;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class ShutdownHookManager$
implements Logging {
    public static final ShutdownHookManager$ MODULE$ = new ShutdownHookManager$();
    private static SparkShutdownHookManager shutdownHooks;
    private static final int DEFAULT_SHUTDOWN_PRIORITY;
    private static final int SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    private static final int TEMP_DIR_SHUTDOWN_PRIORITY;
    private static final HashSet<String> shutdownDeletePaths;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        DEFAULT_SHUTDOWN_PRIORITY = 100;
        SPARK_CONTEXT_SHUTDOWN_PRIORITY = 50;
        TEMP_DIR_SHUTDOWN_PRIORITY = 25;
        shutdownDeletePaths = new HashSet();
        MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> "Adding shutdown hook");
        MODULE$.addShutdownHook(MODULE$.TEMP_DIR_SHUTDOWN_PRIORITY(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable)() -> "Shutdown hook called");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])MODULE$.shutdownDeletePaths().toArray(ClassTag$.MODULE$.apply(String.class))), (Function1 & Serializable)dirPath -> {
                ShutdownHookManager$.$anonfun$new$4(dirPath);
                return BoxedUnit.UNIT;
            });
        });
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int DEFAULT_SHUTDOWN_PRIORITY() {
        return DEFAULT_SHUTDOWN_PRIORITY;
    }

    public int SPARK_CONTEXT_SHUTDOWN_PRIORITY() {
        return SPARK_CONTEXT_SHUTDOWN_PRIORITY;
    }

    public int TEMP_DIR_SHUTDOWN_PRIORITY() {
        return TEMP_DIR_SHUTDOWN_PRIORITY;
    }

    /*
     * WARNING - void declaration
     */
    private SparkShutdownHookManager shutdownHooks$lzycompute() {
        ShutdownHookManager$ shutdownHookManager$ = this;
        synchronized (shutdownHookManager$) {
            if (!bitmap$0) {
                void var2_2;
                SparkShutdownHookManager manager = new SparkShutdownHookManager();
                manager.install();
                shutdownHooks = var2_2;
                bitmap$0 = true;
            }
        }
        return shutdownHooks;
    }

    private SparkShutdownHookManager shutdownHooks() {
        if (!bitmap$0) {
            return this.shutdownHooks$lzycompute();
        }
        return shutdownHooks;
    }

    private HashSet<String> shutdownDeletePaths() {
        return shutdownDeletePaths;
    }

    public void registerShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            HashSet cfr_ignored_0 = (HashSet)this.shutdownDeletePaths().$plus$eq((Object)absolutePath);
        }
    }

    public void removeShutdownDeleteDir(File file) {
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            this.shutdownDeletePaths().remove((Object)absolutePath);
        }
    }

    public boolean hasShutdownDeleteDir(File file) {
        boolean bl;
        String absolutePath = file.getAbsolutePath();
        HashSet<String> hashSet = this.shutdownDeletePaths();
        synchronized (hashSet) {
            bl = this.shutdownDeletePaths().contains((Object)absolutePath);
        }
        return bl;
    }

    public boolean hasRootAsShutdownDeleteDir(File file) {
        boolean retval;
        block3: {
            boolean bl;
            String absolutePath = file.getAbsolutePath();
            HashSet<String> hashSet = this.shutdownDeletePaths();
            synchronized (hashSet) {
                bl = this.shutdownDeletePaths().exists((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)ShutdownHookManager$.$anonfun$hasRootAsShutdownDeleteDir$1(absolutePath, path)));
            }
            retval = bl;
            if (!retval) break block3;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"path = ", ", already present as root for deletion."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.FILE_NAME, file)}))));
        }
        return retval;
    }

    public boolean inShutdown() {
        try {
            Thread hook = new Thread(){

                public void run() {
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
            Runtime.getRuntime().removeShutdownHook(hook);
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    public Object addShutdownHook(Function0<BoxedUnit> hook) {
        return this.addShutdownHook(this.DEFAULT_SHUTDOWN_PRIORITY(), hook);
    }

    public Object addShutdownHook(int priority, Function0<BoxedUnit> hook) {
        return this.shutdownHooks().add(priority, hook);
    }

    public boolean removeShutdownHook(Object ref) {
        return this.shutdownHooks().remove(ref);
    }

    public static final /* synthetic */ void $anonfun$new$4(String dirPath) {
        try {
            MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting directory ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, dirPath)}))));
            Utils$.MODULE$.deleteRecursively(new File(dirPath));
        }
        catch (Exception e) {
            MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while deleting Spark temp dir: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{MODULE$.MDC((LogKey)LogKeys.PATH, dirPath)}))), (Throwable)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$hasRootAsShutdownDeleteDir$1(String absolutePath$1, String path) {
        return !absolutePath$1.equals(path) && absolutePath$1.startsWith(path);
    }

    private ShutdownHookManager$() {
    }
}

