/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Util;

class HashTables<S extends Summary> {
    long[] hashTable = null;
    S[] summaryTable = null;
    int lgTableSize = 0;
    int numKeys = 0;

    HashTables() {
    }

    void fromSketch(Sketch<S> sketch) {
        this.numKeys = sketch.getRetainedEntries();
        this.lgTableSize = HashTables.getLgTableSize(this.numKeys);
        this.hashTable = new long[1 << this.lgTableSize];
        TupleSketchIterator<S> it = sketch.iterator();
        while (it.next()) {
            long hash = it.getHash();
            int index = HashOperations.hashInsertOnly(this.hashTable, this.lgTableSize, hash);
            Summary mySummary = it.getSummary().copy();
            if (this.summaryTable == null) {
                this.summaryTable = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize);
            }
            this.summaryTable[index] = mySummary;
        }
    }

    void fromSketch(org.apache.datasketches.theta.Sketch sketch, S summary) {
        this.numKeys = sketch.getRetainedEntries(true);
        this.lgTableSize = HashTables.getLgTableSize(this.numKeys);
        this.hashTable = new long[1 << this.lgTableSize];
        HashIterator it = sketch.iterator();
        while (it.next()) {
            long hash = it.get();
            int index = HashOperations.hashInsertOnly(this.hashTable, this.lgTableSize, hash);
            Summary mySummary = summary.copy();
            if (this.summaryTable == null) {
                this.summaryTable = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize);
            }
            this.summaryTable[index] = mySummary;
        }
    }

    private void fromArrays(long[] hashArr, S[] summaryArr, int count) {
        this.numKeys = count;
        this.lgTableSize = HashTables.getLgTableSize(count);
        this.summaryTable = null;
        this.hashTable = new long[1 << this.lgTableSize];
        for (int i = 0; i < count; ++i) {
            long hash = hashArr[i];
            int index = HashOperations.hashInsertOnly(this.hashTable, this.lgTableSize, hash);
            S mySummary = summaryArr[i];
            if (this.summaryTable == null) {
                this.summaryTable = (Summary[])Array.newInstance(mySummary.getClass(), 1 << this.lgTableSize);
            }
            this.summaryTable[index] = summaryArr[i];
        }
    }

    HashTables<S> getIntersectHashTables(Sketch<S> nextTupleSketch, long thetaLong, SummarySetOperations<S> summarySetOps) {
        int maxMatchSize = Math.min(this.numKeys, nextTupleSketch.getRetainedEntries());
        long[] matchHashArr = new long[maxMatchSize];
        Summary[] matchSummariesArr = Util.newSummaryArray(this.summaryTable, (int)maxMatchSize);
        int matchCount = 0;
        TupleSketchIterator<S> it = nextTupleSketch.iterator();
        while (it.next()) {
            int index;
            long hash = it.getHash();
            if (hash >= thetaLong || (index = HashOperations.hashSearch(this.hashTable, this.lgTableSize, hash)) < 0) continue;
            matchHashArr[matchCount] = hash;
            matchSummariesArr[matchCount] = summarySetOps.intersection(this.summaryTable[index], it.getSummary());
            ++matchCount;
        }
        HashTables<S> resultHT = new HashTables<S>();
        super.fromArrays(matchHashArr, matchSummariesArr, matchCount);
        return resultHT;
    }

    HashTables<S> getIntersectHashTables(org.apache.datasketches.theta.Sketch nextThetaSketch, long thetaLong, SummarySetOperations<S> summarySetOps, S summary) {
        Class<?> summaryType = summary.getClass();
        int maxMatchSize = Math.min(this.numKeys, nextThetaSketch.getRetainedEntries());
        long[] matchHashArr = new long[maxMatchSize];
        Summary[] matchSummariesArr = (Summary[])Array.newInstance(summaryType, maxMatchSize);
        int matchCount = 0;
        HashIterator it = nextThetaSketch.iterator();
        while (it.next()) {
            int index;
            long hash = it.get();
            if (hash >= thetaLong || (index = HashOperations.hashSearch(this.hashTable, this.lgTableSize, hash)) < 0) continue;
            matchHashArr[matchCount] = hash;
            matchSummariesArr[matchCount] = summarySetOps.intersection(this.summaryTable[index], summary);
            ++matchCount;
        }
        HashTables<S> resultHT = new HashTables<S>();
        super.fromArrays(matchHashArr, matchSummariesArr, matchCount);
        return resultHT;
    }

    void clear() {
        this.hashTable = null;
        this.summaryTable = null;
        this.lgTableSize = 0;
        this.numKeys = 0;
    }

    static int getLgTableSize(int count) {
        int tableSize = Math.max(org.apache.datasketches.common.Util.ceilingPowerOf2((int)Math.ceil((double)count / 0.75)), 16);
        return Integer.numberOfTrailingZeros(tableSize);
    }
}

