/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis.resolver;

import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Offset;
import org.apache.spark.sql.catalyst.plans.logical.Tail;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.errors.QueryErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005a4AAC\u0006\u00015!)q\u0005\u0001C\u0001Q!)1\u0006\u0001C\u0001Y!)q\b\u0001C\u0005\u0001\")1\n\u0001C\u0005\u0019\")\u0001\u000b\u0001C\u0005#\")!\f\u0001C\u00057\")!\u000e\u0001C\u0005W\")a\u000e\u0001C\u0005_\")!\u000f\u0001C\u0005g\naB*[7ji2K7.Z#yaJ,7o]5p]Z\u000bG.\u001b3bi>\u0014(B\u0001\u0007\u000e\u0003!\u0011Xm]8mm\u0016\u0014(B\u0001\b\u0010\u0003!\tg.\u00197zg&\u001c(B\u0001\t\u0012\u0003!\u0019\u0017\r^1msN$(B\u0001\n\u0014\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003)U\tQa\u001d9be.T!AF\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0012aA8sO\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0013\u000e\u0003\rR!\u0001J\t\u0002\r\u0015\u0014(o\u001c:t\u0013\t13EA\bRk\u0016\u0014\u00180\u0012:s_J\u001c()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0006\u0005\u0002+\u00015\t1\"A\u000bwC2LG-\u0019;f\u0019&l\u0017\u000e\u001e'jW\u0016,\u0005\u0010\u001d:\u0015\u00075\u001aT\u0007\u0005\u0002/c5\tqF\u0003\u00021\u001f\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\u0011tF\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u000e\u0002A\u00025\n1\u0003\\5nSRd\u0015n[3FqB\u0014Xm]:j_:DQA\u000e\u0002A\u0002]\n!\u0004]1si&\fG\u000e\\=SKN|GN^3e\u0019&l\u0017\u000e\u001e'jW\u0016\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000f1|w-[2bY*\u0011AhD\u0001\u0006a2\fgn]\u0005\u0003}e\u00121\u0002T8hS\u000e\fG\u000e\u00157b]\u0006I2\r[3dWZ\u000bG.\u001b3MS6LGoV5uQ>3gm]3u)\r\tE)\u0013\t\u00039\tK!aQ\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u000b\u000e\u0001\rAR\u0001\u0014KZ\fG.^1uK\u0012,\u0005\u0010\u001d:fgNLwN\u001c\t\u00039\u001dK!\u0001S\u000f\u0003\u0007%sG\u000fC\u0003K\u0007\u0001\u0007q'\u0001\u0003qY\u0006t\u0017aG3wC2,\u0018\r^3MS6LG\u000fT5lK\u0016C\bO]3tg&|g\u000eF\u0002G\u001b>CQA\u0014\u0003A\u00025\n!\"\u001a=qe\u0016\u001c8/[8o\u0011\u0015QE\u00011\u00018\u0003-\"\bN]8x\u0013:4\u0018\r\\5e\u0019&l\u0017\u000e^,ji\"|eMZ:fiN+X.\u0012=dK\u0016$7/T1y\u0013:$H\u0003\u0002*V/f\u0003\"\u0001H*\n\u0005Qk\"a\u0002(pi\"Lgn\u001a\u0005\u0006-\u0016\u0001\rAR\u0001\u0006Y&l\u0017\u000e\u001e\u0005\u00061\u0016\u0001\rAR\u0001\u0007_\u001a47/\u001a;\t\u000b)+\u0001\u0019A\u001c\u0002WQD'o\\<J]Z\fG.\u001b3MS6LG\u000fT5lK\u0016C\bO]3tg&|g.S:V]\u001a|G\u000eZ1cY\u0016$2A\u0015/j\u0011\u0015if\u00011\u0001_\u0003\u0011q\u0017-\\3\u0011\u0005}3gB\u00011e!\t\tW$D\u0001c\u0015\t\u0019\u0017$\u0001\u0004=e>|GOP\u0005\u0003Kv\ta\u0001\u0015:fI\u00164\u0017BA4i\u0005\u0019\u0019FO]5oO*\u0011Q-\b\u0005\u0006\u001d\u001a\u0001\r!L\u0001(i\"\u0014xn^%om\u0006d\u0017\u000e\u001a'j[&$H*[6f\u000bb\u0004(/Z:tS>tG)\u0019;b)f\u0004X\rF\u0002SY6DQ!X\u0004A\u0002yCQAT\u0004A\u00025\nQ\u0005\u001e5s_^LeN^1mS\u0012d\u0015.\\5u\u0019&\\W-\u0012=qe\u0016\u001c8/[8o\u0013NtU\u000f\u001c7\u0015\u0007I\u0003\u0018\u000fC\u0003^\u0011\u0001\u0007a\fC\u0003O\u0011\u0001\u0007Q&A\u0015uQJ|w/\u00138wC2LG\rT5nSRd\u0015n[3FqB\u0014Xm]:j_:L5OT3hCRLg/\u001a\u000b\u0005%R,h\u000fC\u0003^\u0013\u0001\u0007a\fC\u0003O\u0013\u0001\u0007Q\u0006C\u0003x\u0013\u0001\u0007a)A\u0003wC2,X\r")
public class LimitLikeExpressionValidator
implements QueryErrorsBase {
    @Override
    public String toSQLConfVal(String conf) {
        return QueryErrorsBase.toSQLConfVal$(this, conf);
    }

    @Override
    public String toSQLExpr(Expression e) {
        return QueryErrorsBase.toSQLExpr$(this, e);
    }

    @Override
    public String toSQLValue(Object v, DataType t) {
        return QueryErrorsBase.toSQLValue$(this, v, t);
    }

    @Override
    public String ordinalNumber(int i) {
        return QueryErrorsBase.ordinalNumber$(this, i);
    }

    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, (String)parts);
    }

    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$((DataTypeErrorsBase)this, (String)conf);
    }

    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (String)text);
    }

    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, (AbstractDataType)t);
    }

    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (String)value);
    }

    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (UTF8String)value);
    }

    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (short)value);
    }

    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (int)value);
    }

    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (long)value);
    }

    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (float)value);
    }

    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, (double)value);
    }

    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$((DataTypeErrorsBase)this, (String)elem);
    }

    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$((DataTypeErrorsBase)this, (QueryContext)sqlContext);
    }

    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$((DataTypeErrorsBase)this, (QueryContext)context);
    }

    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$((DataTypeErrorsBase)this, (String)option);
    }

    public Expression validateLimitLikeExpr(Expression limitLikeExpression, LogicalPlan partiallyResolvedLimitLike) {
        int evaluatedExpression = this.evaluateLimitLikeExpression(limitLikeExpression, partiallyResolvedLimitLike);
        this.checkValidLimitWithOffset(evaluatedExpression, partiallyResolvedLimitLike);
        return limitLikeExpression;
    }

    private void checkValidLimitWithOffset(int evaluatedExpression, LogicalPlan plan2) {
        LocalLimit localLimit;
        LogicalPlan logicalPlan;
        LogicalPlan logicalPlan2 = plan2;
        if (logicalPlan2 instanceof LocalLimit && (logicalPlan = (localLimit = (LocalLimit)logicalPlan2).child()) instanceof Offset) {
            Offset offset = (Offset)logicalPlan;
            Expression offsetExpr = offset.offsetExpr();
            int offset2 = BoxesRunTime.unboxToInt((Object)offsetExpr.eval(offsetExpr.eval$default$1()));
            if (Integer.MAX_VALUE - evaluatedExpression < offset2) {
                throw this.throwInvalidLimitWithOffsetSumExceedsMaxInt(evaluatedExpression, offset2, plan2);
            }
            return;
        }
    }

    private int evaluateLimitLikeExpression(Expression expression, LogicalPlan plan2) {
        int n;
        String string;
        LogicalPlan logicalPlan = plan2;
        if (logicalPlan instanceof Offset) {
            string = "offset";
        } else if (logicalPlan instanceof Tail) {
            string = "tail";
        } else if (logicalPlan instanceof LocalLimit ? true : logicalPlan instanceof GlobalLimit) {
            string = "limit";
        } else {
            throw SparkException$.MODULE$.internalError("Unexpected limit like operator type: " + logicalPlan.getClass().getName());
        }
        String operatorName = string;
        if (!expression.foldable()) {
            throw this.throwInvalidLimitLikeExpressionIsUnfoldable(operatorName, expression);
        }
        DataType dataType = expression.dataType();
        IntegerType$ integerType$ = IntegerType$.MODULE$;
        if (dataType == null ? integerType$ != null : !dataType.equals(integerType$)) {
            throw this.throwInvalidLimitLikeExpressionDataType(operatorName, expression);
        }
        Object object = expression.eval(expression.eval$default$1());
        if (object == null) {
            throw this.throwInvalidLimitLikeExpressionIsNull(operatorName, expression);
        }
        if (object instanceof Integer && (n = BoxesRunTime.unboxToInt((Object)object)) < 0) {
            throw this.throwInvalidLimitLikeExpressionIsNegative(operatorName, expression, n);
        }
        return BoxesRunTime.unboxToInt((Object)object);
    }

    private Nothing$ throwInvalidLimitWithOffsetSumExceedsMaxInt(int limit, int offset, LogicalPlan plan2) {
        throw new AnalysisException("SUM_OF_LIMIT_AND_OFFSET_EXCEEDS_MAX_INT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"limit"), (Object)Integer.toString(limit)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"offset"), (Object)Integer.toString(offset))})), plan2.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsUnfoldable(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_UNFOLDABLE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionDataType(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.DATA_TYPE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)this.toSQLType((AbstractDataType)expression.dataType()))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsNull(String name, Expression expression) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_NULL", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression))})), expression.origin());
    }

    private Nothing$ throwInvalidLimitLikeExpressionIsNegative(String name, Expression expression, int value) {
        throw new AnalysisException("INVALID_LIMIT_LIKE_EXPRESSION.IS_NEGATIVE", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)name), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)this.toSQLExpr(expression)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"v"), (Object)this.toSQLValue(BoxesRunTime.boxToInteger((int)value), (DataType)IntegerType$.MODULE$))})), expression.origin());
    }

    public LimitLikeExpressionValidator() {
        DataTypeErrorsBase.$init$((DataTypeErrorsBase)this);
        QueryErrorsBase.$init$(this);
    }
}

