/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class AppsWithRecoveryDisabled {
    private static final AppsWithRecoveryDisabled INSTANCE = new AppsWithRecoveryDisabled();
    private final Set<String> appsWithRecoveryDisabled = Collections.newSetFromMap(new ConcurrentHashMap());

    private AppsWithRecoveryDisabled() {
    }

    public static void disableRecoveryOfApp(String appId) {
        AppsWithRecoveryDisabled.INSTANCE.appsWithRecoveryDisabled.add(Objects.requireNonNull(appId));
    }

    public static boolean isRecoveryEnabledForApp(String appId) {
        return !AppsWithRecoveryDisabled.INSTANCE.appsWithRecoveryDisabled.contains(Objects.requireNonNull(appId));
    }

    public static void removeApp(String appId) {
        AppsWithRecoveryDisabled.INSTANCE.appsWithRecoveryDisabled.remove(Objects.requireNonNull(appId));
    }
}

