/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.linalg.Matrices$;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasSolver;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor$;
import org.apache.spark.ml.regression.FMRegressorParams;
import org.apache.spark.ml.regression.FactorizationMachines;
import org.apache.spark.ml.regression.FactorizationMachines$;
import org.apache.spark.ml.regression.FactorizationMachinesParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001\u0002\r\u001a\u0001\u0011B\u0001\"\u0012\u0001\u0003\u0006\u0004%\tE\u0012\u0005\t;\u0002\u0011\t\u0011)A\u0005\u000f\")q\f\u0001C\u0001A\")q\f\u0001C\u0001I\")a\r\u0001C\u0001O\")\u0001\u000f\u0001C\u0001c\")q\u000f\u0001C\u0001q\")1\u0010\u0001C\u0001y\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\ti\u0002\u0001C\u0001\u0003?Aq!!\n\u0001\t\u0003\t9\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005U\u0002\u0001\"\u0001\u00028!9\u00111\t\u0001\u0005R\u0005\u0015\u0003bBA8\u0001\u0011\u0005\u0013\u0011\u000f\u0005\t\u0003\u000b\u0003A\u0011I\u000f\u0002\b\u001e9\u0011qS\r\t\u0002\u0005eeA\u0002\r\u001a\u0011\u0003\tY\n\u0003\u0004`)\u0011\u0005\u0011\u0011\u0018\u0005\b\u0003w#B\u0011IA_\u0011%\t)\rFA\u0001\n\u0013\t9MA\u0006G\u001bJ+wM]3tg>\u0014(B\u0001\u000e\u001c\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u00039u\t!!\u001c7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001KM2\u0014h\u0010\t\u0006M\u001dJs\u0006M\u0007\u00023%\u0011\u0001&\u0007\u0002\n%\u0016<'/Z:t_J\u0004\"AK\u0017\u000e\u0003-R!\u0001L\u000e\u0002\r1Lg.\u00197h\u0013\tq3F\u0001\u0004WK\u000e$xN\u001d\t\u0003M\u0001\u0001\"AJ\u0019\n\u0005IJ\"!\u0005$N%\u0016<'/Z:tS>tWj\u001c3fYB\u0011a\u0005N\u0005\u0003ke\u0011QCR1di>\u0014\u0018N_1uS>tW*Y2iS:,7\u000f\u0005\u0002'o%\u0011\u0001(\u0007\u0002\u0012\r6\u0013Vm\u001a:fgN|'\u000fU1sC6\u001c\bC\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u001c\u0003\u0011)H/\u001b7\n\u0005yZ$!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7o\u0016:ji\u0006\u0014G.\u001a\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005v\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\t\u0006\u0013q\u0001T8hO&tw-A\u0002vS\u0012,\u0012a\u0012\t\u0003\u0011Fs!!S(\u0011\u0005)kU\"A&\u000b\u00051\u001b\u0013A\u0002\u001fs_>$hHC\u0001O\u0003\u0015\u00198-\u00197b\u0013\t\u0001V*\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)NQ\r\tQk\u0017\t\u0003-fk\u0011a\u0016\u0006\u00031v\t!\"\u00198o_R\fG/[8o\u0013\tQvKA\u0003TS:\u001cW-I\u0001]\u0003\u0015\u0019d\u0006\r\u00181\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\t)6,\u0001\u0004=S:LGO\u0010\u000b\u0003_\u0005DQ!R\u0002A\u0002\u001dC3!Y+\\Q\r\u0019Qk\u0017\u000b\u0002_!\u001aA!V.\u0002\u001bM,GOR1di>\u00148+\u001b>f)\tA\u0017.D\u0001\u0001\u0011\u0015QW\u00011\u0001l\u0003\u00151\u0018\r\\;f!\taW.D\u0001N\u0013\tqWJA\u0002J]RD3!B+\\\u0003=\u0019X\r\u001e$ji&sG/\u001a:dKB$HC\u00015s\u0011\u0015Qg\u00011\u0001t!\taG/\u0003\u0002v\u001b\n9!i\\8mK\u0006t\u0007f\u0001\u0004V7\u0006a1/\u001a;GSRd\u0015N\\3beR\u0011\u0001.\u001f\u0005\u0006U\u001e\u0001\ra\u001d\u0015\u0004\u000fU[\u0016aC:fiJ+w\rU1sC6$\"\u0001[?\t\u000b)D\u0001\u0019\u0001@\u0011\u00051|\u0018bAA\u0001\u001b\n1Ai\\;cY\u0016D3\u0001C+\\\u0003Q\u0019X\r^'j]&\u0014\u0015\r^2i\rJ\f7\r^5p]R\u0019\u0001.!\u0003\t\u000b)L\u0001\u0019\u0001@)\u0007%)6,\u0001\u0006tKRLe.\u001b;Ti\u0012$2\u0001[A\t\u0011\u0015Q'\u00021\u0001\u007fQ\rQQkW\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014Hc\u00015\u0002\u001a!)!n\u0003a\u0001W\"\u001a1\"V.\u0002\u0017M,Go\u0015;faNK'0\u001a\u000b\u0004Q\u0006\u0005\u0002\"\u00026\r\u0001\u0004q\bf\u0001\u0007V7\u000611/\u001a;U_2$2\u0001[A\u0015\u0011\u0015QW\u00021\u0001\u007fQ\riQkW\u0001\ng\u0016$8k\u001c7wKJ$2\u0001[A\u0019\u0011\u0015Qg\u00021\u0001HQ\rqQkW\u0001\bg\u0016$8+Z3e)\rA\u0017\u0011\b\u0005\u0007U>\u0001\r!a\u000f\u0011\u00071\fi$C\u0002\u0002@5\u0013A\u0001T8oO\"\u001aq\"V.\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0007A\n9\u0005C\u0004\u0002JA\u0001\r!a\u0013\u0002\u000f\u0011\fG/Y:fiB\"\u0011QJA/!\u0019\ty%!\u0016\u0002Z5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'j\u0012aA:rY&!\u0011qKA)\u0005\u001d!\u0015\r^1tKR\u0004B!a\u0017\u0002^1\u0001A\u0001DA0\u0003\u000f\n\t\u0011!A\u0003\u0002\u0005\u0005$aA0%cE!\u00111MA5!\ra\u0017QM\u0005\u0004\u0003Oj%a\u0002(pi\"Lgn\u001a\t\u0004Y\u0006-\u0014bAA7\u001b\n\u0019\u0011I\\=\u0002\t\r|\u0007/\u001f\u000b\u0004_\u0005M\u0004bBA;#\u0001\u0007\u0011qO\u0001\u0006Kb$(/\u0019\t\u0005\u0003s\ny(\u0004\u0002\u0002|)\u0019\u0011QP\u000e\u0002\u000bA\f'/Y7\n\t\u0005\u0005\u00151\u0010\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a\u0011#V.\u0002#\u0015\u001cH/[7bi\u0016lu\u000eZ3m'&TX\r\u0006\u0003\u0002<\u0005%\u0005bBA%%\u0001\u0007\u00111\u0012\u0019\u0005\u0003\u001b\u000b\t\n\u0005\u0004\u0002P\u0005U\u0013q\u0012\t\u0005\u00037\n\t\n\u0002\u0007\u0002\u0014\u0006%\u0015\u0011!A\u0001\u0006\u0003\t\tGA\u0002`IIB3\u0001A+\\\u0003-1UJU3he\u0016\u001c8o\u001c:\u0011\u0005\u0019\"2c\u0002\u000b\u0002\u001e\u0006\r\u0016\u0011\u0016\t\u0004Y\u0006}\u0015bAAQ\u001b\n1\u0011I\\=SK\u001a\u0004BAOAS_%\u0019\u0011qU\u001e\u0003+\u0011+g-Y;miB\u000b'/Y7t%\u0016\fG-\u00192mKB!\u00111VA[\u001b\t\tiK\u0003\u0003\u00020\u0006E\u0016AA5p\u0015\t\t\u0019,\u0001\u0003kCZ\f\u0017\u0002BA\\\u0003[\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!!'\u0002\t1|\u0017\r\u001a\u000b\u0004_\u0005}\u0006BBAa-\u0001\u0007q)\u0001\u0003qCRD\u0007f\u0001\fV7\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011\u0011\u001a\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*!\u0011qZAY\u0003\u0011a\u0017M\\4\n\t\u0005M\u0017Q\u001a\u0002\u0007\u001f\nTWm\u0019;)\u0007Q)6\fK\u0002\u0014+n\u0003")
public class FMRegressor
extends Regressor<org.apache.spark.ml.linalg.Vector, FMRegressor, FMRegressionModel>
implements FactorizationMachines,
FMRegressorParams,
DefaultParamsWritable {
    private final String uid;
    private IntParam factorSize;
    private BooleanParam fitLinear;
    private DoubleParam miniBatchFraction;
    private DoubleParam initStd;
    private Param<String> solver;
    private Param<String> weightCol;
    private DoubleParam regParam;
    private BooleanParam fitIntercept;
    private LongParam seed;
    private DoubleParam tol;
    private DoubleParam stepSize;
    private IntParam maxIter;

    public static FMRegressor load(String path) {
        return FMRegressor$.MODULE$.load(path);
    }

    public static MLReader<FMRegressor> read() {
        return FMRegressor$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector initCoefficients(int numFeatures) {
        return FactorizationMachines.initCoefficients$(this, numFeatures);
    }

    @Override
    public Tuple2<org.apache.spark.ml.linalg.Vector, double[]> trainImpl(RDD<Tuple2<Object, Vector>> data, int numFeatures, String loss) {
        return FactorizationMachines.trainImpl$(this, data, numFeatures, loss);
    }

    @Override
    public final int getFactorSize() {
        return FactorizationMachinesParams.getFactorSize$(this);
    }

    @Override
    public final boolean getFitLinear() {
        return FactorizationMachinesParams.getFitLinear$(this);
    }

    @Override
    public final double getMiniBatchFraction() {
        return FactorizationMachinesParams.getMiniBatchFraction$(this);
    }

    @Override
    public final double getInitStd() {
        return FactorizationMachinesParams.getInitStd$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final String getSolver() {
        return HasSolver.getSolver$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final IntParam factorSize() {
        return this.factorSize;
    }

    @Override
    public final BooleanParam fitLinear() {
        return this.fitLinear;
    }

    @Override
    public final DoubleParam miniBatchFraction() {
        return this.miniBatchFraction;
    }

    @Override
    public final DoubleParam initStd() {
        return this.initStd;
    }

    @Override
    public final Param<String> solver() {
        return this.solver;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$factorSize_$eq(IntParam x$1) {
        this.factorSize = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$fitLinear_$eq(BooleanParam x$1) {
        this.fitLinear = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$miniBatchFraction_$eq(DoubleParam x$1) {
        this.miniBatchFraction = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$initStd_$eq(DoubleParam x$1) {
        this.initStd = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$FactorizationMachinesParams$_setter_$solver_$eq(Param<String> x$1) {
        this.solver = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasSolver$_setter_$solver_$eq(Param<String> x$1) {
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public FMRegressor setFactorSize(int value) {
        return (FMRegressor)this.set(this.factorSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setFitIntercept(boolean value) {
        return (FMRegressor)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setFitLinear(boolean value) {
        return (FMRegressor)this.set(this.fitLinear(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public FMRegressor setRegParam(double value) {
        return (FMRegressor)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMiniBatchFraction(double value) {
        return (FMRegressor)this.set(this.miniBatchFraction(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setInitStd(double value) {
        return (FMRegressor)this.set(this.initStd(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setMaxIter(int value) {
        return (FMRegressor)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public FMRegressor setStepSize(double value) {
        return (FMRegressor)this.set(this.stepSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setTol(double value) {
        return (FMRegressor)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public FMRegressor setSolver(String value) {
        return (FMRegressor)this.set(this.solver(), value);
    }

    public FMRegressor setSeed(long value) {
        return (FMRegressor)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public FMRegressionModel train(Dataset<?> dataset) {
        return (FMRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.factorSize(), this.fitIntercept(), this.fitLinear(), this.regParam(), this.miniBatchFraction(), this.initStd(), this.maxIter(), this.stepSize(), this.tol(), this.solver()}));
            int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
            instr.logNumFeatures(numFeatures);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
            RDD data = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkRegressionLabels(this.$(this.labelCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(2) == 0) {
                    Object l = ((SeqOps)some.get()).apply(0);
                    Object v = ((SeqOps)some.get()).apply(1);
                    if (l instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)l);
                        if (v instanceof org.apache.spark.ml.linalg.Vector) {
                            org.apache.spark.ml.linalg.Vector vector = (org.apache.spark.ml.linalg.Vector)v;
                            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)Vectors$.MODULE$.fromML(vector));
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Tuple2.class)).setName("training instances");
            Object object = handlePersistence ? data.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
            Tuple2<org.apache.spark.ml.linalg.Vector, double[]> tuple2 = this.trainImpl((RDD<Tuple2<Object, Vector>>)data, numFeatures, FactorizationMachines$.MODULE$.SquaredError());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            org.apache.spark.ml.linalg.Vector coefficients = (org.apache.spark.ml.linalg.Vector)tuple2._1();
            org.apache.spark.ml.linalg.Vector coefficients2 = coefficients;
            Tuple3<Object, org.apache.spark.ml.linalg.Vector, Matrix> tuple3 = FactorizationMachines$.MODULE$.splitCoefficients(coefficients2, numFeatures, BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.fitLinear())));
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double intercept = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            org.apache.spark.ml.linalg.Vector linear = (org.apache.spark.ml.linalg.Vector)tuple3._2();
            Matrix factors = (Matrix)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)intercept), (Object)linear, (Object)factors);
            double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            org.apache.spark.ml.linalg.Vector linear2 = (org.apache.spark.ml.linalg.Vector)tuple32._2();
            Matrix factors2 = (Matrix)tuple32._3();
            Object object2 = handlePersistence ? data.unpersist(data.unpersist$default$1()) : BoxedUnit.UNIT;
            return this.copyValues(new FMRegressionModel(this.uid(), intercept2, linear2, factors2), this.copyValues$default$2());
        });
    }

    @Override
    public FMRegressor copy(ParamMap extra) {
        return (FMRegressor)this.defaultCopy(extra);
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        size += org.apache.spark.ml.linalg.Vectors$.MODULE$.getDenseSize((long)numFeatures);
        return size += Matrices$.MODULE$.getDenseSize((long)numFeatures, (long)BoxesRunTime.unboxToInt((Object)this.$(this.factorSize())));
    }

    public FMRegressor(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasTol.$init$(this);
        HasSolver.$init$(this);
        HasSeed.$init$(this);
        HasFitIntercept.$init$(this);
        HasRegParam.$init$(this);
        HasWeightCol.$init$(this);
        FactorizationMachinesParams.$init$(this);
        FactorizationMachines.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public FMRegressor() {
        this(Identifiable$.MODULE$.randomUID("fmr"));
    }
}

