/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.util.Map;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.WalkedTypePath;
import org.apache.spark.sql.catalyst.WalkedTypePath$;
import org.apache.spark.sql.catalyst.analysis.GetColumnByOrdinal;
import org.apache.spark.sql.catalyst.analysis.UnresolvedExtractValue;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.encoders.AgnosticExpressionPathEncoder;
import org.apache.spark.sql.catalyst.encoders.Codec;
import org.apache.spark.sql.catalyst.encoders.EncoderUtils$;
import org.apache.spark.sql.catalyst.encoders.JavaSerializationCodec$;
import org.apache.spark.sql.catalyst.encoders.KryoSerializationCodec$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GetStructField;
import org.apache.spark.sql.catalyst.expressions.GetStructField$;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.UpCast;
import org.apache.spark.sql.catalyst.expressions.objects.AssertNotNull;
import org.apache.spark.sql.catalyst.expressions.objects.CreateExternalRow;
import org.apache.spark.sql.catalyst.expressions.objects.DecodeUsingSerializer;
import org.apache.spark.sql.catalyst.expressions.objects.InitializeJavaBean;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke;
import org.apache.spark.sql.catalyst.expressions.objects.Invoke$;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance;
import org.apache.spark.sql.catalyst.expressions.objects.NewInstance$;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke;
import org.apache.spark.sql.catalyst.expressions.objects.StaticInvoke$;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedCatalystToExternalMap;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedMapObjects;
import org.apache.spark.sql.catalyst.expressions.objects.UnresolvedMapObjects$;
import org.apache.spark.sql.catalyst.expressions.objects.WrapOption;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.CharVarcharCodegenUtils;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.catalyst.util.STUtils;
import org.apache.spark.sql.connector.catalog.functions.ScalarFunction;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.Geography;
import org.apache.spark.sql.types.GeographyType;
import org.apache.spark.sql.types.Geometry;
import org.apache.spark.sql.types.GeometryType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ObjectType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;

public final class DeserializerBuildHelper$ {
    public static final DeserializerBuildHelper$ MODULE$ = new DeserializerBuildHelper$();

    public Expression addToPath(Expression path, String part, DataType dataType, WalkedTypePath walkedTypePath) {
        UnresolvedExtractValue newPath = new UnresolvedExtractValue(path, Literal$.MODULE$.apply(part));
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression addToPathOrdinal(Expression path, int ordinal, DataType dataType, WalkedTypePath walkedTypePath) {
        GetStructField newPath = new GetStructField(path, ordinal, GetStructField$.MODULE$.apply$default$3());
        return this.upCastToExpectedType(newPath, dataType, walkedTypePath);
    }

    public Expression deserializerForWithNullSafetyAndUpcast(Expression expr, DataType dataType, boolean nullable, WalkedTypePath walkedTypePath, Function1<Expression, Expression> funcForCreatingDeserializer) {
        Expression casted = this.upCastToExpectedType(expr, dataType, walkedTypePath);
        return this.expressionWithNullSafety((Expression)funcForCreatingDeserializer.apply((Object)casted), nullable, walkedTypePath);
    }

    public Expression expressionWithNullSafety(Expression expr, boolean nullable, WalkedTypePath walkedTypePath) {
        if (nullable) {
            return expr;
        }
        return new AssertNotNull(expr, (Seq<String>)walkedTypePath.getPaths());
    }

    public Expression createDeserializerForTypesSupportValueOf(Expression path, Class<?> clazz) {
        Class<?> x$1 = clazz;
        ObjectType x$2 = new ObjectType(clazz);
        String x$3 = "valueOf";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "valueOf", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForGeometryType(Expression inputObject, GeometryType gt) {
        Class<STUtils> x$1 = STUtils.class;
        ObjectType x$2 = new ObjectType(Geometry.class);
        String x$3 = "deserializeGeom";
        Expression expression = inputObject;
        Literal literal = Literal$.MODULE$.fromObject(gt);
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(STUtils.class, (DataType)x$2, "deserializeGeom", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForGeographyType(Expression inputObject, GeographyType gt) {
        Class<STUtils> x$1 = STUtils.class;
        ObjectType x$2 = new ObjectType(Geography.class);
        String x$3 = "deserializeGeog";
        Expression expression = inputObject;
        Literal literal = Literal$.MODULE$.fromObject(gt);
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(STUtils.class, (DataType)x$2, "deserializeGeog", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForChar(Expression path, boolean returnNullable, int length) {
        Class<CharVarcharCodegenUtils> x$1 = CharVarcharCodegenUtils.class;
        StringType$ x$2 = StringType$.MODULE$;
        String x$3 = "charTypeWriteSideCheck";
        Expression expression = path;
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = returnNullable;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        StaticInvoke expr = new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$2, "charTypeWriteSideCheck", (Seq<Expression>)x$4, x$6, x$7, x$5, x$8, x$9);
        return this.createDeserializerForString(expr, returnNullable);
    }

    public Expression createDeserializerForVarchar(Expression path, boolean returnNullable, int length) {
        Class<CharVarcharCodegenUtils> x$1 = CharVarcharCodegenUtils.class;
        StringType$ x$2 = StringType$.MODULE$;
        String x$3 = "varcharTypeWriteSideCheck";
        Expression expression = path;
        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)length));
        List x$4 = Nil$.MODULE$.$colon$colon((Object)literal).$colon$colon((Object)expression);
        boolean x$5 = returnNullable;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        StaticInvoke expr = new StaticInvoke(CharVarcharCodegenUtils.class, (DataType)x$2, "varcharTypeWriteSideCheck", (Seq<Expression>)x$4, x$6, x$7, x$5, x$8, x$9);
        return this.createDeserializerForString(expr, returnNullable);
    }

    public Expression createDeserializerForString(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toString";
        ObjectType x$3 = new ObjectType(String.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, "toString", (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForSqlDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Date.class);
        String x$3 = "toJavaDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "toJavaDate", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForLocalDate(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalDate.class);
        String x$3 = "daysToLocalDate";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "daysToLocalDate", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForInstant(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Instant.class);
        String x$3 = "microsToInstant";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "microsToInstant", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForSqlTimestamp(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Timestamp.class);
        String x$3 = "toJavaTimestamp";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "toJavaTimestamp", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForLocalDateTime(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalDateTime.class);
        String x$3 = "microsToLocalDateTime";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "microsToLocalDateTime", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForLocalTime(Expression path) {
        Class<?> x$1 = DateTimeUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(LocalTime.class);
        String x$3 = "nanosToLocalTime";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "nanosToLocalTime", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForJavaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigDecimal";
        ObjectType x$3 = new ObjectType(BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, "toJavaBigDecimal", (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForScalaBigDecimal(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toBigDecimal";
        ObjectType x$3 = new ObjectType(scala.math.BigDecimal.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, "toBigDecimal", (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForJavaBigInteger(Expression path, boolean returnNullable) {
        Expression x$1 = path;
        String x$2 = "toJavaBigInteger";
        ObjectType x$3 = new ObjectType(BigInteger.class);
        boolean x$4 = returnNullable;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, "toJavaBigInteger", (DataType)x$3, x$5, x$6, x$7, x$4, x$8);
    }

    public Expression createDeserializerForScalaBigInt(Expression path) {
        Expression x$1 = path;
        String x$2 = "toScalaBigInt";
        ObjectType x$3 = new ObjectType(BigInt.class);
        boolean x$4 = false;
        Seq<Expression> x$5 = Invoke$.MODULE$.apply$default$4();
        Seq<AbstractDataType> x$6 = Invoke$.MODULE$.apply$default$5();
        boolean x$7 = Invoke$.MODULE$.apply$default$6();
        boolean x$8 = Invoke$.MODULE$.apply$default$8();
        return new Invoke(x$1, "toScalaBigInt", (DataType)x$3, x$5, x$6, x$7, false, x$8);
    }

    public Expression createDeserializerForDuration(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Duration.class);
        String x$3 = "microsToDuration";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "microsToDuration", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression createDeserializerForPeriod(Expression path) {
        Class<?> x$1 = IntervalUtils$.MODULE$.getClass();
        ObjectType x$2 = new ObjectType(Period.class);
        String x$3 = "monthsToPeriod";
        Expression expression = path;
        List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
        boolean x$5 = false;
        Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
        boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
        boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
        Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
        return new StaticInvoke(x$1, (DataType)x$2, "monthsToPeriod", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
    }

    public Expression upCastToExpectedType(Expression expr, DataType expected, WalkedTypePath walkedTypePath) {
        DataType dataType = expected;
        if (dataType instanceof StructType) {
            return expr;
        }
        if (dataType instanceof ArrayType) {
            return expr;
        }
        if (dataType instanceof MapType) {
            return expr;
        }
        if (dataType instanceof DecimalType) {
            return new UpCast(expr, (AbstractDataType)DecimalType$.MODULE$, (Seq<String>)walkedTypePath.getPaths());
        }
        return new UpCast(expr, (AbstractDataType)expected, (Seq<String>)walkedTypePath.getPaths());
    }

    public <T> Expression createDeserializer(AgnosticEncoder<T> enc) {
        WalkedTypePath walkedTypePath = new WalkedTypePath(WalkedTypePath$.MODULE$.apply$default$1()).recordRoot(enc.clsTag().runtimeClass().getName());
        GetColumnByOrdinal input = new GetColumnByOrdinal(0, enc.dataType());
        Expression deserializer = this.createDeserializer(enc, this.upCastToExpectedType(input, enc.dataType(), walkedTypePath), walkedTypePath, true);
        return this.expressionWithNullSafety(deserializer, enc.nullable(), walkedTypePath);
    }

    private Expression createDeserializer(AgnosticEncoder<?> enc, Expression path, WalkedTypePath walkedTypePath, boolean isTopLevel) {
        boolean bl = false;
        AgnosticEncoder<?> agnosticEncoder = null;
        boolean bl2 = false;
        AgnosticEncoders.MapEncoder mapEncoder = null;
        boolean bl3 = false;
        AgnosticEncoders.TransformingEncoder transformingEncoder = null;
        AgnosticEncoder<?> agnosticEncoder2 = enc;
        if (agnosticEncoder2 instanceof AgnosticExpressionPathEncoder) {
            AgnosticExpressionPathEncoder agnosticExpressionPathEncoder = (AgnosticExpressionPathEncoder)agnosticEncoder2;
            return agnosticExpressionPathEncoder.fromCatalyst(path);
        }
        if (EncoderUtils$.MODULE$.isNativeEncoder(enc)) {
            return path;
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.BoxedLeafEncoder) {
            return this.createDeserializerForTypesSupportValueOf(path, enc.clsTag().runtimeClass());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.JavaEnumEncoder) {
            AgnosticEncoders.JavaEnumEncoder javaEnumEncoder = (AgnosticEncoders.JavaEnumEncoder)agnosticEncoder2;
            ClassTag tag = javaEnumEncoder.clsTag();
            Expression toString = this.createDeserializerForString(path, false);
            return this.createDeserializerForTypesSupportValueOf(toString, tag.runtimeClass());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.ScalaEnumEncoder) {
            AgnosticEncoders.ScalaEnumEncoder scalaEnumEncoder = (AgnosticEncoders.ScalaEnumEncoder)agnosticEncoder2;
            Class parent = scalaEnumEncoder.parent();
            ClassTag tag = scalaEnumEncoder.clsTag();
            Class x$12 = parent;
            ObjectType x$22 = new ObjectType(tag.runtimeClass());
            String x$32 = "withName";
            Expression expression = this.createDeserializerForString(path, false);
            List x$4 = Nil$.MODULE$.$colon$colon((Object)expression);
            boolean x$5 = false;
            Seq<AbstractDataType> x$6 = StaticInvoke$.MODULE$.apply$default$5();
            boolean x$7 = StaticInvoke$.MODULE$.apply$default$6();
            boolean x$8 = StaticInvoke$.MODULE$.apply$default$8();
            Option<ScalarFunction<?>> x$9 = StaticInvoke$.MODULE$.apply$default$9();
            return new StaticInvoke(x$12, (DataType)x$22, "withName", (Seq<Expression>)x$4, x$6, x$7, false, x$8, x$9);
        }
        if ((agnosticEncoder2 instanceof AgnosticEncoders.GeographyEncoder ? true : agnosticEncoder2 instanceof AgnosticEncoders.GeometryEncoder) && !SQLConf$.MODULE$.get().geospatialEnabled()) {
            throw new AnalysisException("UNSUPPORTED_FEATURE.GEOSPATIAL_DISABLED", Map$.MODULE$.empty());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.GeographyEncoder) {
            AgnosticEncoders.GeographyEncoder geographyEncoder = (AgnosticEncoders.GeographyEncoder)agnosticEncoder2;
            return this.createDeserializerForGeographyType(path, geographyEncoder.dt());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.GeometryEncoder) {
            AgnosticEncoders.GeometryEncoder geometryEncoder = (AgnosticEncoders.GeometryEncoder)agnosticEncoder2;
            return this.createDeserializerForGeometryType(path, geometryEncoder.dt());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.CharEncoder) {
            AgnosticEncoders.CharEncoder charEncoder = (AgnosticEncoders.CharEncoder)agnosticEncoder2;
            int length = charEncoder.length();
            return this.createDeserializerForChar(path, false, length);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.VarcharEncoder) {
            AgnosticEncoders.VarcharEncoder varcharEncoder = (AgnosticEncoders.VarcharEncoder)agnosticEncoder2;
            int length = varcharEncoder.length();
            return this.createDeserializerForVarchar(path, false, length);
        }
        if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForString(path, false);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.ScalaDecimalEncoder) {
            return this.createDeserializerForScalaBigDecimal(path, false);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.JavaDecimalEncoder) {
            return this.createDeserializerForJavaBigDecimal(path, false);
        }
        if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForScalaBigInt(path);
        }
        if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForJavaBigInteger(path, false);
        }
        if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForDuration(path);
        }
        if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForPeriod(path);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.DateEncoder) {
            return this.createDeserializerForSqlDate(path);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.LocalDateEncoder) {
            return this.createDeserializerForLocalDate(path);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.TimestampEncoder) {
            return this.createDeserializerForSqlTimestamp(path);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.InstantEncoder) {
            return this.createDeserializerForInstant(path);
        }
        if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder2)) {
            return this.createDeserializerForLocalDateTime(path);
        }
        if (AgnosticEncoders.LocalTimeEncoder$.MODULE$.equals(agnosticEncoder2)) {
            bl = true;
            agnosticEncoder = agnosticEncoder2;
            if (!SQLConf$.MODULE$.get().isTimeTypeEnabled()) {
                throw QueryCompilationErrors$.MODULE$.unsupportedTimeTypeError();
            }
        }
        if (bl) {
            return this.createDeserializerForLocalTime(path);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.UDTEncoder) {
            AgnosticEncoders.UDTEncoder uDTEncoder = (AgnosticEncoders.UDTEncoder)agnosticEncoder2;
            UserDefinedType udt = uDTEncoder.udt();
            Class udtClass = uDTEncoder.udtClass();
            NewInstance obj = NewInstance$.MODULE$.apply(udtClass, (Seq<Expression>)Nil$.MODULE$, (DataType)new ObjectType(udtClass), NewInstance$.MODULE$.apply$default$4());
            Expression expression = path;
            return new Invoke(obj, "deserialize", (DataType)new ObjectType(udt.userClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.OptionEncoder) {
            AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder2;
            AgnosticEncoder valueEnc = optionEncoder.elementEncoder();
            WalkedTypePath newTypePath = walkedTypePath.recordOption(valueEnc.clsTag().runtimeClass().getName());
            Expression deserializer = this.createDeserializer(valueEnc, path, newTypePath, this.createDeserializer$default$4());
            return new WrapOption(deserializer, EncoderUtils$.MODULE$.externalDataTypeFor(valueEnc));
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.ArrayEncoder) {
            AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder2;
            AgnosticEncoder elementEnc = arrayEncoder.element();
            boolean containsNull = arrayEncoder.containsNull();
            if (elementEnc != null) {
                AgnosticEncoder agnosticEncoder3 = elementEnc;
                Expression x$10 = this.deserializeArray(path, (AgnosticEncoder<?>)agnosticEncoder3, containsNull, (Option<Class<?>>)None$.MODULE$, walkedTypePath);
                String x$11 = this.toArrayMethodName(agnosticEncoder3);
                ObjectType x$12 = new ObjectType(enc.clsTag().runtimeClass());
                boolean x$13 = false;
                Seq<Expression> x$14 = Invoke$.MODULE$.apply$default$4();
                Seq<AbstractDataType> x$15 = Invoke$.MODULE$.apply$default$5();
                boolean x$16 = Invoke$.MODULE$.apply$default$6();
                boolean x$17 = Invoke$.MODULE$.apply$default$8();
                return new Invoke(x$10, x$11, (DataType)x$12, x$14, x$15, x$16, false, x$17);
            }
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.IterableEncoder) {
            AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder2;
            ClassTag clsTag = iterableEncoder.clsTag();
            AgnosticEncoder elementEnc = iterableEncoder.element();
            boolean containsNull = iterableEncoder.containsNull();
            return this.deserializeArray(path, elementEnc, containsNull, Option$.MODULE$.apply((Object)clsTag.runtimeClass()), walkedTypePath);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.MapEncoder) {
            bl2 = true;
            mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder2;
            ClassTag tag = mapEncoder.clsTag();
            AgnosticEncoder keyEncoder = mapEncoder.keyEncoder();
            AgnosticEncoder valueEncoder = mapEncoder.valueEncoder();
            if (Map.class.isAssignableFrom(tag.runtimeClass())) {
                WalkedTypePath newTypePath = walkedTypePath.recordMap(keyEncoder.clsTag().runtimeClass().getName(), valueEncoder.clsTag().runtimeClass().getName());
                Invoke keyData = new Invoke(new UnresolvedMapObjects((Function1<Expression, Expression>)(Function1 & Serializable)p -> MODULE$.createDeserializer((AgnosticEncoder<?>)keyEncoder, (Expression)p, newTypePath, MODULE$.createDeserializer$default$4()), new MapKeys(path), UnresolvedMapObjects$.MODULE$.apply$default$3()), "array", (DataType)new ObjectType(Object[].class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
                Invoke valueData = new Invoke(new UnresolvedMapObjects((Function1<Expression, Expression>)(Function1 & Serializable)p -> MODULE$.createDeserializer((AgnosticEncoder<?>)valueEncoder, (Expression)p, newTypePath, MODULE$.createDeserializer$default$4()), new MapValues(path), UnresolvedMapObjects$.MODULE$.apply$default$3()), "array", (DataType)new ObjectType(Object[].class), Invoke$.MODULE$.apply$default$4(), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
                Class<?> x$18 = ArrayBasedMapData$.MODULE$.getClass();
                ObjectType x$19 = new ObjectType(Map.class);
                String x$20 = "toJavaMap";
                Invoke invoke = keyData;
                Invoke invoke2 = valueData;
                List x$21 = Nil$.MODULE$.$colon$colon((Object)invoke2).$colon$colon((Object)invoke);
                boolean x$22 = false;
                Seq<AbstractDataType> x$23 = StaticInvoke$.MODULE$.apply$default$5();
                boolean x$24 = StaticInvoke$.MODULE$.apply$default$6();
                boolean x$25 = StaticInvoke$.MODULE$.apply$default$8();
                Option<ScalarFunction<?>> x$26 = StaticInvoke$.MODULE$.apply$default$9();
                return new StaticInvoke(x$18, (DataType)x$19, "toJavaMap", (Seq<Expression>)x$21, x$23, x$24, false, x$25, x$26);
            }
        }
        if (bl2) {
            ClassTag tag = mapEncoder.clsTag();
            AgnosticEncoder keyEncoder = mapEncoder.keyEncoder();
            AgnosticEncoder valueEncoder = mapEncoder.valueEncoder();
            WalkedTypePath newTypePath = walkedTypePath.recordMap(keyEncoder.clsTag().runtimeClass().getName(), valueEncoder.clsTag().runtimeClass().getName());
            return new UnresolvedCatalystToExternalMap(path, (Function1<Expression, Expression>)(Function1 & Serializable)x$1 -> MODULE$.createDeserializer((AgnosticEncoder<?>)keyEncoder, (Expression)x$1, newTypePath, MODULE$.createDeserializer$default$4()), (Function1<Expression, Expression>)(Function1 & Serializable)x$2 -> MODULE$.createDeserializer((AgnosticEncoder<?>)valueEncoder, (Expression)x$2, newTypePath, MODULE$.createDeserializer$default$4()), tag.runtimeClass());
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.ProductEncoder) {
            AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder2;
            ClassTag tag = productEncoder.clsTag();
            Seq fields = productEncoder.fields();
            Option outerPointerGetter = productEncoder.outerPointerGetter();
            Class cls = tag.runtimeClass();
            ObjectType dt = new ObjectType(cls);
            boolean isTuple = cls.getName().startsWith("scala.Tuple");
            Seq arguments = (Seq)((IterableOps)fields.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    WalkedTypePath newTypePath = walkedTypePath.recordField(field.enc().clsTag().runtimeClass().getName(), field.name());
                    Expression getter = isTuple ? MODULE$.addToPathOrdinal(path, i, field.enc().dataType(), newTypePath) : MODULE$.addToPath(path, field.name(), field.enc().dataType(), newTypePath);
                    return MODULE$.expressionWithNullSafety(MODULE$.createDeserializer(field.enc(), getter, newTypePath, MODULE$.createDeserializer$default$4()), field.enc().nullable(), newTypePath);
                }
                throw new MatchError((Object)tuple2);
            });
            return new If(new IsNull(path), Literal$.MODULE$.create(null, (DataType)dt), new NewInstance(cls, (Seq<Expression>)arguments, (Seq<AbstractDataType>)Nil$.MODULE$, false, (DataType)dt, (Option<Function0<Object>>)outerPointerGetter));
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.RowEncoder) {
            AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)agnosticEncoder2;
            Seq fields = rowEncoder.fields();
            Seq convertedFields = (Seq)((IterableOps)fields.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    AgnosticEncoders.EncoderField f = (AgnosticEncoders.EncoderField)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    WalkedTypePath newTypePath = walkedTypePath.recordField(f.enc().clsTag().runtimeClass().getName(), f.name());
                    Expression deserializer = MODULE$.createDeserializer(f.enc(), new GetStructField(path, i, GetStructField$.MODULE$.apply$default$3()), newTypePath, MODULE$.createDeserializer$default$4());
                    if (!isTopLevel) {
                        Literal literal = Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i));
                        return new If(new Invoke(path, "isNullAt", (DataType)BooleanType$.MODULE$, (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)literal), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8()), Literal$.MODULE$.create(null, EncoderUtils$.MODULE$.externalDataTypeFor(f.enc())), deserializer);
                    }
                    return deserializer;
                }
                throw new MatchError((Object)tuple2);
            });
            return new If(new IsNull(path), Literal$.MODULE$.create(null, EncoderUtils$.MODULE$.externalDataTypeFor(enc)), new CreateExternalRow((Seq<Expression>)convertedFields, enc.schema()));
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.JavaBeanEncoder) {
            AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder2;
            ClassTag tag = javaBeanEncoder.clsTag();
            Seq fields = javaBeanEncoder.fields();
            Seq setters = (Seq)((IterableOps)fields.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)DeserializerBuildHelper$.$anonfun$createDeserializer$7(x$3)))).map((Function1 & Serializable)f -> {
                WalkedTypePath newTypePath = walkedTypePath.recordField(f.enc().clsTag().runtimeClass().getName(), f.name());
                Expression setter = MODULE$.expressionWithNullSafety(MODULE$.createDeserializer(f.enc(), MODULE$.addToPath(path, f.name(), f.enc().dataType(), newTypePath), newTypePath, MODULE$.createDeserializer$default$4()), f.nullable(), newTypePath);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f.writeMethod().get()), (Object)setter);
            });
            Class cls = tag.runtimeClass();
            NewInstance newInstance = NewInstance$.MODULE$.apply(cls, (Seq<Expression>)Nil$.MODULE$, (DataType)new ObjectType(cls), false);
            InitializeJavaBean result = new InitializeJavaBean(newInstance, (scala.collection.immutable.Map<String, Expression>)setters.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return new If(new IsNull(path), Literal$.MODULE$.create(null, (DataType)new ObjectType(cls)), result);
        }
        if (agnosticEncoder2 instanceof AgnosticEncoders.TransformingEncoder) {
            Function0 codec;
            bl3 = true;
            transformingEncoder = (AgnosticEncoders.TransformingEncoder)agnosticEncoder2;
            ClassTag tag = transformingEncoder.clsTag();
            Function0 function0 = codec = transformingEncoder.codecProvider();
            JavaSerializationCodec$ javaSerializationCodec$ = JavaSerializationCodec$.MODULE$;
            if (!(function0 != null ? !function0.equals(javaSerializationCodec$) : javaSerializationCodec$ != null)) {
                return new DecodeUsingSerializer(path, tag, false);
            }
        }
        if (bl3) {
            Function0 codec;
            ClassTag tag = transformingEncoder.clsTag();
            Function0 function0 = codec = transformingEncoder.codecProvider();
            KryoSerializationCodec$ kryoSerializationCodec$ = KryoSerializationCodec$.MODULE$;
            if (!(function0 != null ? !function0.equals(kryoSerializationCodec$) : kryoSerializationCodec$ != null)) {
                return new DecodeUsingSerializer(path, tag, true);
            }
        }
        if (bl3) {
            ClassTag tag = transformingEncoder.clsTag();
            AgnosticEncoder encoder = transformingEncoder.transformed();
            Function0 provider = transformingEncoder.codecProvider();
            Expression expression = this.createDeserializer(encoder, path, walkedTypePath, isTopLevel);
            return new Invoke(Literal$.MODULE$.create(provider.apply(), (DataType)new ObjectType(Codec.class)), "decode", EncoderUtils$.MODULE$.dataTypeForClass(tag.runtimeClass()), (Seq<Expression>)Nil$.MODULE$.$colon$colon((Object)expression), Invoke$.MODULE$.apply$default$5(), Invoke$.MODULE$.apply$default$6(), Invoke$.MODULE$.apply$default$7(), Invoke$.MODULE$.apply$default$8());
        }
        throw new MatchError(agnosticEncoder2);
    }

    private boolean createDeserializer$default$4() {
        return false;
    }

    private Expression deserializeArray(Expression path, AgnosticEncoder<?> elementEnc, boolean containsNull, Option<Class<?>> cls, WalkedTypePath walkedTypePath) {
        WalkedTypePath newTypePath = walkedTypePath.recordArray(elementEnc.clsTag().runtimeClass().getName());
        Function1 & Serializable mapFunction = (Function1 & Serializable)element -> MODULE$.deserializerForWithNullSafetyAndUpcast((Expression)element, elementEnc.dataType(), containsNull, newTypePath, (Function1<Expression, Expression>)(Function1 & Serializable)x$4 -> MODULE$.createDeserializer(elementEnc, (Expression)x$4, newTypePath, MODULE$.createDeserializer$default$4()));
        return new UnresolvedMapObjects((Function1<Expression, Expression>)mapFunction, path, cls);
    }

    private String toArrayMethodName(AgnosticEncoder<?> enc) {
        AgnosticEncoder<?> agnosticEncoder = enc;
        if (AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toBooleanArray";
        }
        if (AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toByteArray";
        }
        if (AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toShortArray";
        }
        if (AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toIntArray";
        }
        if (AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toLongArray";
        }
        if (AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toFloatArray";
        }
        if (AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder)) {
            return "toDoubleArray";
        }
        return "array";
    }

    public static final /* synthetic */ boolean $anonfun$createDeserializer$7(AgnosticEncoders.EncoderField x$3) {
        return x$3.writeMethod().isDefined();
    }

    private DeserializerBuildHelper$() {
    }
}

