/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.aggregate.ModeBuilder$;
import org.apache.spark.sql.catalyst.plans.logical.FunctionSignature;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@ExpressionDescription(usage="\n    _FUNC_(col[, deterministic]) - Returns the most frequent value for the values within `col`. NULL values are ignored. If all the values are NULL, or there are 0 rows, returns NULL.\n      When multiple values have the same greatest frequency then either any of values is returned if `deterministic` is false or is not defined, or the lowest value is returned if `deterministic` is true.\n    _FUNC_() WITHIN GROUP (ORDER BY col) - Returns the most frequent value for the values within `col` (specified in ORDER BY clause). NULL values are ignored.\n      If all the values are NULL, or there are 0 rows, returns NULL. When multiple values have the same greatest frequency only one value will be returned.\n      The value will be chosen based on sort direction. Return the smallest value if sort direction is asc or the largest value if sort direction is desc from multiple values with the same frequency.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (0), (10), (10) AS tab(col);\n       10\n      > SELECT _FUNC_(col) FROM VALUES (INTERVAL '0' MONTH), (INTERVAL '10' MONTH), (INTERVAL '10' MONTH) AS tab(col);\n       0-10\n      > SELECT _FUNC_(col) FROM VALUES (0), (10), (10), (null), (null), (null) AS tab(col);\n       10\n      > SELECT _FUNC_(col, false) FROM VALUES (-10), (0), (10) AS tab(col);\n       0\n      > SELECT _FUNC_(col, true) FROM VALUES (-10), (0), (10) AS tab(col);\n       -10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col) FROM VALUES (0), (10), (10) AS tab(col);\n       10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col) FROM VALUES (0), (10), (10), (20), (20) AS tab(col);\n       10\n      > SELECT _FUNC_() WITHIN GROUP (ORDER BY col DESC) FROM VALUES (0), (10), (10), (20), (20) AS tab(col);\n       20\n  ", group="agg_funcs", since="3.4.0")
@ScalaSignature(bytes="\u0006\u0005Q;Q\u0001B\u0003\t\u0002Q1QAF\u0003\t\u0002]AQ\u0001J\u0001\u0005\u0002\u0015BQAJ\u0001\u0005B\u001d\n1\"T8eK\n+\u0018\u000e\u001c3fe*\u0011aaB\u0001\nC\u001e<'/Z4bi\u0016T!\u0001C\u0005\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u0015-\t\u0001bY1uC2L8\u000f\u001e\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001\u0001\t\u0003+\u0005i\u0011!\u0002\u0002\f\u001b>$WMQ;jY\u0012,'oE\u0002\u00021y\u0001\"!\u0007\u000f\u000e\u0003iQ\u0011aG\u0001\u0006g\u000e\fG.Y\u0005\u0003;i\u0011a!\u00118z%\u00164\u0007CA\u0010#\u001b\u0005\u0001#BA\u0011\n\u0003!\tg.\u00197zg&\u001c\u0018BA\u0012!\u0005E)\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\tQAY;jY\u0012$2\u0001\u000b\u0017:!\tI#&D\u0001\b\u0013\tYsA\u0001\u0006FqB\u0014Xm]:j_:DQ!L\u0002A\u00029\n\u0001BZ;oG:\u000bW.\u001a\t\u0003_Yr!\u0001\r\u001b\u0011\u0005ERR\"\u0001\u001a\u000b\u0005M\u001a\u0012A\u0002\u001fs_>$h(\u0003\u000265\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$\u0004C\u0003\t\u0007\u0001\u0007!\bE\u0002<\u0001\"r!\u0001\u0010 \u000f\u0005Ej\u0014\"A\u000e\n\u0005}R\u0012a\u00029bG.\fw-Z\u0005\u0003\u0003\n\u00131aU3r\u0015\ty$\u0004\u000b\u0006\u0002\t\u001eC%jS'O!F\u0003\"!K#\n\u0005\u0019;!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0002\u0013\u00069\u0019B\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aw\u000e\\.-A\u0011,G/\u001a:nS:L7\u000f^5d;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u0004Sn\\:uA\u0019\u0014X-];f]R\u0004c/\u00197vK\u00022wN\u001d\u0011uQ\u0016\u0004c/\u00197vKN\u0004s/\u001b;iS:\u0004\u0003mY8mA:\u0002c*\u0016'MAY\fG.^3tA\u0005\u0014X\rI5h]>\u0014X\r\u001a\u0018!\u0013\u001a\u0004\u0013\r\u001c7!i\",\u0007E^1mk\u0016\u001c\b%\u0019:fA9+F\n\u0014\u0017!_J\u0004C\u000f[3sK\u0002\n'/\u001a\u00111AI|wo\u001d\u0017!e\u0016$XO\u001d8tA9+F\n\u0014\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011XQ\u0016t\u0007%\\;mi&\u0004H.\u001a\u0011wC2,Xm\u001d\u0011iCZ,\u0007\u0005\u001e5fAM\fW.\u001a\u0011he\u0016\fG/Z:uA\u0019\u0014X-];f]\u000eL\b\u0005\u001e5f]\u0002*\u0017\u000e\u001e5fe\u0002\ng.\u001f\u0011pM\u00022\u0018\r\\;fg\u0002J7\u000f\t:fiV\u0014h.\u001a3!S\u001a\u0004\u0003\rZ3uKJl\u0017N\\5ti&\u001c\u0007\rI5tA\u0019\fGn]3!_J\u0004\u0013n\u001d\u0011o_R\u0004C-\u001a4j]\u0016$G\u0006I8sAQDW\r\t7po\u0016\u001cH\u000f\t<bYV,\u0007%[:!e\u0016$XO\u001d8fI\u0002Jg\r\t1eKR,'/\\5oSN$\u0018n\u00191!SN\u0004CO];f])\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015*A]KE\u000bS%OA\u001d\u0013v*\u0016)!Q=\u0013F)\u0012*!\u0005f\u00033m\u001c7*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA5|7\u000f\u001e\u0011ge\u0016\fX/\u001a8uAY\fG.^3!M>\u0014\b\u0005\u001e5fAY\fG.^3tA]LG\u000f[5oA\u0001\u001cw\u000e\u001c1!QM\u0004XmY5gS\u0016$\u0007%\u001b8!\u001fJ#UI\u0015\u0011C3\u0002\u001aG.Y;tK&r\u0003ET+M\u0019\u00022\u0018\r\\;fg\u0002\n'/\u001a\u0011jO:|'/\u001a3/\u0015\u0001\u0002\u0003\u0005\t\u0011!\u0013\u001a\u0004\u0013\r\u001c7!i\",\u0007E^1mk\u0016\u001c\b%\u0019:fA9+F\n\u0014\u0017!_J\u0004C\u000f[3sK\u0002\n'/\u001a\u00111AI|wo\u001d\u0017!e\u0016$XO\u001d8tA9+F\n\u0014\u0018!/\",g\u000eI7vYRL\u0007\u000f\\3!m\u0006dW/Z:!Q\u00064X\r\t;iK\u0002\u001a\u0018-\\3!OJ,\u0017\r^3ti\u00022'/Z9vK:\u001c\u0017\u0010I8oYf\u0004sN\\3!m\u0006dW/\u001a\u0011xS2d\u0007EY3!e\u0016$XO\u001d8fI:R\u0001\u0005\t\u0011!A\u0001\"\u0006.\u001a\u0011wC2,X\rI<jY2\u0004#-\u001a\u0011dQ>\u001cXM\u001c\u0011cCN,G\rI8oAM|'\u000f\u001e\u0011eSJ,7\r^5p]:\u0002#+\u001a;ve:\u0004C\u000f[3!g6\fG\u000e\\3ti\u00022\u0018\r\\;fA%4\u0007e]8si\u0002\"\u0017N]3di&|g\u000eI5tA\u0005\u001c8\rI8sAQDW\r\t7be\u001e,7\u000f\u001e\u0011wC2,X\rI5gAM|'\u000f\u001e\u0011eSJ,7\r^5p]\u0002J7\u000f\t3fg\u000e\u0004cM]8nA5,H\u000e^5qY\u0016\u0004c/\u00197vKN\u0004s/\u001b;iAQDW\rI:b[\u0016\u0004cM]3rk\u0016t7-\u001f\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f\u0013\u0001T\u0001\u0007\f*\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)a%b\u0003\u0005K\u00191S1\u0002\u0003&\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fY8mS\u00012%kT'!-\u0006cU+R*!Q%sE+\u0012*W\u00032\u0003s\u0005M\u0014!\u001b>sE\u000bS\u0015-A!Je\nV#S-\u0006c\u0005eJ\u00191O\u0001juJ\u0014+IS1\u0002\u0003&\u0013(U\u000bJ3\u0016\t\u0014\u0011(cA:\u0003%T(O)\"K\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0003'L\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aw\u000e\\\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00151S1\u0002\u0003&\r\u0019*Y\u0001B\u0013\u0007M\u0015-A!rW\u000f\u001c7*Y\u0001Bc.\u001e7mS1\u0002\u0003F\\;mY&\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\n\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2d\u0003EZ1mg\u0016L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002BS&\r\u0019*Y\u0001B\u0003'\u000b\u0017!QE\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)G>dG\u0006\t;sk\u0016L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002BS&\r\u0019*Y\u0001B\u0003'\u000b\u0017!QE\u0002\u0014\u0006I!TAQ\f'\rK2pY&Z$\u0002\t\u0011!A\u0001\u0002\u0003%L\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"J\u0003eV%U\u0011&s\u0005e\u0012*P+B\u0003\u0003f\u0014*E\u000bJ\u0003#)\u0017\u0011d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002B\u0003'\u000b\u0017!QE\u0002\u0014\u0006\f\u0011)cAJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u0002\u0013\u0007\r\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)S\u0001:\u0016\n\u0016%J\u001d\u0002:%kT+QA!z%\u000bR#SA\tK\u0006eY8mS\u00012%kT'!-\u0006cU+R*!QAJC\u0006\t\u00152a%b\u0003\u0005K\u00191S1\u0002\u0003F\r\u0019*Y\u0001B#\u0007M\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112a)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0006I,J)\"Ke\nI$S\u001fV\u0003\u0006\u0005K(S\t\u0016\u0013\u0006EQ-!G>d\u0007\u0005R#T\u0007&\u0002cIU(NAY\u000bE*V#TA!\u0002\u0014\u0006\f\u0011)cAJC\u0006\t\u00152a%b\u0003\u0005\u000b\u001a1S1\u0002\u0003F\r\u0019*A\u0005\u001b\u0006\u0005^1cQ\r|G.K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eAR\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0002\u001f\u0006I\u0011mZ4`MVt7m]\u0001\u0006g&t7-Z\u0011\u0002%\u0006)1G\f\u001b/a!R\u0001\u0001R$I\u0015.ke\nU)")
public final class ModeBuilder {
    public static Expression build(String funcName, Seq<Expression> expressions) {
        return ModeBuilder$.MODULE$.build(funcName, (Seq)expressions);
    }

    public static boolean supportsLambda() {
        return ModeBuilder$.MODULE$.supportsLambda();
    }

    public static Seq<Expression> rearrange(FunctionSignature expectedSignature, Seq<Expression> providedArguments, String functionName, Function2<String, String, Object> resolver) {
        return ModeBuilder$.MODULE$.rearrange(expectedSignature, providedArguments, functionName, resolver);
    }

    public static Option<FunctionSignature> functionSignature() {
        return ModeBuilder$.MODULE$.functionSignature();
    }
}

