/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import com.ibm.icu.util.ULocale;
import com.ibm.icu.util.VersionInfo;
import java.lang.invoke.CallSite;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkRuntimeException;
import org.apache.spark.sql.catalyst.util.CollationAwareUTF8String;
import org.apache.spark.unsafe.types.UTF8String;
import scala.collection.immutable.Map$;

public final class CollationFactory {
    public static final String CATALOG = "SYSTEM";
    public static final String SCHEMA = "BUILTIN";
    public static final String PROVIDER_SPARK = "spark";
    public static final String PROVIDER_ICU = "icu";
    public static final String PROVIDER_NULL = "null";
    public static final List<String> SUPPORTED_PROVIDERS = List.of("spark", "icu");
    public static final String PAD_ATTRIBUTE_EMPTY = "NO_PAD";
    public static final String PAD_ATTRIBUTE_RTRIM = "RTRIM";
    public static final int UTF8_BINARY_COLLATION_ID = Collation.CollationSpecUTF8.UTF8_BINARY_COLLATION_ID;
    public static final int UTF8_LCASE_COLLATION_ID = Collation.CollationSpecUTF8.UTF8_LCASE_COLLATION_ID;
    public static final int UNICODE_COLLATION_ID = Collation.CollationSpecICU.UNICODE_COLLATION_ID;
    public static final int UNICODE_CI_COLLATION_ID = Collation.CollationSpecICU.UNICODE_CI_COLLATION_ID;
    public static final int INDETERMINATE_COLLATION_ID = -1;

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String, int collationId) {
        return CollationFactory.getStringSearch(targetUTF8String.toValidString(), patternUTF8String.toValidString(), collationId);
    }

    public static StringSearch getStringSearch(String targetString, String patternString, int collationId) {
        StringCharacterIterator target = new StringCharacterIterator(targetString);
        Collator collator = CollationFactory.fetchCollation(collationId).getCollator();
        return new StringSearch(patternString, (CharacterIterator)target, (RuleBasedCollator)collator);
    }

    public static StringSearch getStringSearch(UTF8String targetUTF8String, UTF8String patternUTF8String) {
        return new StringSearch(patternUTF8String.toValidString(), targetUTF8String.toValidString());
    }

    public static int collationNameToId(String collationName) throws SparkException {
        return Collation.CollationSpec.collationNameToId(collationName);
    }

    public static String resolveFullyQualifiedName(String[] collationName) throws SparkException {
        if (collationName.length == 1) {
            return collationName[0];
        }
        if (collationName.length != 3 || !CATALOG.equalsIgnoreCase(collationName[0]) || !SCHEMA.equalsIgnoreCase(collationName[1])) {
            throw CollationFactory.collationInvalidNameException(collationName.length != 0 ? collationName[collationName.length - 1] : "");
        }
        return collationName[2];
    }

    public static SparkException collationInvalidNameException(String collationName) {
        HashMap<String, String> params = new HashMap<String, String>();
        int maxSuggestions = 3;
        params.put("collationName", collationName);
        params.put("proposals", CollationFactory.getClosestSuggestionsOnInvalidName(collationName, 3));
        return new SparkException("COLLATION_INVALID_NAME", SparkException.constructMessageParams(params), null);
    }

    public static String fullyQualifiedName(int collationId) {
        if (collationId == -1) {
            return Collation.CollationSpec.INDETERMINATE_COLLATION.collationName;
        }
        Collation.CollationSpec.DefinitionOrigin definitionOrigin = Collation.CollationSpec.getDefinitionOrigin(collationId);
        assert (definitionOrigin == Collation.CollationSpec.DefinitionOrigin.PREDEFINED);
        return String.format("%s.%s.%s", CATALOG, SCHEMA, Collation.CollationSpec.fetchCollation((int)collationId).collationName);
    }

    public static boolean isCaseInsensitive(int collationId) {
        if (Collation.CollationSpec.getImplementationProvider(collationId) != Collation.CollationSpec.ImplementationProvider.ICU) {
            return false;
        }
        return Collation.CollationSpecICU.fromCollationId((int)collationId).caseSensitivity == Collation.CollationSpecICU.CaseSensitivity.CI;
    }

    public static boolean isAccentInsensitive(int collationId) {
        if (Collation.CollationSpec.getImplementationProvider(collationId) != Collation.CollationSpec.ImplementationProvider.ICU) {
            return false;
        }
        return Collation.CollationSpecICU.fromCollationId((int)collationId).accentSensitivity == Collation.CollationSpecICU.AccentSensitivity.AI;
    }

    public static void assertValidProvider(String provider) throws SparkException {
        if (!SUPPORTED_PROVIDERS.contains(provider.toLowerCase())) {
            Map<String, String> params = Map.of("provider", provider, "supportedProviders", String.join((CharSequence)", ", SUPPORTED_PROVIDERS));
            throw new SparkException("COLLATION_INVALID_PROVIDER", SparkException.constructMessageParams(params), null);
        }
    }

    public static Collation fetchCollation(int collationId) {
        return Collation.CollationSpec.fetchCollation(collationId);
    }

    public static Collation fetchCollation(String collationName) throws SparkException {
        return CollationFactory.fetchCollation(CollationFactory.collationNameToId(collationName));
    }

    public static String[] getICULocaleNames() {
        return Collation.CollationSpecICU.ICULocaleNames;
    }

    public static UTF8String applyTrimmingPolicy(UTF8String input, int collationId) {
        return Collation.CollationSpec.applyTrimmingPolicy(input, collationId);
    }

    public static boolean ignoresSpacesInTrimFunctions(int collationId, boolean isLTrim, boolean isRTrim) {
        return Collation.CollationSpec.ignoresSpacesInTrimFunctions(collationId, isLTrim, isRTrim);
    }

    public static UTF8String getCollationKey(UTF8String input, int collationId) {
        Collation collation = CollationFactory.fetchCollation(collationId);
        if (collation.supportsSpaceTrimming) {
            input = Collation.CollationSpec.applyTrimmingPolicy(input, collationId);
        }
        if (collation.isUtf8BinaryType) {
            return input;
        }
        if (collation.isUtf8LcaseType) {
            return CollationAwareUTF8String.lowerCaseCodePoints(input);
        }
        CollationKey collationKey = collation.getCollator().getCollationKey(input.toValidString());
        return UTF8String.fromBytes(collationKey.toByteArray());
    }

    public static byte[] getCollationKeyBytes(UTF8String input, int collationId) {
        Collation collation = CollationFactory.fetchCollation(collationId);
        if (collation.supportsSpaceTrimming) {
            input = Collation.CollationSpec.applyTrimmingPolicy(input, collationId);
        }
        if (collation.isUtf8BinaryType) {
            return input.getBytes();
        }
        if (collation.isUtf8LcaseType) {
            return CollationAwareUTF8String.lowerCaseCodePoints(input).getBytes();
        }
        return collation.getCollator().getCollationKey(input.toValidString()).toByteArray();
    }

    public static String getClosestSuggestionsOnInvalidName(String collationName, int maxSuggestions) {
        String[] validModifiers;
        String[] validRootNames;
        if (collationName.startsWith("UTF8_")) {
            validRootNames = new String[]{Collation.CollationSpecUTF8.UTF8_BINARY_COLLATION.collationName, Collation.CollationSpecUTF8.UTF8_LCASE_COLLATION.collationName};
            validModifiers = new String[]{"_RTRIM"};
        } else {
            validRootNames = CollationFactory.getICULocaleNames();
            validModifiers = new String[]{"_CI", "_AI", "_CS", "_AS", "_RTRIM"};
        }
        boolean foundModifier = true;
        String localeName = collationName.toUpperCase();
        List<Object> modifiers = new ArrayList();
        block0: while (foundModifier) {
            foundModifier = false;
            for (String modifier : validModifiers) {
                if (!localeName.endsWith(modifier)) continue;
                modifiers.add(modifier);
                localeName = localeName.substring(0, localeName.length() - modifier.length());
                foundModifier = true;
                continue block0;
            }
        }
        Collections.reverse(modifiers);
        modifiers = modifiers.stream().distinct().toList();
        if (modifiers.contains("_CI") && modifiers.contains("_CS")) {
            modifiers = modifiers.stream().filter(m -> !m.equals("_CI")).toList();
        }
        if (modifiers.contains("_AI") && modifiers.contains("_AS")) {
            modifiers = modifiers.stream().filter(m -> !m.equals("_AI")).toList();
        }
        String finalLocaleName = localeName;
        Comparator distanceComparator = (c1, c2) -> {
            int distance1 = UTF8String.fromString(c1.toUpperCase()).levenshteinDistance(UTF8String.fromString(finalLocaleName));
            int distance2 = UTF8String.fromString(c2.toUpperCase()).levenshteinDistance(UTF8String.fromString(finalLocaleName));
            return Integer.compare(distance1, distance2);
        };
        String[] rootNamesByDistance = Arrays.copyOf(validRootNames, validRootNames.length);
        Arrays.sort(rootNamesByDistance, distanceComparator);
        Function<String, Boolean> isCollationNameValid = name -> {
            try {
                CollationFactory.collationNameToId(name);
                return true;
            }
            catch (SparkException e) {
                return false;
            }
        };
        int suggestionThreshold = 3;
        ArrayList<CallSite> suggestions = new ArrayList<CallSite>(maxSuggestions);
        for (int i = 0; i < maxSuggestions; ++i) {
            String suggestion = rootNamesByDistance[i] + String.join((CharSequence)"", modifiers);
            assert (isCollationNameValid.apply(suggestion).booleanValue());
            if (suggestions.isEmpty()) {
                suggestions.add((CallSite)((Object)suggestion));
                continue;
            }
            int distance = UTF8String.fromString(suggestion.toUpperCase()).levenshteinDistance(UTF8String.fromString(collationName.toUpperCase()));
            if (distance >= 3) break;
            suggestions.add((CallSite)((Object)suggestion));
        }
        return String.join((CharSequence)", ", suggestions);
    }

    public static List<CollationIdentifier> listCollations() {
        return Collation.CollationSpec.listCollations();
    }

    public static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
        return Collation.CollationSpec.loadCollationMeta(collationIdentifier);
    }

    public static class Collation {
        public final String collationName;
        public final String provider;
        private final Collator collator;
        public final Comparator<UTF8String> comparator;
        public final String version;
        public final Function<UTF8String, byte[]> sortKeyFunction;
        public final BiFunction<UTF8String, UTF8String, Boolean> equalsFunction;
        public final boolean supportsBinaryEquality;
        public final boolean supportsBinaryOrdering;
        public final boolean supportsLowercaseEquality;
        public final boolean supportsSpaceTrimming;
        public final boolean isUtf8BinaryType;
        public final boolean isUtf8LcaseType;

        public Collation(String collationName, String provider, Collator collator, Comparator<UTF8String> comparator, String version, Function<UTF8String, byte[]> sortKeyFunction, BiFunction<UTF8String, UTF8String, Boolean> equalsFunction, boolean isUtf8BinaryType, boolean isUtf8LcaseType, boolean supportsSpaceTrimming) {
            this.collationName = collationName;
            this.provider = provider;
            this.collator = collator;
            this.comparator = comparator;
            this.version = version;
            this.sortKeyFunction = sortKeyFunction;
            this.isUtf8BinaryType = isUtf8BinaryType;
            this.isUtf8LcaseType = isUtf8LcaseType;
            this.equalsFunction = equalsFunction;
            this.supportsSpaceTrimming = supportsSpaceTrimming;
            this.supportsBinaryEquality = !supportsSpaceTrimming && isUtf8BinaryType;
            this.supportsBinaryOrdering = !supportsSpaceTrimming && isUtf8BinaryType;
            boolean bl = this.supportsLowercaseEquality = !supportsSpaceTrimming && isUtf8LcaseType;
            assert (!this.supportsBinaryEquality || !this.supportsLowercaseEquality);
            assert (SUPPORTED_PROVIDERS.contains(provider) || provider.equals(CollationFactory.PROVIDER_NULL));
        }

        public Collator getCollator() {
            return this.collator;
        }

        public CollationIdentifier identifier() {
            return new CollationIdentifier(this.provider, this.collationName, this.version);
        }

        private static class SpecifierUtils {
            private SpecifierUtils() {
            }

            private static int getSpecValue(int collationId, int offset, int mask) {
                return collationId >> offset & mask;
            }

            private static int removeSpec(int collationId, int offset, int mask) {
                return collationId & ~(mask << offset);
            }

            private static int setSpecValue(int collationId, int offset, Enum spec) {
                return collationId | spec.ordinal() << offset;
            }
        }

        private static class IndeterminateCollation
        extends Collation {
            IndeterminateCollation() {
                super(CollationFactory.PROVIDER_NULL, CollationFactory.PROVIDER_NULL, null, (s1, s2) -> {
                    throw IndeterminateCollation.indeterminateError();
                }, null, s -> {
                    throw IndeterminateCollation.indeterminateError();
                }, (s1, s2) -> {
                    throw IndeterminateCollation.indeterminateError();
                }, false, false, false);
            }

            @Override
            public Collator getCollator() {
                throw IndeterminateCollation.indeterminateError();
            }

            private static SparkRuntimeException indeterminateError() {
                return new SparkRuntimeException("INDETERMINATE_COLLATION", Map$.MODULE$.empty(), null, new QueryContext[0], "");
            }
        }

        private static class CollationSpecICU
        extends CollationSpec {
            private static final int CASE_SENSITIVITY_OFFSET = 17;
            private static final int CASE_SENSITIVITY_MASK = 1;
            private static final int ACCENT_SENSITIVITY_OFFSET = 16;
            private static final int ACCENT_SENSITIVITY_MASK = 1;
            private static final String[] ICULocaleNames;
            private static final Map<String, ULocale> ICULocaleMap;
            private static final Map<String, String> ICULocaleMapUppercase;
            private static final Map<String, Integer> ICULocaleToId;
            private static final String ICU_VERSION;
            private static final int UNICODE_COLLATION_ID;
            private static final int UNICODE_CI_COLLATION_ID;
            private final CaseSensitivity caseSensitivity;
            private final AccentSensitivity accentSensitivity;
            private final String locale;
            private final int collationId;

            private CollationSpecICU(String locale, CaseSensitivity caseSensitivity, AccentSensitivity accentSensitivity, CollationSpec.SpaceTrimming spaceTrimming) {
                this.locale = locale;
                this.caseSensitivity = caseSensitivity;
                this.accentSensitivity = accentSensitivity;
                this.spaceTrimming = spaceTrimming;
                int collationId = ICULocaleToId.get(locale);
                collationId = SpecifierUtils.setSpecValue(collationId, 29, CollationSpec.ImplementationProvider.ICU);
                collationId = SpecifierUtils.setSpecValue(collationId, 17, caseSensitivity);
                collationId = SpecifierUtils.setSpecValue(collationId, 16, accentSensitivity);
                this.collationId = collationId = SpecifierUtils.setSpecValue(collationId, 18, spaceTrimming);
            }

            private static int collationNameToId(String originalName, String collationName) throws SparkException {
                String[] specifiers;
                int lastPos = -1;
                for (int i = 1; i <= collationName.length(); ++i) {
                    String localeName = collationName.substring(0, i);
                    if (!ICULocaleMapUppercase.containsKey(localeName)) continue;
                    lastPos = i;
                }
                if (lastPos == -1) {
                    throw CollationFactory.collationInvalidNameException(originalName);
                }
                String locale = collationName.substring(0, lastPos);
                int collationId = ICULocaleToId.get(ICULocaleMapUppercase.get(locale));
                collationId = SpecifierUtils.setSpecValue(collationId, 29, CollationSpec.ImplementationProvider.ICU);
                if (collationName.equals(locale)) {
                    return collationId;
                }
                if (collationName.charAt(locale.length()) != '_') {
                    throw CollationFactory.collationInvalidNameException(originalName);
                }
                String remainingSpecifiers = collationName.substring(lastPos + 1);
                boolean isCaseSpecifierSet = false;
                boolean isAccentSpecifierSet = false;
                boolean isSpaceTrimmingSpecifierSet = false;
                CaseSensitivity caseSensitivity = CaseSensitivity.CS;
                AccentSensitivity accentSensitivity = AccentSensitivity.AS;
                CollationSpec.SpaceTrimming spaceTrimming = CollationSpec.SpaceTrimming.NONE;
                String[] stringArray = specifiers = remainingSpecifiers.split("_");
                int n = stringArray.length;
                block13: for (int i = 0; i < n; ++i) {
                    String specifier;
                    switch (specifier = stringArray[i]) {
                        case "CI": 
                        case "CS": {
                            if (isCaseSpecifierSet) {
                                throw CollationFactory.collationInvalidNameException(originalName);
                            }
                            caseSensitivity = CaseSensitivity.valueOf(specifier);
                            isCaseSpecifierSet = true;
                            continue block13;
                        }
                        case "AI": 
                        case "AS": {
                            if (isAccentSpecifierSet) {
                                throw CollationFactory.collationInvalidNameException(originalName);
                            }
                            accentSensitivity = AccentSensitivity.valueOf(specifier);
                            isAccentSpecifierSet = true;
                            continue block13;
                        }
                        case "RTRIM": {
                            if (isSpaceTrimmingSpecifierSet) {
                                throw CollationFactory.collationInvalidNameException(originalName);
                            }
                            spaceTrimming = CollationSpec.SpaceTrimming.valueOf(specifier);
                            isSpaceTrimmingSpecifierSet = true;
                            continue block13;
                        }
                        default: {
                            throw CollationFactory.collationInvalidNameException(originalName);
                        }
                    }
                }
                collationId = SpecifierUtils.setSpecValue(collationId, 17, caseSensitivity);
                collationId = SpecifierUtils.setSpecValue(collationId, 16, accentSensitivity);
                collationId = SpecifierUtils.setSpecValue(collationId, 18, spaceTrimming);
                return collationId;
            }

            private static CollationSpecICU fromCollationId(int collationId) {
                int spaceTrimmingOrdinal = SpecifierUtils.getSpecValue(collationId, 18, 1);
                int caseSensitivityOrdinal = SpecifierUtils.getSpecValue(collationId, 17, 1);
                int accentSensitivityOrdinal = SpecifierUtils.getSpecValue(collationId, 16, 1);
                collationId = SpecifierUtils.removeSpec(collationId, 29, 1);
                collationId = SpecifierUtils.removeSpec(collationId, 18, 1);
                collationId = SpecifierUtils.removeSpec(collationId, 17, 1);
                int localeId = collationId = SpecifierUtils.removeSpec(collationId, 16, 1);
                assert (localeId >= 0 && localeId < ICULocaleNames.length);
                CaseSensitivity caseSensitivity = CaseSensitivity.values()[caseSensitivityOrdinal];
                AccentSensitivity accentSensitivity = AccentSensitivity.values()[accentSensitivityOrdinal];
                CollationSpec.SpaceTrimming spaceTrimming = CollationSpec.SpaceTrimming.values()[spaceTrimmingOrdinal];
                String locale = ICULocaleNames[localeId];
                return new CollationSpecICU(locale, caseSensitivity, accentSensitivity, spaceTrimming);
            }

            @Override
            protected Collation buildCollation() {
                Function<UTF8String, byte[]> sortKeyFunction;
                Comparator comparator;
                ULocale.Builder builder = new ULocale.Builder();
                builder.setLocale(ICULocaleMap.get(this.locale));
                if (this.caseSensitivity == CaseSensitivity.CS && this.accentSensitivity == AccentSensitivity.AS) {
                    builder.setUnicodeLocaleKeyword("ks", "level3");
                } else if (this.caseSensitivity == CaseSensitivity.CS && this.accentSensitivity == AccentSensitivity.AI) {
                    builder.setUnicodeLocaleKeyword("ks", "level1").setUnicodeLocaleKeyword("kc", "true");
                } else if (this.caseSensitivity == CaseSensitivity.CI && this.accentSensitivity == AccentSensitivity.AS) {
                    builder.setUnicodeLocaleKeyword("ks", "level2");
                } else if (this.caseSensitivity == CaseSensitivity.CI && this.accentSensitivity == AccentSensitivity.AI) {
                    builder.setUnicodeLocaleKeyword("ks", "level1");
                }
                ULocale resultLocale = builder.build();
                Collator collator = Collator.getInstance((ULocale)resultLocale);
                collator.freeze();
                if (this.spaceTrimming == CollationSpec.SpaceTrimming.NONE) {
                    comparator = (s1, s2) -> collator.compare(s1.toValidString(), s2.toValidString());
                    sortKeyFunction = s -> collator.getCollationKey(s.toValidString()).toByteArray();
                } else {
                    comparator = (s1, s2) -> collator.compare(CollationSpecICU.applyTrimmingPolicy(s1, this.spaceTrimming).toValidString(), CollationSpecICU.applyTrimmingPolicy(s2, this.spaceTrimming).toValidString());
                    sortKeyFunction = s -> collator.getCollationKey(CollationSpecICU.applyTrimmingPolicy(s, this.spaceTrimming).toValidString()).toByteArray();
                }
                return new Collation(this.normalizedCollationName(), CollationFactory.PROVIDER_ICU, collator, comparator, ICU_VERSION, sortKeyFunction, (s1, s2) -> comparator.compare(s1, s2) == 0, false, false, this.spaceTrimming != CollationSpec.SpaceTrimming.NONE);
            }

            @Override
            protected CollationMeta buildCollationMeta() {
                String language = ICULocaleMap.get(this.locale).getDisplayLanguage();
                String country = ICULocaleMap.get(this.locale).getDisplayCountry();
                return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, this.normalizedCollationName(), language.isEmpty() ? null : language, country.isEmpty() ? null : country, VersionInfo.ICU_VERSION.toString(), this.getPadding(), this.accentSensitivity == AccentSensitivity.AS, this.caseSensitivity == CaseSensitivity.CS, this.spaceTrimming.toString());
            }

            @Override
            protected String normalizedCollationName() {
                StringBuilder builder = new StringBuilder();
                builder.append(this.locale);
                if (this.caseSensitivity != CaseSensitivity.CS) {
                    builder.append('_');
                    builder.append(this.caseSensitivity.toString());
                }
                if (this.accentSensitivity != AccentSensitivity.AS) {
                    builder.append('_');
                    builder.append(this.accentSensitivity.toString());
                }
                if (this.spaceTrimming != CollationSpec.SpaceTrimming.NONE) {
                    builder.append('_');
                    builder.append(this.spaceTrimming.toString());
                }
                return builder.toString();
            }

            private static List<String> allCollationNames() {
                ArrayList<CallSite> collationNames = new ArrayList<CallSite>();
                List<String> caseAccentSpecifiers = Arrays.asList("", "_AI", "_CI", "_CI_AI");
                List<String> trimmingSpecifiers = Arrays.asList("", "_RTRIM");
                for (String locale : ICULocaleToId.keySet()) {
                    for (String caseAccent : caseAccentSpecifiers) {
                        for (String trimming : trimmingSpecifiers) {
                            String collationName = locale + caseAccent + trimming;
                            collationNames.add((CallSite)((Object)collationName));
                        }
                    }
                }
                return collationNames.stream().sorted().toList();
            }

            static List<CollationIdentifier> listCollations() {
                return CollationSpecICU.allCollationNames().stream().map(name -> new CollationIdentifier(CollationFactory.PROVIDER_ICU, (String)name, VersionInfo.ICU_VERSION.toString())).toList();
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                try {
                    int collationId = CollationSpecICU.collationNameToId(collationIdentifier.name, collationIdentifier.name.toUpperCase());
                    return CollationSpecICU.fromCollationId(collationId).buildCollationMeta();
                }
                catch (SparkException ignored) {
                    return null;
                }
            }

            static {
                ICULocaleMap = new HashMap<String, ULocale>();
                ICULocaleMapUppercase = new HashMap<String, String>();
                ICULocaleToId = new HashMap<String, Integer>();
                ICU_VERSION = String.format("%d.%d", VersionInfo.ICU_VERSION.getMajor(), VersionInfo.ICU_VERSION.getMinor());
                ICULocaleMap.put("UNICODE", ULocale.ROOT);
                ULocale[] locales = Collator.getAvailableULocales();
                for (ULocale locale : locales) {
                    String country;
                    if (!locale.getVariant().isEmpty()) continue;
                    String language = locale.getLanguage();
                    assert (!language.isEmpty());
                    StringBuilder builder = new StringBuilder(language);
                    String script = locale.getScript();
                    if (!script.isEmpty()) {
                        builder.append('_');
                        builder.append(script);
                    }
                    if (!(country = locale.getISO3Country()).isEmpty()) {
                        builder.append('_');
                        builder.append(country);
                    }
                    String localeName = builder.toString();
                    assert (!ICULocaleMap.containsKey(localeName));
                    ICULocaleMap.put(localeName, locale);
                }
                for (String localeName : ICULocaleMap.keySet()) {
                    String localeUppercase = localeName.toUpperCase();
                    assert (!ICULocaleMapUppercase.containsKey(localeUppercase));
                    ICULocaleMapUppercase.put(localeUppercase, localeName);
                }
                ICULocaleNames = ICULocaleMap.keySet().toArray(new String[0]);
                Arrays.sort(ICULocaleNames);
                assert (ICULocaleNames.length <= 4096);
                for (int i = 0; i < ICULocaleNames.length; ++i) {
                    ICULocaleToId.put(ICULocaleNames[i], i);
                }
                UNICODE_COLLATION_ID = new CollationSpecICU((String)"UNICODE", (CaseSensitivity)CaseSensitivity.CS, (AccentSensitivity)AccentSensitivity.AS, (CollationSpec.SpaceTrimming)CollationSpec.SpaceTrimming.NONE).collationId;
                UNICODE_CI_COLLATION_ID = new CollationSpecICU((String)"UNICODE", (CaseSensitivity)CaseSensitivity.CI, (AccentSensitivity)AccentSensitivity.AS, (CollationSpec.SpaceTrimming)CollationSpec.SpaceTrimming.NONE).collationId;
            }

            private static enum CaseSensitivity {
                CS,
                CI;

            }

            private static enum AccentSensitivity {
                AS,
                AI;

            }
        }

        private static class CollationSpecUTF8
        extends CollationSpec {
            private static final int CASE_SENSITIVITY_OFFSET = 0;
            private static final int CASE_SENSITIVITY_MASK = 1;
            private static final int UTF8_BINARY_COLLATION_ID = new CollationSpecUTF8((CaseSensitivity)CaseSensitivity.UNSPECIFIED, (CollationSpec.SpaceTrimming)CollationSpec.SpaceTrimming.NONE).collationId;
            private static final int UTF8_LCASE_COLLATION_ID = new CollationSpecUTF8((CaseSensitivity)CaseSensitivity.LCASE, (CollationSpec.SpaceTrimming)CollationSpec.SpaceTrimming.NONE).collationId;
            protected static Collation UTF8_BINARY_COLLATION = new CollationSpecUTF8(CaseSensitivity.UNSPECIFIED, CollationSpec.SpaceTrimming.NONE).buildCollation();
            protected static Collation UTF8_LCASE_COLLATION = new CollationSpecUTF8(CaseSensitivity.LCASE, CollationSpec.SpaceTrimming.NONE).buildCollation();
            private final CaseSensitivity caseSensitivity;
            private final int collationId;

            private CollationSpecUTF8(CaseSensitivity caseSensitivity, CollationSpec.SpaceTrimming spaceTrimming) {
                this.caseSensitivity = caseSensitivity;
                this.spaceTrimming = spaceTrimming;
                int collationId = SpecifierUtils.setSpecValue(0, 0, caseSensitivity);
                this.collationId = SpecifierUtils.setSpecValue(collationId, 18, spaceTrimming);
            }

            private static int collationNameToId(String originalName, String collationName) throws SparkException {
                String collationNamePrefix;
                int baseId;
                if (collationName.startsWith(CollationSpecUTF8.UTF8_BINARY_COLLATION.collationName)) {
                    baseId = UTF8_BINARY_COLLATION_ID;
                    collationNamePrefix = CollationSpecUTF8.UTF8_BINARY_COLLATION.collationName;
                } else if (collationName.startsWith(CollationSpecUTF8.UTF8_LCASE_COLLATION.collationName)) {
                    baseId = UTF8_LCASE_COLLATION_ID;
                    collationNamePrefix = CollationSpecUTF8.UTF8_LCASE_COLLATION.collationName;
                } else {
                    throw CollationFactory.collationInvalidNameException(originalName);
                }
                String remainingSpecifiers = collationName.substring(collationNamePrefix.length());
                if (remainingSpecifiers.isEmpty()) {
                    return baseId;
                }
                if (!remainingSpecifiers.startsWith("_")) {
                    throw CollationFactory.collationInvalidNameException(originalName);
                }
                CollationSpec.SpaceTrimming spaceTrimming = CollationSpec.SpaceTrimming.NONE;
                String remainingSpec = remainingSpecifiers.substring(1);
                if (!remainingSpec.equals(CollationFactory.PAD_ATTRIBUTE_RTRIM)) {
                    throw CollationFactory.collationInvalidNameException(originalName);
                }
                spaceTrimming = CollationSpec.SpaceTrimming.RTRIM;
                return SpecifierUtils.setSpecValue(baseId, 18, spaceTrimming);
            }

            private static CollationSpecUTF8 fromCollationId(int collationId) {
                int caseConversionOrdinal = SpecifierUtils.getSpecValue(collationId, 0, 1);
                int spaceTrimmingOrdinal = CollationSpecUTF8.getSpaceTrimming(collationId).ordinal();
                assert (CollationSpecUTF8.isValidCollationId(collationId));
                return new CollationSpecUTF8(CaseSensitivity.values()[caseConversionOrdinal], CollationSpec.SpaceTrimming.values()[spaceTrimmingOrdinal]);
            }

            private static boolean isValidCollationId(int collationId) {
                collationId = SpecifierUtils.removeSpec(collationId, 18, 1);
                return (collationId = SpecifierUtils.removeSpec(collationId, 0, 1)) == 0;
            }

            @Override
            protected Collation buildCollation() {
                Function<UTF8String, byte[]> sortKeyFunction;
                Comparator comparator;
                if (this.caseSensitivity == CaseSensitivity.UNSPECIFIED) {
                    BiFunction<UTF8String, UTF8String, Boolean> equalsFunction;
                    Function<UTF8String, byte[]> sortKeyFunction2;
                    Comparator comparator2;
                    boolean supportsSpaceTrimming;
                    boolean bl = supportsSpaceTrimming = this.spaceTrimming != CollationSpec.SpaceTrimming.NONE;
                    if (this.spaceTrimming == CollationSpec.SpaceTrimming.NONE) {
                        comparator2 = UTF8String::binaryCompare;
                        sortKeyFunction2 = s -> s.getBytes();
                        equalsFunction = UTF8String::equals;
                    } else {
                        comparator2 = (s1, s2) -> CollationSpecUTF8.applyTrimmingPolicy(s1, this.spaceTrimming).binaryCompare(CollationSpecUTF8.applyTrimmingPolicy(s2, this.spaceTrimming));
                        sortKeyFunction2 = s -> CollationSpecUTF8.applyTrimmingPolicy(s, this.spaceTrimming).getBytes();
                        equalsFunction = (s1, s2) -> CollationSpecUTF8.applyTrimmingPolicy(s1, this.spaceTrimming).equals(CollationSpecUTF8.applyTrimmingPolicy(s2, this.spaceTrimming));
                    }
                    return new Collation(this.normalizedCollationName(), CollationFactory.PROVIDER_SPARK, null, comparator2, CollationSpecICU.ICU_VERSION, sortKeyFunction2, equalsFunction, true, false, this.spaceTrimming != CollationSpec.SpaceTrimming.NONE);
                }
                if (this.spaceTrimming == CollationSpec.SpaceTrimming.NONE) {
                    comparator = CollationAwareUTF8String::compareLowerCase;
                    sortKeyFunction = s -> CollationAwareUTF8String.lowerCaseCodePoints(s).getBytes();
                } else {
                    comparator = (s1, s2) -> CollationAwareUTF8String.compareLowerCase(CollationSpecUTF8.applyTrimmingPolicy(s1, this.spaceTrimming), CollationSpecUTF8.applyTrimmingPolicy(s2, this.spaceTrimming));
                    sortKeyFunction = s -> CollationAwareUTF8String.lowerCaseCodePoints(CollationSpecUTF8.applyTrimmingPolicy(s, this.spaceTrimming)).getBytes();
                }
                return new Collation(this.normalizedCollationName(), CollationFactory.PROVIDER_SPARK, null, comparator, CollationSpecICU.ICU_VERSION, sortKeyFunction, (s1, s2) -> comparator.compare(s1, s2) == 0, false, true, this.spaceTrimming != CollationSpec.SpaceTrimming.NONE);
            }

            @Override
            protected CollationMeta buildCollationMeta() {
                if (this.caseSensitivity == CaseSensitivity.UNSPECIFIED) {
                    return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, this.normalizedCollationName(), null, null, null, this.getPadding(), true, true, this.spaceTrimming.toString());
                }
                return new CollationMeta(CollationFactory.CATALOG, CollationFactory.SCHEMA, this.normalizedCollationName(), null, null, null, this.getPadding(), true, false, this.spaceTrimming.toString());
            }

            @Override
            protected String normalizedCollationName() {
                StringBuilder builder = new StringBuilder();
                if (this.caseSensitivity == CaseSensitivity.UNSPECIFIED) {
                    builder.append("UTF8_BINARY");
                } else {
                    builder.append("UTF8_LCASE");
                }
                if (this.spaceTrimming != CollationSpec.SpaceTrimming.NONE) {
                    builder.append('_');
                    builder.append(this.spaceTrimming.toString());
                }
                return builder.toString();
            }

            static List<CollationIdentifier> listCollations() {
                CollationIdentifier UTF8_BINARY_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, "UTF8_BINARY", CollationSpecICU.ICU_VERSION);
                CollationIdentifier UTF8_LCASE_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, "UTF8_LCASE", CollationSpecICU.ICU_VERSION);
                CollationIdentifier UTF8_BINARY_RTRIM_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, "UTF8_BINARY_RTRIM", CollationSpecICU.ICU_VERSION);
                CollationIdentifier UTF8_LCASE_RTRIM_COLLATION_IDENT = new CollationIdentifier(CollationFactory.PROVIDER_SPARK, "UTF8_LCASE_RTRIM", CollationSpecICU.ICU_VERSION);
                return Arrays.asList(UTF8_BINARY_COLLATION_IDENT, UTF8_LCASE_COLLATION_IDENT, UTF8_BINARY_RTRIM_COLLATION_IDENT, UTF8_LCASE_RTRIM_COLLATION_IDENT);
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                try {
                    int collationId = CollationSpecUTF8.collationNameToId(collationIdentifier.name, collationIdentifier.name.toUpperCase());
                    return CollationSpecUTF8.fromCollationId(collationId).buildCollationMeta();
                }
                catch (SparkException ignored) {
                    return null;
                }
            }

            private static enum CaseSensitivity {
                UNSPECIFIED,
                LCASE;

            }
        }

        private static abstract class CollationSpec {
            private static final int DEFINITION_ORIGIN_OFFSET = 30;
            private static final int DEFINITION_ORIGIN_MASK = 1;
            protected static final int IMPLEMENTATION_PROVIDER_OFFSET = 29;
            protected static final int IMPLEMENTATION_PROVIDER_MASK = 1;
            protected static final int SPACE_TRIMMING_OFFSET = 18;
            protected static final int SPACE_TRIMMING_MASK = 1;
            private static final int INDETERMINATE_COLLATION_ID = -1;
            private static final Collation INDETERMINATE_COLLATION = new IndeterminateCollation();
            private static final Map<Integer, Collation> collationMap = new ConcurrentHashMap<Integer, Collation>();
            protected SpaceTrimming spaceTrimming;

            private CollationSpec() {
            }

            protected static ImplementationProvider getImplementationProvider(int collationId) {
                if (collationId == -1) {
                    return ImplementationProvider.INDETERMINATE;
                }
                return ImplementationProvider.values()[SpecifierUtils.getSpecValue(collationId, 29, 1)];
            }

            private static DefinitionOrigin getDefinitionOrigin(int collationId) {
                return DefinitionOrigin.values()[SpecifierUtils.getSpecValue(collationId, 30, 1)];
            }

            protected static SpaceTrimming getSpaceTrimming(int collationId) {
                return SpaceTrimming.values()[SpecifierUtils.getSpecValue(collationId, 18, 1)];
            }

            protected static UTF8String applyTrimmingPolicy(UTF8String s, int collationId) {
                return CollationSpec.applyTrimmingPolicy(s, CollationSpec.getSpaceTrimming(collationId));
            }

            protected static boolean ignoresSpacesInTrimFunctions(int collationId, boolean isLTrim, boolean isRTrim) {
                return isRTrim && CollationSpec.getSpaceTrimming(collationId) == SpaceTrimming.RTRIM;
            }

            protected static UTF8String applyTrimmingPolicy(UTF8String s, SpaceTrimming spaceTrimming) {
                if (spaceTrimming == SpaceTrimming.RTRIM) {
                    return s.trimRight();
                }
                return s;
            }

            private static Collation fetchCollation(int collationId) {
                assert (collationId == -1 || CollationSpec.getDefinitionOrigin(collationId) == DefinitionOrigin.PREDEFINED);
                if (collationId == UTF8_BINARY_COLLATION_ID) {
                    return CollationSpecUTF8.UTF8_BINARY_COLLATION;
                }
                if (collationMap.containsKey(collationId)) {
                    return collationMap.get(collationId);
                }
                if (collationId == -1) {
                    return INDETERMINATE_COLLATION;
                }
                ImplementationProvider implementationProvider = CollationSpec.getImplementationProvider(collationId);
                CollationSpec spec = implementationProvider == ImplementationProvider.UTF8_BINARY ? CollationSpecUTF8.fromCollationId(collationId) : CollationSpecICU.fromCollationId(collationId);
                Collation collation = spec.buildCollation();
                collationMap.put(collationId, collation);
                return collation;
            }

            private static int collationNameToId(String collationName) throws SparkException {
                String collationNameUpper = collationName.toUpperCase();
                if (collationNameUpper.startsWith("UTF8_")) {
                    return CollationSpecUTF8.collationNameToId(collationName, collationNameUpper);
                }
                return CollationSpecICU.collationNameToId(collationName, collationNameUpper);
            }

            protected String getPadding() {
                if (this.spaceTrimming == SpaceTrimming.RTRIM) {
                    return CollationFactory.PAD_ATTRIBUTE_RTRIM;
                }
                assert (this.spaceTrimming == SpaceTrimming.NONE);
                return CollationFactory.PAD_ATTRIBUTE_EMPTY;
            }

            protected abstract Collation buildCollation();

            protected abstract CollationMeta buildCollationMeta();

            protected abstract String normalizedCollationName();

            static List<CollationIdentifier> listCollations() {
                return Stream.concat(CollationSpecUTF8.listCollations().stream(), CollationSpecICU.listCollations().stream()).toList();
            }

            static CollationMeta loadCollationMeta(CollationIdentifier collationIdentifier) {
                CollationMeta collationSpecUTF8 = CollationSpecUTF8.loadCollationMeta(collationIdentifier);
                if (collationSpecUTF8 == null) {
                    return CollationSpecICU.loadCollationMeta(collationIdentifier);
                }
                return collationSpecUTF8;
            }

            protected static enum ImplementationProvider {
                UTF8_BINARY,
                ICU,
                INDETERMINATE;

            }

            private static enum DefinitionOrigin {
                PREDEFINED,
                USER_DEFINED;

            }

            protected static enum SpaceTrimming {
                NONE,
                RTRIM;

            }
        }
    }

    public static class CollationIdentifier {
        private final String provider;
        private final String name;
        private final String version;

        public CollationIdentifier(String provider, String collationName, String version) {
            this.provider = provider;
            this.name = collationName;
            this.version = version;
        }

        public static CollationIdentifier fromString(String identifier) {
            long numDots = identifier.chars().filter(ch -> ch == 46).count();
            assert (numDots > 0L);
            if (numDots == 1L) {
                String[] parts = identifier.split("\\.", 2);
                return new CollationIdentifier(parts[0], parts[1], null);
            }
            String[] parts = identifier.split("\\.", 3);
            return new CollationIdentifier(parts[0], parts[1], parts[2]);
        }

        public String toStringWithoutVersion() {
            return String.format("%s.%s", this.provider, this.name);
        }

        public String getProvider() {
            return this.provider;
        }

        public String getName() {
            return this.name;
        }

        public Optional<String> getVersion() {
            return Optional.ofNullable(this.version);
        }
    }

    public record CollationMeta(String catalog, String schema, String collationName, String language, String country, String icuVersion, String padAttribute, boolean accentSensitivity, boolean caseSensitivity, String spaceTrimming) {
    }
}

