/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.ml.feature.ElementwiseProduct;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.linalg.Vectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class JavaElementwiseProductExample {
    public static void main(String[] args) {
        SparkSession spark = SparkSession.builder().appName("JavaElementwiseProductExample").getOrCreate();
        List<Row> data = Arrays.asList(RowFactory.create((Object[])new Object[]{"a", Vectors.dense((double)1.0, (double[])new double[]{2.0, 3.0})}), RowFactory.create((Object[])new Object[]{"b", Vectors.dense((double)4.0, (double[])new double[]{5.0, 6.0})}));
        ArrayList<StructField> fields = new ArrayList<StructField>(2);
        fields.add(DataTypes.createStructField((String)"id", (DataType)DataTypes.StringType, (boolean)false));
        fields.add(DataTypes.createStructField((String)"vector", (DataType)new VectorUDT(), (boolean)false));
        StructType schema = DataTypes.createStructType(fields);
        Dataset dataFrame = spark.createDataFrame(data, schema);
        Vector transformingVector = Vectors.dense((double)0.0, (double[])new double[]{1.0, 2.0});
        ElementwiseProduct transformer = (ElementwiseProduct)((ElementwiseProduct)new ElementwiseProduct().setScalingVec(transformingVector).setInputCol("vector")).setOutputCol("transformedVector");
        transformer.transform(dataFrame).show();
        spark.stop();
    }
}

