/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.operators.stateful.join;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOpStateStoreCheckpointInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.StatefulOperatorStateInfo;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.JoinStateManagerStoreGenerator;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SnapshotOptions;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$LeftSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.StreamingSymmetricHashJoinHelper$RightSide$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$KeyToNumValuesType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManager$KeyWithIndexToValueType$;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManagerV1;
import org.apache.spark.sql.execution.streaming.operators.stateful.join.SymmetricHashJoinStateManagerV2;
import org.apache.spark.sql.execution.streaming.state.KeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.NoPrefixKeyStateEncoderSpec;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema;
import org.apache.spark.sql.execution.streaming.state.StateStoreColFamilySchema$;
import org.apache.spark.sql.execution.streaming.state.StateStoreConf;
import org.apache.spark.sql.execution.streaming.state.StateStoreId$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class SymmetricHashJoinStateManager$ {
    public static final SymmetricHashJoinStateManager$ MODULE$ = new SymmetricHashJoinStateManager$();
    private static final Seq<Object> supportedVersions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
    private static final int legacyVersion = 1;

    public Option<SQLMetric> $lessinit$greater$default$11() {
        return None$.MODULE$;
    }

    public boolean $lessinit$greater$default$12() {
        return true;
    }

    public Option<SnapshotOptions> $lessinit$greater$default$13() {
        return None$.MODULE$;
    }

    public Seq<Object> supportedVersions() {
        return supportedVersions;
    }

    public int legacyVersion() {
        return legacyVersion;
    }

    public SymmetricHashJoinStateManager apply(StreamingSymmetricHashJoinHelper.JoinSide joinSide, Seq<Attribute> inputValueAttributes, Seq<Expression> joinKeys, Option<StatefulOperatorStateInfo> stateInfo, StateStoreConf storeConf, Configuration hadoopConf, int partitionId, Option<String> keyToNumValuesStateStoreCkptId, Option<String> keyWithIndexToValueStateStoreCkptId, int stateFormatVersion, Option<SQLMetric> skippedNullValueCount, boolean useStateStoreCoordinator, Option<SnapshotOptions> snapshotOptions, JoinStateManagerStoreGenerator joinStoreGenerator) {
        if (stateFormatVersion == 3) {
            return new SymmetricHashJoinStateManagerV2(joinSide, inputValueAttributes, joinKeys, stateInfo, storeConf, hadoopConf, partitionId, keyToNumValuesStateStoreCkptId, keyWithIndexToValueStateStoreCkptId, stateFormatVersion, skippedNullValueCount, useStateStoreCoordinator, snapshotOptions, joinStoreGenerator);
        }
        return new SymmetricHashJoinStateManagerV1(joinSide, inputValueAttributes, joinKeys, stateInfo, storeConf, hadoopConf, partitionId, keyToNumValuesStateStoreCkptId, keyWithIndexToValueStateStoreCkptId, stateFormatVersion, skippedNullValueCount, useStateStoreCoordinator, snapshotOptions, joinStoreGenerator);
    }

    public Option<SQLMetric> apply$default$11() {
        return None$.MODULE$;
    }

    public boolean apply$default$12() {
        return true;
    }

    public Option<SnapshotOptions> apply$default$13() {
        return None$.MODULE$;
    }

    public Seq<String> allStateStoreNames(Seq<StreamingSymmetricHashJoinHelper.JoinSide> joinSides) {
        .colon.colon allStateStoreTypes = new .colon.colon((Object)SymmetricHashJoinStateManager$KeyToNumValuesType$.MODULE$, (List)new .colon.colon((Object)SymmetricHashJoinStateManager$KeyWithIndexToValueType$.MODULE$, (List)Nil$.MODULE$));
        return (Seq)joinSides.flatMap(arg_0 -> SymmetricHashJoinStateManager$.$anonfun$allStateStoreNames$1((Seq)allStateStoreTypes, arg_0));
    }

    public Map<String, Tuple2<StructType, StructType>> getSchemaForStateStores(StreamingSymmetricHashJoinHelper.JoinSide joinSide, Seq<Attribute> inputValueAttributes, Seq<Expression> joinKeys, int stateFormatVersion) {
        Seq seq;
        Map result = Predef$.MODULE$.Map().empty();
        StructType keySchema = StructType$.MODULE$.apply((Seq)((IterableOps)joinKeys.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Expression k = (Expression)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return new StructField("field" + i, k.dataType(), k.nullable(), StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)tuple2);
        }));
        StructType longValueSchema = new StructType().add("value", "long");
        result = (Map)result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.getStateStoreName(joinSide, SymmetricHashJoinStateManager$KeyToNumValuesType$.MODULE$)), (Object)new Tuple2((Object)keySchema, (Object)longValueSchema)));
        StructType keyWithIndexSchema = keySchema.add("index", (DataType)LongType$.MODULE$);
        if (stateFormatVersion == 1) {
            seq = inputValueAttributes;
        } else if (stateFormatVersion == 2 || stateFormatVersion == 3) {
            String x$1 = "matched";
            BooleanType$ x$2 = BooleanType$.MODULE$;
            boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
            Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
            ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("matched", (DataType)x$2, x$3, x$4);
            Seq x$6 = AttributeReference$.MODULE$.apply$default$6("matched", (DataType)x$2, x$3, x$4);
            seq = (Seq)inputValueAttributes.$colon$plus((Object)new AttributeReference("matched", (DataType)x$2, x$3, x$4, x$5, x$6));
        } else {
            throw new IllegalArgumentException("Incorrect state format version! version=" + stateFormatVersion);
        }
        Seq valueSchema = seq;
        result = (Map)result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.getStateStoreName(joinSide, SymmetricHashJoinStateManager$KeyWithIndexToValueType$.MODULE$)), (Object)new Tuple2((Object)keyWithIndexSchema, (Object)org.apache.spark.sql.catalyst.expressions.package$.MODULE$.AttributeSeq(valueSchema).toStructType())));
        return result;
    }

    public Map<String, StateStoreColFamilySchema> getSchemasForStateStoreWithColFamily(StreamingSymmetricHashJoinHelper.JoinSide joinSide, Seq<Attribute> inputValueAttributes, Seq<Expression> joinKeys, int stateFormatVersion) {
        Map<String, Tuple2<StructType, StructType>> schemas = this.getSchemaForStateStores(joinSide, inputValueAttributes, joinKeys, stateFormatVersion);
        return (Map)schemas.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String colFamilyName = (String)tuple2._1();
                Tuple2 tuple22 = (Tuple2)tuple2._2();
                if (tuple22 != null) {
                    StructType keySchema = (StructType)tuple22._1();
                    StructType valueSchema = (StructType)tuple22._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)colFamilyName), (Object)new StateStoreColFamilySchema(colFamilyName, 0, keySchema, 0, valueSchema, (Option<KeyStateEncoderSpec>)new Some((Object)new NoPrefixKeyStateEncoderSpec(keySchema)), StateStoreColFamilySchema$.MODULE$.apply$default$7()));
                }
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public StatefulOpStateStoreCheckpointInfo mergeStateStoreCheckpointInfo(StreamingSymmetricHashJoinHelper.JoinStateStoreCkptInfo joinCkptInfo) {
        Predef$.MODULE$.assert(joinCkptInfo.left().keyToNumValues().partitionId() == joinCkptInfo.right().keyToNumValues().partitionId(), (Function0 & Serializable)() -> "state store info returned from two Stream-Stream Join sides have different partition IDs");
        Predef$.MODULE$.assert(joinCkptInfo.left().keyToNumValues().batchVersion() == joinCkptInfo.right().keyToNumValues().batchVersion(), (Function0 & Serializable)() -> "state store info returned from two Stream-Stream Join sides have different batch versions");
        Predef$.MODULE$.assert(joinCkptInfo.left().keyToNumValues().stateStoreCkptId().isDefined() == joinCkptInfo.right().keyToNumValues().stateStoreCkptId().isDefined(), (Function0 & Serializable)() -> "state store info returned from two Stream-Stream Join sides should both return checkpoint ID or not");
        Option ckptIds = joinCkptInfo.left().keyToNumValues().stateStoreCkptId().map((Function1 & Serializable)x$9 -> (String[])((Object[])new String[]{x$9, (String)joinCkptInfo.left().keyWithIndexToValue().stateStoreCkptId().get(), (String)joinCkptInfo.right().keyToNumValues().stateStoreCkptId().get(), (String)joinCkptInfo.right().keyWithIndexToValue().stateStoreCkptId().get()}));
        Option baseCkptIds = joinCkptInfo.left().keyToNumValues().baseStateStoreCkptId().map((Function1 & Serializable)x$10 -> (String[])((Object[])new String[]{x$10, (String)joinCkptInfo.left().keyWithIndexToValue().baseStateStoreCkptId().get(), (String)joinCkptInfo.right().keyToNumValues().baseStateStoreCkptId().get(), (String)joinCkptInfo.right().keyWithIndexToValue().baseStateStoreCkptId().get()}));
        return new StatefulOpStateStoreCheckpointInfo(joinCkptInfo.left().keyToNumValues().partitionId(), joinCkptInfo.left().keyToNumValues().batchVersion(), (Option<String[]>)ckptIds, (Option<String[]>)baseCkptIds);
    }

    public StreamingSymmetricHashJoinHelper.JoinStateStoreCheckpointId getStateStoreCheckpointIds(int partitionId, Option<String[][]> stateStoreCkptIds, boolean useColumnFamiliesForJoins) {
        if (useColumnFamiliesForJoins) {
            Option ckpt = stateStoreCkptIds.map((Function1 & Serializable)x$11 -> x$11[partitionId]).map((Function1 & Serializable)x$12 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$12)));
            return new StreamingSymmetricHashJoinHelper.JoinStateStoreCheckpointId(new StreamingSymmetricHashJoinHelper.JoinerStateStoreCheckpointId((Option<String>)ckpt, (Option<String>)ckpt), new StreamingSymmetricHashJoinHelper.JoinerStateStoreCheckpointId((Option<String>)ckpt, (Option<String>)ckpt));
        }
        Option[] stateStoreCkptIdsOpt = (Option[])stateStoreCkptIds.map((Function1 & Serializable)x$13 -> x$13[partitionId]).map((Function1 & Serializable)x$14 -> (Option[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x$14), (Function1 & Serializable)x$15 -> Option$.MODULE$.apply(x$15), ClassTag$.MODULE$.apply(Option.class))).getOrElse((Function0 & Serializable)() -> (Option[])Array$.MODULE$.fill(4, (Function0 & Serializable)() -> None$.MODULE$, ClassTag$.MODULE$.apply(Option.class)));
        return new StreamingSymmetricHashJoinHelper.JoinStateStoreCheckpointId(new StreamingSymmetricHashJoinHelper.JoinerStateStoreCheckpointId((Option<String>)stateStoreCkptIdsOpt[0], (Option<String>)stateStoreCkptIdsOpt[1]), new StreamingSymmetricHashJoinHelper.JoinerStateStoreCheckpointId((Option<String>)stateStoreCkptIdsOpt[2], (Option<String>)stateStoreCkptIdsOpt[3]));
    }

    public Option<String> getStateStoreCheckpointId(String storeName, int partitionId, Option<String[][]> stateStoreCkptIds, boolean useColumnFamiliesForJoins) {
        block8: {
            block7: {
                if (useColumnFamiliesForJoins) break block7;
                String string = storeName;
                String string2 = StateStoreId$.MODULE$.DEFAULT_STORE_NAME();
                if (string != null ? !string.equals(string2) : string2 != null) break block8;
            }
            return stateStoreCkptIds.map((Function1 & Serializable)x$16 -> x$16[partitionId]).map((Function1 & Serializable)x$17 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$17)));
        }
        StreamingSymmetricHashJoinHelper.JoinStateStoreCheckpointId joinStateStoreCkptIds = this.getStateStoreCheckpointIds(partitionId, stateStoreCkptIds, useColumnFamiliesForJoins);
        String string = storeName;
        String string3 = this.getStateStoreName(StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, SymmetricHashJoinStateManager$KeyToNumValuesType$.MODULE$);
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            return joinStateStoreCkptIds.left().keyToNumValues();
        }
        String string4 = storeName;
        String string5 = this.getStateStoreName(StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, SymmetricHashJoinStateManager$KeyToNumValuesType$.MODULE$);
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return joinStateStoreCkptIds.right().keyToNumValues();
        }
        String string6 = storeName;
        String string7 = this.getStateStoreName(StreamingSymmetricHashJoinHelper$LeftSide$.MODULE$, SymmetricHashJoinStateManager$KeyWithIndexToValueType$.MODULE$);
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            return joinStateStoreCkptIds.left().keyWithIndexToValue();
        }
        String string8 = storeName;
        String string9 = this.getStateStoreName(StreamingSymmetricHashJoinHelper$RightSide$.MODULE$, SymmetricHashJoinStateManager$KeyWithIndexToValueType$.MODULE$);
        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
            return joinStateStoreCkptIds.right().keyWithIndexToValue();
        }
        return None$.MODULE$;
    }

    public boolean getStateStoreCheckpointId$default$4() {
        return false;
    }

    public String getStateStoreName(StreamingSymmetricHashJoinHelper.JoinSide joinSide, SymmetricHashJoinStateManager.StateStoreType storeType) {
        return joinSide + "-" + storeType;
    }

    public static final /* synthetic */ Seq $anonfun$allStateStoreNames$1(Seq allStateStoreTypes$1, StreamingSymmetricHashJoinHelper.JoinSide joinSide) {
        return (Seq)allStateStoreTypes$1.map((Function1 & Serializable)stateStoreType -> MODULE$.getStateStoreName(joinSide, (SymmetricHashJoinStateManager.StateStoreType)stateStoreType));
    }

    private SymmetricHashJoinStateManager$() {
    }
}

