/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfig;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigBuilder;
import io.fabric8.kubernetes.api.model.extensions.RollbackConfigFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DeploymentRollbackFluent<A extends DeploymentRollbackFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String apiVersion;
    private String kind;
    private String name;
    private RollbackConfigBuilder rollbackTo;
    private Map<String, String> updatedAnnotations;

    public DeploymentRollbackFluent() {
    }

    public DeploymentRollbackFluent(DeploymentRollback instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToUpdatedAnnotations(Map<String, String> map) {
        if (this.updatedAnnotations == null && map != null) {
            this.updatedAnnotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.updatedAnnotations.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToUpdatedAnnotations(String key, String value) {
        if (this.updatedAnnotations == null && key != null && value != null) {
            this.updatedAnnotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.updatedAnnotations.put(key, value);
        }
        return (A)((Object)this);
    }

    public RollbackConfig buildRollbackTo() {
        return this.rollbackTo != null ? this.rollbackTo.build() : null;
    }

    protected void copyInstance(DeploymentRollback instance) {
        DeploymentRollback deploymentRollback = instance = instance != null ? instance : new DeploymentRollback();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withRollbackTo(instance.getRollbackTo());
            this.withUpdatedAnnotations(instance.getUpdatedAnnotations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public RollbackToNested<A> editOrNewRollbackTo() {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(new RollbackConfigBuilder().build()));
    }

    public RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(item));
    }

    public RollbackToNested<A> editRollbackTo() {
        return this.withNewRollbackToLike(Optional.ofNullable(this.buildRollbackTo()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentRollbackFluent that = (DeploymentRollbackFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals((Object)this.rollbackTo, (Object)that.rollbackTo)) {
            return false;
        }
        if (!Objects.equals(this.updatedAnnotations, that.updatedAnnotations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getUpdatedAnnotations() {
        return this.updatedAnnotations;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean hasRollbackTo() {
        return this.rollbackTo != null;
    }

    public boolean hasUpdatedAnnotations() {
        return this.updatedAnnotations != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.kind, this.name, this.rollbackTo, this.updatedAnnotations, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromUpdatedAnnotations(String key) {
        if (this.updatedAnnotations == null) {
            return (A)((Object)this);
        }
        if (key != null && this.updatedAnnotations != null) {
            this.updatedAnnotations.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromUpdatedAnnotations(Map<String, String> map) {
        if (this.updatedAnnotations == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.updatedAnnotations == null) continue;
                this.updatedAnnotations.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion);
            sb.append(",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.rollbackTo != null) {
            sb.append("rollbackTo:");
            sb.append((Object)this.rollbackTo);
            sb.append(",");
        }
        if (this.updatedAnnotations != null && !this.updatedAnnotations.isEmpty()) {
            sb.append("updatedAnnotations:");
            sb.append(this.updatedAnnotations);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public RollbackToNested<A> withNewRollbackTo() {
        return new RollbackToNested(null);
    }

    public A withNewRollbackTo(Long revision) {
        return this.withRollbackTo(new RollbackConfig(revision));
    }

    public RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
        return new RollbackToNested(item);
    }

    public A withRollbackTo(RollbackConfig rollbackTo) {
        this._visitables.remove((Object)"rollbackTo");
        if (rollbackTo != null) {
            this.rollbackTo = new RollbackConfigBuilder(rollbackTo);
            this._visitables.get((Object)"rollbackTo").add(this.rollbackTo);
        } else {
            this.rollbackTo = null;
            this._visitables.get((Object)"rollbackTo").remove((Object)this.rollbackTo);
        }
        return (A)((Object)this);
    }

    public <K, V> A withUpdatedAnnotations(Map<String, String> updatedAnnotations) {
        this.updatedAnnotations = updatedAnnotations == null ? null : new LinkedHashMap<String, String>(updatedAnnotations);
        return (A)((Object)this);
    }

    public class RollbackToNested<N>
    extends RollbackConfigFluent<RollbackToNested<N>>
    implements Nested<N> {
        RollbackConfigBuilder builder;

        RollbackToNested(RollbackConfig item) {
            this.builder = new RollbackConfigBuilder(this, item);
        }

        public N and() {
            return (N)DeploymentRollbackFluent.this.withRollbackTo(this.builder.build());
        }

        public N endRollbackTo() {
            return this.and();
        }
    }
}

