/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodBuilder;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.volcano.api.model.scheduling.v1beta1.PodGroup;
import io.fabric8.volcano.api.model.scheduling.v1beta1.PodGroupSpec;
import io.fabric8.volcano.client.DefaultVolcanoClient;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.KubernetesDriverCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesExecutorCustomFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.deploy.k8s.features.VolcanoFeatureStep$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.StringContext;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\rd!\u0002\f\u0018\u0001u\u0019\u0003\"B\u001c\u0001\t\u0003I\u0004\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0003=\u0011%\t\u0005\u00011AA\u0002\u0013%!\tC\u0005I\u0001\u0001\u0007\t\u0011)Q\u0005{!A\u0011\n\u0001EC\u0002\u0013%!\n\u0003\u0005T\u0001!\u0015\r\u0011\"\u0003U\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015y\u0006\u0001\"\u0011g\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002B\u0001!\t%a\u0011\b\u0011\u0005=s\u0003#\u0001\u001e\u0003#2qAF\f\t\u0002u\t\u0019\u0006\u0003\u00048\u001d\u0011\u0005\u0011Q\u000b\u0005\t\u0003/r!\u0019!C\u0001\u0015\"9\u0011\u0011\f\b!\u0002\u0013Y\u0005\u0002CA.\u001d\t\u0007I\u0011\u0001&\t\u000f\u0005uc\u0002)A\u0005\u0017\"A\u0011q\f\bC\u0002\u0013\u0005!\nC\u0004\u0002b9\u0001\u000b\u0011B&\u0003%Y{GnY1o_\u001a+\u0017\r^;sKN#X\r\u001d\u0006\u00031e\t\u0001BZ3biV\u0014Xm\u001d\u0006\u00035m\t1a\u001b\u001dt\u0015\taR$\u0001\u0004eKBdw.\u001f\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0013aA8sON)\u0001\u0001\n\u0016/cA\u0011Q\u0005K\u0007\u0002M)\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*M\t1\u0011I\\=SK\u001a\u0004\"a\u000b\u0017\u000e\u0003]I!!L\f\u0003O-+(-\u001a:oKR,7\u000f\u0012:jm\u0016\u00148)^:u_64U-\u0019;ve\u0016\u001cuN\u001c4jON#X\r\u001d\t\u0003W=J!\u0001M\f\u0003S-+(-\u001a:oKR,7/\u0012=fGV$xN]\"vgR|WNR3biV\u0014XmQ8oM&<7\u000b^3q!\t\u0011T'D\u00014\u0015\t!T$\u0001\u0005j]R,'O\\1m\u0013\t14GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u000f\t\u0003W\u0001\tab[;cKJtW\r^3t\u0007>tg-F\u0001>!\tqt(D\u0001\u001a\u0013\t\u0001\u0015D\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0002%-,(-\u001a:oKR,7oQ8oM~#S-\u001d\u000b\u0003\u0007\u001a\u0003\"!\n#\n\u0005\u00153#\u0001B+oSRDqaR\u0002\u0002\u0002\u0003\u0007Q(A\u0002yIE\nqb[;cKJtW\r^3t\u0007>tg\rI\u0001\ra>$wI]8va:\u000bW.Z\u000b\u0002\u0017B\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\u0005Y\u0006twMC\u0001Q\u0003\u0011Q\u0017M^1\n\u0005Ik%AB*ue&tw-A\u0005oC6,7\u000f]1dKV\tQ\u000b\u0005\u0002W;:\u0011qk\u0017\t\u00031\u001aj\u0011!\u0017\u0006\u00035b\na\u0001\u0010:p_Rt\u0014B\u0001/'\u0003\u0019\u0001&/\u001a3fM&\u0011!K\u0018\u0006\u00039\u001a\nA!\u001b8jiR\u00111)\u0019\u0005\u0006E\u001e\u0001\raY\u0001\u0007G>tg-[4\u0011\u0005y\"\u0017BA3\u001a\u0005QYUOY3s]\u0016$Xm\u001d#sSZ,'oQ8oMR\u00111i\u001a\u0005\u0006E\"\u0001\r\u0001\u001b\t\u0003}%L!A[\r\u0003--+(-\u001a:oKR,7/\u0012=fGV$xN]\"p]\u001a\f1eZ3u\u0003\u0012$\u0017\u000e^5p]\u0006d\u0007K]3Lk\n,'O\\3uKN\u0014Vm]8ve\u000e,7\u000fF\u0001n!\rq7O\u001e\b\u0003_Ft!\u0001\u00179\n\u0003\u001dJ!A\u001d\u0014\u0002\u000fA\f7m[1hK&\u0011A/\u001e\u0002\u0004'\u0016\f(B\u0001:'!\r9\u0018QA\u0007\u0002q*\u0011\u0011P_\u0001\u0006[>$W\r\u001c\u0006\u0003wr\f1!\u00199j\u0015\tih0\u0001\u0006lk\n,'O\\3uKNT1a`A\u0001\u0003\u001d1\u0017M\u0019:jGbR!!a\u0001\u0002\u0005%|\u0017bAA\u0004q\nY\u0001*Y:NKR\fG-\u0019;b\u0003}9W\r\u001e)pI\u001e\u0013x.\u001e9D_:4\u0017n\u001a\"z)\u0016l\u0007\u000f\\1uK\u001aKG.\u001a\u000b\u0005\u0003\u001b\tY\u0003E\u0003&\u0003\u001f\t\u0019\"C\u0002\u0002\u0012\u0019\u0012aa\u00149uS>t\u0007\u0003BA\u000b\u0003Oi!!a\u0006\u000b\t\u0005e\u00111D\u0001\bmF\u0012W\r^12\u0015\u0011\ti\"a\b\u0002\u0015M\u001c\u0007.\u001a3vY&twMC\u0002z\u0003CQ1a_A\u0012\u0015\r\t)C`\u0001\bm>d7-\u00198p\u0013\u0011\tI#a\u0006\u0003\u0011A{Gm\u0012:pkBDq!!\f\u000b\u0001\u0004\ty#A\u0007w_2\u001c\u0017M\\8DY&,g\u000e\u001e\t\u0005\u0003c\t9$\u0004\u0002\u00024)!\u0011QGA\u0012\u0003\u0019\u0019G.[3oi&!\u0011\u0011HA\u001a\u0005Q!UMZ1vYR4v\u000e\\2b]>\u001cE.[3oi\u0006Ir-\u001a;Q_\u0012<%o\\;q\u0005f$V-\u001c9mCR,'j]8o)\u0011\ti!a\u0010\t\u000f\u000552\u00021\u0001\u00020\u0005a1m\u001c8gS\u001e,(/\u001a)pIR!\u0011QIA&!\rq\u0014qI\u0005\u0004\u0003\u0013J\"\u0001C*qCJ\\\u0007k\u001c3\t\u000f\u00055C\u00021\u0001\u0002F\u0005\u0019\u0001o\u001c3\u0002%Y{GnY1o_\u001a+\u0017\r^;sKN#X\r\u001d\t\u0003W9\u0019\"A\u0004\u0013\u0015\u0005\u0005E\u0013\u0001\u0006)P\t~;%kT+Q?\u0006sej\u0014+B)&{e*A\u000bQ\u001f\u0012{vIU(V!~\u000beJT(U\u0003RKuJ\u0014\u0011\u00027A{EiX$S\u001fV\u0003v\fV#N!2\u000bE+R0G\u00132+ulS#Z\u0003q\u0001v\nR0H%>+\u0006k\u0018+F\u001bBc\u0015\tV#`\r&cUiX&F3\u0002\n1\u0004U(E?\u001e\u0013v*\u0016)`)\u0016k\u0005\u000bT!U\u000b~S5k\u0014(`\u0017\u0016K\u0016\u0001\b)P\t~;%kT+Q?R+U\n\u0015'B)\u0016{&jU(O?.+\u0015\f\t")
public class VolcanoFeatureStep
implements KubernetesDriverCustomFeatureConfigStep,
KubernetesExecutorCustomFeatureConfigStep,
Logging {
    private String podGroupName;
    private String namespace;
    private KubernetesConf kubernetesConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static String POD_GROUP_TEMPLATE_JSON_KEY() {
        return VolcanoFeatureStep$.MODULE$.POD_GROUP_TEMPLATE_JSON_KEY();
    }

    public static String POD_GROUP_TEMPLATE_FILE_KEY() {
        return VolcanoFeatureStep$.MODULE$.POD_GROUP_TEMPLATE_FILE_KEY();
    }

    public static String POD_GROUP_ANNOTATION() {
        return VolcanoFeatureStep$.MODULE$.POD_GROUP_ANNOTATION();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        return KubernetesFeatureConfigStep.getAdditionalPodSystemProperties$(this);
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        return KubernetesFeatureConfigStep.getAdditionalKubernetesResources$(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private KubernetesConf kubernetesConf() {
        return this.kubernetesConf;
    }

    private void kubernetesConf_$eq(KubernetesConf x$1) {
        this.kubernetesConf = x$1;
    }

    private String podGroupName$lzycompute() {
        VolcanoFeatureStep volcanoFeatureStep = this;
        synchronized (volcanoFeatureStep) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.podGroupName = this.kubernetesConf().appId() + "-podgroup";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.podGroupName;
    }

    private String podGroupName() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.podGroupName$lzycompute();
        }
        return this.podGroupName;
    }

    private String namespace$lzycompute() {
        VolcanoFeatureStep volcanoFeatureStep = this;
        synchronized (volcanoFeatureStep) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.namespace = this.kubernetesConf().namespace();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.namespace;
    }

    private String namespace() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.namespace$lzycompute();
        }
        return this.namespace;
    }

    @Override
    public void init(KubernetesDriverConf config) {
        this.kubernetesConf_$eq(config);
    }

    @Override
    public void init(KubernetesExecutorConf config) {
        this.kubernetesConf_$eq(config);
    }

    @Override
    public Seq<HasMetadata> getAdditionalPreKubernetesResources() {
        LazyRef client$lzy = new LazyRef();
        if (this.kubernetesConf() instanceof KubernetesExecutorConf) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "VolcanoFeatureStep#getAdditionalPreKubernetesResources() is not supported for executor.");
            return (Seq)package$.MODULE$.Seq().empty();
        }
        PodGroup pg = (PodGroup)this.getPodGroupConfigByTemplateFile(VolcanoFeatureStep.client$1(client$lzy)).orElse((Function0 & Serializable)() -> this.getPodGroupByTemplateJson(VolcanoFeatureStep.client$1(client$lzy))).getOrElse((Function0 & Serializable)() -> new PodGroup());
        ObjectMeta metadata = pg.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMeta();
        }
        metadata.setName(this.podGroupName());
        metadata.setNamespace(this.namespace());
        pg.setMetadata(metadata);
        PodGroupSpec spec = pg.getSpec();
        if (spec == null) {
            spec = new PodGroupSpec();
        }
        pg.setSpec(spec);
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Volcano PodGroup configuration: " + pg);
        return new .colon.colon((Object)pg, (List)Nil$.MODULE$);
    }

    private Option<PodGroup> getPodGroupConfigByTemplateFile(DefaultVolcanoClient volcanoClient) {
        return this.kubernetesConf().getOption(VolcanoFeatureStep$.MODULE$.POD_GROUP_TEMPLATE_FILE_KEY()).map((Function1 & Serializable)templateFile -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Loading Volcano PodGroup configuration from template file");
            return (PodGroup)((Resource)volcanoClient.podGroups().load(templateFile)).item();
        });
    }

    private Option<PodGroup> getPodGroupByTemplateJson(DefaultVolcanoClient volcanoClient) {
        return this.kubernetesConf().getOption(VolcanoFeatureStep$.MODULE$.POD_GROUP_TEMPLATE_JSON_KEY()).map((Function1 & Serializable)templateJson -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Loading Volcano PodGroup configuration from template json");
            return (PodGroup)((Resource)volcanoClient.podGroups().load((InputStream)new ByteArrayInputStream(templateJson.getBytes()))).item();
        });
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        PodBuilder k8sPodBuilder = (PodBuilder)((PodFluent.MetadataNested)new PodBuilder(pod.pod()).editMetadata().addToAnnotations(VolcanoFeatureStep$.MODULE$.POD_GROUP_ANNOTATION(), this.podGroupName())).endMetadata();
        Pod k8sPod = k8sPodBuilder.build();
        return new SparkPod(k8sPod, pod.container());
    }

    private static final /* synthetic */ DefaultVolcanoClient client$lzycompute$1(LazyRef client$lzy$1) {
        DefaultVolcanoClient defaultVolcanoClient;
        LazyRef lazyRef = client$lzy$1;
        synchronized (lazyRef) {
            defaultVolcanoClient = client$lzy$1.initialized() ? (DefaultVolcanoClient)client$lzy$1.value() : (DefaultVolcanoClient)client$lzy$1.initialize((Object)new DefaultVolcanoClient());
        }
        return defaultVolcanoClient;
    }

    private static final DefaultVolcanoClient client$1(LazyRef client$lzy$1) {
        if (client$lzy$1.initialized()) {
            return (DefaultVolcanoClient)client$lzy$1.value();
        }
        return VolcanoFeatureStep.client$lzycompute$1(client$lzy$1);
    }

    public VolcanoFeatureStep() {
        KubernetesFeatureConfigStep.$init$(this);
        Logging.$init$((Logging)this);
    }
}

