/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Constructor;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.FunctionRegistry$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.FromAvro$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child, jsonFormatSchema, options) - Converts a binary Avro value into a Catalyst value.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(s, '{\"type\": \"record\", \"name\": \"struct\", \"fields\": [{ \"name\": \"u\", \"type\": [\"int\",\"string\"] }]}', map()) IS NULL AS result FROM (SELECT NAMED_STRUCT('u', NAMED_STRUCT('member0', member0, 'member1', member1)) AS s FROM VALUES (1, NULL), (NULL,  'a') tab(member0, member1));\n       [false]\n  ", note="\n    The specified schema must match actual schema of the read data, otherwise the behavior\n    is undefined: it may fail or return arbitrary result.\n    To deserialize the data with a compatible and evolved schema, the expected Avro schema can be\n    set via the corresponding option.\n  ", group="avro_funcs", since="4.0.0")
@ScalaSignature(bytes="\u0006\u0005\u0005}g\u0001\u0002\u0012$\u0001BB\u0001B\u0013\u0001\u0003\u0016\u0004%\ta\u0013\u0005\t\u001f\u0002\u0011\t\u0012)A\u0005\u0019\"A\u0001\u000b\u0001BK\u0002\u0013\u00051\n\u0003\u0005R\u0001\tE\t\u0015!\u0003M\u0011!\u0011\u0006A!f\u0001\n\u0003Y\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011\u0002'\t\u000bQ\u0003A\u0011A+\t\u000bi\u0003A\u0011I&\t\u000bm\u0003A\u0011I&\t\u000bq\u0003A\u0011I&\t\u000bQ\u0003A\u0011A/\t\u000b\u0001\u0004A\u0011I1\t\u000b!\u0004A\u0011I5\t\u0011A\u0004\u0001R1A\u0005B-CQ!\u001d\u0001\u0005BIDqa\u001f\u0001\u0002\u0002\u0013\u0005A\u0010C\u0005\u0002\u0002\u0001\t\n\u0011\"\u0001\u0002\u0004!I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\u0001\u0005\n\u00037\u0001\u0011\u0013!C\u0001\u0003\u0007A\u0011\"!\b\u0001\u0003\u0003%\t%a\b\t\u0013\u0005=\u0002!!A\u0005\u0002\u0005E\u0002\"CA\u001d\u0001\u0005\u0005I\u0011AA\u001e\u0011%\t9\u0005AA\u0001\n\u0003\nI\u0005C\u0005\u0002X\u0001\t\t\u0011\"\u0001\u0002Z!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013Q\r\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003W:\u0011\"!&$\u0003\u0003E\t!a&\u0007\u0011\t\u001a\u0013\u0011!E\u0001\u00033Ca\u0001\u0016\u000f\u0005\u0002\u0005E\u0006\"CAZ9\u0005\u0005IQIA[\u0011%\t9\fHA\u0001\n\u0003\u000bI\fC\u0005\u0002Br\t\t\u0011\"!\u0002D\"I\u0011Q\u001b\u000f\u0002\u0002\u0013%\u0011q\u001b\u0002\t\rJ|W.\u0011<s_*\u0011A%J\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002'O\u0005A1-\u0019;bYf\u001cHO\u0003\u0002)S\u0005\u00191/\u001d7\u000b\u0005)Z\u0013!B:qCJ\\'B\u0001\u0017.\u0003\u0019\t\u0007/Y2iK*\ta&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001cUBd\b\u0005\u00023g5\t1%\u0003\u00025G\t\tB+\u001a:oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005I2\u0014BA\u001c$\u0005I\u0011VO\u001c;j[\u0016\u0014V\r\u001d7bG\u0016\f'\r\\3\u0011\u0005ebT\"\u0001\u001e\u000b\u0003m\nQa]2bY\u0006L!!\u0010\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011qh\u0012\b\u0003\u0001\u0016s!!\u0011#\u000e\u0003\tS!aQ\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014B\u0001$;\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001S%\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005\u0019S\u0014!B2iS2$W#\u0001'\u0011\u0005Ij\u0015B\u0001($\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002!)\u001cxN\u001c$pe6\fGoU2iK6\f\u0017!\u00056t_:4uN]7biN\u001b\u0007.Z7bA\u00059q\u000e\u001d;j_:\u001c\u0018\u0001C8qi&|gn\u001d\u0011\u0002\rqJg.\u001b;?)\u00111v\u000bW-\u0011\u0005I\u0002\u0001\"\u0002&\b\u0001\u0004a\u0005\"\u0002)\b\u0001\u0004a\u0005\"\u0002*\b\u0001\u0004a\u0015!\u00024jeN$\u0018AB:fG>tG-A\u0003uQ&\u0014H\rF\u0002W=~CQAS\u0006A\u00021CQ\u0001U\u0006A\u00021\u000bqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\t1\u0013GM\u001a\u0005\u0006G2\u0001\r\u0001T\u0001\t]\u0016<h)\u001b:ti\")Q\r\u0004a\u0001\u0019\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0006O2\u0001\r\u0001T\u0001\t]\u0016<H\u000b[5sI\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nK\u0005A\u0011M\\1msNL7/\u0003\u0002pY\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0006sKBd\u0017mY3nK:$\u0018A\u00039sKR$\u0018PT1nKV\t1\u000f\u0005\u0002uq:\u0011QO\u001e\t\u0003\u0003jJ!a\u001e\u001e\u0002\rA\u0013X\rZ3g\u0013\tI(P\u0001\u0004TiJLgn\u001a\u0006\u0003oj\nAaY8qsR!a+ @\u0000\u0011\u001dQ\u0005\u0003%AA\u00021Cq\u0001\u0015\t\u0011\u0002\u0003\u0007A\nC\u0004S!A\u0005\t\u0019\u0001'\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0001\u0016\u0004\u0019\u0006\u001d1FAA\u0005!\u0011\tY!!\u0006\u000e\u0005\u00055!\u0002BA\b\u0003#\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005M!(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0006\u0002\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\"A!\u00111EA\u0017\u001b\t\t)C\u0003\u0003\u0002(\u0005%\u0012\u0001\u00027b]\u001eT!!a\u000b\u0002\t)\fg/Y\u0005\u0004s\u0006\u0015\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001a!\rI\u0014QG\u0005\u0004\u0003oQ$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001f\u0003\u0007\u00022!OA \u0013\r\t\tE\u000f\u0002\u0004\u0003:L\b\"CA#-\u0005\u0005\t\u0019AA\u001a\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\n\t\u0007\u0003\u001b\n\u0019&!\u0010\u000e\u0005\u0005=#bAA)u\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0013q\n\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\\\u0005\u0005\u0004cA\u001d\u0002^%\u0019\u0011q\f\u001e\u0003\u000f\t{w\u000e\\3b]\"I\u0011Q\t\r\u0002\u0002\u0003\u0007\u0011QH\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\"\u0005\u001d\u0004\"CA#3\u0005\u0005\t\u0019AA\u001a\u0003\u0019)\u0017/^1mgR!\u00111LA7\u0011%\t)EGA\u0001\u0002\u0004\ti\u0004K\f\u0001\u0003c\n9(!\u001f\u0002~\u0005}\u00141QAC\u0003\u0013\u000bY)a$\u0002\u0012B\u0019!'a\u001d\n\u0007\u0005U4EA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005m\u0014\u0001\u001b\u0006!A\u0001\u0002sLR+O\u0007~C3\r[5mI2\u0002#n]8o\r>\u0014X.\u0019;TG\",W.\u0019\u0017!_B$\u0018n\u001c8tS\u0001j\u0003eQ8om\u0016\u0014Ho\u001d\u0011bA\tLg.\u0019:zA\u00053(o\u001c\u0011wC2,X\rI5oi>\u0004\u0013\rI\"bi\u0006d\u0017p\u001d;!m\u0006dW/\u001a\u0018\u000bA\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t\t)\u0001BH\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u001aH\u0006I\u0014|EQL\b/\u001a\u0012;A\t\u0012XmY8sI\nb\u0003E\t8b[\u0016\u0014#\b\t\u0012tiJ,8\r\u001e\u0012-A\t2\u0017.\u001a7eg\nR\u0004eW>!E9\fW.\u001a\u0012;A\t*(\u0005\f\u0011#if\u0004XM\t\u001e!7\nJg\u000e\u001e\u0012-EM$(/\u001b8hEu\u0003S0X?(Y\u0001j\u0017\r\u001d\u0015*S\u0001J5\u000b\t(V\u00192\u0003\u0013i\u0015\u0011sKN,H\u000e\u001e\u0011G%>k\u0005\u0005K*F\u0019\u0016\u001bE\u000b\t(B\u001b\u0016#ul\u0015+S+\u000e#\u0006fJ;(Y\u0001r\u0015)T#E?N#&+V\"UQ\u001djW-\u001c2feB:C\u0006I7f[\n,'\u000f\r\u0017!O5,WNY3sc\u001db\u0003%\\3nE\u0016\u0014\u0018'K\u0015!\u0003N\u00033\u000f\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u0017!\u001dVcE*\u000b\u0017!Q9+F\n\u0014\u0017!A\u001d\nw%\u000b\u0011uC\nDS.Z7cKJ\u0004D\u0006I7f[\n,'/M\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Zf-\u00197tKvS\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002\b\u0006\u0011\tE\u0003\u0011!A\u0001\"\u0006.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u001a8\r[3nC\u0002jWo\u001d;![\u0006$8\r\u001b\u0011bGR,\u0018\r\u001c\u0011tG\",W.\u0019\u0011pM\u0002\"\b.\u001a\u0011sK\u0006$\u0007\u0005Z1uC2\u0002s\u000e\u001e5fe^L7/\u001a\u0011uQ\u0016\u0004#-\u001a5bm&|'O\u0003\u0011!A\u0001J7\u000fI;oI\u00164\u0017N\\3eu\u0001JG\u000fI7bs\u00022\u0017-\u001b7!_J\u0004#/\u001a;ve:\u0004\u0013M\u001d2jiJ\f'/\u001f\u0011sKN,H\u000e\u001e\u0018\u000bA\u0001\u0002\u0003\u0005V8!I\u0016\u001cXM]5bY&TX\r\t;iK\u0002\"\u0017\r^1!o&$\b\u000eI1!G>l\u0007/\u0019;jE2,\u0007%\u00198eA\u00154x\u000e\u001c<fI\u0002\u001a8\r[3nC2\u0002C\u000f[3!Kb\u0004Xm\u0019;fI\u0002\neO]8!g\u000eDW-\\1!G\u0006t\u0007EY3\u000bA\u0001\u0002\u0003e]3uAYL\u0017\r\t;iK\u0002\u001awN\u001d:fgB|g\u000eZ5oO\u0002z\u0007\u000f^5p]:R\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003\u001b\u000b!\"\u0019<s_~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\t\u0019*A\u00035]Ar\u0003'\u0001\u0005Ge>l\u0017I\u001e:p!\t\u0011DdE\u0003\u001d\u00037\u000b9\u000b\u0005\u0005\u0002\u001e\u0006\rF\n\u0014'W\u001b\t\tyJC\u0002\u0002\"j\nqA];oi&lW-\u0003\u0003\u0002&\u0006}%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!\u0011\u0011VAX\u001b\t\tYK\u0003\u0003\u0002.\u0006%\u0012AA5p\u0013\rA\u00151\u0016\u000b\u0003\u0003/\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003C\tQ!\u00199qYf$rAVA^\u0003{\u000by\fC\u0003K?\u0001\u0007A\nC\u0003Q?\u0001\u0007A\nC\u0003S?\u0001\u0007A*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005\u0015\u0017\u0011\u001b\t\u0006s\u0005\u001d\u00171Z\u0005\u0004\u0003\u0013T$AB(qi&|g\u000e\u0005\u0004:\u0003\u001bdE\nT\u0005\u0004\u0003\u001fT$A\u0002+va2,7\u0007\u0003\u0005\u0002T\u0002\n\t\u00111\u0001W\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u00033\u0004B!a\t\u0002\\&!\u0011Q\\A\u0013\u0005\u0019y%M[3di\u0002")
public class FromAvro
extends TernaryExpression
implements RuntimeReplaceable,
Serializable {
    private Expression replacement;
    private final Expression child;
    private final Expression jsonFormatSchema;
    private final Expression options;
    private Seq<Enumeration.Value> nodePatterns;
    private Expression canonicalized;
    private volatile byte bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(FromAvro x$0) {
        return FromAvro$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, FromAvro> tupled() {
        return FromAvro$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, FromAvro>>> curried() {
        return FromAvro$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return RuntimeReplaceable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return RuntimeReplaceable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return RuntimeReplaceable.doGenCode$(this, ctx, ev);
    }

    @Override
    public Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private Expression canonicalized$lzycompute() {
        FromAvro fromAvro = this;
        synchronized (fromAvro) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.canonicalized$lzycompute();
        }
        return this.canonicalized;
    }

    @Override
    public void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression child() {
        return this.child;
    }

    public Expression jsonFormatSchema() {
        return this.jsonFormatSchema;
    }

    public Expression options() {
        return this.options;
    }

    @Override
    public Expression first() {
        return this.child();
    }

    @Override
    public Expression second() {
        return this.jsonFormatSchema();
    }

    @Override
    public Expression third() {
        return this.options();
    }

    @Override
    public Expression withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        block3: {
            block2: {
                var6_1 = this.jsonFormatSchema().dataType();
                schemaCheck = (var6_1 instanceof StringType != false ? true : var6_1 instanceof NullType != false) != false && this.jsonFormatSchema().foldable() != false ? None$.MODULE$ : new Some((Object)new TypeCheckResult.TypeCheckFailure("The second argument of the FROM_AVRO SQL function must be a constant string containing the JSON representation of the schema to use for converting the value from AVRO format"));
                var8_3 = this.options().dataType();
                if (!(var8_3 instanceof MapType)) break block2;
                var9_4 = (MapType)var8_3;
                var10_5 = var9_4.keyType();
                var11_6 = var9_4.valueType();
                if (!StringType$.MODULE$.equals(var10_5) || !StringType$.MODULE$.equals(var11_6)) break block2;
                v0 = true;
                break block3;
            }
            if (!(var8_3 instanceof MapType)) ** GOTO lbl-1000
            var12_7 = (MapType)var8_3;
            var13_8 = var12_7.keyType();
            var14_9 = var12_7.valueType();
            if (NullType$.MODULE$.equals(var13_8) && NullType$.MODULE$.equals(var14_9)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = var8_3 instanceof NullType != false;
            }
        }
        optionsCheck = v0 != false && this.options().foldable() != false ? None$.MODULE$ : new Some((Object)new TypeCheckResult.TypeCheckFailure("The third argument of the FROM_AVRO SQL function must be a constant map of strings to strings containing the options to use for converting the value from AVRO format"));
        return (TypeCheckResult)schemaCheck.getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$checkInputDataTypes$1(scala.Option ), ()Lorg/apache/spark/sql/catalyst/analysis/TypeCheckResult;)((Option)optionsCheck));
    }

    private Expression replacement$lzycompute() {
        FromAvro fromAvro = this;
        synchronized (fromAvro) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Map map;
                ArrayBasedMapData arrayBasedMapData;
                String string;
                Object object = this.jsonFormatSchema().eval(this.jsonFormatSchema().eval$default$1());
                if (object instanceof UTF8String) {
                    UTF8String uTF8String = (UTF8String)object;
                    string = uTF8String.toString();
                } else if (object == null) {
                    string = "";
                } else {
                    throw new MatchError(object);
                }
                String schemaValue = string;
                Object object2 = this.options().eval(this.options().eval$default$1());
                if (object2 instanceof ArrayBasedMapData && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.genericArrayOps((Object)(arrayBasedMapData = (ArrayBasedMapData)object2).keyArray().array()))) {
                    String[] keys = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)arrayBasedMapData.keyArray().array()), (Function1 & Serializable)x$1 -> x$1.toString(), ClassTag$.MODULE$.apply(String.class));
                    String[] values = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.genericArrayOps((Object)arrayBasedMapData.valueArray().array()), (Function1 & Serializable)x$2 -> x$2.toString(), ClassTag$.MODULE$.apply(String.class));
                    map = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.zip$extension(Predef$.MODULE$.refArrayOps((Object[])keys), (IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])values))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                } else {
                    map = Predef$.MODULE$.Map().empty();
                }
                Map optionsValue = map;
                Constructor constructor = FromAvro.liftedTree1$1();
                Object expr = constructor.newInstance(this.child(), schemaValue, optionsValue);
                this.replacement = (Expression)expr;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.replacement;
    }

    @Override
    public Expression replacement() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.replacement$lzycompute();
        }
        return this.replacement;
    }

    @Override
    public String prettyName() {
        return (String)this.getTagValue(FunctionRegistry$.MODULE$.FUNC_ALIAS()).getOrElse((Function0 & Serializable)() -> "from_avro");
    }

    public FromAvro copy(Expression child, Expression jsonFormatSchema, Expression options) {
        return new FromAvro(child, jsonFormatSchema, options);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.jsonFormatSchema();
    }

    public Expression copy$default$3() {
        return this.options();
    }

    @Override
    public String productPrefix() {
        return "FromAvro";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return this.jsonFormatSchema();
            }
            case 2: {
                return this.options();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof FromAvro;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "jsonFormatSchema";
            }
            case 2: {
                return "options";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof FromAvro)) return false;
        boolean bl = true;
        if (!bl) return false;
        FromAvro fromAvro = (FromAvro)x$1;
        Expression expression = this.child();
        Expression expression2 = fromAvro.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.jsonFormatSchema();
        Expression expression4 = fromAvro.jsonFormatSchema();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.options();
        Expression expression6 = fromAvro.options();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!fromAvro.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ TypeCheckResult $anonfun$checkInputDataTypes$1(Option optionsCheck$1) {
        return (TypeCheckResult)optionsCheck$1.getOrElse((Function0 & Serializable)() -> TypeCheckResult$TypeCheckSuccess$.MODULE$);
    }

    private static final /* synthetic */ Constructor liftedTree1$1() {
        Constructor constructor;
        try {
            constructor = (Constructor)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])Utils$.MODULE$.classForName("org.apache.spark.sql.avro.AvroDataToCatalyst", Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()).getConstructors()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw QueryCompilationErrors$.MODULE$.avroNotLoadedSqlFunctionsUnusable("FROM_AVRO");
        }
        return constructor;
    }

    public FromAvro(Expression child, Expression jsonFormatSchema, Expression options) {
        this.child = child;
        this.jsonFormatSchema = jsonFormatSchema;
        this.options = options;
        RuntimeReplaceable.$init$(this);
        Statics.releaseFence();
    }

    public FromAvro(Expression child, Expression jsonFormatSchema) {
        this(child, jsonFormatSchema, Literal$.MODULE$.create(null, ((TypeTags)package$.MODULE$.universe()).TypeTag().Null()));
    }
}

